/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnnotationIntrospectorPair
extends AnnotationIntrospector
implements Serializable {
    protected final AnnotationIntrospector _primary;
    protected final AnnotationIntrospector _secondary;

    public AnnotationIntrospectorPair(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        this._primary = annotationIntrospector;
        this._secondary = annotationIntrospector2;
    }

    @Override
    public Version version() {
        return this._primary.version();
    }

    public static AnnotationIntrospector create(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        if (annotationIntrospector == null) {
            return annotationIntrospector2;
        }
        if (annotationIntrospector2 == null) {
            return annotationIntrospector;
        }
        return new AnnotationIntrospectorPair(annotationIntrospector, annotationIntrospector2);
    }

    @Override
    public Collection<AnnotationIntrospector> allIntrospectors() {
        return ((AnnotationIntrospector)this).allIntrospectors(new ArrayList<AnnotationIntrospector>());
    }

    @Override
    public Collection<AnnotationIntrospector> allIntrospectors(Collection<AnnotationIntrospector> collection) {
        this._primary.allIntrospectors(collection);
        this._secondary.allIntrospectors(collection);
        return collection;
    }

    @Override
    public boolean isAnnotationBundle(Annotation annotation) {
        return this._primary.isAnnotationBundle(annotation) || this._secondary.isAnnotationBundle(annotation);
    }

    @Override
    public PropertyName findRootName(AnnotatedClass annotatedClass) {
        return PropertyName.merge(this._primary.findRootName(annotatedClass), this._secondary.findRootName(annotatedClass));
    }

    @Override
    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> serializable, Annotated annotated) {
        JsonIgnoreProperties.Value value = this._secondary.findPropertyIgnoralByName((MapperConfig<?>)serializable, annotated);
        serializable = this._primary.findPropertyIgnoralByName((MapperConfig<?>)serializable, annotated);
        if (value == null) {
            return serializable;
        }
        return value.withOverrides((JsonIgnoreProperties.Value)serializable);
    }

    @Override
    public JsonIncludeProperties.Value findPropertyInclusionByName(MapperConfig<?> serializable, Annotated annotated) {
        JsonIncludeProperties.Value value = this._secondary.findPropertyInclusionByName((MapperConfig<?>)serializable, annotated);
        serializable = this._primary.findPropertyInclusionByName((MapperConfig<?>)serializable, annotated);
        if (value == null) {
            return serializable;
        }
        return value.withOverrides((JsonIncludeProperties.Value)serializable);
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        Boolean bl2 = this._primary.isIgnorableType(annotatedClass);
        if (bl2 == null) {
            bl2 = this._secondary.isIgnorableType(annotatedClass);
        }
        return bl2;
    }

    @Override
    public Object findFilterId(Annotated annotated) {
        Object object = this._primary.findFilterId(annotated);
        if (object == null) {
            object = this._secondary.findFilterId(annotated);
        }
        return object;
    }

    @Override
    public Object findNamingStrategy(AnnotatedClass annotatedClass) {
        Object object = this._primary.findNamingStrategy(annotatedClass);
        if (object == null) {
            object = this._secondary.findNamingStrategy(annotatedClass);
        }
        return object;
    }

    @Override
    public Object findEnumNamingStrategy(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        Object object = this._primary.findEnumNamingStrategy(mapperConfig, annotatedClass);
        if (object == null) {
            object = this._secondary.findEnumNamingStrategy(mapperConfig, annotatedClass);
        }
        return object;
    }

    @Override
    public String findClassDescription(AnnotatedClass annotatedClass) {
        String string = this._primary.findClassDescription(annotatedClass);
        if (string == null || string.isEmpty()) {
            string = this._secondary.findClassDescription(annotatedClass);
        }
        return string;
    }

    @Override
    @Deprecated
    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated object) {
        JsonIgnoreProperties.Value value = this._secondary.findPropertyIgnorals((Annotated)object);
        object = this._primary.findPropertyIgnorals((Annotated)object);
        if (value == null) {
            return object;
        }
        return value.withOverrides((JsonIgnoreProperties.Value)object);
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker<?> visibilityChecker) {
        visibilityChecker = this._secondary.findAutoDetectVisibility(annotatedClass, visibilityChecker);
        return this._primary.findAutoDetectVisibility(annotatedClass, visibilityChecker);
    }

    @Override
    public JsonTypeInfo.Value findPolymorphicTypeInfo(MapperConfig<?> mapperConfig, Annotated annotated) {
        JsonTypeInfo.Value value = this._primary.findPolymorphicTypeInfo(mapperConfig, annotated);
        if (value == null) {
            value = this._secondary.findPolymorphicTypeInfo(mapperConfig, annotated);
        }
        return value;
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        TypeResolverBuilder<?> typeResolverBuilder = this._primary.findTypeResolver(mapperConfig, annotatedClass, javaType);
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this._secondary.findTypeResolver(mapperConfig, annotatedClass, javaType);
        }
        return typeResolverBuilder;
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        TypeResolverBuilder<?> typeResolverBuilder = this._primary.findPropertyTypeResolver(mapperConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this._secondary.findPropertyTypeResolver(mapperConfig, annotatedMember, javaType);
        }
        return typeResolverBuilder;
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        TypeResolverBuilder<?> typeResolverBuilder = this._primary.findPropertyContentTypeResolver(mapperConfig, annotatedMember, javaType);
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this._secondary.findPropertyContentTypeResolver(mapperConfig, annotatedMember, javaType);
        }
        return typeResolverBuilder;
    }

    @Override
    public List<NamedType> findSubtypes(Annotated object) {
        List<NamedType> list = this._primary.findSubtypes((Annotated)object);
        object = this._secondary.findSubtypes((Annotated)object);
        if (list == null || list.isEmpty()) {
            return object;
        }
        if (object == null || object.isEmpty()) {
            return list;
        }
        ArrayList<NamedType> arrayList = new ArrayList<NamedType>(list.size() + object.size());
        arrayList.addAll(list);
        arrayList.addAll((Collection<NamedType>)object);
        return arrayList;
    }

    @Override
    public String findTypeName(AnnotatedClass annotatedClass) {
        String string = this._primary.findTypeName(annotatedClass);
        if (string == null || string.isEmpty()) {
            string = this._secondary.findTypeName(annotatedClass);
        }
        return string;
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember annotatedMember) {
        AnnotationIntrospector.ReferenceProperty referenceProperty = this._primary.findReferenceType(annotatedMember);
        if (referenceProperty == null) {
            return this._secondary.findReferenceType(annotatedMember);
        }
        return referenceProperty;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember annotatedMember) {
        NameTransformer nameTransformer = this._primary.findUnwrappingNameTransformer(annotatedMember);
        if (nameTransformer == null) {
            return this._secondary.findUnwrappingNameTransformer(annotatedMember);
        }
        return nameTransformer;
    }

    @Override
    public JacksonInject.Value findInjectableValue(AnnotatedMember serializable) {
        Serializable serializable2 = this._primary.findInjectableValue((AnnotatedMember)serializable);
        if ((serializable2 == null || serializable2.getUseInput() == null) && (serializable = this._secondary.findInjectableValue((AnnotatedMember)serializable)) != null) {
            serializable2 = serializable2 == null ? serializable : serializable2.withUseInput(((JacksonInject.Value)serializable).getUseInput());
        }
        return serializable2;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return this._primary.hasIgnoreMarker(annotatedMember) || this._secondary.hasIgnoreMarker(annotatedMember);
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        Boolean bl2 = this._primary.hasRequiredMarker(annotatedMember);
        if (bl2 == null) {
            return this._secondary.hasRequiredMarker(annotatedMember);
        }
        return bl2;
    }

    @Override
    @Deprecated
    public Object findInjectableValueId(AnnotatedMember annotatedMember) {
        Object object = this._primary.findInjectableValueId(annotatedMember);
        if (object == null) {
            return this._secondary.findInjectableValueId(annotatedMember);
        }
        return object;
    }

    @Override
    public Object findSerializer(Annotated annotated) {
        Object object = this._primary.findSerializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonSerializer.None.class)) {
            return object;
        }
        AnnotationIntrospectorPair annotationIntrospectorPair = this;
        return annotationIntrospectorPair._explicitClassOrOb(annotationIntrospectorPair._secondary.findSerializer(annotated), JsonSerializer.None.class);
    }

    @Override
    public Object findKeySerializer(Annotated annotated) {
        Object object = this._primary.findKeySerializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonSerializer.None.class)) {
            return object;
        }
        AnnotationIntrospectorPair annotationIntrospectorPair = this;
        return annotationIntrospectorPair._explicitClassOrOb(annotationIntrospectorPair._secondary.findKeySerializer(annotated), JsonSerializer.None.class);
    }

    @Override
    public Object findContentSerializer(Annotated annotated) {
        Object object = this._primary.findContentSerializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonSerializer.None.class)) {
            return object;
        }
        AnnotationIntrospectorPair annotationIntrospectorPair = this;
        return annotationIntrospectorPair._explicitClassOrOb(annotationIntrospectorPair._secondary.findContentSerializer(annotated), JsonSerializer.None.class);
    }

    @Override
    public Object findNullSerializer(Annotated annotated) {
        Object object = this._primary.findNullSerializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonSerializer.None.class)) {
            return object;
        }
        AnnotationIntrospectorPair annotationIntrospectorPair = this;
        return annotationIntrospectorPair._explicitClassOrOb(annotationIntrospectorPair._secondary.findNullSerializer(annotated), JsonSerializer.None.class);
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(Annotated object) {
        JsonInclude.Value value = this._secondary.findPropertyInclusion((Annotated)object);
        object = this._primary.findPropertyInclusion((Annotated)object);
        if (value == null) {
            return object;
        }
        return value.withOverrides((JsonInclude.Value)object);
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated annotated) {
        JsonSerialize.Typing typing = this._primary.findSerializationTyping(annotated);
        if (typing == null) {
            return this._secondary.findSerializationTyping(annotated);
        }
        return typing;
    }

    @Override
    public Object findSerializationConverter(Annotated annotated) {
        Object object = this._primary.findSerializationConverter(annotated);
        if (object == null) {
            return this._secondary.findSerializationConverter(annotated);
        }
        return object;
    }

    @Override
    public Object findSerializationContentConverter(AnnotatedMember annotatedMember) {
        Object object = this._primary.findSerializationContentConverter(annotatedMember);
        if (object == null) {
            return this._secondary.findSerializationContentConverter(annotatedMember);
        }
        return object;
    }

    @Override
    public Class<?>[] findViews(Annotated annotated) {
        Class<?>[] classArray = this._primary.findViews(annotated);
        if (classArray == null) {
            classArray = this._secondary.findViews(annotated);
        }
        return classArray;
    }

    @Override
    public Boolean isTypeId(AnnotatedMember annotatedMember) {
        Boolean bl2 = this._primary.isTypeId(annotatedMember);
        if (bl2 == null) {
            return this._secondary.isTypeId(annotatedMember);
        }
        return bl2;
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        ObjectIdInfo objectIdInfo = this._primary.findObjectIdInfo(annotated);
        if (objectIdInfo == null) {
            return this._secondary.findObjectIdInfo(annotated);
        }
        return objectIdInfo;
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated annotated, ObjectIdInfo objectIdInfo) {
        objectIdInfo = this._secondary.findObjectReferenceInfo(annotated, objectIdInfo);
        objectIdInfo = this._primary.findObjectReferenceInfo(annotated, objectIdInfo);
        return objectIdInfo;
    }

    @Override
    public JsonFormat.Value findFormat(Annotated object) {
        JsonFormat.Value value = this._primary.findFormat((Annotated)object);
        if ((object = this._secondary.findFormat((Annotated)object)) == null) {
            return value;
        }
        return ((JsonFormat.Value)object).withOverrides(value);
    }

    @Override
    public PropertyName findWrapperName(Annotated annotated) {
        return PropertyName.merge(this._primary.findWrapperName(annotated), this._secondary.findWrapperName(annotated));
    }

    @Override
    public String findPropertyDefaultValue(Annotated annotated) {
        String string = this._primary.findPropertyDefaultValue(annotated);
        if (string == null || string.isEmpty()) {
            return this._secondary.findPropertyDefaultValue(annotated);
        }
        return string;
    }

    @Override
    public String findPropertyDescription(Annotated annotated) {
        String string = this._primary.findPropertyDescription(annotated);
        if (string == null) {
            return this._secondary.findPropertyDescription(annotated);
        }
        return string;
    }

    @Override
    public Integer findPropertyIndex(Annotated annotated) {
        Integer n2 = this._primary.findPropertyIndex(annotated);
        if (n2 == null) {
            return this._secondary.findPropertyIndex(annotated);
        }
        return n2;
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember annotatedMember) {
        String string = this._primary.findImplicitPropertyName(annotatedMember);
        if (string == null) {
            return this._secondary.findImplicitPropertyName(annotatedMember);
        }
        return string;
    }

    @Override
    public List<PropertyName> findPropertyAliases(Annotated annotated) {
        List<PropertyName> list = this._primary.findPropertyAliases(annotated);
        if (list == null) {
            return this._secondary.findPropertyAliases(annotated);
        }
        return list;
    }

    @Override
    public JsonProperty.Access findPropertyAccess(Annotated annotated) {
        JsonProperty.Access access = this._primary.findPropertyAccess(annotated);
        if (access != null && access != JsonProperty.Access.AUTO) {
            return access;
        }
        access = this._secondary.findPropertyAccess(annotated);
        if (access != null) {
            return access;
        }
        return JsonProperty.Access.AUTO;
    }

    @Override
    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, AnnotatedMethod annotatedMethod2) {
        AnnotatedMethod annotatedMethod3 = this._primary.resolveSetterConflict(mapperConfig, annotatedMethod, annotatedMethod2);
        if (annotatedMethod3 == null) {
            annotatedMethod3 = this._secondary.resolveSetterConflict(mapperConfig, annotatedMethod, annotatedMethod2);
        }
        return annotatedMethod3;
    }

    @Override
    public PropertyName findRenameByField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, PropertyName propertyName) {
        return PropertyName.merge(this._secondary.findRenameByField(mapperConfig, annotatedField, propertyName), this._primary.findRenameByField(mapperConfig, annotatedField, propertyName));
    }

    @Override
    public JavaType refineSerializationType(MapperConfig<?> mapperConfig, Annotated annotated, JavaType javaType) {
        javaType = this._secondary.refineSerializationType(mapperConfig, annotated, javaType);
        return this._primary.refineSerializationType(mapperConfig, annotated, javaType);
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        String[] stringArray = this._primary.findSerializationPropertyOrder(annotatedClass);
        if (stringArray == null) {
            return this._secondary.findSerializationPropertyOrder(annotatedClass);
        }
        return stringArray;
    }

    @Override
    public Boolean findSerializationSortAlphabetically(Annotated annotated) {
        Boolean bl2 = this._primary.findSerializationSortAlphabetically(annotated);
        if (bl2 == null) {
            return this._secondary.findSerializationSortAlphabetically(annotated);
        }
        return bl2;
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, List<BeanPropertyWriter> list) {
        this._primary.findAndAddVirtualProperties(mapperConfig, annotatedClass, list);
        this._secondary.findAndAddVirtualProperties(mapperConfig, annotatedClass, list);
    }

    @Override
    public PropertyName findNameForSerialization(Annotated annotated) {
        return PropertyName.merge(this._primary.findNameForSerialization(annotated), this._secondary.findNameForSerialization(annotated));
    }

    @Override
    public Boolean hasAsKey(MapperConfig<?> mapperConfig, Annotated annotated) {
        Boolean bl2 = this._primary.hasAsKey(mapperConfig, annotated);
        if (bl2 == null) {
            bl2 = this._secondary.hasAsKey(mapperConfig, annotated);
        }
        return bl2;
    }

    @Override
    public Boolean hasAsValue(Annotated annotated) {
        Boolean bl2 = this._primary.hasAsValue(annotated);
        if (bl2 == null) {
            bl2 = this._secondary.hasAsValue(annotated);
        }
        return bl2;
    }

    @Override
    public Boolean hasAnyGetter(Annotated annotated) {
        Boolean bl2 = this._primary.hasAnyGetter(annotated);
        if (bl2 == null) {
            bl2 = this._secondary.hasAnyGetter(annotated);
        }
        return bl2;
    }

    @Override
    @Deprecated
    public String[] findEnumValues(Class<?> clazz, Enum<?>[] enumArray, String[] stringArray) {
        stringArray = this._secondary.findEnumValues(clazz, enumArray, stringArray);
        stringArray = this._primary.findEnumValues(clazz, enumArray, stringArray);
        return stringArray;
    }

    @Override
    public String[] findEnumValues(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, Enum<?>[] enumArray, String[] stringArray) {
        stringArray = this._secondary.findEnumValues(mapperConfig, annotatedClass, enumArray, stringArray);
        stringArray = this._primary.findEnumValues(mapperConfig, annotatedClass, enumArray, stringArray);
        return stringArray;
    }

    @Override
    @Deprecated
    public void findEnumAliases(Class<?> clazz, Enum<?>[] enumArray, String[][] stringArray) {
        this._secondary.findEnumAliases(clazz, enumArray, stringArray);
        this._primary.findEnumAliases(clazz, enumArray, stringArray);
    }

    @Override
    public void findEnumAliases(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, Enum<?>[] enumArray, String[][] stringArray) {
        this._secondary.findEnumAliases(mapperConfig, annotatedClass, enumArray, stringArray);
        this._primary.findEnumAliases(mapperConfig, annotatedClass, enumArray, stringArray);
    }

    @Override
    @Deprecated
    public Enum<?> findDefaultEnumValue(Class<Enum<?>> clazz) {
        Enum<?> enum_ = this._primary.findDefaultEnumValue(clazz);
        if (enum_ == null) {
            return this._secondary.findDefaultEnumValue(clazz);
        }
        return enum_;
    }

    @Override
    public Enum<?> findDefaultEnumValue(AnnotatedClass annotatedClass, Enum<?>[] enumArray) {
        Enum<?> enum_ = this._primary.findDefaultEnumValue(annotatedClass, enumArray);
        if (enum_ == null) {
            return this._secondary.findDefaultEnumValue(annotatedClass, enumArray);
        }
        return enum_;
    }

    @Override
    @Deprecated
    public String findEnumValue(Enum<?> enum_) {
        String string = this._primary.findEnumValue(enum_);
        if (string == null) {
            return this._secondary.findEnumValue(enum_);
        }
        return string;
    }

    @Override
    @Deprecated
    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        return this._primary.hasAsValueAnnotation(annotatedMethod) || this._secondary.hasAsValueAnnotation(annotatedMethod);
    }

    @Override
    @Deprecated
    public boolean hasAnyGetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._primary.hasAnyGetterAnnotation(annotatedMethod) || this._secondary.hasAnyGetterAnnotation(annotatedMethod);
    }

    @Override
    public Object findDeserializer(Annotated annotated) {
        Object object = this._primary.findDeserializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonDeserializer.None.class)) {
            return object;
        }
        AnnotationIntrospectorPair annotationIntrospectorPair = this;
        return annotationIntrospectorPair._explicitClassOrOb(annotationIntrospectorPair._secondary.findDeserializer(annotated), JsonDeserializer.None.class);
    }

    @Override
    public Object findKeyDeserializer(Annotated annotated) {
        Object object = this._primary.findKeyDeserializer(annotated);
        if (this._isExplicitClassOrOb(object, KeyDeserializer.None.class)) {
            return object;
        }
        AnnotationIntrospectorPair annotationIntrospectorPair = this;
        return annotationIntrospectorPair._explicitClassOrOb(annotationIntrospectorPair._secondary.findKeyDeserializer(annotated), KeyDeserializer.None.class);
    }

    @Override
    public Object findContentDeserializer(Annotated annotated) {
        Object object = this._primary.findContentDeserializer(annotated);
        if (this._isExplicitClassOrOb(object, JsonDeserializer.None.class)) {
            return object;
        }
        AnnotationIntrospectorPair annotationIntrospectorPair = this;
        return annotationIntrospectorPair._explicitClassOrOb(annotationIntrospectorPair._secondary.findContentDeserializer(annotated), JsonDeserializer.None.class);
    }

    @Override
    public Object findDeserializationConverter(Annotated annotated) {
        Object object = this._primary.findDeserializationConverter(annotated);
        if (object == null) {
            return this._secondary.findDeserializationConverter(annotated);
        }
        return object;
    }

    @Override
    public Object findDeserializationContentConverter(AnnotatedMember annotatedMember) {
        Object object = this._primary.findDeserializationContentConverter(annotatedMember);
        if (object == null) {
            return this._secondary.findDeserializationContentConverter(annotatedMember);
        }
        return object;
    }

    @Override
    public JavaType refineDeserializationType(MapperConfig<?> mapperConfig, Annotated annotated, JavaType javaType) {
        javaType = this._secondary.refineDeserializationType(mapperConfig, annotated, javaType);
        return this._primary.refineDeserializationType(mapperConfig, annotated, javaType);
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass annotatedClass) {
        Object object = this._primary.findValueInstantiator(annotatedClass);
        if (object == null) {
            return this._secondary.findValueInstantiator(annotatedClass);
        }
        return object;
    }

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass annotatedClass) {
        Class<?> clazz = this._primary.findPOJOBuilder(annotatedClass);
        if (clazz == null) {
            return this._secondary.findPOJOBuilder(annotatedClass);
        }
        return clazz;
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass annotatedClass) {
        JsonPOJOBuilder.Value value = this._primary.findPOJOBuilderConfig(annotatedClass);
        if (value == null) {
            return this._secondary.findPOJOBuilderConfig(annotatedClass);
        }
        return value;
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated annotated) {
        return PropertyName.merge(this._primary.findNameForDeserialization(annotated), this._secondary.findNameForDeserialization(annotated));
    }

    @Override
    public Boolean hasAnySetter(Annotated annotated) {
        Boolean bl2 = this._primary.hasAnySetter(annotated);
        if (bl2 == null) {
            bl2 = this._secondary.hasAnySetter(annotated);
        }
        return bl2;
    }

    @Override
    public JsonSetter.Value findSetterInfo(Annotated object) {
        JsonSetter.Value value = this._secondary.findSetterInfo((Annotated)object);
        object = this._primary.findSetterInfo((Annotated)object);
        if (value == null) {
            return object;
        }
        return value.withOverrides((JsonSetter.Value)object);
    }

    @Override
    public Boolean findMergeInfo(Annotated annotated) {
        Boolean bl2 = this._primary.findMergeInfo(annotated);
        if (bl2 == null) {
            bl2 = this._secondary.findMergeInfo(annotated);
        }
        return bl2;
    }

    @Override
    @Deprecated
    public boolean hasCreatorAnnotation(Annotated annotated) {
        return this._primary.hasCreatorAnnotation(annotated) || this._secondary.hasCreatorAnnotation(annotated);
    }

    @Override
    @Deprecated
    public JsonCreator.Mode findCreatorBinding(Annotated annotated) {
        JsonCreator.Mode mode = this._primary.findCreatorBinding(annotated);
        if (mode != null) {
            return mode;
        }
        return this._secondary.findCreatorBinding(annotated);
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> mapperConfig, Annotated annotated) {
        JsonCreator.Mode mode = this._primary.findCreatorAnnotation(mapperConfig, annotated);
        if (mode == null) {
            return this._secondary.findCreatorAnnotation(mapperConfig, annotated);
        }
        return mode;
    }

    @Override
    @Deprecated
    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._primary.hasAnySetterAnnotation(annotatedMethod) || this._secondary.hasAnySetterAnnotation(annotatedMethod);
    }

    protected boolean _isExplicitClassOrOb(Object object, Class<?> clazz) {
        if (object == null || object == clazz) {
            return false;
        }
        if (object instanceof Class) {
            return !ClassUtil.isBogusClass((Class)object);
        }
        return true;
    }

    protected Object _explicitClassOrOb(Object object, Class<?> clazz) {
        if (object == null || object == clazz) {
            return null;
        }
        if (object instanceof Class && ClassUtil.isBogusClass((Class)object)) {
            return null;
        }
        return object;
    }
}

