/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedAndMetadata;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicBeanDescription
extends BeanDescription {
    private static final Class<?>[] a = new Class[0];
    protected final POJOPropertiesCollector _propCollector;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final AnnotatedClass _classInfo;
    protected Class<?>[] _defaultViews;
    protected boolean _defaultViewsResolved;
    protected List<BeanPropertyDefinition> _properties;
    protected ObjectIdInfo _objectIdInfo;

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector, JavaType javaType, AnnotatedClass annotatedClass) {
        super(javaType);
        this._propCollector = pOJOPropertiesCollector;
        this._config = pOJOPropertiesCollector.getConfig();
        this._annotationIntrospector = this._config == null ? null : this._config.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
    }

    protected BasicBeanDescription(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass, List<BeanPropertyDefinition> list) {
        super(javaType);
        this._propCollector = null;
        this._config = mapperConfig;
        this._annotationIntrospector = this._config == null ? null : this._config.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
        this._properties = list;
    }

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector) {
        POJOPropertiesCollector pOJOPropertiesCollector2 = pOJOPropertiesCollector;
        this(pOJOPropertiesCollector2, pOJOPropertiesCollector2.getType(), pOJOPropertiesCollector.getClassDef());
        this._objectIdInfo = pOJOPropertiesCollector.getObjectIdInfo();
    }

    public static BasicBeanDescription forDeserialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forSerialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        return new BasicBeanDescription(pOJOPropertiesCollector);
    }

    public static BasicBeanDescription forOtherUse(MapperConfig<?> mapperConfig, JavaType javaType, AnnotatedClass annotatedClass) {
        return new BasicBeanDescription(mapperConfig, javaType, annotatedClass, Collections.emptyList());
    }

    protected List<BeanPropertyDefinition> _properties() {
        if (this._properties == null) {
            this._properties = this._propCollector.getProperties();
        }
        return this._properties;
    }

    public boolean removeProperty(String string) {
        Iterator<BeanPropertyDefinition> iterator = this._properties().iterator();
        while (iterator.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = iterator.next();
            if (!beanPropertyDefinition.getName().equals(string)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean addProperty(BeanPropertyDefinition beanPropertyDefinition) {
        if (this.hasProperty(beanPropertyDefinition.getFullName())) {
            return false;
        }
        this._properties().add(beanPropertyDefinition);
        return true;
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public BeanPropertyDefinition findProperty(PropertyName propertyName) {
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            if (!beanPropertyDefinition.hasName(propertyName)) continue;
            return beanPropertyDefinition;
        }
        return null;
    }

    @Override
    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    @Override
    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    @Override
    public List<BeanPropertyDefinition> findProperties() {
        return this._properties();
    }

    @Override
    public AnnotatedMember findJsonKeyAccessor() {
        if (this._propCollector == null) {
            return null;
        }
        return this._propCollector.getJsonKeyAccessor();
    }

    @Override
    @Deprecated
    public AnnotatedMethod findJsonValueMethod() {
        if (this._propCollector == null) {
            return null;
        }
        return this._propCollector.getJsonValueMethod();
    }

    @Override
    public AnnotatedMember findJsonValueAccessor() {
        if (this._propCollector == null) {
            return null;
        }
        return this._propCollector.getJsonValueAccessor();
    }

    @Override
    public Set<String> getIgnoredPropertyNames() {
        Set<String> set = this._propCollector == null ? null : this._propCollector.getIgnoredPropertyNames();
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    @Override
    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    @Override
    public Annotations getClassAnnotations() {
        return this._classInfo.getAnnotations();
    }

    @Override
    @Deprecated
    public TypeBindings bindingsForBeanType() {
        return this._type.getBindings();
    }

    @Override
    @Deprecated
    public JavaType resolveType(Type type) {
        return this._config.getTypeFactory().resolveMemberType(type, this._type.getBindings());
    }

    @Override
    public AnnotatedConstructor findDefaultConstructor() {
        return this._classInfo.getDefaultConstructor();
    }

    @Override
    public AnnotatedMember findAnySetterAccessor() {
        if (this._propCollector != null) {
            Serializable serializable = this._propCollector.getAnySetterMethod();
            if (serializable != null) {
                Class<?> clazz = ((AnnotatedWithParams)serializable).getRawParameterType(0);
                if (clazz != String.class && clazz != Object.class) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on method '%s()': first argument not of type String or Object, but %s", ((Annotated)((Object)serializable)).getName(), clazz.getName()));
                }
                return serializable;
            }
            AnnotatedMember annotatedMember = this._propCollector.getAnySetterField();
            if (annotatedMember != null) {
                serializable = annotatedMember.getRawType();
                if (!Map.class.isAssignableFrom((Class<?>)serializable) && !JsonNode.class.isAssignableFrom((Class<?>)serializable)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-setter' annotation on field '%s': type is not instance of `java.util.Map` or `JsonNode`", annotatedMember.getName()));
                }
                return annotatedMember;
            }
        }
        return null;
    }

    @Override
    public Map<Object, AnnotatedMember> findInjectables() {
        if (this._propCollector != null) {
            return this._propCollector.getInjectables();
        }
        return Collections.emptyMap();
    }

    @Override
    public List<AnnotatedConstructor> getConstructors() {
        return this._classInfo.getConstructors();
    }

    @Override
    public List<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> getConstructorsWithMode() {
        List<AnnotatedConstructor> list = this._classInfo.getConstructors();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>> arrayList = new ArrayList<AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode>>();
        for (AnnotatedConstructor annotatedConstructor : list) {
            JsonCreator.Mode mode = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedConstructor);
            if (mode == JsonCreator.Mode.DISABLED) continue;
            arrayList.add(AnnotatedAndMetadata.of(annotatedConstructor, mode));
        }
        return arrayList;
    }

    @Override
    public Object instantiateBean(boolean bl2) {
        AnnotatedConstructor annotatedConstructor = this._classInfo.getDefaultConstructor();
        if (annotatedConstructor == null) {
            return null;
        }
        if (bl2) {
            annotatedConstructor.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        try {
            return ((AnnotatedWithParams)annotatedConstructor).call();
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            throwable = exception;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            ClassUtil.throwIfError(throwable);
            ClassUtil.throwIfRTE(throwable);
            throw new IllegalArgumentException("Failed to instantiate bean of type " + ((Class)this._classInfo.getAnnotated()).getName() + ": (" + throwable.getClass().getName() + ") " + ClassUtil.exceptionMessage(throwable), throwable);
        }
    }

    @Override
    public AnnotatedMethod findMethod(String string, Class<?>[] classArray) {
        return this._classInfo.findMethod(string, classArray);
    }

    @Override
    public JsonFormat.Value findExpectedFormat() {
        if (this._propCollector == null) {
            return JsonFormat.Value.empty();
        }
        return this._propCollector.getFormatOverrides();
    }

    @Override
    public Class<?>[] findDefaultViews() {
        if (!this._defaultViewsResolved) {
            this._defaultViewsResolved = true;
            Class<?>[] classArray = this._annotationIntrospector == null ? null : this._annotationIntrospector.findViews(this._classInfo);
            if (classArray == null && !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
                classArray = a;
            }
            this._defaultViews = classArray;
        }
        return this._defaultViews;
    }

    @Override
    public Converter<Object, Object> findSerializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        BasicBeanDescription basicBeanDescription = this;
        return basicBeanDescription._createConverter(basicBeanDescription._annotationIntrospector.findSerializationConverter(this._classInfo));
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(JsonInclude.Value value) {
        JsonInclude.Value value2;
        if (this._annotationIntrospector != null && (value2 = this._annotationIntrospector.findPropertyInclusion(this._classInfo)) != null) {
            if (value == null) {
                return value2;
            }
            return value.withOverrides(value2);
        }
        return value;
    }

    @Override
    public AnnotatedMember findAnyGetter() {
        if (this._propCollector != null) {
            Serializable serializable = this._propCollector.getAnyGetterMethod();
            if (serializable != null) {
                Class<?> clazz = ((Annotated)((Object)serializable)).getRawType();
                if (!Map.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on method %s(): return type is not instance of java.util.Map", ((Annotated)((Object)serializable)).getName()));
                }
                return serializable;
            }
            AnnotatedMember annotatedMember = this._propCollector.getAnyGetterField();
            if (annotatedMember != null) {
                serializable = annotatedMember.getRawType();
                if (!Map.class.isAssignableFrom((Class<?>)serializable)) {
                    throw new IllegalArgumentException(String.format("Invalid 'any-getter' annotation on field '%s': type is not instance of java.util.Map", annotatedMember.getName()));
                }
                return annotatedMember;
            }
        }
        return null;
    }

    @Override
    public List<BeanPropertyDefinition> findBackReferences() {
        ArrayList<BeanPropertyDefinition> arrayList = null;
        HashSet<Object> hashSet = null;
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            Object object = beanPropertyDefinition.findReferenceType();
            if (object == null || !((AnnotationIntrospector.ReferenceProperty)object).isBackReference()) continue;
            object = ((AnnotationIntrospector.ReferenceProperty)object).getName();
            if (arrayList == null) {
                arrayList = new ArrayList<BeanPropertyDefinition>();
                hashSet = new HashSet<Object>();
                hashSet.add(object);
            } else if (!hashSet.add(object)) {
                throw new IllegalArgumentException("Multiple back-reference properties with name " + ClassUtil.name((String)object));
            }
            arrayList.add(beanPropertyDefinition);
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public Map<String, AnnotatedMember> findBackReferenceProperties() {
        List<BeanPropertyDefinition> list = ((BeanDescription)this).findBackReferences();
        if (list == null) {
            return null;
        }
        HashMap<String, AnnotatedMember> hashMap = new HashMap<String, AnnotatedMember>();
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            hashMap.put(beanPropertyDefinition.getName(), beanPropertyDefinition.getMutator());
        }
        return hashMap;
    }

    @Override
    public List<AnnotatedMethod> getFactoryMethods() {
        List<AnnotatedMethod> list = this._classInfo.getFactoryMethods();
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<AnnotatedMethod> arrayList = null;
        for (AnnotatedMethod annotatedMethod : list) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<AnnotatedMethod>();
            }
            arrayList.add(annotatedMethod);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    @Override
    public List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> getFactoryMethodsWithMode() {
        List<AnnotatedMethod> list = this._classInfo.getFactoryMethods();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> arrayList = null;
        for (AnnotatedMethod annotatedMethod : list) {
            AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> object = this.findFactoryMethodMetadata(annotatedMethod);
            if (object == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>>();
            }
            arrayList.add(object);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public Constructor<?> findSingleArgConstructor(Class<?> ... classArray) {
        for (AnnotatedConstructor annotatedConstructor : this._classInfo.getConstructors()) {
            if (((AnnotatedWithParams)annotatedConstructor).getParameterCount() != 1) continue;
            Class<?> clazz = ((AnnotatedWithParams)annotatedConstructor).getRawParameterType(0);
            Class<?>[] classArray2 = classArray;
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz2 = classArray2[i2];
                if (clazz2 != clazz) continue;
                return annotatedConstructor.getAnnotated();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public Method findFactoryMethod(Class<?> ... classArray) {
        for (AnnotatedMethod annotatedMethod : this._classInfo.getFactoryMethods()) {
            if (!this.isFactoryMethod(annotatedMethod) || ((AnnotatedWithParams)annotatedMethod).getParameterCount() != 1) continue;
            Class<?> clazz = ((AnnotatedWithParams)annotatedMethod).getRawParameterType(0);
            Class<?>[] classArray2 = classArray;
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz2 = classArray2[i2];
                if (!clazz.isAssignableFrom(clazz2)) continue;
                return annotatedMethod.getAnnotated();
            }
        }
        return null;
    }

    protected boolean isFactoryMethod(AnnotatedMethod serializable) {
        Object object = serializable.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom((Class<?>)object)) {
            return false;
        }
        object = this._annotationIntrospector.findCreatorAnnotation(this._config, (Annotated)((Object)serializable));
        if (object != null && object != JsonCreator.Mode.DISABLED) {
            return true;
        }
        object = ((Annotated)((Object)serializable)).getName();
        if ("valueOf".equals(object) && ((AnnotatedWithParams)serializable).getParameterCount() == 1) {
            return true;
        }
        return "fromString".equals(object) && ((AnnotatedWithParams)serializable).getParameterCount() == 1 && ((serializable = ((AnnotatedWithParams)serializable).getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom((Class<?>)serializable));
    }

    protected AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> findFactoryMethodMetadata(AnnotatedMethod annotatedMethod) {
        Object object = annotatedMethod.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom((Class<?>)object)) {
            return null;
        }
        object = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedMethod);
        if (object != null) {
            if (object == JsonCreator.Mode.DISABLED) {
                return null;
            }
            return AnnotatedAndMetadata.of(annotatedMethod, object);
        }
        Object object2 = ((Annotated)annotatedMethod).getName();
        if ("valueOf".equals(object2) && ((AnnotatedWithParams)annotatedMethod).getParameterCount() == 1) {
            return AnnotatedAndMetadata.of(annotatedMethod, object);
        }
        if ("fromString".equals(object2) && ((AnnotatedWithParams)annotatedMethod).getParameterCount() == 1 && ((object2 = ((AnnotatedWithParams)annotatedMethod).getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom((Class<?>)object2))) {
            return AnnotatedAndMetadata.of(annotatedMethod, object);
        }
        return null;
    }

    @Deprecated
    protected PropertyName _findCreatorPropertyName(AnnotatedParameter object) {
        PropertyName propertyName = this._annotationIntrospector.findNameForDeserialization((Annotated)object);
        if ((propertyName == null || propertyName.isEmpty()) && (object = this._annotationIntrospector.findImplicitPropertyName((AnnotatedMember)object)) != null && !((String)object).isEmpty()) {
            propertyName = PropertyName.construct((String)object);
        }
        return propertyName;
    }

    @Override
    public Class<?> findPOJOBuilder() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._annotationIntrospector.findPOJOBuilder(this._classInfo);
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._annotationIntrospector.findPOJOBuilderConfig(this._classInfo);
    }

    @Override
    public Converter<Object, Object> findDeserializationConverter() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        BasicBeanDescription basicBeanDescription = this;
        return basicBeanDescription._createConverter(basicBeanDescription._annotationIntrospector.findDeserializationConverter(this._classInfo));
    }

    @Override
    public String findClassDescription() {
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._annotationIntrospector.findClassDescription(this._classInfo);
    }

    @Deprecated
    public LinkedHashMap<String, AnnotatedField> _findPropertyFields(Collection<String> collection, boolean bl2) {
        LinkedHashMap<String, AnnotatedField> linkedHashMap = new LinkedHashMap<String, AnnotatedField>();
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties()) {
            AnnotatedField annotatedField = beanPropertyDefinition.getField();
            if (annotatedField == null) continue;
            String string = beanPropertyDefinition.getName();
            if (collection != null && collection.contains(string)) continue;
            linkedHashMap.put(string, annotatedField);
        }
        return linkedHashMap;
    }

    protected Converter<Object, Object> _createConverter(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        if ((object = (Class)object) == Converter.None.class || ClassUtil.isBogusClass(object)) {
            return null;
        }
        if (!Converter.class.isAssignableFrom((Class<?>)object)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + ((Class)object).getName() + "; expected Class<Converter>");
        }
        Object object2 = this._config.getHandlerInstantiator();
        object2 = object2 == null ? null : ((HandlerInstantiator)object2).converterInstance(this._config, this._classInfo, (Class<?>)object);
        if (object2 == null) {
            object2 = (Converter)ClassUtil.createInstance(object, this._config.canOverrideAccessModifiers());
        }
        return object2;
    }
}

