/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final Class<?> a = Object.class;
    private static final Class<?> b = String.class;
    private static final Class<?> c = JsonNode.class;
    protected static final BasicBeanDescription STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), AnnotatedClassResolver.a(b));
    protected static final BasicBeanDescription BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Boolean.TYPE), AnnotatedClassResolver.a(Boolean.TYPE));
    protected static final BasicBeanDescription INT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Integer.TYPE), AnnotatedClassResolver.a(Integer.TYPE));
    protected static final BasicBeanDescription LONG_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Long.TYPE), AnnotatedClassResolver.a(Long.TYPE));
    protected static final BasicBeanDescription OBJECT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Object.class), AnnotatedClassResolver.a(a));

    @Override
    public ClassIntrospector copy() {
        return new BasicClassIntrospector();
    }

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig serializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(serializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(serializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forSerialization(this.collectProperties(serializationConfig, javaType, mixInResolver, true));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(deserializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, BeanDescription beanDescription) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, mixInResolver, beanDescription, false));
    }

    @Override
    @Deprecated
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, mixInResolver, null, false));
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(deserializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, mixInResolver, false));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(mapperConfig, javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, mixInResolver));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDirectClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(mapperConfig, javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedWithoutSuperTypes(mapperConfig, javaType, mixInResolver));
        }
        return basicBeanDescription;
    }

    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver object, boolean bl2) {
        object = this._resolveAnnotatedClass(mapperConfig, javaType, (ClassIntrospector.MixInResolver)object);
        AccessorNamingStrategy accessorNamingStrategy = javaType.isRecordType() ? mapperConfig.getAccessorNaming().forRecord(mapperConfig, (AnnotatedClass)object) : mapperConfig.getAccessorNaming().forPOJO(mapperConfig, (AnnotatedClass)object);
        return this.constructPropertyCollector(mapperConfig, (AnnotatedClass)object, javaType, bl2, accessorNamingStrategy);
    }

    @Deprecated
    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver object, boolean bl2, String object2) {
        object = this._resolveAnnotatedClass(mapperConfig, javaType, (ClassIntrospector.MixInResolver)object);
        object2 = ((AccessorNamingStrategy.Provider)new DefaultAccessorNamingStrategy.Provider().withSetterPrefix((String)object2)).forPOJO(mapperConfig, (AnnotatedClass)object);
        return this.constructPropertyCollector(mapperConfig, (AnnotatedClass)object, javaType, bl2, (AccessorNamingStrategy)object2);
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver object, BeanDescription object2, boolean bl2) {
        object = this._resolveAnnotatedClass(mapperConfig, javaType, (ClassIntrospector.MixInResolver)object);
        object2 = mapperConfig.getAccessorNaming().forBuilder(mapperConfig, (AnnotatedClass)object, (BeanDescription)object2);
        return this.constructPropertyCollector(mapperConfig, (AnnotatedClass)object, javaType, bl2, (AccessorNamingStrategy)object2);
    }

    @Deprecated
    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver, boolean bl2) {
        return this.collectPropertiesWithBuilder(mapperConfig, javaType, mixInResolver, null, bl2);
    }

    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl2, AccessorNamingStrategy accessorNamingStrategy) {
        return new POJOPropertiesCollector(mapperConfig, bl2, javaType, annotatedClass, accessorNamingStrategy);
    }

    @Deprecated
    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl2, String string) {
        return new POJOPropertiesCollector(mapperConfig, bl2, javaType, annotatedClass, string);
    }

    protected BasicBeanDescription _findStdTypeDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_DESC;
            }
            if (clazz == Long.TYPE) {
                return LONG_DESC;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_DESC;
            }
        } else if (ClassUtil.isJDKClass(clazz)) {
            if (clazz == a) {
                return OBJECT_DESC;
            }
            if (clazz == b) {
                return STRING_DESC;
            }
            if (clazz == Integer.class) {
                return INT_DESC;
            }
            if (clazz == Long.class) {
                return LONG_DESC;
            }
            if (clazz == Boolean.class) {
                return BOOLEAN_DESC;
            }
        } else if (c.isAssignableFrom(clazz)) {
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, AnnotatedClassResolver.a(clazz));
        }
        return null;
    }

    protected boolean _isStdJDKCollection(JavaType type) {
        if (!((ResolvedType)((Object)type)).isContainerType() || ((ResolvedType)((Object)type)).isArrayType()) {
            return false;
        }
        return ClassUtil.isJDKClass(type = ((ResolvedType)((Object)type)).getRawClass()) && (Collection.class.isAssignableFrom((Class<?>)type) || Map.class.isAssignableFrom((Class<?>)type));
    }

    protected BasicBeanDescription _findStdJdkCollectionDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        if (this._isStdJDKCollection(javaType)) {
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, mapperConfig));
        }
        return null;
    }

    protected AnnotatedClass _resolveAnnotatedClass(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return AnnotatedClassResolver.resolve(mapperConfig, javaType, mixInResolver);
    }

    protected AnnotatedClass _resolveAnnotatedWithoutSuperTypes(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector.MixInResolver mixInResolver) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, javaType, mixInResolver);
    }
}

