/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.jdk14.JDK14Util;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultAccessorNamingStrategy
extends AccessorNamingStrategy {
    protected final MapperConfig<?> _config;
    protected final AnnotatedClass _forClass;
    protected final BaseNameValidator _baseNameValidator;
    protected final boolean _stdBeanNaming;
    protected final boolean _isGettersNonBoolean;
    protected final String _getterPrefix;
    protected final String _isGetterPrefix;
    protected final String _mutatorPrefix;

    protected DefaultAccessorNamingStrategy(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, String string, String string2, String string3, BaseNameValidator baseNameValidator) {
        this._config = mapperConfig;
        this._forClass = annotatedClass;
        this._stdBeanNaming = mapperConfig.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
        this._isGettersNonBoolean = mapperConfig.isEnabled(MapperFeature.ALLOW_IS_GETTERS_FOR_NON_BOOLEAN);
        this._mutatorPrefix = string;
        this._getterPrefix = string2;
        this._isGetterPrefix = string3;
        this._baseNameValidator = baseNameValidator;
    }

    @Override
    public String findNameForIsGetter(AnnotatedMethod serializable, String string) {
        block6: {
            block7: {
                if (this._isGetterPrefix == null) break block6;
                if (this._isGettersNonBoolean) break block7;
                if (((ResolvedType)((Object)(serializable = ((Annotated)((Object)serializable)).getType()))).isReferenceType()) {
                    serializable = ((JavaType)serializable).getReferencedType();
                }
                if (!(((ResolvedType)((Object)serializable)).hasRawClass(Boolean.TYPE) || ((ResolvedType)((Object)serializable)).hasRawClass(Boolean.class) || ((ResolvedType)((Object)serializable)).hasRawClass(AtomicBoolean.class))) break block6;
            }
            if (string.startsWith(this._isGetterPrefix)) {
                if (this._stdBeanNaming) {
                    return this.stdManglePropertyName(string, this._isGetterPrefix.length());
                }
                return this.legacyManglePropertyName(string, this._isGetterPrefix.length());
            }
        }
        return null;
    }

    @Override
    public String findNameForRegularGetter(AnnotatedMethod annotatedMethod, String string) {
        if (this._getterPrefix != null && string.startsWith(this._getterPrefix)) {
            if ("getCallbacks".equals(string) ? this._isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && this._isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            if (this._stdBeanNaming) {
                return this.stdManglePropertyName(string, this._getterPrefix.length());
            }
            return this.legacyManglePropertyName(string, this._getterPrefix.length());
        }
        return null;
    }

    @Override
    public String findNameForMutator(AnnotatedMethod annotatedMethod, String string) {
        if (this._mutatorPrefix != null && string.startsWith(this._mutatorPrefix)) {
            if (this._stdBeanNaming) {
                return this.stdManglePropertyName(string, this._mutatorPrefix.length());
            }
            return this.legacyManglePropertyName(string, this._mutatorPrefix.length());
        }
        return null;
    }

    @Override
    public String modifyFieldName(AnnotatedField annotatedField, String string) {
        return string;
    }

    protected String legacyManglePropertyName(String string, int n2) {
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c2 = string.charAt(n2);
        if (this._baseNameValidator != null && !this._baseNameValidator.accept(c2, string, n2)) {
            return null;
        }
        char c3 = Character.toLowerCase(c2);
        if (c2 == c3) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c3);
        ++n2;
        while (n2 < n3) {
            c2 = string.charAt(n2);
            if (c2 == (c3 = Character.toLowerCase(c2))) {
                stringBuilder.append(string, n2, n3);
                break;
            }
            stringBuilder.append(c3);
            ++n2;
        }
        return stringBuilder.toString();
    }

    protected String stdManglePropertyName(String string, int n2) {
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c2 = string.charAt(n2);
        if (this._baseNameValidator != null && !this._baseNameValidator.accept(c2, string, n2)) {
            return null;
        }
        char c3 = Character.toLowerCase(c2);
        if (c2 == c3) {
            return string.substring(n2);
        }
        if (n2 + 1 < n3 && Character.isUpperCase(string.charAt(n2 + 1))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c3);
        stringBuilder.append(string, n2 + 1, n3);
        return stringBuilder.toString();
    }

    protected boolean _isCglibGetCallbacks(AnnotatedMethod object) {
        if (((Class)(object = ((Annotated)object).getRawType())).isArray()) {
            object = ((Class)object).getComponentType();
            if (((String)(object = ((Class)object).getName())).contains(".cglib")) {
                return ((String)object).startsWith("net.sf.cglib") || ((String)object).startsWith("org.hibernate.repackage.cglib") || ((String)object).startsWith("org.springframework.cglib");
            }
        }
        return false;
    }

    protected boolean _isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        return ((Annotated)annotatedMethod).getRawType().getName().startsWith("groovy.lang");
    }

    public static class RecordNaming
    extends DefaultAccessorNamingStrategy {
        protected final Set<String> _fieldNames;

        public RecordNaming(MapperConfig<?> stringArray, AnnotatedClass annotatedClass) {
            super((MapperConfig<?>)stringArray, annotatedClass, null, "get", "is", null);
            stringArray = JDK14Util.getRecordFieldNames(((Annotated)annotatedClass).getRawType());
            this._fieldNames = stringArray == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(stringArray));
        }

        @Override
        public String findNameForRegularGetter(AnnotatedMethod annotatedMethod, String string) {
            if (this._fieldNames.contains(string)) {
                return string;
            }
            return super.findNameForRegularGetter(annotatedMethod, string);
        }
    }

    public static class FirstCharBasedValidator
    implements BaseNameValidator {
        private final boolean a;
        private final boolean b;

        protected FirstCharBasedValidator(boolean bl2, boolean bl3) {
            this.a = bl2;
            this.b = bl3;
        }

        public static BaseNameValidator forFirstNameRule(boolean bl2, boolean bl3) {
            if (!bl2 && !bl3) {
                return null;
            }
            return new FirstCharBasedValidator(bl2, bl3);
        }

        @Override
        public boolean accept(char c2, String string, int n2) {
            if (Character.isLetter(c2)) {
                return this.a || !Character.isLowerCase(c2);
            }
            return this.b;
        }
    }

    public static class Provider
    extends AccessorNamingStrategy.Provider
    implements Serializable {
        protected final String _setterPrefix;
        protected final String _withPrefix;
        protected final String _getterPrefix;
        protected final String _isGetterPrefix;
        protected final BaseNameValidator _baseNameValidator;

        public Provider() {
            this("set", "with", "get", "is", null);
        }

        protected Provider(Provider provider, String string, String string2, String string3, String string4) {
            this(string, string2, string3, string4, provider._baseNameValidator);
        }

        protected Provider(Provider provider, BaseNameValidator baseNameValidator) {
            this(provider._setterPrefix, provider._withPrefix, provider._getterPrefix, provider._isGetterPrefix, baseNameValidator);
        }

        protected Provider(String string, String string2, String string3, String string4, BaseNameValidator baseNameValidator) {
            this._setterPrefix = string;
            this._withPrefix = string2;
            this._getterPrefix = string3;
            this._isGetterPrefix = string4;
            this._baseNameValidator = baseNameValidator;
        }

        public Provider withSetterPrefix(String string) {
            return new Provider(this, string, this._withPrefix, this._getterPrefix, this._isGetterPrefix);
        }

        public Provider withBuilderPrefix(String string) {
            Provider provider = this;
            return new Provider(provider, provider._setterPrefix, string, this._getterPrefix, this._isGetterPrefix);
        }

        public Provider withGetterPrefix(String string) {
            Provider provider = this;
            return new Provider(provider, provider._setterPrefix, this._withPrefix, string, this._isGetterPrefix);
        }

        public Provider withIsGetterPrefix(String string) {
            Provider provider = this;
            return new Provider(provider, provider._setterPrefix, this._withPrefix, this._getterPrefix, string);
        }

        public Provider withFirstCharAcceptance(boolean bl2, boolean bl3) {
            return this.withBaseNameValidator(FirstCharBasedValidator.forFirstNameRule(bl2, bl3));
        }

        public Provider withBaseNameValidator(BaseNameValidator baseNameValidator) {
            return new Provider(this, baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forPOJO(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
            return new DefaultAccessorNamingStrategy(mapperConfig, annotatedClass, this._setterPrefix, this._getterPrefix, this._isGetterPrefix, this._baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forBuilder(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, BeanDescription object) {
            object = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
            object = object == null ? null : ((AnnotationIntrospector)object).findPOJOBuilderConfig(annotatedClass);
            object = object == null ? this._withPrefix : ((JsonPOJOBuilder.Value)object).withPrefix;
            return new DefaultAccessorNamingStrategy(mapperConfig, annotatedClass, (String)object, this._getterPrefix, this._isGetterPrefix, this._baseNameValidator);
        }

        @Override
        public AccessorNamingStrategy forRecord(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
            return new RecordNaming(mapperConfig, annotatedClass);
        }
    }

    public static interface BaseNameValidator {
        public boolean accept(char var1, String var2, int var3);
    }
}

