/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonKey;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.EnumNaming;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import com.fasterxml.jackson.databind.annotation.JsonValueInstantiator;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.ext.Java7Support;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.AttributePropertyWriter;
import com.fasterxml.jackson.databind.ser.std.RawSerializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.ExceptionUtil;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class JacksonAnnotationIntrospector
extends AnnotationIntrospector
implements Serializable {
    private static final Class<? extends Annotation>[] a = new Class[]{JsonSerialize.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonRawValue.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class};
    private static final Class<? extends Annotation>[] b = new Class[]{JsonDeserialize.class, JsonView.class, JsonFormat.class, JsonTypeInfo.class, JsonUnwrapped.class, JsonBackReference.class, JsonManagedReference.class, JsonMerge.class};
    private static final Java7Support c;
    protected transient LRUMap<String, Boolean> _annotationsInside = new LRUMap(48, 48);
    protected boolean _cfgConstructorPropertiesImpliesCreator = true;

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected Object readResolve() {
        if (this._annotationsInside == null) {
            this._annotationsInside = new LRUMap(48, 48);
        }
        return this;
    }

    public JacksonAnnotationIntrospector setConstructorPropertiesImpliesCreator(boolean bl2) {
        this._cfgConstructorPropertiesImpliesCreator = bl2;
        return this;
    }

    @Override
    public boolean isAnnotationBundle(Annotation object) {
        String string = ((Class)(object = object.annotationType())).getName();
        Boolean bl2 = this._annotationsInside.get(string);
        if (bl2 == null) {
            bl2 = ((Class)object).getAnnotation(JacksonAnnotationsInside.class) != null;
            this._annotationsInside.putIfAbsent(string, bl2);
        }
        return bl2;
    }

    @Override
    @Deprecated
    public String findEnumValue(Enum<?> enum_) {
        try {
            Object object = enum_.getDeclaringClass().getField(enum_.name());
            if (object != null && (object = ((Field)object).getAnnotation(JsonProperty.class)) != null && (object = object.value()) != null && !((String)object).isEmpty()) {
                return object;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return enum_.name();
    }

    @Override
    @Deprecated
    public String[] findEnumValues(Class<?> fieldArray, Enum<?>[] enumArray, String[] stringArray) {
        HashMap<String, Object> hashMap = null;
        for (Field object : fieldArray.getDeclaredFields()) {
            Object object2;
            if (!object.isEnumConstant() || (object2 = object.getAnnotation(JsonProperty.class)) == null || ((String)(object2 = object2.value())).isEmpty()) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            hashMap.put(object.getName(), object2);
        }
        if (hashMap != null) {
            int n2 = enumArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = enumArray[i2].name();
                String string2 = (String)hashMap.get(string);
                if (string2 == null) continue;
                stringArray[i2] = string2;
            }
        }
        return stringArray;
    }

    @Override
    public String[] findEnumValues(MapperConfig<?> serializable, AnnotatedClass object, Enum<?>[] enumArray, String[] stringArray) {
        Object object2;
        serializable = new LinkedHashMap();
        for (AnnotatedField annotatedField : ((AnnotatedClass)object).fields()) {
            object2 = ((Annotated)annotatedField).getAnnotation(JsonProperty.class);
            if (object2 == null || (object2 = object2.value()) == null || ((String)object2).isEmpty()) continue;
            serializable.put(((Annotated)annotatedField).getName(), object2);
        }
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object2 = enumArray[i2].name();
            if ((object2 = (String)serializable.get(object2)) == null) continue;
            stringArray[i2] = object2;
        }
        return stringArray;
    }

    @Override
    @Deprecated
    public void findEnumAliases(Class<?> fieldArray, Enum<?>[] enumArray, String[][] stringArray) {
        for (Field field : fieldArray.getDeclaredFields()) {
            String[] stringArray2;
            if (!field.isEnumConstant() || (stringArray2 = field.getAnnotation(JsonAlias.class)) == null || (stringArray2 = stringArray2.value()).length == 0) continue;
            String string = field.getName();
            int n2 = enumArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!string.equals(enumArray[i2].name())) continue;
                stringArray[i2] = stringArray2;
            }
        }
    }

    @Override
    public void findEnumAliases(MapperConfig<?> serializable, AnnotatedClass object, Enum<?>[] enumArray, String[][] stringArray) {
        serializable = new HashMap();
        for (AnnotatedField annotatedField : ((AnnotatedClass)((Object)object)).fields()) {
            JsonAlias object2 = ((Annotated)annotatedField).getAnnotation(JsonAlias.class);
            if (object2 == null) continue;
            ((HashMap)serializable).putIfAbsent(((Annotated)annotatedField).getName(), object2.value());
        }
        for (Enum<?> enum_ : enumArray) {
            stringArray[var2_3] = ((HashMap)serializable).getOrDefault(enum_.name(), new String[0]);
        }
    }

    @Override
    @Deprecated
    public Enum<?> findDefaultEnumValue(Class<Enum<?>> clazz) {
        return ClassUtil.findFirstAnnotatedEnumValue(clazz, JsonEnumDefaultValue.class);
    }

    @Override
    public Enum<?> findDefaultEnumValue(AnnotatedClass object, Enum<?>[] enumArray) {
        for (Annotated annotated : ((AnnotatedClass)((Object)object)).fields()) {
            Enum<?>[] enumArray2;
            if (!((ResolvedType)annotated.getType()).isEnumType() || (enumArray2 = this._findAnnotation(annotated, JsonEnumDefaultValue.class)) == null) continue;
            enumArray2 = enumArray;
            int n2 = enumArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Enum<?> enum_ = enumArray2[i2];
                if (!enum_.name().equals(annotated.getName())) continue;
                return enum_;
            }
        }
        return null;
    }

    @Override
    public PropertyName findRootName(AnnotatedClass object) {
        if ((object = this._findAnnotation((Annotated)object, JsonRootName.class)) == null) {
            return null;
        }
        String string = object.namespace();
        if (string != null && string.isEmpty()) {
            string = null;
        }
        return PropertyName.construct(object.value(), string);
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass object) {
        if ((object = this._findAnnotation((Annotated)object, JsonIgnoreType.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> object, Annotated annotated) {
        object = this._findAnnotation(annotated, JsonIgnoreProperties.class);
        if (object == null) {
            return JsonIgnoreProperties.Value.empty();
        }
        return JsonIgnoreProperties.Value.from((JsonIgnoreProperties)object);
    }

    @Override
    @Deprecated
    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated annotated) {
        return ((AnnotationIntrospector)this).findPropertyIgnoralByName(null, annotated);
    }

    @Override
    public JsonIncludeProperties.Value findPropertyInclusionByName(MapperConfig<?> object, Annotated annotated) {
        object = this._findAnnotation(annotated, JsonIncludeProperties.class);
        if (object == null) {
            return JsonIncludeProperties.Value.all();
        }
        return JsonIncludeProperties.Value.from((JsonIncludeProperties)object);
    }

    @Override
    public Object findFilterId(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonFilter.class)) != null && !((String)(object = object.value())).isEmpty()) {
            return object;
        }
        return null;
    }

    @Override
    public Object findNamingStrategy(AnnotatedClass object) {
        if ((object = this._findAnnotation((Annotated)object, JsonNaming.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public Object findEnumNamingStrategy(MapperConfig<?> object, AnnotatedClass annotatedClass) {
        object = this._findAnnotation(annotatedClass, EnumNaming.class);
        if (object == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public String findClassDescription(AnnotatedClass object) {
        if ((object = this._findAnnotation((Annotated)object, JsonClassDescription.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass object, VisibilityChecker<?> visibilityChecker) {
        if ((object = this._findAnnotation((Annotated)object, JsonAutoDetect.class)) == null) {
            return visibilityChecker;
        }
        return visibilityChecker.with((JsonAutoDetect)object);
    }

    @Override
    public String findImplicitPropertyName(AnnotatedMember serializable) {
        if ((serializable = this._findConstructorName((Annotated)((Object)serializable))) == null) {
            return null;
        }
        return ((PropertyName)serializable).getSimpleName();
    }

    @Override
    public List<PropertyName> findPropertyAliases(Annotated stringArray) {
        if ((stringArray = this._findAnnotation((Annotated)stringArray, JsonAlias.class)) == null) {
            return null;
        }
        int n2 = (stringArray = stringArray.value()).length;
        if (n2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<PropertyName> arrayList = new ArrayList<PropertyName>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(PropertyName.construct(stringArray[i2]));
        }
        return arrayList;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return this._isIgnorable(annotatedMember);
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember object) {
        if ((object = this._findAnnotation((Annotated)object, JsonProperty.class)) != null) {
            return object.required();
        }
        return null;
    }

    @Override
    public JsonProperty.Access findPropertyAccess(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonProperty.class)) != null) {
            return object.access();
        }
        return null;
    }

    @Override
    public String findPropertyDescription(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonPropertyDescription.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public Integer findPropertyIndex(Annotated object) {
        int n2;
        if ((object = this._findAnnotation((Annotated)object, JsonProperty.class)) != null && (n2 = object.index()) != -1) {
            return n2;
        }
        return null;
    }

    @Override
    public String findPropertyDefaultValue(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonProperty.class)) == null) {
            return null;
        }
        if (((String)(object = object.defaultValue())).isEmpty()) {
            return null;
        }
        return object;
    }

    @Override
    public JsonFormat.Value findFormat(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonFormat.class)) == null) {
            return null;
        }
        return JsonFormat.Value.from((JsonFormat)object);
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember object) {
        JsonManagedReference jsonManagedReference = this._findAnnotation((Annotated)object, JsonManagedReference.class);
        if (jsonManagedReference != null) {
            return AnnotationIntrospector.ReferenceProperty.managed(jsonManagedReference.value());
        }
        if ((object = this._findAnnotation((Annotated)object, JsonBackReference.class)) != null) {
            return AnnotationIntrospector.ReferenceProperty.back(object.value());
        }
        return null;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember object) {
        if ((object = this._findAnnotation((Annotated)object, JsonUnwrapped.class)) == null || !object.enabled()) {
            return null;
        }
        String string = object.prefix();
        object = object.suffix();
        return NameTransformer.simpleTransformer(string, (String)object);
    }

    @Override
    public JacksonInject.Value findInjectableValue(AnnotatedMember object) {
        Object object2 = this._findAnnotation((Annotated)object, JacksonInject.class);
        if (object2 == null) {
            return null;
        }
        if (!((JacksonInject.Value)(object2 = JacksonInject.Value.from((JacksonInject)object2))).hasId()) {
            AnnotatedMethod annotatedMethod;
            object = !(object instanceof AnnotatedMethod) ? ((Annotated)object).getRawType().getName() : (((AnnotatedWithParams)(annotatedMethod = (AnnotatedMethod)object)).getParameterCount() == 0 ? ((Annotated)object).getRawType().getName() : ((AnnotatedWithParams)annotatedMethod).getRawParameterType(0).getName());
            object2 = ((JacksonInject.Value)object2).withId(object);
        }
        return object2;
    }

    @Override
    @Deprecated
    public Object findInjectableValueId(AnnotatedMember serializable) {
        if ((serializable = ((AnnotationIntrospector)this).findInjectableValue((AnnotatedMember)serializable)) == null) {
            return null;
        }
        return ((JacksonInject.Value)serializable).getId();
    }

    @Override
    public Class<?>[] findViews(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonView.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> serializable, AnnotatedMethod annotatedMethod, AnnotatedMethod annotatedMethod2) {
        serializable = ((AnnotatedWithParams)annotatedMethod).getRawParameterType(0);
        Class<?> clazz = ((AnnotatedWithParams)annotatedMethod2).getRawParameterType(0);
        if (((Class)serializable).isPrimitive()) {
            if (!clazz.isPrimitive()) {
                return annotatedMethod;
            }
            return null;
        }
        if (clazz.isPrimitive()) {
            return annotatedMethod2;
        }
        if (serializable == String.class) {
            if (clazz != String.class) {
                return annotatedMethod;
            }
        } else if (clazz == String.class) {
            return annotatedMethod2;
        }
        return null;
    }

    @Override
    public PropertyName findRenameByField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, PropertyName propertyName) {
        return null;
    }

    @Override
    public JsonTypeInfo.Value findPolymorphicTypeInfo(MapperConfig<?> object, Annotated annotated) {
        object = this._findAnnotation(annotated, JsonTypeInfo.class);
        if (object == null) {
            return null;
        }
        return JsonTypeInfo.Value.from((JsonTypeInfo)object);
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        return this._findTypeResolver(mapperConfig, annotatedClass, javaType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (((ResolvedType)javaType).isContainerType() || javaType.isReferenceType()) {
            return null;
        }
        return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (javaType.getContentType() == null) {
            throw new IllegalArgumentException("Must call method with a container or reference type (got " + javaType + ")");
        }
        return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
    }

    @Override
    public List<NamedType> findSubtypes(Annotated arrayList) {
        JsonSubTypes.Type[] typeArray = this._findAnnotation((Annotated)((Object)arrayList), JsonSubTypes.class);
        if (typeArray == null) {
            return null;
        }
        Object object = typeArray.value();
        if (typeArray.failOnRepeatedNames()) {
            typeArray = object;
            arrayList = ((Annotated)((Object)arrayList)).getName();
            object = new ArrayList(typeArray.length);
            HashSet<Object> hashSet = new HashSet<Object>();
            for (JsonSubTypes.Type type : typeArray) {
                String[] stringArray = type.name();
                if (!stringArray.isEmpty() && hashSet.contains(stringArray)) {
                    throw new IllegalArgumentException("Annotated type [" + arrayList + "] got repeated subtype name [" + (String)stringArray + "]");
                }
                hashSet.add(stringArray);
                ((ArrayList)object).add(new NamedType(type.value(), (String)stringArray));
                for (String string : type.names()) {
                    if (!string.isEmpty() && hashSet.contains(string)) {
                        throw new IllegalArgumentException("Annotated type [" + arrayList + "] got repeated subtype name [" + string + "]");
                    }
                    hashSet.add(string);
                    ((ArrayList)object).add(new NamedType(type.value(), string));
                }
            }
            return object;
        }
        arrayList = new ArrayList<NamedType>(((JsonSubTypes.Type[])object).length);
        typeArray = object;
        int n2 = ((JsonSubTypes.Type[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonSubTypes.Type type = typeArray[i2];
            arrayList.add(new NamedType(type.value(), type.name()));
            for (String string : type.names()) {
                arrayList.add(new NamedType(type.value(), string));
            }
        }
        return arrayList;
    }

    @Override
    public String findTypeName(AnnotatedClass object) {
        if ((object = this._findAnnotation((Annotated)object, JsonTypeName.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public Boolean isTypeId(AnnotatedMember annotatedMember) {
        return this._hasAnnotation(annotatedMember, JsonTypeId.class);
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonIdentityInfo.class)) == null || object.generator() == ObjectIdGenerators.None.class) {
            return null;
        }
        PropertyName propertyName = PropertyName.construct(object.property());
        return new ObjectIdInfo(propertyName, object.scope(), object.generator(), object.resolver());
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated object, ObjectIdInfo objectIdInfo) {
        if ((object = this._findAnnotation((Annotated)object, JsonIdentityReference.class)) == null) {
            return objectIdInfo;
        }
        if (objectIdInfo == null) {
            objectIdInfo = ObjectIdInfo.empty();
        }
        return objectIdInfo.withAlwaysAsId(object.alwaysAsId());
    }

    @Override
    public Object findSerializer(Annotated object) {
        Object object2 = this._findAnnotation((Annotated)object, JsonSerialize.class);
        if (object2 != null && (object2 = object2.using()) != JsonSerializer.None.class) {
            return object2;
        }
        object2 = this._findAnnotation((Annotated)object, JsonRawValue.class);
        if (object2 != null && object2.value()) {
            object = ((Annotated)object).getRawType();
            return new RawSerializer((Class<?>)object);
        }
        return null;
    }

    @Override
    public Object findKeySerializer(Annotated clazz) {
        if ((clazz = this._findAnnotation((Annotated)((Object)clazz), JsonSerialize.class)) != null && (clazz = clazz.keyUsing()) != JsonSerializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findContentSerializer(Annotated clazz) {
        if ((clazz = this._findAnnotation((Annotated)((Object)clazz), JsonSerialize.class)) != null && (clazz = clazz.contentUsing()) != JsonSerializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findNullSerializer(Annotated clazz) {
        if ((clazz = this._findAnnotation((Annotated)((Object)clazz), JsonSerialize.class)) != null && (clazz = clazz.nullsUsing()) != JsonSerializer.None.class) {
            return clazz;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public JsonInclude.Value findPropertyInclusion(Annotated var1_1) {
        block6: {
            var2_2 = this._findAnnotation((Annotated)var1_1, JsonInclude.class);
            var2_2 = var2_2 == null ? JsonInclude.Value.empty() : JsonInclude.Value.from((JsonInclude)var2_2);
            if (var2_2.getValueInclusion() != JsonInclude.Include.USE_DEFAULTS) break block6;
            var3_3 = var2_2;
            var2_2 = var1_1;
            var1_1 = this;
            if ((var1_1 = var1_1._findAnnotation((Annotated)var2_2, JsonSerialize.class)) == null) ** GOTO lbl-1000
            switch (1.a[var1_1.include().ordinal()]) {
                case 1: {
                    v0 = var3_3.withValueInclusion(JsonInclude.Include.ALWAYS);
                    break;
                }
                case 2: {
                    v0 = var3_3.withValueInclusion(JsonInclude.Include.NON_NULL);
                    break;
                }
                case 3: {
                    v0 = var3_3.withValueInclusion(JsonInclude.Include.NON_DEFAULT);
                    break;
                }
                case 4: {
                    v0 = var3_3.withValueInclusion(JsonInclude.Include.NON_EMPTY);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v0 = var3_3;
                }
            }
            var2_2 = v0;
        }
        return var2_2;
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonSerialize.class)) == null) {
            return null;
        }
        return object.typing();
    }

    @Override
    public Object findSerializationConverter(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonSerialize.class)) == null) {
            return null;
        }
        return this._classIfExplicit(object.converter(), Converter.None.class);
    }

    @Override
    public Object findSerializationContentConverter(AnnotatedMember object) {
        if ((object = this._findAnnotation((Annotated)object, JsonSerialize.class)) == null) {
            return null;
        }
        return this._classIfExplicit(object.contentConverter(), Converter.None.class);
    }

    @Override
    public JavaType refineSerializationType(MapperConfig<?> serializable, Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        Type type;
        Class<?> clazz2;
        JsonSerialize jsonSerialize;
        block25: {
            serializable = ((MapperConfig)serializable).getTypeFactory();
            jsonSerialize = this._findAnnotation(annotated, JsonSerialize.class);
            clazz2 = jsonSerialize == null ? null : this._classIfExplicit(jsonSerialize.as());
            if (clazz2 != null) {
                if (((ResolvedType)javaType).hasRawClass(clazz2)) {
                    javaType = javaType.withStaticTyping();
                } else {
                    type = ((ResolvedType)javaType).getRawClass();
                    try {
                        if (clazz2.isAssignableFrom((Class<?>)type)) {
                            javaType = ((TypeFactory)serializable).constructGeneralizedType(javaType, clazz2);
                            break block25;
                        }
                        if (((Class)type).isAssignableFrom(clazz2)) {
                            javaType = ((TypeFactory)serializable).constructSpecializedType(javaType, clazz2);
                            break block25;
                        }
                        if (JacksonAnnotationIntrospector.a(type, clazz2)) {
                            javaType = javaType.withStaticTyping();
                            break block25;
                        }
                        throw JacksonAnnotationIntrospector.a(String.format("Cannot refine serialization type %s into %s; types not related", javaType, clazz2.getName()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                        throw JacksonAnnotationIntrospector.a(illegalArgumentException, String.format("Failed to widen type %s with annotation (value %s), from '%s': %s", javaType, clazz2.getName(), annotated.getName(), illegalArgumentException2.getMessage()));
                    }
                }
            }
        }
        if (((ResolvedType)javaType).isMapLikeType()) {
            type = javaType.getKeyType();
            clazz = jsonSerialize == null ? null : this._classIfExplicit(jsonSerialize.keyAs());
            if (clazz != null) {
                block26: {
                    if (((ResolvedType)((Object)type)).hasRawClass(clazz)) {
                        type = ((JavaType)type).withStaticTyping();
                    } else {
                        clazz2 = ((ResolvedType)((Object)type)).getRawClass();
                        try {
                            if (clazz.isAssignableFrom(clazz2)) {
                                type = ((TypeFactory)serializable).constructGeneralizedType((JavaType)type, clazz);
                                break block26;
                            }
                            if (clazz2.isAssignableFrom(clazz)) {
                                type = ((TypeFactory)serializable).constructSpecializedType((JavaType)type, clazz);
                                break block26;
                            }
                            if (JacksonAnnotationIntrospector.a(clazz2, clazz)) {
                                type = ((JavaType)type).withStaticTyping();
                                break block26;
                            }
                            throw JacksonAnnotationIntrospector.a(String.format("Cannot refine serialization key type %s into %s; types not related", type, clazz.getName()));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            serializable = illegalArgumentException;
                            throw JacksonAnnotationIntrospector.a(illegalArgumentException, String.format("Failed to widen key type of %s with concrete-type annotation (value %s), from '%s': %s", javaType, clazz.getName(), annotated.getName(), ((Throwable)serializable).getMessage()));
                        }
                    }
                }
                javaType = ((MapLikeType)javaType).withKeyType((JavaType)type);
            }
        }
        if ((type = javaType.getContentType()) != null && (clazz = jsonSerialize == null ? null : this._classIfExplicit(jsonSerialize.contentAs())) != null) {
            block27: {
                if (((ResolvedType)((Object)type)).hasRawClass(clazz)) {
                    type = ((JavaType)type).withStaticTyping();
                } else {
                    clazz2 = ((ResolvedType)((Object)type)).getRawClass();
                    try {
                        if (clazz.isAssignableFrom(clazz2)) {
                            type = ((TypeFactory)serializable).constructGeneralizedType((JavaType)type, clazz);
                            break block27;
                        }
                        if (clazz2.isAssignableFrom(clazz)) {
                            type = ((TypeFactory)serializable).constructSpecializedType((JavaType)type, clazz);
                            break block27;
                        }
                        if (JacksonAnnotationIntrospector.a(clazz2, clazz)) {
                            type = ((JavaType)type).withStaticTyping();
                            break block27;
                        }
                        throw JacksonAnnotationIntrospector.a(String.format("Cannot refine serialization content type %s into %s; types not related", type, clazz.getName()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        serializable = illegalArgumentException;
                        throw JacksonAnnotationIntrospector.a(illegalArgumentException, String.format("Internal error: failed to refine value type of %s with concrete-type annotation (value %s), from '%s': %s", javaType, clazz.getName(), annotated.getName(), ((Throwable)serializable).getMessage()));
                    }
                }
            }
            javaType = javaType.withContentType((JavaType)type);
        }
        return javaType;
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass object) {
        if ((object = this._findAnnotation((Annotated)object, JsonPropertyOrder.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(Annotated object) {
        Annotated annotated = object;
        object = this;
        if ((object = ((AnnotationIntrospector)object)._findAnnotation(annotated, JsonPropertyOrder.class)) != null && object.alphabetic()) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, List<BeanPropertyWriter> list) {
        Object object = this._findAnnotation(annotatedClass, JsonAppend.class);
        if (object == null) {
            return;
        }
        boolean bl2 = object.prepend();
        JavaType javaType = null;
        JsonAppend.Attr[] attrArray = object.attrs();
        int n2 = attrArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (javaType == null) {
                javaType = mapperConfig.constructType(Object.class);
            }
            BeanPropertyWriter beanPropertyWriter = this._constructVirtualProperty(attrArray[i2], mapperConfig, annotatedClass, javaType);
            if (bl2) {
                list.add(i2, beanPropertyWriter);
                continue;
            }
            list.add(beanPropertyWriter);
        }
        JsonAppend.Prop[] propArray = object.props();
        int n3 = propArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = this._constructVirtualProperty(propArray[n2], mapperConfig, annotatedClass);
            if (bl2) {
                list.add(n2, (BeanPropertyWriter)object);
                continue;
            }
            list.add((BeanPropertyWriter)object);
        }
    }

    protected BeanPropertyWriter _constructVirtualProperty(JsonAppend.Attr object, MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        PropertyMetadata propertyMetadata = object.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        String string = object.value();
        PropertyName propertyName = this._propertyName(object.propName(), object.propNamespace());
        if (!propertyName.hasSimpleName()) {
            propertyName = PropertyName.construct(string);
        }
        AnnotatedClass annotatedClass2 = annotatedClass;
        VirtualAnnotatedMember virtualAnnotatedMember = new VirtualAnnotatedMember(annotatedClass2, ((Annotated)annotatedClass2).getRawType(), string, javaType);
        object = SimpleBeanPropertyDefinition.construct(mapperConfig, (AnnotatedMember)virtualAnnotatedMember, propertyName, propertyMetadata, object.include());
        return AttributePropertyWriter.construct(string, (BeanPropertyDefinition)object, annotatedClass.getAnnotations(), javaType);
    }

    protected BeanPropertyWriter _constructVirtualProperty(JsonAppend.Prop object, MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        Object object2 = object.required() ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL;
        Object object3 = this._propertyName(object.name(), object.namespace());
        JavaType javaType = mapperConfig.constructType(object.type());
        AnnotatedClass annotatedClass2 = annotatedClass;
        VirtualAnnotatedMember virtualAnnotatedMember = new VirtualAnnotatedMember(annotatedClass2, ((Annotated)annotatedClass2).getRawType(), ((PropertyName)object3).getSimpleName(), javaType);
        object2 = SimpleBeanPropertyDefinition.construct(mapperConfig, (AnnotatedMember)virtualAnnotatedMember, (PropertyName)object3, (PropertyMetadata)object2, object.include());
        object = object.value();
        object3 = mapperConfig.getHandlerInstantiator();
        if ((object3 = object3 == null ? null : ((HandlerInstantiator)object3).virtualPropertyWriterInstance(mapperConfig, (Class<?>)object)) == null) {
            object3 = (VirtualBeanPropertyWriter)ClassUtil.createInstance(object, mapperConfig.canOverrideAccessModifiers());
        }
        return ((VirtualBeanPropertyWriter)object3).withConfig(mapperConfig, annotatedClass, (BeanPropertyDefinition)object2, javaType);
    }

    @Override
    public PropertyName findNameForSerialization(Annotated object) {
        boolean bl2 = false;
        Object object2 = this._findAnnotation((Annotated)object, JsonGetter.class);
        if (object2 != null) {
            if (!((String)(object2 = object2.value())).isEmpty()) {
                return PropertyName.construct((String)object2);
            }
            bl2 = true;
        }
        if ((object2 = this._findAnnotation((Annotated)object, JsonProperty.class)) != null) {
            object = object2.namespace();
            if (object != null && ((String)object).isEmpty()) {
                object = null;
            }
            return PropertyName.construct(object2.value(), (String)object);
        }
        if (bl2 || this._hasOneOf((Annotated)object, a)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public Boolean hasAsKey(MapperConfig<?> object, Annotated annotated) {
        object = this._findAnnotation(annotated, JsonKey.class);
        if (object == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public Boolean hasAsValue(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonValue.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public Boolean hasAnyGetter(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonAnyGetter.class)) == null) {
            return null;
        }
        return object.enabled();
    }

    @Override
    @Deprecated
    public boolean hasAnyGetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._hasAnnotation(annotatedMethod, JsonAnyGetter.class);
    }

    @Override
    @Deprecated
    public boolean hasAsValueAnnotation(AnnotatedMethod object) {
        return (object = this._findAnnotation((Annotated)object, JsonValue.class)) != null && object.value();
    }

    @Override
    public Object findDeserializer(Annotated clazz) {
        if ((clazz = this._findAnnotation((Annotated)((Object)clazz), JsonDeserialize.class)) != null && (clazz = clazz.using()) != JsonDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findKeyDeserializer(Annotated clazz) {
        if ((clazz = this._findAnnotation((Annotated)((Object)clazz), JsonDeserialize.class)) != null && (clazz = clazz.keyUsing()) != KeyDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findContentDeserializer(Annotated clazz) {
        if ((clazz = this._findAnnotation((Annotated)((Object)clazz), JsonDeserialize.class)) != null && (clazz = clazz.contentUsing()) != JsonDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findDeserializationConverter(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonDeserialize.class)) == null) {
            return null;
        }
        return this._classIfExplicit(object.converter(), Converter.None.class);
    }

    @Override
    public Object findDeserializationContentConverter(AnnotatedMember object) {
        if ((object = this._findAnnotation((Annotated)object, JsonDeserialize.class)) == null) {
            return null;
        }
        return this._classIfExplicit(object.contentConverter(), Converter.None.class);
    }

    @Override
    public JavaType refineDeserializationType(MapperConfig<?> serializable, Annotated annotated, JavaType javaType) {
        JavaType javaType2;
        serializable = ((MapperConfig)serializable).getTypeFactory();
        JsonDeserialize jsonDeserialize = this._findAnnotation(annotated, JsonDeserialize.class);
        Class<?> clazz = jsonDeserialize == null ? null : this._classIfExplicit(jsonDeserialize.as());
        if (clazz != null && !((ResolvedType)javaType).hasRawClass(clazz) && !JacksonAnnotationIntrospector.a(javaType, clazz)) {
            try {
                javaType = ((TypeFactory)serializable).constructSpecializedType(javaType, clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                throw JacksonAnnotationIntrospector.a(illegalArgumentException, String.format("Failed to narrow type %s with annotation (value %s), from '%s': %s", javaType, clazz.getName(), annotated.getName(), illegalArgumentException2.getMessage()));
            }
        }
        if (((ResolvedType)javaType).isMapLikeType()) {
            javaType2 = javaType.getKeyType();
            clazz = jsonDeserialize == null ? null : this._classIfExplicit(jsonDeserialize.keyAs());
            if (clazz != null && !JacksonAnnotationIntrospector.a(javaType2, clazz)) {
                try {
                    javaType2 = ((TypeFactory)serializable).constructSpecializedType(javaType2, clazz);
                    javaType = ((MapLikeType)javaType).withKeyType(javaType2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    serializable = illegalArgumentException;
                    throw JacksonAnnotationIntrospector.a(illegalArgumentException, String.format("Failed to narrow key type of %s with concrete-type annotation (value %s), from '%s': %s", javaType, clazz.getName(), annotated.getName(), ((Throwable)serializable).getMessage()));
                }
            }
        }
        if ((javaType2 = javaType.getContentType()) != null && (clazz = jsonDeserialize == null ? null : this._classIfExplicit(jsonDeserialize.contentAs())) != null && !JacksonAnnotationIntrospector.a(javaType2, clazz)) {
            try {
                javaType2 = ((TypeFactory)serializable).constructSpecializedType(javaType2, clazz);
                javaType = javaType.withContentType(javaType2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                serializable = illegalArgumentException;
                throw JacksonAnnotationIntrospector.a(illegalArgumentException, String.format("Failed to narrow value type of %s with concrete-type annotation (value %s), from '%s': %s", javaType, clazz.getName(), annotated.getName(), ((Throwable)serializable).getMessage()));
            }
        }
        return javaType;
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass object) {
        if ((object = this._findAnnotation((Annotated)object, JsonValueInstantiator.class)) == null) {
            return null;
        }
        return object.value();
    }

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass object) {
        if ((object = this._findAnnotation((Annotated)object, JsonDeserialize.class)) == null) {
            return null;
        }
        return this._classIfExplicit(object.builder());
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass object) {
        if ((object = this._findAnnotation((Annotated)object, JsonPOJOBuilder.class)) == null) {
            return null;
        }
        return new JsonPOJOBuilder.Value((JsonPOJOBuilder)object);
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated object) {
        boolean bl2 = false;
        Object object2 = this._findAnnotation((Annotated)object, JsonSetter.class);
        if (object2 != null) {
            if (((String)(object2 = object2.value())).isEmpty()) {
                bl2 = true;
            } else {
                return PropertyName.construct((String)object2);
            }
        }
        if ((object2 = this._findAnnotation((Annotated)object, JsonProperty.class)) != null) {
            object = object2.namespace();
            if (object != null && ((String)object).isEmpty()) {
                object = null;
            }
            return PropertyName.construct(object2.value(), (String)object);
        }
        if (bl2 || this._hasOneOf((Annotated)object, b)) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public Boolean hasAnySetter(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonAnySetter.class)) == null) {
            return null;
        }
        return object.enabled();
    }

    @Override
    public JsonSetter.Value findSetterInfo(Annotated annotated) {
        return JsonSetter.Value.from(this._findAnnotation(annotated, JsonSetter.class));
    }

    @Override
    public Boolean findMergeInfo(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonMerge.class)) == null) {
            return null;
        }
        return object.value().asBoolean();
    }

    @Override
    @Deprecated
    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return this._hasAnnotation(annotatedMethod, JsonAnySetter.class);
    }

    @Override
    @Deprecated
    public boolean hasCreatorAnnotation(Annotated object) {
        JsonCreator jsonCreator = this._findAnnotation((Annotated)object, JsonCreator.class);
        if (jsonCreator != null) {
            return jsonCreator.mode() != JsonCreator.Mode.DISABLED;
        }
        if (this._cfgConstructorPropertiesImpliesCreator && object instanceof AnnotatedConstructor && c != null && (object = c.hasCreatorAnnotation((Annotated)object)) != null) {
            return (Boolean)object;
        }
        return false;
    }

    @Override
    @Deprecated
    public JsonCreator.Mode findCreatorBinding(Annotated object) {
        if ((object = this._findAnnotation((Annotated)object, JsonCreator.class)) == null) {
            return null;
        }
        return object.mode();
    }

    @Override
    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> serializable, Annotated annotated) {
        JsonCreator jsonCreator = this._findAnnotation(annotated, JsonCreator.class);
        if (jsonCreator != null) {
            return jsonCreator.mode();
        }
        if (this._cfgConstructorPropertiesImpliesCreator && ((MapperConfig)serializable).isEnabled(MapperFeature.INFER_CREATOR_FROM_CONSTRUCTOR_PROPERTIES) && annotated instanceof AnnotatedConstructor && c != null && (serializable = c.hasCreatorAnnotation(annotated)) != null && ((Boolean)serializable).booleanValue()) {
            return JsonCreator.Mode.PROPERTIES;
        }
        return null;
    }

    protected boolean _isIgnorable(Annotated object) {
        JsonIgnore jsonIgnore = this._findAnnotation((Annotated)object, JsonIgnore.class);
        if (jsonIgnore != null) {
            return jsonIgnore.value();
        }
        if (c != null && (object = c.findTransient((Annotated)object)) != null) {
            return (Boolean)object;
        }
        return false;
    }

    protected Class<?> _classIfExplicit(Class<?> clazz) {
        if (clazz == null || ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        return clazz;
    }

    protected Class<?> _classIfExplicit(Class<?> clazz, Class<?> clazz2) {
        if ((clazz = this._classIfExplicit(clazz)) == null || clazz == clazz2) {
            return null;
        }
        return clazz;
    }

    protected PropertyName _propertyName(String string, String string2) {
        if (string.isEmpty()) {
            return PropertyName.USE_DEFAULT;
        }
        if (string2 == null || string2.isEmpty()) {
            return PropertyName.construct(string);
        }
        return PropertyName.construct(string, string2);
    }

    protected PropertyName _findConstructorName(Annotated object) {
        AnnotatedWithParams annotatedWithParams;
        if (object instanceof AnnotatedParameter && (annotatedWithParams = ((AnnotatedParameter)(object = (AnnotatedParameter)object)).getOwner()) != null && c != null && (object = c.findConstructorName((AnnotatedParameter)object)) != null) {
            return object;
        }
        return null;
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> object, Annotated object2, JavaType object3) {
        JsonTypeInfo.Value value = ((AnnotationIntrospector)this).findPolymorphicTypeInfo((MapperConfig<?>)object, (Annotated)object2);
        Object object4 = this._findAnnotation((Annotated)object2, JsonTypeResolver.class);
        if (object4 != null) {
            if (value == null) {
                return null;
            }
            object4 = ((MapperConfig)object).typeResolverBuilderInstance((Annotated)object2, object4.value());
        } else {
            if (value == null) {
                return null;
            }
            if (value.getIdType() == JsonTypeInfo.Id.NONE) {
                return this._constructNoTypeResolverBuilder();
            }
            object4 = this._constructStdTypeResolverBuilder((MapperConfig<?>)object, value, (JavaType)object3);
        }
        JsonTypeIdResolver jsonTypeIdResolver = this._findAnnotation((Annotated)object2, JsonTypeIdResolver.class);
        object = jsonTypeIdResolver == null ? null : ((MapperConfig)object).typeIdResolverInstance((Annotated)object2, jsonTypeIdResolver.value());
        if (object != null) {
            object.init((JavaType)object3);
        }
        if ((object3 = value.getInclusionType()) == JsonTypeInfo.As.EXTERNAL_PROPERTY && object2 instanceof AnnotatedClass) {
            value = value.withInclusionType(JsonTypeInfo.As.PROPERTY);
        }
        if ((object2 = value.getDefaultImpl()) != null && object2 != JsonTypeInfo.None.class && !((Class)object2).isAnnotation()) {
            value = value.withDefaultImpl((Class<?>)object2);
        }
        object4 = object4.init(value, (TypeIdResolver)object);
        return object4;
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new StdTypeResolverBuilder();
    }

    protected TypeResolverBuilder<?> _constructStdTypeResolverBuilder(MapperConfig<?> mapperConfig, JsonTypeInfo.Value value, JavaType javaType) {
        return new StdTypeResolverBuilder(value);
    }

    protected StdTypeResolverBuilder _constructNoTypeResolverBuilder() {
        return StdTypeResolverBuilder.noTypeInfoBuilder();
    }

    private static boolean a(Class<?> clazz, Class<?> clazz2) {
        if (clazz.isPrimitive()) {
            return clazz == ClassUtil.primitiveType(clazz2);
        }
        if (clazz2.isPrimitive()) {
            return clazz2 == ClassUtil.primitiveType(clazz);
        }
        return false;
    }

    private static boolean a(JavaType javaType, Class<?> clazz) {
        if (((ResolvedType)javaType).isPrimitive()) {
            return ((ResolvedType)javaType).hasRawClass(ClassUtil.primitiveType(clazz));
        }
        if (clazz.isPrimitive()) {
            return clazz == ClassUtil.primitiveType(((ResolvedType)javaType).getRawClass());
        }
        return false;
    }

    private static JsonMappingException a(String string) {
        return new JsonMappingException(null, string);
    }

    private static JsonMappingException a(Throwable throwable, String string) {
        return new JsonMappingException(null, string, throwable);
    }

    static {
        Java7Support java7Support = null;
        try {
            java7Support = Java7Support.instance();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            ExceptionUtil.rethrowIfFatal(throwable);
        }
        c = java7Support;
    }
}

