/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jdk14.JDK14Util;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final AccessorNamingStrategy _accessorNaming;
    protected final boolean _forSerialization;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final boolean _useAnnotations;
    protected final boolean _isRecordType;
    protected boolean _collected;
    protected LinkedHashMap<String, POJOPropertyBuilder> _properties;
    protected LinkedList<POJOPropertyBuilder> _creatorProperties;
    protected Map<PropertyName, PropertyName> _fieldRenameMappings;
    protected LinkedList<AnnotatedMember> _anyGetters;
    protected LinkedList<AnnotatedMember> _anyGetterField;
    protected LinkedList<AnnotatedMethod> _anySetters;
    protected LinkedList<AnnotatedMember> _anySetterField;
    protected LinkedList<AnnotatedMember> _jsonKeyAccessors;
    protected LinkedList<AnnotatedMember> _jsonValueAccessors;
    protected HashSet<String> _ignoredPropertyNames;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;
    protected JsonFormat.Value _formatOverrides;
    @Deprecated
    protected final boolean _stdBeanNaming;
    @Deprecated
    protected String _mutatorPrefix;

    protected POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl2, JavaType javaType, AnnotatedClass annotatedClass, AccessorNamingStrategy accessorNamingStrategy) {
        this._mutatorPrefix = "set";
        this._config = mapperConfig;
        this._forSerialization = bl2;
        this._type = javaType;
        this._classDef = annotatedClass;
        this._isRecordType = this._type.isRecordType();
        if (mapperConfig.isAnnotationProcessingEnabled()) {
            this._useAnnotations = true;
            this._annotationIntrospector = this._config.getAnnotationIntrospector();
        } else {
            this._useAnnotations = false;
            this._annotationIntrospector = AnnotationIntrospector.nopInstance();
        }
        this._visibilityChecker = this._config.getDefaultVisibilityChecker(((ResolvedType)javaType).getRawClass(), annotatedClass);
        this._accessorNaming = accessorNamingStrategy;
        this._stdBeanNaming = mapperConfig.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
    }

    @Deprecated
    protected POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl2, JavaType object, AnnotatedClass annotatedClass, String string) {
        MapperConfig<?> mapperConfig2 = mapperConfig;
        JavaType javaType = object;
        object = string;
        AnnotatedClass annotatedClass2 = annotatedClass;
        if (object == null) {
            object = "set";
        }
        this(mapperConfig2, bl2, javaType, annotatedClass, ((AccessorNamingStrategy.Provider)new DefaultAccessorNamingStrategy.Provider().withSetterPrefix((String)object)).forPOJO(mapperConfig, annotatedClass2));
        this._mutatorPrefix = string;
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public boolean isRecordType() {
        return this._isRecordType;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public List<BeanPropertyDefinition> getProperties() {
        Map<String, POJOPropertyBuilder> map = this.getPropertyMap();
        return new ArrayList<BeanPropertyDefinition>(map.values());
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._injectables;
    }

    public AnnotatedMember getJsonKeyAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonKeyAccessors != null) {
            if (this._jsonKeyAccessors.size() > 1) {
                POJOPropertiesCollector pOJOPropertiesCollector = this;
                if (!pOJOPropertiesCollector._resolveFieldVsGetter(pOJOPropertiesCollector._jsonKeyAccessors)) {
                    this.reportProblem("Multiple 'as-key' properties defined (%s vs %s)", this._jsonKeyAccessors.get(0), this._jsonKeyAccessors.get(1));
                }
            }
            return this._jsonKeyAccessors.get(0);
        }
        return null;
    }

    public AnnotatedMember getJsonValueAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonValueAccessors != null) {
            if (this._jsonValueAccessors.size() > 1) {
                POJOPropertiesCollector pOJOPropertiesCollector = this;
                if (!pOJOPropertiesCollector._resolveFieldVsGetter(pOJOPropertiesCollector._jsonValueAccessors)) {
                    this.reportProblem("Multiple 'as-value' properties defined (%s vs %s)", this._jsonValueAccessors.get(0), this._jsonValueAccessors.get(1));
                }
            }
            return this._jsonValueAccessors.get(0);
        }
        return null;
    }

    @Deprecated
    public AnnotatedMember getAnyGetter() {
        return this.getAnyGetterMethod();
    }

    public AnnotatedMember getAnyGetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetterField != null) {
            if (this._anyGetterField.size() > 1) {
                this.reportProblem("Multiple 'any-getter' fields defined (%s vs %s)", this._anyGetterField.get(0), this._anyGetterField.get(1));
            }
            return this._anyGetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnyGetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetters != null) {
            if (this._anyGetters.size() > 1) {
                this.reportProblem("Multiple 'any-getter' methods defined (%s vs %s)", this._anyGetters.get(0), this._anyGetters.get(1));
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnySetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetterField != null) {
            if (this._anySetterField.size() > 1) {
                this.reportProblem("Multiple 'any-setter' fields defined (%s vs %s)", this._anySetterField.get(0), this._anySetterField.get(1));
            }
            return this._anySetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetters != null) {
            if (this._anySetters.size() > 1) {
                this.reportProblem("Multiple 'any-setter' methods defined (%s vs %s)", this._anySetters.get(0), this._anySetters.get(1));
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public ObjectIdInfo getObjectIdInfo() {
        ObjectIdInfo objectIdInfo = this._annotationIntrospector.findObjectIdInfo(this._classDef);
        if (objectIdInfo != null) {
            objectIdInfo = this._annotationIntrospector.findObjectReferenceInfo(this._classDef, objectIdInfo);
        }
        return objectIdInfo;
    }

    protected Map<String, POJOPropertyBuilder> getPropertyMap() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._properties;
    }

    @Deprecated
    public AnnotatedMethod getJsonValueMethod() {
        AnnotatedMember annotatedMember = this.getJsonValueAccessor();
        if (annotatedMember instanceof AnnotatedMethod) {
            return (AnnotatedMethod)annotatedMember;
        }
        return null;
    }

    @Deprecated
    public Class<?> findPOJOBuilderClass() {
        return this._annotationIntrospector.findPOJOBuilder(this._classDef);
    }

    public JsonFormat.Value getFormatOverrides() {
        if (this._formatOverrides == null) {
            JsonFormat.Value value;
            JsonFormat.Value value2 = null;
            if (this._annotationIntrospector != null) {
                value2 = this._annotationIntrospector.findFormat(this._classDef);
            }
            if ((value = this._config.getDefaultPropertyFormat(((ResolvedType)this._type).getRawClass())) != null) {
                value2 = value2 == null ? value : value2.withOverrides(value);
            }
            this._formatOverrides = value2 == null ? JsonFormat.Value.empty() : value2;
        }
        return this._formatOverrides;
    }

    protected void collectAll() {
        PropertyNamingStrategy propertyNamingStrategy;
        Object object;
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap = new LinkedHashMap<String, POJOPropertyBuilder>();
        boolean bl2 = this.isRecordType();
        if (!bl2 || this._forSerialization) {
            this._addFields(linkedHashMap);
        }
        this._addMethods(linkedHashMap);
        if (!(this._classDef.isNonStaticInnerClass() || this._forSerialization && bl2)) {
            this._addCreators(linkedHashMap);
        }
        this._removeUnwantedProperties(linkedHashMap);
        this._removeUnwantedAccessor(linkedHashMap);
        this._renameProperties(linkedHashMap);
        this._addInjectables(linkedHashMap);
        for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
            pOJOPropertyBuilder.mergeAnnotations(this._forSerialization);
        }
        POJOPropertiesCollector pOJOPropertiesCollector = this;
        Object object2 = pOJOPropertiesCollector._annotationIntrospector.findNamingStrategy(pOJOPropertiesCollector._classDef);
        if (object2 == null) {
            object = pOJOPropertiesCollector._config.getPropertyNamingStrategy();
        } else if (object2 instanceof PropertyNamingStrategy) {
            object = (PropertyNamingStrategy)object2;
        } else {
            Class clazz;
            if (!(object2 instanceof Class)) {
                pOJOPropertiesCollector.reportProblem("AnnotationIntrospector returned PropertyNamingStrategy definition of type %s; expected type `PropertyNamingStrategy` or `Class<PropertyNamingStrategy>` instead", ClassUtil.classNameOf(object2));
            }
            if ((clazz = (Class)object2) == PropertyNamingStrategy.class) {
                object = null;
            } else {
                Object object3;
                if (!PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
                    pOJOPropertiesCollector.reportProblem("AnnotationIntrospector returned Class %s; expected `Class<PropertyNamingStrategy>`", ClassUtil.classNameOf(clazz));
                }
                object = propertyNamingStrategy = (object3 = pOJOPropertiesCollector._config.getHandlerInstantiator()) != null && (object3 = ((HandlerInstantiator)object3).namingStrategyInstance(pOJOPropertiesCollector._config, pOJOPropertiesCollector._classDef, clazz)) != null ? object3 : (PropertyNamingStrategy)ClassUtil.createInstance(clazz, pOJOPropertiesCollector._config.canOverrideAccessModifiers());
            }
        }
        if (object != null) {
            this._renameUsing(linkedHashMap, propertyNamingStrategy);
        }
        for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
            pOJOPropertyBuilder.trimByVisibility();
        }
        if (this._config.isEnabled(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)) {
            this._renameWithWrappers(linkedHashMap);
        }
        this._sortProperties(linkedHashMap);
        this._properties = linkedHashMap;
        this._collected = true;
    }

    protected void _addFields(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        boolean bl2 = !this._forSerialization && !this._config.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        boolean bl3 = this._config.isEnabled(MapperFeature.PROPAGATE_TRANSIENT_MARKER);
        for (AnnotatedField annotatedField : this._classDef.fields()) {
            boolean bl4;
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsKey(this._config, annotatedField))) {
                if (this._jsonKeyAccessors == null) {
                    this._jsonKeyAccessors = new LinkedList();
                }
                this._jsonKeyAccessors.add(annotatedField);
            }
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedField))) {
                if (this._jsonValueAccessors == null) {
                    this._jsonValueAccessors = new LinkedList();
                }
                this._jsonValueAccessors.add(annotatedField);
                continue;
            }
            boolean bl5 = Boolean.TRUE.equals(annotationIntrospector.hasAnyGetter(annotatedField));
            boolean bl6 = Boolean.TRUE.equals(annotationIntrospector.hasAnySetter(annotatedField));
            if (bl5 || bl6) {
                if (bl5) {
                    if (this._anyGetterField == null) {
                        this._anyGetterField = new LinkedList();
                    }
                    this._anyGetterField.add(annotatedField);
                }
                if (!bl6) continue;
                if (this._anySetterField == null) {
                    this._anySetterField = new LinkedList();
                }
                this._anySetterField.add(annotatedField);
                continue;
            }
            String string = annotationIntrospector.findImplicitPropertyName(annotatedField);
            if (string == null) {
                string = ((Annotated)annotatedField).getName();
            }
            if ((string = this._accessorNaming.modifyFieldName(annotatedField, string)) == null) continue;
            Object object = string;
            PropertyName propertyName = annotationIntrospector.findRenameByField(this._config, annotatedField, (PropertyName)(object = PropertyName.construct((String)object, null)));
            if (propertyName != null && !propertyName.equals(object)) {
                if (this._fieldRenameMappings == null) {
                    this._fieldRenameMappings = new HashMap<PropertyName, PropertyName>();
                }
                this._fieldRenameMappings.put(propertyName, (PropertyName)object);
            }
            object = this._forSerialization ? annotationIntrospector.findNameForSerialization(annotatedField) : annotationIntrospector.findNameForDeserialization(annotatedField);
            boolean bl7 = object != null;
            boolean bl8 = bl7;
            if (bl7 && ((PropertyName)object).isEmpty()) {
                object = string;
                object = PropertyName.construct((String)object, null);
                bl8 = false;
            }
            if (!(bl4 = object != null)) {
                bl4 = this._visibilityChecker.isFieldVisible(annotatedField);
            }
            boolean bl9 = annotationIntrospector.hasIgnoreMarker(annotatedField);
            if (annotatedField.isTransient() && !bl7) {
                if (bl3) {
                    bl9 = true;
                } else if (!bl9) continue;
            }
            if (bl2 && object == null && !bl9 && Modifier.isFinal(annotatedField.getModifiers())) continue;
            this._property(map, string).addField(annotatedField, (PropertyName)object, bl8, bl4, bl9);
        }
    }

    protected void _addCreators(Map<String, POJOPropertyBuilder> map) {
        AnnotatedConstructor annotatedConstructor;
        Iterator<AnnotatedMethod> iterator;
        if (this._useAnnotations) {
            int n2;
            int n3;
            for (AnnotatedConstructor annotatedWithParams2 : this._classDef.getConstructors()) {
                if (this._creatorProperties == null) {
                    this._creatorProperties = new LinkedList();
                }
                n3 = ((AnnotatedWithParams)annotatedWithParams2).getParameterCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    this._addCreatorParam(map, annotatedWithParams2.getParameter(n2));
                }
            }
            iterator = this._classDef.getFactoryMethods().iterator();
            while (iterator.hasNext()) {
                AnnotatedMethod annotatedMethod = iterator.next();
                if (this._creatorProperties == null) {
                    this._creatorProperties = new LinkedList();
                }
                n3 = ((AnnotatedWithParams)annotatedMethod).getParameterCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    this._addCreatorParam(map, annotatedMethod.getParameter(n2));
                }
            }
        }
        if (this.isRecordType() && (annotatedConstructor = JDK14Util.findRecordConstructor(this._classDef, this._annotationIntrospector, this._config, iterator = new ArrayList())) != null) {
            if (this._creatorProperties == null) {
                this._creatorProperties = new LinkedList();
            }
            HashSet<AnnotatedParameter> hashSet = new HashSet<AnnotatedParameter>();
            for (POJOPropertyBuilder pOJOPropertyBuilder : this._creatorProperties) {
                Iterator<AnnotatedParameter> iterator2 = ((BeanPropertyDefinition)pOJOPropertyBuilder).getConstructorParameters();
                while (iterator2.hasNext()) {
                    AnnotatedParameter annotatedParameter = iterator2.next();
                    if (!annotatedParameter.getOwner().equals(annotatedConstructor)) continue;
                    hashSet.add(annotatedParameter);
                }
            }
            if (this._creatorProperties.isEmpty() || !hashSet.isEmpty()) {
                for (int i2 = 0; i2 < ((AnnotatedWithParams)annotatedConstructor).getParameterCount(); ++i2) {
                    AnnotatedParameter annotatedParameter = annotatedConstructor.getParameter(i2);
                    if (hashSet.contains(annotatedParameter)) continue;
                    this.a(map, annotatedParameter, (String)iterator.get(i2));
                }
            }
        }
    }

    protected void _addCreatorParam(Map<String, POJOPropertyBuilder> map, AnnotatedParameter annotatedParameter) {
        this.a(map, annotatedParameter, null);
    }

    private void a(Map<String, POJOPropertyBuilder> map, AnnotatedParameter annotatedParameter, String string) {
        Object object;
        String string2;
        if (string != null) {
            string2 = string;
        } else {
            string2 = this._annotationIntrospector.findImplicitPropertyName(annotatedParameter);
            if (string2 == null) {
                string2 = "";
            }
        }
        PropertyName propertyName = this._annotationIntrospector.findNameForDeserialization(annotatedParameter);
        boolean bl2 = propertyName != null && !propertyName.isEmpty();
        if (!bl2) {
            boolean bl3;
            if (string2.isEmpty()) {
                return;
            }
            object = this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedParameter.getOwner());
            boolean bl4 = bl3 = string != null;
            if (!(object != null && object != JsonCreator.Mode.DISABLED && object != JsonCreator.Mode.DELEGATING || bl3)) {
                return;
            }
            propertyName = PropertyName.construct(string2);
        }
        string2 = this.a(string2);
        object = bl2 && string2.isEmpty() ? this._property(map, propertyName) : this._property(map, string2);
        ((POJOPropertyBuilder)object).addCtor(annotatedParameter, propertyName, bl2, true, false);
        this._creatorProperties.add((POJOPropertyBuilder)object);
    }

    protected void _addMethods(Map<String, POJOPropertyBuilder> map) {
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            int n2 = ((AnnotatedWithParams)annotatedMethod).getParameterCount();
            if (n2 == 0) {
                this._addGetterMethod(map, annotatedMethod, this._annotationIntrospector);
                continue;
            }
            if (n2 == 1) {
                this._addSetterMethod(map, annotatedMethod, this._annotationIntrospector);
                continue;
            }
            if (n2 != 2 || !Boolean.TRUE.equals(this._annotationIntrospector.hasAnySetter(annotatedMethod))) continue;
            if (this._anySetters == null) {
                this._anySetters = new LinkedList();
            }
            this._anySetters.add(annotatedMethod);
        }
    }

    protected void _addGetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl2;
        Object object = annotatedMethod.getRawReturnType();
        if (object == Void.TYPE || object == Void.class && !this._config.isEnabled(MapperFeature.ALLOW_VOID_VALUED_PROPERTIES)) {
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAnyGetter(annotatedMethod))) {
            if (this._anyGetters == null) {
                this._anyGetters = new LinkedList();
            }
            this._anyGetters.add(annotatedMethod);
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAsKey(this._config, annotatedMethod))) {
            if (this._jsonKeyAccessors == null) {
                this._jsonKeyAccessors = new LinkedList();
            }
            this._jsonKeyAccessors.add(annotatedMethod);
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedMethod))) {
            if (this._jsonValueAccessors == null) {
                this._jsonValueAccessors = new LinkedList();
            }
            this._jsonValueAccessors.add(annotatedMethod);
            return;
        }
        PropertyName propertyName = annotationIntrospector.findNameForSerialization(annotatedMethod);
        boolean bl3 = propertyName != null;
        if (!bl3) {
            object = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (object == null) {
                AnnotatedMethod annotatedMethod2 = annotatedMethod;
                object = this._accessorNaming.findNameForRegularGetter(annotatedMethod2, ((Annotated)annotatedMethod2).getName());
            }
            if (object == null) {
                AnnotatedMethod annotatedMethod3 = annotatedMethod;
                object = this._accessorNaming.findNameForIsGetter(annotatedMethod3, ((Annotated)annotatedMethod3).getName());
                if (object == null) {
                    return;
                }
                bl2 = this._visibilityChecker.isIsGetterVisible(annotatedMethod);
            } else {
                bl2 = this._visibilityChecker.isGetterVisible(annotatedMethod);
            }
        } else {
            object = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (object == null) {
                AnnotatedMethod annotatedMethod4 = annotatedMethod;
                object = this._accessorNaming.findNameForRegularGetter(annotatedMethod4, ((Annotated)annotatedMethod4).getName());
                if (object == null) {
                    AnnotatedMethod annotatedMethod5 = annotatedMethod;
                    object = this._accessorNaming.findNameForIsGetter(annotatedMethod5, ((Annotated)annotatedMethod5).getName());
                }
            }
            if (object == null) {
                object = ((Annotated)annotatedMethod).getName();
            }
            if (propertyName.isEmpty()) {
                Class<?> clazz = object;
                propertyName = PropertyName.construct((String)((Object)clazz), null);
                bl3 = false;
            }
            bl2 = true;
        }
        object = this.a((String)object);
        boolean bl4 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, (String)object).addGetter(annotatedMethod, propertyName, bl3, bl2, bl4);
    }

    protected void _addSetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl2;
        String string;
        PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedMethod);
        boolean bl3 = propertyName != null;
        if (!bl3) {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                AnnotatedMethod annotatedMethod2 = annotatedMethod;
                string = this._accessorNaming.findNameForMutator(annotatedMethod2, ((Annotated)annotatedMethod2).getName());
            }
            if (string == null) {
                return;
            }
            bl2 = this._visibilityChecker.isSetterVisible(annotatedMethod);
        } else {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                AnnotatedMethod annotatedMethod3 = annotatedMethod;
                string = this._accessorNaming.findNameForMutator(annotatedMethod3, ((Annotated)annotatedMethod3).getName());
            }
            if (string == null) {
                string = ((Annotated)annotatedMethod).getName();
            }
            if (propertyName.isEmpty()) {
                String string2 = string;
                propertyName = PropertyName.construct(string2, null);
                bl3 = false;
            }
            bl2 = true;
        }
        string = this.a(string);
        boolean bl4 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, string).addSetter(annotatedMethod, propertyName, bl3, bl2, bl4);
    }

    protected void _addInjectables(Map<String, POJOPropertyBuilder> iterator) {
        for (AnnotatedField annotatedMember : this._classDef.fields()) {
            POJOPropertiesCollector pOJOPropertiesCollector = this;
            pOJOPropertiesCollector._doAddInjectable(pOJOPropertiesCollector._annotationIntrospector.findInjectableValue(annotatedMember), annotatedMember);
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            if (((AnnotatedWithParams)annotatedMethod).getParameterCount() != 1) continue;
            POJOPropertiesCollector pOJOPropertiesCollector = this;
            pOJOPropertiesCollector._doAddInjectable(pOJOPropertiesCollector._annotationIntrospector.findInjectableValue(annotatedMethod), annotatedMethod);
        }
    }

    protected void _doAddInjectable(JacksonInject.Value object, AnnotatedMember annotatedMember) {
        AnnotatedMember annotatedMember2;
        if (object == null) {
            return;
        }
        object = ((JacksonInject.Value)object).getId();
        if (this._injectables == null) {
            this._injectables = new LinkedHashMap();
        }
        if ((annotatedMember2 = this._injectables.put(object, annotatedMember)) != null && annotatedMember2.getClass() == annotatedMember.getClass()) {
            this.reportProblem("Duplicate injectable value with id '%s' (of type %s)", object, ClassUtil.classNameOf(object));
        }
    }

    private String a(String string) {
        if (this._fieldRenameMappings != null) {
            Object object = string;
            if ((object = this._fieldRenameMappings.get(PropertyName.construct((String)object, null))) != null) {
                string = ((PropertyName)object).getSimpleName();
                return string;
            }
        }
        return string;
    }

    protected void _removeUnwantedProperties(Map<String, POJOPropertyBuilder> object) {
        object = object.values().iterator();
        while (object.hasNext()) {
            POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)object.next();
            if (!pOJOPropertyBuilder.anyVisible()) {
                object.remove();
                continue;
            }
            if (!pOJOPropertyBuilder.anyIgnorals()) continue;
            if (this.isRecordType() && !this._forSerialization) {
                pOJOPropertyBuilder.removeIgnored();
                this._collectIgnorals(((BeanPropertyDefinition)pOJOPropertyBuilder).getName());
                continue;
            }
            if (!pOJOPropertyBuilder.anyExplicitsWithoutIgnoral()) {
                object.remove();
                this._collectIgnorals(((BeanPropertyDefinition)pOJOPropertyBuilder).getName());
                continue;
            }
            pOJOPropertyBuilder.removeIgnored();
            if (((BeanPropertyDefinition)pOJOPropertyBuilder).couldDeserialize()) continue;
            this._collectIgnorals(((BeanPropertyDefinition)pOJOPropertyBuilder).getName());
        }
    }

    protected void _removeUnwantedAccessor(Map<String, POJOPropertyBuilder> object) {
        boolean bl2 = !this.isRecordType() && this._config.isEnabled(MapperFeature.INFER_PROPERTY_MUTATORS);
        for (POJOPropertyBuilder pOJOPropertyBuilder : object.values()) {
            pOJOPropertyBuilder.removeNonVisible(bl2, this._forSerialization ? null : this);
        }
    }

    protected void _collectIgnorals(String string) {
        if (!this._forSerialization && string != null) {
            if (this._ignoredPropertyNames == null) {
                this._ignoredPropertyNames = new HashSet();
            }
            this._ignoredPropertyNames.add(string);
        }
    }

    protected void _renameProperties(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = pOJOPropertyBuilder.findExplicitNames();
            if (object2.isEmpty()) continue;
            iterator.remove();
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            if (object2.size() == 1) {
                object = (PropertyName)object2.iterator().next();
                linkedList.add(pOJOPropertyBuilder.withName((PropertyName)object));
                continue;
            }
            linkedList.addAll(pOJOPropertyBuilder.explode((Collection<PropertyName>)object2));
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = ((BeanPropertyDefinition)pOJOPropertyBuilder).getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                } else {
                    ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
                }
                if (!this._replaceCreatorProperty(pOJOPropertyBuilder, this._creatorProperties) || this._ignoredPropertyNames == null) continue;
                this._ignoredPropertyNames.remove(object2);
            }
        }
    }

    protected void _renameUsing(Map<String, POJOPropertyBuilder> map, PropertyNamingStrategy propertyNamingStrategy) {
        if (((ResolvedType)this._type).isEnumType() && this.getFormatOverrides().getShape() != JsonFormat.Shape.OBJECT) {
            return;
        }
        POJOPropertyBuilder[] pOJOPropertyBuilderArray = map.values().toArray(new POJOPropertyBuilder[map.size()]);
        map.clear();
        for (POJOPropertyBuilder pOJOPropertyBuilder : pOJOPropertyBuilderArray) {
            Object object = ((BeanPropertyDefinition)pOJOPropertyBuilder).getFullName();
            Object object2 = null;
            if (!((BeanPropertyDefinition)pOJOPropertyBuilder).isExplicitlyNamed() || this._config.isEnabled(MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING)) {
                if (this._forSerialization) {
                    if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasGetter()) {
                        object2 = propertyNamingStrategy.nameForGetterMethod(this._config, ((BeanPropertyDefinition)pOJOPropertyBuilder).getGetter(), ((PropertyName)object).getSimpleName());
                    } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasField()) {
                        object2 = propertyNamingStrategy.nameForField(this._config, ((BeanPropertyDefinition)pOJOPropertyBuilder).getField(), ((PropertyName)object).getSimpleName());
                    }
                } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasSetter()) {
                    object2 = propertyNamingStrategy.nameForSetterMethod(this._config, pOJOPropertyBuilder.getSetterUnchecked(), ((PropertyName)object).getSimpleName());
                } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasConstructorParameter()) {
                    object2 = propertyNamingStrategy.nameForConstructorParameter(this._config, ((BeanPropertyDefinition)pOJOPropertyBuilder).getConstructorParameter(), ((PropertyName)object).getSimpleName());
                } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasField()) {
                    object2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getFieldUnchecked(), ((PropertyName)object).getSimpleName());
                } else if (((BeanPropertyDefinition)pOJOPropertyBuilder).hasGetter()) {
                    object2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetterUnchecked(), ((PropertyName)object).getSimpleName());
                }
            }
            if (object2 != null && !((PropertyName)object).hasSimpleName((String)object2)) {
                pOJOPropertyBuilder = pOJOPropertyBuilder.withSimpleName((String)object2);
                object = object2;
            } else {
                object = ((PropertyName)object).getSimpleName();
            }
            object2 = map.get(object);
            if (object2 == null) {
                map.put((String)object, pOJOPropertyBuilder);
            } else {
                ((POJOPropertyBuilder)object2).addAll(pOJOPropertyBuilder);
            }
            this._replaceCreatorProperty(pOJOPropertyBuilder, this._creatorProperties);
        }
    }

    protected void _renameWithWrappers(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = ((BeanPropertyDefinition)pOJOPropertyBuilder).getPrimaryMember();
            if (object2 == null || (object = this._annotationIntrospector.findWrapperName((Annotated)object2)) == null || !((PropertyName)object).hasSimpleName() || ((PropertyName)object).equals(((BeanPropertyDefinition)pOJOPropertyBuilder).getFullName())) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            pOJOPropertyBuilder = pOJOPropertyBuilder.withName((PropertyName)object);
            linkedList.add(pOJOPropertyBuilder);
            iterator.remove();
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = ((BeanPropertyDefinition)pOJOPropertyBuilder).getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                    continue;
                }
                ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void _sortProperties(Map<String, POJOPropertyBuilder> map) {
        Comparable<POJOPropertyBuilder> comparable;
        AbstractMap abstractMap;
        boolean bl2;
        boolean bl3;
        String[] stringArray;
        block17: {
            stringArray = this._annotationIntrospector;
            Boolean bl4 = this._annotationIntrospector.findSerializationSortAlphabetically(this._classDef);
            bl3 = bl4 == null ? this._config.shouldSortPropertiesAlphabetically() : bl4.booleanValue();
            Object object3 = map.values();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)object3.next();
                if (!((BeanPropertyDefinition)pOJOPropertyBuilder).getMetadata().hasIndex()) continue;
                bl2 = true;
                break block17;
            }
            bl2 = false;
        }
        boolean bl5 = bl2;
        stringArray = stringArray.findSerializationPropertyOrder(this._classDef);
        if (!bl3 && !bl5 && this._creatorProperties == null && stringArray == null) {
            return;
        }
        int n2 = map.size();
        if (bl3) {
            abstractMap = new TreeMap();
        } else {
            int n3 = n2;
            abstractMap = new LinkedHashMap(n3 + n3);
        }
        for (POJOPropertyBuilder object22 : map.values()) {
            abstractMap.put(((BeanPropertyDefinition)object22).getName(), object22);
        }
        int n4 = n2;
        LinkedHashMap linkedHashMap = new LinkedHashMap(n4 + n4);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n5 = stringArray.length;
            for (n2 = 0; n2 < n5; ++n2) {
                void var9_27;
                String string = stringArray2[n2];
                comparable = (POJOPropertyBuilder)abstractMap.remove(string);
                if (comparable == null) {
                    for (POJOPropertyBuilder pOJOPropertyBuilder : map.values()) {
                        if (!string.equals(((BeanPropertyDefinition)pOJOPropertyBuilder).getInternalName())) continue;
                        comparable = pOJOPropertyBuilder;
                        String string2 = ((BeanPropertyDefinition)pOJOPropertyBuilder).getName();
                        break;
                    }
                }
                if (comparable == null) continue;
                linkedHashMap.put(var9_27, comparable);
            }
        }
        if (bl5) {
            TreeMap<POJOPropertyBuilder, POJOPropertyBuilder> treeMap = new TreeMap<POJOPropertyBuilder, POJOPropertyBuilder>();
            Iterator iterator = abstractMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)entry.getValue();
                comparable = ((BeanPropertyDefinition)pOJOPropertyBuilder).getMetadata().getIndex();
                if (comparable == null) continue;
                treeMap.put((POJOPropertyBuilder)comparable, pOJOPropertyBuilder);
                iterator.remove();
            }
            for (POJOPropertyBuilder pOJOPropertyBuilder : treeMap.values()) {
                linkedHashMap.put(((BeanPropertyDefinition)pOJOPropertyBuilder).getName(), pOJOPropertyBuilder);
            }
        }
        if (this._creatorProperties != null && (!bl3 || this._config.isEnabled(MapperFeature.SORT_CREATOR_PROPERTIES_FIRST))) {
            void var8_26;
            if (bl3) {
                TreeMap<String, POJOPropertyBuilder> treeMap = new TreeMap<String, POJOPropertyBuilder>();
                for (POJOPropertyBuilder pOJOPropertyBuilder : this._creatorProperties) {
                    treeMap.put(((BeanPropertyDefinition)pOJOPropertyBuilder).getName(), pOJOPropertyBuilder);
                }
                Collection collection = treeMap.values();
            } else {
                LinkedList<POJOPropertyBuilder> linkedList = this._creatorProperties;
            }
            for (POJOPropertyBuilder pOJOPropertyBuilder : var8_26) {
                String string = ((BeanPropertyDefinition)pOJOPropertyBuilder).getName();
                if (!abstractMap.containsKey(string)) continue;
                linkedHashMap.put(string, pOJOPropertyBuilder);
            }
        }
        linkedHashMap.putAll(abstractMap);
        map.clear();
        map.putAll(linkedHashMap);
    }

    protected boolean _resolveFieldVsGetter(List<AnnotatedMember> list) {
        do {
            AnnotatedMember annotatedMember = list.get(0);
            AnnotatedMember annotatedMember2 = list.get(1);
            if (annotatedMember instanceof AnnotatedField) {
                if (annotatedMember2 instanceof AnnotatedMethod) {
                    list.remove(0);
                    continue;
                }
            } else if (annotatedMember instanceof AnnotatedMethod && annotatedMember2 instanceof AnnotatedField) {
                list.remove(1);
                continue;
            }
            return false;
        } while (list.size() > 1);
        return true;
    }

    protected void reportProblem(String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + string);
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, PropertyName propertyName) {
        String string = propertyName.getSimpleName();
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, propertyName);
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, String string) {
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, PropertyName.construct(string));
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    @Deprecated
    protected void _updateCreatorProperty(POJOPropertyBuilder pOJOPropertyBuilder, List<POJOPropertyBuilder> list) {
        this._replaceCreatorProperty(pOJOPropertyBuilder, list);
    }

    protected boolean _replaceCreatorProperty(POJOPropertyBuilder pOJOPropertyBuilder, List<POJOPropertyBuilder> list) {
        if (list != null) {
            String string = ((BeanPropertyDefinition)pOJOPropertyBuilder).getInternalName();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!((BeanPropertyDefinition)list.get(i2)).getInternalName().equals(string)) continue;
                list.set(i2, pOJOPropertyBuilder);
                return true;
            }
        }
        return false;
    }
}

