/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;

public class POJOPropertyBuilder
extends BeanPropertyDefinition
implements Comparable<POJOPropertyBuilder> {
    private static final AnnotationIntrospector.ReferenceProperty a = AnnotationIntrospector.ReferenceProperty.managed("");
    protected final boolean _forSerialization;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final PropertyName _name;
    protected final PropertyName _internalName;
    protected Linked<AnnotatedField> _fields;
    protected Linked<AnnotatedParameter> _ctorParameters;
    protected Linked<AnnotatedMethod> _getters;
    protected Linked<AnnotatedMethod> _setters;
    protected transient PropertyMetadata _metadata;
    protected transient AnnotationIntrospector.ReferenceProperty _referenceInfo;

    public POJOPropertyBuilder(MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, boolean bl2, PropertyName propertyName) {
        PropertyName propertyName2 = propertyName;
        this(mapperConfig, annotationIntrospector, bl2, propertyName2, propertyName2);
    }

    protected POJOPropertyBuilder(MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, boolean bl2, PropertyName propertyName, PropertyName propertyName2) {
        this._config = mapperConfig;
        this._annotationIntrospector = annotationIntrospector;
        this._internalName = propertyName;
        this._name = propertyName2;
        this._forSerialization = bl2;
    }

    protected POJOPropertyBuilder(POJOPropertyBuilder pOJOPropertyBuilder, PropertyName propertyName) {
        this._config = pOJOPropertyBuilder._config;
        this._annotationIntrospector = pOJOPropertyBuilder._annotationIntrospector;
        this._internalName = pOJOPropertyBuilder._internalName;
        this._name = propertyName;
        this._fields = pOJOPropertyBuilder._fields;
        this._ctorParameters = pOJOPropertyBuilder._ctorParameters;
        this._getters = pOJOPropertyBuilder._getters;
        this._setters = pOJOPropertyBuilder._setters;
        this._forSerialization = pOJOPropertyBuilder._forSerialization;
    }

    @Override
    public POJOPropertyBuilder withName(PropertyName propertyName) {
        return new POJOPropertyBuilder(this, propertyName);
    }

    @Override
    public POJOPropertyBuilder withSimpleName(String object) {
        if ((object = this._name.withSimpleName((String)object)) == this._name) {
            return this;
        }
        return new POJOPropertyBuilder(this, (PropertyName)object);
    }

    @Override
    public int compareTo(POJOPropertyBuilder pOJOPropertyBuilder) {
        if (this._ctorParameters != null) {
            if (pOJOPropertyBuilder._ctorParameters == null) {
                return -1;
            }
        } else if (pOJOPropertyBuilder._ctorParameters != null) {
            return 1;
        }
        return ((BeanPropertyDefinition)this).getName().compareTo(((BeanPropertyDefinition)pOJOPropertyBuilder).getName());
    }

    @Override
    public String getName() {
        if (this._name == null) {
            return null;
        }
        return this._name.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._name;
    }

    @Override
    public boolean hasName(PropertyName propertyName) {
        return this._name.equals(propertyName);
    }

    @Override
    public String getInternalName() {
        return this._internalName.getSimpleName();
    }

    @Override
    public PropertyName getWrapperName() {
        AnnotatedMember annotatedMember = ((BeanPropertyDefinition)this).getPrimaryMember();
        if (annotatedMember == null || this._annotationIntrospector == null) {
            return null;
        }
        return this._annotationIntrospector.findWrapperName(annotatedMember);
    }

    @Override
    public boolean isExplicitlyIncluded() {
        return POJOPropertyBuilder.e(this._fields) || POJOPropertyBuilder.e(this._getters) || POJOPropertyBuilder.e(this._setters) || POJOPropertyBuilder.f(this._ctorParameters);
    }

    @Override
    public boolean isExplicitlyNamed() {
        return POJOPropertyBuilder.f(this._fields) || POJOPropertyBuilder.f(this._getters) || POJOPropertyBuilder.f(this._setters) || POJOPropertyBuilder.f(this._ctorParameters);
    }

    @Override
    public PropertyMetadata getMetadata() {
        if (this._metadata == null) {
            AnnotatedMember annotatedMember = this.getPrimaryMemberUnchecked();
            if (annotatedMember == null) {
                this._metadata = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
            } else {
                Boolean bl2 = this._annotationIntrospector.hasRequiredMarker(annotatedMember);
                String string = this._annotationIntrospector.findPropertyDescription(annotatedMember);
                Integer n2 = this._annotationIntrospector.findPropertyIndex(annotatedMember);
                String string2 = this._annotationIntrospector.findPropertyDefaultValue(annotatedMember);
                this._metadata = bl2 == null && n2 == null && string2 == null ? (string == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : PropertyMetadata.STD_REQUIRED_OR_OPTIONAL.withDescription(string)) : PropertyMetadata.construct(bl2, string, n2, string2);
                if (!this._forSerialization) {
                    this._metadata = this._getSetterInfo(this._metadata, annotatedMember);
                }
            }
        }
        return this._metadata;
    }

    protected PropertyMetadata _getSetterInfo(PropertyMetadata propertyMetadata, AnnotatedMember object) {
        Serializable serializable;
        boolean bl2 = true;
        Nulls nulls = null;
        Nulls nulls2 = null;
        AnnotatedMember annotatedMember = this.getAccessor();
        if (object != null) {
            if (this._annotationIntrospector != null) {
                if (annotatedMember != null && (serializable = this._annotationIntrospector.findMergeInfo((Annotated)object)) != null) {
                    bl2 = false;
                    if (((Boolean)serializable).booleanValue()) {
                        propertyMetadata = propertyMetadata.withMergeInfo(PropertyMetadata.MergeInfo.createForPropertyOverride(annotatedMember));
                    }
                }
                if ((serializable = this._annotationIntrospector.findSetterInfo((Annotated)object)) != null) {
                    nulls = ((JsonSetter.Value)serializable).nonDefaultValueNulls();
                    nulls2 = ((JsonSetter.Value)serializable).nonDefaultContentNulls();
                }
            }
            if (bl2 || nulls == null || nulls2 == null) {
                serializable = this._rawTypeOf((AnnotatedMember)object);
                object = this._config.getConfigOverride((Class<?>)serializable);
                if ((serializable = ((ConfigOverride)object).getSetterInfo()) != null) {
                    if (nulls == null) {
                        nulls = ((JsonSetter.Value)serializable).nonDefaultValueNulls();
                    }
                    if (nulls2 == null) {
                        nulls2 = ((JsonSetter.Value)serializable).nonDefaultContentNulls();
                    }
                }
                if (bl2 && annotatedMember != null && (object = ((ConfigOverride)object).getMergeable()) != null) {
                    bl2 = false;
                    if (((Boolean)object).booleanValue()) {
                        propertyMetadata = propertyMetadata.withMergeInfo(PropertyMetadata.MergeInfo.createForTypeOverride(annotatedMember));
                    }
                }
            }
        }
        if (bl2 || nulls == null || nulls2 == null) {
            serializable = this._config.getDefaultSetterInfo();
            if (nulls == null) {
                nulls = ((JsonSetter.Value)serializable).nonDefaultValueNulls();
            }
            if (nulls2 == null) {
                nulls2 = ((JsonSetter.Value)serializable).nonDefaultContentNulls();
            }
            if (bl2 && Boolean.TRUE.equals(object = this._config.getDefaultMergeable()) && annotatedMember != null) {
                propertyMetadata = propertyMetadata.withMergeInfo(PropertyMetadata.MergeInfo.createForDefaults(annotatedMember));
            }
        }
        if (nulls != null || nulls2 != null) {
            propertyMetadata = propertyMetadata.withNulls(nulls, nulls2);
        }
        return propertyMetadata;
    }

    @Override
    public JavaType getPrimaryType() {
        if (this._forSerialization) {
            AnnotatedMember annotatedMember = ((BeanPropertyDefinition)this).getGetter();
            if (annotatedMember == null && (annotatedMember = ((BeanPropertyDefinition)this).getField()) == null) {
                return TypeFactory.unknownType();
            }
            return ((Annotated)annotatedMember).getType();
        }
        AnnotatedMember annotatedMember = ((BeanPropertyDefinition)this).getConstructorParameter();
        if (annotatedMember == null) {
            annotatedMember = ((BeanPropertyDefinition)this).getSetter();
            if (annotatedMember != null) {
                return ((AnnotatedWithParams)((AnnotatedMethod)annotatedMember)).getParameterType(0);
            }
            annotatedMember = ((BeanPropertyDefinition)this).getField();
        }
        if (annotatedMember == null && (annotatedMember = ((BeanPropertyDefinition)this).getGetter()) == null) {
            return TypeFactory.unknownType();
        }
        return ((Annotated)annotatedMember).getType();
    }

    @Override
    public Class<?> getRawPrimaryType() {
        return ((ResolvedType)((BeanPropertyDefinition)this).getPrimaryType()).getRawClass();
    }

    @Override
    public boolean hasGetter() {
        return this._getters != null;
    }

    @Override
    public boolean hasSetter() {
        return this._setters != null;
    }

    @Override
    public boolean hasField() {
        return this._fields != null;
    }

    @Override
    public boolean hasConstructorParameter() {
        return this._ctorParameters != null;
    }

    @Override
    public boolean couldDeserialize() {
        return this._ctorParameters != null || this._setters != null || this._fields != null && POJOPropertyBuilder.g(this._fields);
    }

    @Override
    public boolean couldSerialize() {
        return this._getters != null || this._fields != null;
    }

    @Override
    public AnnotatedMethod getGetter() {
        Linked<AnnotatedMethod> linked = this._getters;
        if (linked == null) {
            return null;
        }
        Linked linked2 = linked.next;
        if (linked2 == null) {
            return (AnnotatedMethod)linked.value;
        }
        while (linked2 != null) {
            block11: {
                int n2;
                int n3;
                block9: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block10: {
                        clazz2 = ((AnnotatedMember)((AnnotatedMethod)linked.value)).getDeclaringClass();
                        if (clazz2 == (clazz = ((AnnotatedMember)((AnnotatedMethod)linked2.value)).getDeclaringClass())) break block9;
                        if (!clazz2.isAssignableFrom(clazz)) break block10;
                        linked = linked2;
                        break block11;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block11;
                }
                if ((n3 = this._getterPriority((AnnotatedMethod)linked2.value)) != (n2 = this._getterPriority((AnnotatedMethod)linked.value))) {
                    if (n3 < n2) {
                        linked = linked2;
                    }
                } else {
                    throw new IllegalArgumentException("Conflicting getter definitions for property \"" + ((BeanPropertyDefinition)this).getName() + "\": " + ((AnnotatedMember)((AnnotatedMethod)linked.value)).getFullName() + " vs " + ((AnnotatedMember)((AnnotatedMethod)linked2.value)).getFullName());
                }
            }
            linked2 = linked2.next;
        }
        this._getters = linked.withoutNext();
        return (AnnotatedMethod)linked.value;
    }

    protected AnnotatedMethod getGetterUnchecked() {
        Linked<AnnotatedMethod> linked = this._getters;
        if (linked == null) {
            return null;
        }
        return (AnnotatedMethod)linked.value;
    }

    @Override
    public AnnotatedMethod getSetter() {
        Linked<AnnotatedMethod> linked = this._setters;
        if (linked == null) {
            return null;
        }
        Linked<AnnotatedMethod> linked2 = linked.next;
        if (linked2 == null) {
            return (AnnotatedMethod)linked.value;
        }
        while (linked2 != null) {
            AnnotatedMethod annotatedMethod = this._selectSetter((AnnotatedMethod)linked.value, (AnnotatedMethod)linked2.value);
            if (annotatedMethod != linked.value) {
                if (annotatedMethod == linked2.value) {
                    linked = linked2;
                } else {
                    return this._selectSetterFromMultiple(linked, linked2);
                }
            }
            linked2 = linked2.next;
        }
        this._setters = linked.withoutNext();
        return (AnnotatedMethod)linked.value;
    }

    protected AnnotatedMethod getSetterUnchecked() {
        Linked<AnnotatedMethod> linked = this._setters;
        if (linked == null) {
            return null;
        }
        return (AnnotatedMethod)linked.value;
    }

    protected AnnotatedMethod _selectSetterFromMultiple(Linked<AnnotatedMethod> linked, Linked<AnnotatedMethod> linked2) {
        Object object;
        ArrayList arrayList = new ArrayList();
        arrayList.add(linked.value);
        arrayList.add(linked2.value);
        linked2 = linked2.next;
        while (linked2 != null) {
            object = this._selectSetter((AnnotatedMethod)linked.value, (AnnotatedMethod)linked2.value);
            if (object != linked.value) {
                if (object == linked2.value) {
                    arrayList.clear();
                    linked = linked2;
                } else {
                    arrayList.add(linked2.value);
                }
            }
            linked2 = linked2.next;
        }
        if (arrayList.isEmpty()) {
            this._setters = linked.withoutNext();
            return (AnnotatedMethod)linked.value;
        }
        object = arrayList.stream().map(AnnotatedMethod::getFullName).collect(Collectors.joining(" vs "));
        throw new IllegalArgumentException(String.format("Conflicting setter definitions for property \"%s\": %s", ((BeanPropertyDefinition)this).getName(), object));
    }

    protected AnnotatedMethod _selectSetter(AnnotatedMethod annotatedMethod, AnnotatedMethod annotatedMethod2) {
        int n2;
        int n3;
        Class<?> clazz;
        Class<?> clazz2 = ((AnnotatedMember)annotatedMethod).getDeclaringClass();
        if (clazz2 != (clazz = ((AnnotatedMember)annotatedMethod2).getDeclaringClass())) {
            if (clazz2.isAssignableFrom(clazz)) {
                return annotatedMethod2;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return annotatedMethod;
            }
        }
        if ((n3 = this._setterPriority(annotatedMethod2)) != (n2 = this._setterPriority(annotatedMethod))) {
            if (n3 < n2) {
                return annotatedMethod2;
            }
            return annotatedMethod;
        }
        if (this._annotationIntrospector == null) {
            return null;
        }
        return this._annotationIntrospector.resolveSetterConflict(this._config, annotatedMethod, annotatedMethod2);
    }

    @Override
    public AnnotatedField getField() {
        if (this._fields == null) {
            return null;
        }
        AnnotatedField annotatedField = (AnnotatedField)this._fields.value;
        Linked linked = this._fields.next;
        while (linked != null) {
            block10: {
                boolean bl2;
                boolean bl3;
                AnnotatedField annotatedField2;
                block8: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block9: {
                        annotatedField2 = (AnnotatedField)linked.value;
                        clazz2 = ((AnnotatedMember)annotatedField).getDeclaringClass();
                        if (clazz2 == (clazz = ((AnnotatedMember)annotatedField2).getDeclaringClass())) break block8;
                        if (!clazz2.isAssignableFrom(clazz)) break block9;
                        annotatedField = annotatedField2;
                        break block10;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block10;
                }
                if ((bl3 = annotatedField.isStatic()) != (bl2 = annotatedField2.isStatic())) {
                    if (bl3) {
                        annotatedField = annotatedField2;
                    }
                } else {
                    throw new IllegalArgumentException("Multiple fields representing property \"" + ((BeanPropertyDefinition)this).getName() + "\": " + annotatedField.getFullName() + " vs " + annotatedField2.getFullName());
                }
            }
            linked = linked.next;
        }
        return annotatedField;
    }

    protected AnnotatedField getFieldUnchecked() {
        Linked<AnnotatedField> linked = this._fields;
        if (linked == null) {
            return null;
        }
        return (AnnotatedField)linked.value;
    }

    @Override
    public AnnotatedParameter getConstructorParameter() {
        if (this._ctorParameters == null) {
            return null;
        }
        Linked<AnnotatedParameter> linked = this._ctorParameters;
        do {
            if (!(((AnnotatedParameter)linked.value).getOwner() instanceof AnnotatedConstructor)) continue;
            return (AnnotatedParameter)linked.value;
        } while ((linked = linked.next) != null);
        return (AnnotatedParameter)this._ctorParameters.value;
    }

    @Override
    public Iterator<AnnotatedParameter> getConstructorParameters() {
        if (this._ctorParameters == null) {
            return ClassUtil.emptyIterator();
        }
        return new MemberIterator<AnnotatedParameter>(this._ctorParameters);
    }

    @Override
    public AnnotatedMember getPrimaryMember() {
        if (this._forSerialization) {
            return this.getAccessor();
        }
        AnnotatedMember annotatedMember = this.getMutator();
        if (annotatedMember == null) {
            annotatedMember = this.getAccessor();
        }
        return annotatedMember;
    }

    protected AnnotatedMember getPrimaryMemberUnchecked() {
        if (this._forSerialization) {
            if (this._getters != null) {
                return (AnnotatedMember)this._getters.value;
            }
            if (this._fields != null) {
                return (AnnotatedMember)this._fields.value;
            }
            return null;
        }
        if (this._ctorParameters != null) {
            return (AnnotatedMember)this._ctorParameters.value;
        }
        if (this._setters != null) {
            return (AnnotatedMember)this._setters.value;
        }
        if (this._fields != null) {
            return (AnnotatedMember)this._fields.value;
        }
        if (this._getters != null) {
            return (AnnotatedMember)this._getters.value;
        }
        return null;
    }

    protected int _getterPriority(AnnotatedMethod object) {
        if (((String)(object = ((Annotated)object).getName())).startsWith("get") && ((String)object).length() > 3) {
            return 1;
        }
        if (((String)object).startsWith("is") && ((String)object).length() > 2) {
            return 2;
        }
        return 3;
    }

    protected int _setterPriority(AnnotatedMethod object) {
        if (((String)(object = ((Annotated)object).getName())).startsWith("set") && ((String)object).length() > 3) {
            return 1;
        }
        return 2;
    }

    @Override
    public Class<?>[] findViews() {
        return this.fromMemberAnnotations(new a<Class<?>[]>(this){
            private /* synthetic */ POJOPropertyBuilder a;
            {
                this.a = pOJOPropertyBuilder;
            }

            @Override
            public final /* synthetic */ Object a(AnnotatedMember object) {
                AnnotatedMember annotatedMember = object;
                object = this;
                return object.a._annotationIntrospector.findViews(annotatedMember);
            }
        });
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType() {
        AnnotationIntrospector.ReferenceProperty referenceProperty = this._referenceInfo;
        if (referenceProperty != null) {
            if (referenceProperty == a) {
                return null;
            }
            return referenceProperty;
        }
        referenceProperty = this.fromMemberAnnotations(new a<AnnotationIntrospector.ReferenceProperty>(this){
            private /* synthetic */ POJOPropertyBuilder a;
            {
                this.a = pOJOPropertyBuilder;
            }

            @Override
            public final /* synthetic */ Object a(AnnotatedMember object) {
                AnnotatedMember annotatedMember = object;
                object = this;
                return object.a._annotationIntrospector.findReferenceType(annotatedMember);
            }
        });
        this._referenceInfo = referenceProperty == null ? a : referenceProperty;
        return referenceProperty;
    }

    @Override
    public boolean isTypeId() {
        Boolean bl2 = this.fromMemberAnnotations(new a<Boolean>(this){
            private /* synthetic */ POJOPropertyBuilder a;
            {
                this.a = pOJOPropertyBuilder;
            }

            @Override
            public final /* synthetic */ Object a(AnnotatedMember object) {
                AnnotatedMember annotatedMember = object;
                object = this;
                return object.a._annotationIntrospector.isTypeId(annotatedMember);
            }
        });
        return bl2 != null && bl2 != false;
    }

    @Override
    public ObjectIdInfo findObjectIdInfo() {
        return this.fromMemberAnnotations(new a<ObjectIdInfo>(this){
            private /* synthetic */ POJOPropertyBuilder a;
            {
                this.a = pOJOPropertyBuilder;
            }

            @Override
            public final /* synthetic */ Object a(AnnotatedMember object) {
                AnnotatedMember annotatedMember = object;
                object = this;
                ObjectIdInfo objectIdInfo = object.a._annotationIntrospector.findObjectIdInfo(annotatedMember);
                if (objectIdInfo != null) {
                    objectIdInfo = object.a._annotationIntrospector.findObjectReferenceInfo(annotatedMember, objectIdInfo);
                }
                return objectIdInfo;
            }
        });
    }

    @Override
    public JsonInclude.Value findInclusion() {
        Serializable serializable = this.getAccessor();
        serializable = this._annotationIntrospector == null ? null : this._annotationIntrospector.findPropertyInclusion((Annotated)((Object)serializable));
        if (serializable == null) {
            return JsonInclude.Value.empty();
        }
        return serializable;
    }

    @Override
    public List<PropertyName> findAliases() {
        Object object = ((BeanPropertyDefinition)this).getPrimaryMember();
        if (object != null && (object = this._annotationIntrospector.findPropertyAliases((Annotated)object)) != null) {
            return object;
        }
        return Collections.emptyList();
    }

    public JsonProperty.Access findAccess() {
        return this.fromMemberAnnotationsExcept(new a<JsonProperty.Access>(this){
            private /* synthetic */ POJOPropertyBuilder a;
            {
                this.a = pOJOPropertyBuilder;
            }

            @Override
            public final /* synthetic */ Object a(AnnotatedMember object) {
                AnnotatedMember annotatedMember = object;
                object = this;
                return object.a._annotationIntrospector.findPropertyAccess(annotatedMember);
            }
        }, JsonProperty.Access.AUTO);
    }

    public void addField(AnnotatedField annotatedField, PropertyName propertyName, boolean bl2, boolean bl3, boolean bl4) {
        this._fields = new Linked<AnnotatedField>(annotatedField, this._fields, propertyName, bl2, bl3, bl4);
    }

    public void addCtor(AnnotatedParameter annotatedParameter, PropertyName propertyName, boolean bl2, boolean bl3, boolean bl4) {
        this._ctorParameters = new Linked<AnnotatedParameter>(annotatedParameter, this._ctorParameters, propertyName, bl2, bl3, bl4);
    }

    public void addGetter(AnnotatedMethod annotatedMethod, PropertyName propertyName, boolean bl2, boolean bl3, boolean bl4) {
        this._getters = new Linked<AnnotatedMethod>(annotatedMethod, this._getters, propertyName, bl2, bl3, bl4);
    }

    public void addSetter(AnnotatedMethod annotatedMethod, PropertyName propertyName, boolean bl2, boolean bl3, boolean bl4) {
        this._setters = new Linked<AnnotatedMethod>(annotatedMethod, this._setters, propertyName, bl2, bl3, bl4);
    }

    public void addAll(POJOPropertyBuilder pOJOPropertyBuilder) {
        this._fields = POJOPropertyBuilder.a(this._fields, pOJOPropertyBuilder._fields);
        this._ctorParameters = POJOPropertyBuilder.a(this._ctorParameters, pOJOPropertyBuilder._ctorParameters);
        this._getters = POJOPropertyBuilder.a(this._getters, pOJOPropertyBuilder._getters);
        this._setters = POJOPropertyBuilder.a(this._setters, pOJOPropertyBuilder._setters);
    }

    private static <T> Linked<T> a(Linked<T> linked, Linked<T> linked2) {
        if (linked == null) {
            return linked2;
        }
        if (linked2 == null) {
            return linked;
        }
        return linked.append(linked2);
    }

    public void removeIgnored() {
        this._fields = POJOPropertyBuilder.b(this._fields);
        this._getters = POJOPropertyBuilder.b(this._getters);
        this._setters = POJOPropertyBuilder.b(this._setters);
        this._ctorParameters = POJOPropertyBuilder.b(this._ctorParameters);
    }

    @Deprecated
    public JsonProperty.Access removeNonVisible(boolean bl2) {
        return this.removeNonVisible(bl2, null);
    }

    public JsonProperty.Access removeNonVisible(boolean bl2, POJOPropertiesCollector pOJOPropertiesCollector) {
        JsonProperty.Access access = this.findAccess();
        if (access == null) {
            access = JsonProperty.Access.AUTO;
        }
        switch (access) {
            case READ_ONLY: {
                if (pOJOPropertiesCollector != null) {
                    pOJOPropertiesCollector._collectIgnorals(((BeanPropertyDefinition)this).getName());
                    for (PropertyName propertyName : this.findExplicitNames()) {
                        pOJOPropertiesCollector._collectIgnorals(propertyName.getSimpleName());
                    }
                }
                this._setters = null;
                this._ctorParameters = null;
                if (this._forSerialization) break;
                this._fields = null;
                break;
            }
            case READ_WRITE: {
                break;
            }
            case WRITE_ONLY: {
                this._getters = null;
                if (!this._forSerialization) break;
                this._fields = null;
                break;
            }
            default: {
                this._getters = POJOPropertyBuilder.c(this._getters);
                this._ctorParameters = POJOPropertyBuilder.c(this._ctorParameters);
                if (bl2 && this._getters != null) break;
                this._fields = POJOPropertyBuilder.c(this._fields);
                this._setters = POJOPropertyBuilder.c(this._setters);
            }
        }
        return access;
    }

    public void removeConstructors() {
        this._ctorParameters = null;
    }

    public void trimByVisibility() {
        this._fields = POJOPropertyBuilder.d(this._fields);
        this._getters = POJOPropertyBuilder.d(this._getters);
        this._setters = POJOPropertyBuilder.d(this._setters);
        this._ctorParameters = POJOPropertyBuilder.d(this._ctorParameters);
    }

    public void mergeAnnotations(boolean bl2) {
        if (bl2) {
            if (this._getters != null) {
                AnnotationMap annotationMap = this.a(0, this._getters, this._fields, this._ctorParameters, this._setters);
                this._getters = this.a(this._getters, annotationMap);
                return;
            }
            if (this._fields != null) {
                AnnotationMap annotationMap = this.a(0, this._fields, this._ctorParameters, this._setters);
                this._fields = this.a(this._fields, annotationMap);
                return;
            }
        } else {
            if (this._ctorParameters != null) {
                AnnotationMap annotationMap = this.a(0, this._ctorParameters, this._setters, this._fields, this._getters);
                this._ctorParameters = this.a(this._ctorParameters, annotationMap);
                return;
            }
            if (this._setters != null) {
                AnnotationMap annotationMap = this.a(0, this._setters, this._fields, this._getters);
                this._setters = this.a(this._setters, annotationMap);
                return;
            }
            if (this._fields != null) {
                AnnotationMap annotationMap = this.a(0, this._fields, this._getters);
                this._fields = this.a(this._fields, annotationMap);
            }
        }
    }

    private AnnotationMap a(int n2, Linked<? extends AnnotatedMember> ... linkedArray) {
        AnnotationMap annotationMap = this.a(linkedArray[n2]);
        while (++n2 < linkedArray.length) {
            if (linkedArray[n2] == null) continue;
            return AnnotationMap.merge(annotationMap, this.a(n2, linkedArray));
        }
        return annotationMap;
    }

    private <T extends AnnotatedMember> AnnotationMap a(Linked<T> linked) {
        AnnotationMap annotationMap = ((AnnotatedMember)linked.value).getAllAnnotations();
        if (linked.next != null) {
            annotationMap = AnnotationMap.merge(annotationMap, this.a(linked.next));
        }
        return annotationMap;
    }

    private <T extends AnnotatedMember> Linked<T> a(Linked<T> linked, AnnotationMap annotationMap) {
        AnnotatedMember annotatedMember = (AnnotatedMember)((AnnotatedMember)linked.value).withAnnotations(annotationMap);
        if (linked.next != null) {
            linked = linked.withNext(this.a(linked.next, annotationMap));
        }
        return linked.withValue(annotatedMember);
    }

    private static <T> Linked<T> b(Linked<T> linked) {
        if (linked == null) {
            return linked;
        }
        return linked.withoutIgnored();
    }

    private static <T> Linked<T> c(Linked<T> linked) {
        if (linked == null) {
            return linked;
        }
        return linked.withoutNonVisible();
    }

    private static <T> Linked<T> d(Linked<T> linked) {
        if (linked == null) {
            return linked;
        }
        return linked.trimByVisibility();
    }

    private static <T> boolean e(Linked<T> linked) {
        while (linked != null) {
            if (linked.name != null && linked.name.hasSimpleName()) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    private static <T> boolean f(Linked<T> linked) {
        while (linked != null) {
            if (linked.name != null && linked.isNameExplicit) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public boolean anyVisible() {
        return POJOPropertyBuilder.g(this._fields) || POJOPropertyBuilder.g(this._getters) || POJOPropertyBuilder.g(this._setters) || POJOPropertyBuilder.g(this._ctorParameters);
    }

    private static <T> boolean g(Linked<T> linked) {
        while (linked != null) {
            if (linked.isVisible) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public boolean anyIgnorals() {
        return POJOPropertyBuilder.h(this._fields) || POJOPropertyBuilder.h(this._getters) || POJOPropertyBuilder.h(this._setters) || POJOPropertyBuilder.h(this._ctorParameters);
    }

    private static <T> boolean h(Linked<T> linked) {
        while (linked != null) {
            if (linked.isMarkedIgnored) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public boolean anyExplicitsWithoutIgnoral() {
        block7: {
            block6: {
                boolean bl2;
                block5: {
                    if (POJOPropertyBuilder.i(this._fields) || POJOPropertyBuilder.i(this._getters) || POJOPropertyBuilder.i(this._setters)) break block6;
                    Linked<AnnotatedParameter> linked = this._ctorParameters;
                    while (linked != null) {
                        if (!linked.isMarkedIgnored && linked.name != null && linked.isNameExplicit) {
                            bl2 = true;
                            break block5;
                        }
                        linked = linked.next;
                    }
                    bl2 = false;
                }
                if (!bl2) break block7;
            }
            return true;
        }
        return false;
    }

    private static <T> boolean i(Linked<T> linked) {
        while (linked != null) {
            if (!linked.isMarkedIgnored && linked.name != null && linked.name.hasSimpleName()) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public Set<PropertyName> findExplicitNames() {
        Set<PropertyName> set = POJOPropertyBuilder.a(this._fields, null);
        set = POJOPropertyBuilder.a(this._getters, set);
        set = POJOPropertyBuilder.a(this._setters, set);
        if ((set = POJOPropertyBuilder.a(this._ctorParameters, set)) == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public Collection<POJOPropertyBuilder> explode(Collection<PropertyName> collection) {
        HashMap<PropertyName, POJOPropertyBuilder> hashMap = new HashMap<PropertyName, POJOPropertyBuilder>();
        this.a(collection, hashMap, this._fields);
        this.a(collection, hashMap, this._getters);
        this.a(collection, hashMap, this._setters);
        this.a(collection, hashMap, this._ctorParameters);
        return hashMap.values();
    }

    private void a(Collection<PropertyName> collection, Map<PropertyName, POJOPropertyBuilder> map, Linked<?> linked) {
        Linked<?> linked2 = linked;
        while (linked != null) {
            Linked<Object> linked3 = linked.name;
            if (!linked.isNameExplicit || linked3 == null) {
                if (linked.isVisible) {
                    throw new IllegalStateException("Conflicting/ambiguous property name definitions (implicit name " + ClassUtil.name(this._name) + "): found multiple explicit names: " + collection + ", but also implicit accessor: " + linked);
                }
            } else {
                POJOPropertyBuilder pOJOPropertyBuilder = map.get(linked3);
                if (pOJOPropertyBuilder == null) {
                    pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, this._internalName, (PropertyName)((Object)linked3));
                    map.put((PropertyName)((Object)linked3), pOJOPropertyBuilder);
                }
                if (linked2 == this._fields) {
                    linked3 = linked;
                    pOJOPropertyBuilder._fields = linked3.withNext(pOJOPropertyBuilder._fields);
                } else if (linked2 == this._getters) {
                    linked3 = linked;
                    pOJOPropertyBuilder._getters = linked3.withNext(pOJOPropertyBuilder._getters);
                } else if (linked2 == this._setters) {
                    linked3 = linked;
                    pOJOPropertyBuilder._setters = linked3.withNext(pOJOPropertyBuilder._setters);
                } else if (linked2 == this._ctorParameters) {
                    linked3 = linked;
                    pOJOPropertyBuilder._ctorParameters = linked3.withNext(pOJOPropertyBuilder._ctorParameters);
                } else {
                    throw new IllegalStateException("Internal error: mismatched accessors, property: " + this);
                }
            }
            linked = linked.next;
        }
    }

    private static Set<PropertyName> a(Linked<? extends AnnotatedMember> linked, Set<PropertyName> set) {
        while (linked != null) {
            if (linked.isNameExplicit && linked.name != null) {
                if (set == null) {
                    set = new HashSet<PropertyName>();
                }
                set.add(linked.name);
            }
            linked = linked.next;
        }
        return set;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Property '").append(this._name).append("'; ctors: ").append(this._ctorParameters).append(", field(s): ").append(this._fields).append(", getter(s): ").append(this._getters).append(", setter(s): ").append(this._setters);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected <T> T fromMemberAnnotations(a<T> a2) {
        T t2 = null;
        if (this._annotationIntrospector != null) {
            if (this._forSerialization) {
                if (this._getters != null) {
                    t2 = a2.a((AnnotatedMember)this._getters.value);
                }
            } else {
                if (this._ctorParameters != null) {
                    t2 = a2.a((AnnotatedMember)this._ctorParameters.value);
                }
                if (t2 == null && this._setters != null) {
                    t2 = a2.a((AnnotatedMember)this._setters.value);
                }
            }
            if (t2 == null && this._fields != null) {
                t2 = a2.a((AnnotatedMember)this._fields.value);
            }
        }
        return t2;
    }

    protected <T> T fromMemberAnnotationsExcept(a<T> a2, T t2) {
        T t3;
        if (this._annotationIntrospector == null) {
            return null;
        }
        if (this._forSerialization) {
            T t4;
            if (this._getters != null && (t4 = a2.a((AnnotatedMember)this._getters.value)) != null && t4 != t2) {
                return t4;
            }
            if (this._fields != null && (t4 = a2.a((AnnotatedMember)this._fields.value)) != null && t4 != t2) {
                return t4;
            }
            if (this._ctorParameters != null && (t4 = a2.a((AnnotatedMember)this._ctorParameters.value)) != null && t4 != t2) {
                return t4;
            }
            if (this._setters != null && (t4 = a2.a((AnnotatedMember)this._setters.value)) != null && t4 != t2) {
                return t4;
            }
            return null;
        }
        if (this._ctorParameters != null && (t3 = a2.a((AnnotatedMember)this._ctorParameters.value)) != null && t3 != t2) {
            return t3;
        }
        if (this._setters != null && (t3 = a2.a((AnnotatedMember)this._setters.value)) != null && t3 != t2) {
            return t3;
        }
        if (this._fields != null && (t3 = a2.a((AnnotatedMember)this._fields.value)) != null && t3 != t2) {
            return t3;
        }
        if (this._getters != null && (t3 = a2.a((AnnotatedMember)this._getters.value)) != null && t3 != t2) {
            return t3;
        }
        return null;
    }

    protected Class<?> _rawTypeOf(AnnotatedMember annotatedMember) {
        AnnotatedMethod annotatedMethod;
        if (annotatedMember instanceof AnnotatedMethod && ((AnnotatedWithParams)(annotatedMethod = (AnnotatedMethod)annotatedMember)).getParameterCount() > 0) {
            return ((ResolvedType)((AnnotatedWithParams)annotatedMethod).getParameterType(0)).getRawClass();
        }
        return ((ResolvedType)annotatedMember.getType()).getRawClass();
    }

    protected static final class Linked<T> {
        public final T value;
        public final Linked<T> next;
        public final PropertyName name;
        public final boolean isNameExplicit;
        public final boolean isVisible;
        public final boolean isMarkedIgnored;

        public Linked(T t2, Linked<T> linked, PropertyName propertyName, boolean bl2, boolean bl3, boolean bl4) {
            this.value = t2;
            this.next = linked;
            PropertyName propertyName2 = this.name = propertyName == null || propertyName.isEmpty() ? null : propertyName;
            if (bl2) {
                if (this.name == null) {
                    throw new IllegalArgumentException("Cannot pass true for 'explName' if name is null/empty");
                }
                if (!propertyName.hasSimpleName()) {
                    bl2 = false;
                }
            }
            this.isNameExplicit = bl2;
            this.isVisible = bl3;
            this.isMarkedIgnored = bl4;
        }

        public final Linked<T> withoutNext() {
            if (this.next == null) {
                return this;
            }
            return new Linked<T>(this.value, null, this.name, this.isNameExplicit, this.isVisible, this.isMarkedIgnored);
        }

        public final Linked<T> withValue(T t2) {
            if (t2 == this.value) {
                return this;
            }
            return new Linked<T>(t2, this.next, this.name, this.isNameExplicit, this.isVisible, this.isMarkedIgnored);
        }

        public final Linked<T> withNext(Linked<T> linked) {
            if (linked == this.next) {
                return this;
            }
            return new Linked<T>(this.value, linked, this.name, this.isNameExplicit, this.isVisible, this.isMarkedIgnored);
        }

        public final Linked<T> withoutIgnored() {
            Linked<T> linked;
            while (linked2.isMarkedIgnored) {
                if (linked2.next == null) {
                    return null;
                }
                Linked<T> linked2 = linked2.next;
            }
            if (linked2.next != null && (linked = linked2.next.withoutIgnored()) != linked2.next) {
                return linked2.withNext(linked);
            }
            return linked2;
        }

        public final Linked<T> withoutNonVisible() {
            Linked<T> linked;
            Linked<T> linked2 = linked = this.next == null ? null : this.next.withoutNonVisible();
            if (this.isVisible) {
                return this.withNext(linked);
            }
            return linked;
        }

        protected final Linked<T> append(Linked<T> linked) {
            if (this.next == null) {
                return this.withNext(linked);
            }
            Linked linked2 = this;
            return linked2.withNext(linked2.next.append(linked));
        }

        public final Linked<T> trimByVisibility() {
            if (this.next == null) {
                return this;
            }
            Linked<T> linked = this.next.trimByVisibility();
            if (this.name != null) {
                if (linked.name == null) {
                    return this.withNext(null);
                }
                return this.withNext(linked);
            }
            if (linked.name != null) {
                return linked;
            }
            if (this.isVisible == linked.isVisible) {
                return this.withNext(linked);
            }
            if (this.isVisible) {
                return this.withNext(null);
            }
            return linked;
        }

        public final String toString() {
            String string = String.format("%s[visible=%b,ignore=%b,explicitName=%b]", this.value.toString(), this.isVisible, this.isMarkedIgnored, this.isNameExplicit);
            if (this.next != null) {
                string = string + ", " + this.next.toString();
            }
            return string;
        }
    }

    protected static class MemberIterator<T extends AnnotatedMember>
    implements Iterator<T> {
        private Linked<T> a;

        public MemberIterator(Linked<T> linked) {
            this.a = linked;
        }

        @Override
        public boolean hasNext() {
            return this.a != null;
        }

        @Override
        public T next() {
            if (this.a == null) {
                throw new NoSuchElementException();
            }
            AnnotatedMember annotatedMember = (AnnotatedMember)this.a.value;
            this.a = this.a.next;
            return (T)annotatedMember;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface a<T> {
        public T a(AnnotatedMember var1);
    }
}

