/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class BasicPolymorphicTypeValidator
extends PolymorphicTypeValidator.Base
implements Serializable {
    protected final Set<Class<?>> _invalidBaseTypes;
    protected final TypeMatcher[] _baseTypeMatchers;
    protected final NameMatcher[] _subTypeNameMatchers;
    protected final TypeMatcher[] _subClassMatchers;

    protected BasicPolymorphicTypeValidator(Set<Class<?>> set, TypeMatcher[] typeMatcherArray, NameMatcher[] nameMatcherArray, TypeMatcher[] typeMatcherArray2) {
        this._invalidBaseTypes = set;
        this._baseTypeMatchers = typeMatcherArray;
        this._subTypeNameMatchers = nameMatcherArray;
        this._subClassMatchers = typeMatcherArray2;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PolymorphicTypeValidator.Validity validateBaseType(MapperConfig<?> mapperConfig, JavaType type) {
        type = ((ResolvedType)((Object)type)).getRawClass();
        if (this._invalidBaseTypes != null && this._invalidBaseTypes.contains(type)) {
            return PolymorphicTypeValidator.Validity.DENIED;
        }
        if (this._baseTypeMatchers != null) {
            TypeMatcher[] typeMatcherArray = this._baseTypeMatchers;
            int n2 = this._baseTypeMatchers.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                TypeMatcher typeMatcher = typeMatcherArray[i2];
                if (!typeMatcher.match(mapperConfig, (Class<?>)type)) continue;
                return PolymorphicTypeValidator.Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator.Validity.INDETERMINATE;
    }

    @Override
    public PolymorphicTypeValidator.Validity validateSubClassName(MapperConfig<?> mapperConfig, JavaType nameMatcherArray, String string) {
        if (this._subTypeNameMatchers != null) {
            nameMatcherArray = this._subTypeNameMatchers;
            int n2 = this._subTypeNameMatchers.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                NameMatcher nameMatcher = nameMatcherArray[i2];
                if (!nameMatcher.match(mapperConfig, string)) continue;
                return PolymorphicTypeValidator.Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator.Validity.INDETERMINATE;
    }

    @Override
    public PolymorphicTypeValidator.Validity validateSubType(MapperConfig<?> mapperConfig, JavaType type, JavaType typeMatcherArray) {
        if (this._subClassMatchers != null) {
            type = typeMatcherArray.getRawClass();
            typeMatcherArray = this._subClassMatchers;
            int n2 = this._subClassMatchers.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                TypeMatcher typeMatcher = typeMatcherArray[i2];
                if (!typeMatcher.match(mapperConfig, (Class<?>)type)) continue;
                return PolymorphicTypeValidator.Validity.ALLOWED;
            }
        }
        return PolymorphicTypeValidator.Validity.INDETERMINATE;
    }

    public static class Builder {
        protected Set<Class<?>> _invalidBaseTypes;
        protected List<TypeMatcher> _baseTypeMatchers;
        protected List<NameMatcher> _subTypeNameMatchers;
        protected List<TypeMatcher> _subTypeClassMatchers;

        protected Builder() {
        }

        public Builder allowIfBaseType(Class<?> clazz) {
            return this._appendBaseMatcher(new TypeMatcher(this, clazz){
                private /* synthetic */ Class a;
                private /* synthetic */ Builder b;
                {
                    this.b = builder;
                    this.a = clazz;
                }

                @Override
                public final boolean match(MapperConfig<?> mapperConfig, Class<?> clazz) {
                    return this.a.isAssignableFrom(clazz);
                }
            });
        }

        public Builder allowIfBaseType(Pattern pattern) {
            return this._appendBaseMatcher(new TypeMatcher(this, pattern){
                private /* synthetic */ Pattern a;
                private /* synthetic */ Builder b;
                {
                    this.b = builder;
                    this.a = pattern;
                }

                @Override
                public final boolean match(MapperConfig<?> mapperConfig, Class<?> clazz) {
                    return this.a.matcher(clazz.getName()).matches();
                }
            });
        }

        public Builder allowIfBaseType(String string) {
            return this._appendBaseMatcher(new TypeMatcher(this, string){
                private /* synthetic */ String a;
                private /* synthetic */ Builder b;
                {
                    this.b = builder;
                    this.a = string;
                }

                @Override
                public final boolean match(MapperConfig<?> mapperConfig, Class<?> clazz) {
                    return clazz.getName().startsWith(this.a);
                }
            });
        }

        public Builder allowIfBaseType(TypeMatcher typeMatcher) {
            return this._appendBaseMatcher(typeMatcher);
        }

        public Builder denyForExactBaseType(Class<?> clazz) {
            if (this._invalidBaseTypes == null) {
                this._invalidBaseTypes = new HashSet();
            }
            this._invalidBaseTypes.add(clazz);
            return this;
        }

        public Builder allowIfSubType(Class<?> clazz) {
            return this._appendSubClassMatcher(new TypeMatcher(this, clazz){
                private /* synthetic */ Class a;
                private /* synthetic */ Builder b;
                {
                    this.b = builder;
                    this.a = clazz;
                }

                @Override
                public final boolean match(MapperConfig<?> mapperConfig, Class<?> clazz) {
                    return this.a.isAssignableFrom(clazz);
                }
            });
        }

        public Builder allowIfSubType(Pattern pattern) {
            return this._appendSubNameMatcher(new NameMatcher(this, pattern){
                private /* synthetic */ Pattern a;
                private /* synthetic */ Builder b;
                {
                    this.b = builder;
                    this.a = pattern;
                }

                @Override
                public final boolean match(MapperConfig<?> mapperConfig, String string) {
                    return this.a.matcher(string).matches();
                }
            });
        }

        public Builder allowIfSubType(String string) {
            return this._appendSubNameMatcher(new NameMatcher(this, string){
                private /* synthetic */ String a;
                private /* synthetic */ Builder b;
                {
                    this.b = builder;
                    this.a = string;
                }

                @Override
                public final boolean match(MapperConfig<?> mapperConfig, String string) {
                    return string.startsWith(this.a);
                }
            });
        }

        public Builder allowIfSubType(TypeMatcher typeMatcher) {
            return this._appendSubClassMatcher(typeMatcher);
        }

        public Builder allowIfSubTypeIsArray() {
            return this._appendSubClassMatcher(new TypeMatcher(this){
                private /* synthetic */ Builder a;
                {
                    this.a = builder;
                }

                @Override
                public final boolean match(MapperConfig<?> mapperConfig, Class<?> clazz) {
                    return clazz.isArray();
                }
            });
        }

        public BasicPolymorphicTypeValidator build() {
            return new BasicPolymorphicTypeValidator(this._invalidBaseTypes, this._baseTypeMatchers == null ? null : this._baseTypeMatchers.toArray(new TypeMatcher[0]), this._subTypeNameMatchers == null ? null : this._subTypeNameMatchers.toArray(new NameMatcher[0]), this._subTypeClassMatchers == null ? null : this._subTypeClassMatchers.toArray(new TypeMatcher[0]));
        }

        protected Builder _appendBaseMatcher(TypeMatcher typeMatcher) {
            if (this._baseTypeMatchers == null) {
                this._baseTypeMatchers = new ArrayList<TypeMatcher>();
            }
            this._baseTypeMatchers.add(typeMatcher);
            return this;
        }

        protected Builder _appendSubNameMatcher(NameMatcher nameMatcher) {
            if (this._subTypeNameMatchers == null) {
                this._subTypeNameMatchers = new ArrayList<NameMatcher>();
            }
            this._subTypeNameMatchers.add(nameMatcher);
            return this;
        }

        protected Builder _appendSubClassMatcher(TypeMatcher typeMatcher) {
            if (this._subTypeClassMatchers == null) {
                this._subTypeClassMatchers = new ArrayList<TypeMatcher>();
            }
            this._subTypeClassMatchers.add(typeMatcher);
            return this;
        }
    }

    public static abstract class NameMatcher {
        public abstract boolean match(MapperConfig<?> var1, String var2);
    }

    public static abstract class TypeMatcher {
        public abstract boolean match(MapperConfig<?> var1, Class<?> var2);
    }
}

