/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class AsDeductionTypeDeserializer
extends AsPropertyTypeDeserializer {
    private static final BitSet a = new BitSet(0);
    private final Map<String, Integer> b;
    private final Map<BitSet, String> c;

    public AsDeductionTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, JavaType javaType2, DeserializationConfig deserializationConfig, Collection<NamedType> collection) {
        super(javaType, typeIdResolver, null, false, javaType2, null, true);
        this.b = new HashMap<String, Integer>();
        this.c = this.buildFingerprints(deserializationConfig, collection);
    }

    public AsDeductionTypeDeserializer(AsDeductionTypeDeserializer asDeductionTypeDeserializer, BeanProperty beanProperty) {
        super(asDeductionTypeDeserializer, beanProperty);
        this.b = asDeductionTypeDeserializer.b;
        this.c = asDeductionTypeDeserializer.c;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        if (beanProperty == this._property) {
            return this;
        }
        return new AsDeductionTypeDeserializer(this, beanProperty);
    }

    /*
     * WARNING - void declaration
     */
    protected Map<BitSet, String> buildFingerprints(DeserializationConfig deserializationConfig, Collection<NamedType> object) {
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        int n2 = 0;
        HashMap<BitSet, String> hashMap = new HashMap<BitSet, String>();
        object = object.iterator();
        while (object.hasNext()) {
            NamedType namedType = (NamedType)object.next();
            Object object2 = deserializationConfig.getTypeFactory().constructType(namedType.getType());
            object2 = deserializationConfig.introspect((JavaType)object2).findProperties();
            BitSet bitSet = new BitSet(n2 + object2.size());
            object2 = object2.iterator();
            while (object2.hasNext()) {
                void var10_13;
                Integer n3;
                BeanPropertyDefinition beanPropertyDefinition = (BeanPropertyDefinition)object2.next();
                String string = beanPropertyDefinition.getName();
                if (bl2) {
                    String string2 = string.toLowerCase();
                }
                if ((n3 = this.b.get(var10_13)) == null) {
                    n3 = n2++;
                    this.b.put((String)var10_13, n3);
                }
                for (PropertyName propertyName : beanPropertyDefinition.findAliases()) {
                    void var10_17;
                    String string3 = propertyName.getSimpleName();
                    if (bl2) {
                        String string4 = string3.toLowerCase();
                    }
                    if (this.b.containsKey(var10_17)) continue;
                    this.b.put((String)var10_17, n3);
                }
                bitSet.set(n3);
            }
            object2 = hashMap.put(bitSet, namedType.getType().getName());
            if (object2 == null) continue;
            throw new IllegalStateException(String.format("Subtypes %s and %s have the same signature and cannot be uniquely deduced.", object2, namedType.getType().getName()));
        }
        return hashMap;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        Object object2 = jsonParser.currentToken();
        if (object2 == JsonToken.START_OBJECT) {
            object2 = jsonParser.nextToken();
        } else if (object2 != JsonToken.FIELD_NAME) {
            return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, null, "Unexpected input");
        }
        if (object2 == JsonToken.END_OBJECT && (object = this.c.get(a)) != null) {
            return this._deserializeTypedForId(jsonParser, deserializationContext, null, (String)object);
        }
        object = new LinkedList<BitSet>(this.c.keySet());
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        boolean bl2 = ((DatabindContext)deserializationContext).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        while (object2 == JsonToken.FIELD_NAME) {
            object2 = jsonParser.currentName();
            if (bl2) {
                object2 = ((String)object2).toLowerCase();
            }
            ((JsonGenerator)tokenBuffer).copyCurrentStructure(jsonParser);
            object2 = this.b.get(object2);
            if (object2 != null) {
                int n2 = (Integer)object2;
                object2 = object;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    if (((BitSet)object2.next()).get(n2)) continue;
                    object2.remove();
                }
                if (object.size() == 1) {
                    return this._deserializeTypedForId(jsonParser, deserializationContext, tokenBuffer, this.c.get(object.get(0)));
                }
            }
            object2 = jsonParser.nextToken();
        }
        object2 = String.format("Cannot deduce unique subtype of %s (%d candidates match)", ClassUtil.getTypeDescription(this._baseType), object.size());
        return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, tokenBuffer, (String)object2);
    }
}

