/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.EnumSet;

public class ClassNameIdResolver
extends TypeIdResolverBase
implements Serializable {
    protected final PolymorphicTypeValidator _subTypeValidator;

    @Deprecated
    protected ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
        this(javaType, typeFactory, LaissezFaireSubTypeValidator.instance);
    }

    public ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
        super(javaType, typeFactory);
        this._subTypeValidator = polymorphicTypeValidator;
    }

    public static ClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new ClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), polymorphicTypeValidator);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> clazz, String string) {
    }

    @Override
    public String idFromValue(Object object) {
        Object object2 = object;
        return this._idFrom(object2, object2.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        return this._idFrom(object, clazz, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) {
        return this._typeFromId(string, databindContext);
    }

    protected JavaType _typeFromId(String string, DatabindContext databindContext) {
        JavaType javaType = databindContext.resolveAndValidateSubType(this._baseType, string, this._subTypeValidator);
        if (javaType == null && databindContext instanceof DeserializationContext) {
            return ((DeserializationContext)databindContext).handleUnknownTypeId(this._baseType, string, this, "no such class found");
        }
        return javaType;
    }

    protected String _idFrom(Object clazz, Class<?> clazz2, TypeFactory typeFactory) {
        String string;
        if (ClassUtil.isEnumType(clazz2) && !clazz2.isEnum()) {
            clazz2 = clazz2.getSuperclass();
        }
        if ((string = clazz2.getName()).startsWith("java.util.")) {
            if (clazz instanceof EnumSet) {
                clazz = ClassUtil.findEnumType((EnumSet)((Object)clazz));
                string = ((ResolvedType)typeFactory.constructCollectionType(EnumSet.class, clazz)).toCanonical();
            } else if (clazz instanceof EnumMap) {
                clazz = ClassUtil.findEnumType((EnumMap)((Object)clazz));
                clazz2 = Object.class;
                string = ((ResolvedType)typeFactory.constructMapType(EnumMap.class, clazz, clazz2)).toCanonical();
            }
        } else if (string.indexOf(36) >= 0 && (clazz = ClassUtil.getOuterClass(clazz2)) != null && ClassUtil.getOuterClass(clazz2 = ((ResolvedType)this._baseType).getRawClass()) == null) {
            clazz2 = ((ResolvedType)this._baseType).getRawClass();
            string = clazz2.getName();
        }
        return string;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

