/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.module;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleKeyDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.module.SimpleValueInstantiators;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleModule
extends Module
implements Serializable {
    private static final AtomicInteger a = new AtomicInteger(1);
    protected final String _name;
    protected final Version _version;
    protected final boolean _hasExplicitName;
    protected SimpleSerializers _serializers = null;
    protected SimpleDeserializers _deserializers = null;
    protected SimpleSerializers _keySerializers = null;
    protected SimpleKeyDeserializers _keyDeserializers = null;
    protected SimpleAbstractTypeResolver _abstractTypes = null;
    protected SimpleValueInstantiators _valueInstantiators = null;
    protected BeanDeserializerModifier _deserializerModifier = null;
    protected BeanSerializerModifier _serializerModifier = null;
    protected HashMap<Class<?>, Class<?>> _mixins = null;
    protected LinkedHashSet<NamedType> _subtypes = null;
    protected PropertyNamingStrategy _namingStrategy = null;

    public SimpleModule() {
        this._name = this.getClass() == SimpleModule.class ? "SimpleModule-" + a.getAndIncrement() : this.getClass().getName();
        this._version = Version.unknownVersion();
        this._hasExplicitName = false;
    }

    public SimpleModule(String string) {
        this(string, Version.unknownVersion());
    }

    public SimpleModule(Version version) {
        this(version.getArtifactId(), version);
    }

    public SimpleModule(String string, Version version) {
        this._name = string;
        this._version = version;
        this._hasExplicitName = true;
    }

    public SimpleModule(String string, Version version, Map<Class<?>, JsonDeserializer<?>> map) {
        this(string, version, map, null);
    }

    public SimpleModule(String string, Version version, List<JsonSerializer<?>> list) {
        this(string, version, null, list);
    }

    public SimpleModule(String string, Version version, Map<Class<?>, JsonDeserializer<?>> map, List<JsonSerializer<?>> list) {
        this._name = string;
        this._hasExplicitName = true;
        this._version = version;
        if (map != null) {
            this._deserializers = new SimpleDeserializers(map);
        }
        if (list != null) {
            this._serializers = new SimpleSerializers(list);
        }
    }

    @Override
    public Object getTypeId() {
        if (this._hasExplicitName) {
            return this._name;
        }
        if (this.getClass() == SimpleModule.class) {
            return this._name;
        }
        return super.getTypeId();
    }

    public void setSerializers(SimpleSerializers simpleSerializers) {
        this._serializers = simpleSerializers;
    }

    public void setDeserializers(SimpleDeserializers simpleDeserializers) {
        this._deserializers = simpleDeserializers;
    }

    public void setKeySerializers(SimpleSerializers simpleSerializers) {
        this._keySerializers = simpleSerializers;
    }

    public void setKeyDeserializers(SimpleKeyDeserializers simpleKeyDeserializers) {
        this._keyDeserializers = simpleKeyDeserializers;
    }

    public void setAbstractTypes(SimpleAbstractTypeResolver simpleAbstractTypeResolver) {
        this._abstractTypes = simpleAbstractTypeResolver;
    }

    public void setValueInstantiators(SimpleValueInstantiators simpleValueInstantiators) {
        this._valueInstantiators = simpleValueInstantiators;
    }

    public SimpleModule setDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        this._deserializerModifier = beanDeserializerModifier;
        return this;
    }

    public SimpleModule setSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
        this._serializerModifier = beanSerializerModifier;
        return this;
    }

    protected SimpleModule setNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this._namingStrategy = propertyNamingStrategy;
        return this;
    }

    public SimpleModule addSerializer(JsonSerializer<?> jsonSerializer) {
        this._checkNotNull(jsonSerializer, "serializer");
        if (this._serializers == null) {
            this._serializers = new SimpleSerializers();
        }
        this._serializers.addSerializer(jsonSerializer);
        return this;
    }

    public <T> SimpleModule addSerializer(Class<? extends T> clazz, JsonSerializer<T> jsonSerializer) {
        this._checkNotNull(clazz, "type to register serializer for");
        this._checkNotNull(jsonSerializer, "serializer");
        if (this._serializers == null) {
            this._serializers = new SimpleSerializers();
        }
        this._serializers.addSerializer(clazz, jsonSerializer);
        return this;
    }

    public <T> SimpleModule addKeySerializer(Class<? extends T> clazz, JsonSerializer<T> jsonSerializer) {
        this._checkNotNull(clazz, "type to register key serializer for");
        this._checkNotNull(jsonSerializer, "key serializer");
        if (this._keySerializers == null) {
            this._keySerializers = new SimpleSerializers();
        }
        this._keySerializers.addSerializer(clazz, jsonSerializer);
        return this;
    }

    public <T> SimpleModule addDeserializer(Class<T> clazz, JsonDeserializer<? extends T> jsonDeserializer) {
        this._checkNotNull(clazz, "type to register deserializer for");
        this._checkNotNull(jsonDeserializer, "deserializer");
        if (this._deserializers == null) {
            this._deserializers = new SimpleDeserializers();
        }
        this._deserializers.addDeserializer(clazz, jsonDeserializer);
        return this;
    }

    public SimpleModule addKeyDeserializer(Class<?> clazz, KeyDeserializer keyDeserializer) {
        this._checkNotNull(clazz, "type to register key deserializer for");
        this._checkNotNull(keyDeserializer, "key deserializer");
        if (this._keyDeserializers == null) {
            this._keyDeserializers = new SimpleKeyDeserializers();
        }
        this._keyDeserializers.addDeserializer(clazz, keyDeserializer);
        return this;
    }

    public <T> SimpleModule addAbstractTypeMapping(Class<T> clazz, Class<? extends T> clazz2) {
        this._checkNotNull(clazz, "abstract type to map");
        this._checkNotNull(clazz2, "concrete type to map to");
        if (this._abstractTypes == null) {
            this._abstractTypes = new SimpleAbstractTypeResolver();
        }
        this._abstractTypes = this._abstractTypes.addMapping(clazz, clazz2);
        return this;
    }

    public SimpleModule registerSubtypes(Class<?> ... classArray) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet();
        }
        for (Class<?> clazz : classArray) {
            this._checkNotNull(clazz, "subtype to register");
            this._subtypes.add(new NamedType(clazz));
        }
        return this;
    }

    public SimpleModule registerSubtypes(NamedType ... namedTypeArray) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet();
        }
        for (NamedType namedType : namedTypeArray) {
            this._checkNotNull(namedType, "subtype to register");
            this._subtypes.add(namedType);
        }
        return this;
    }

    public SimpleModule registerSubtypes(Collection<Class<?>> object) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet();
        }
        object = object.iterator();
        while (object.hasNext()) {
            Class clazz = (Class)object.next();
            this._checkNotNull(clazz, "subtype to register");
            this._subtypes.add(new NamedType(clazz));
        }
        return this;
    }

    public SimpleModule addValueInstantiator(Class<?> clazz, ValueInstantiator valueInstantiator) {
        this._checkNotNull(clazz, "class to register value instantiator for");
        this._checkNotNull(valueInstantiator, "value instantiator");
        if (this._valueInstantiators == null) {
            this._valueInstantiators = new SimpleValueInstantiators();
        }
        this._valueInstantiators = this._valueInstantiators.addValueInstantiator(clazz, valueInstantiator);
        return this;
    }

    public SimpleModule setMixInAnnotation(Class<?> clazz, Class<?> clazz2) {
        this._checkNotNull(clazz, "target type");
        this._checkNotNull(clazz2, "mixin class");
        if (this._mixins == null) {
            this._mixins = new HashMap();
        }
        this._mixins.put(clazz, clazz2);
        return this;
    }

    @Override
    public String getModuleName() {
        return this._name;
    }

    @Override
    public void setupModule(Module.SetupContext setupContext) {
        if (this._serializers != null) {
            setupContext.addSerializers(this._serializers);
        }
        if (this._deserializers != null) {
            setupContext.addDeserializers(this._deserializers);
        }
        if (this._keySerializers != null) {
            setupContext.addKeySerializers(this._keySerializers);
        }
        if (this._keyDeserializers != null) {
            setupContext.addKeyDeserializers(this._keyDeserializers);
        }
        if (this._abstractTypes != null) {
            setupContext.addAbstractTypeResolver(this._abstractTypes);
        }
        if (this._valueInstantiators != null) {
            setupContext.addValueInstantiators(this._valueInstantiators);
        }
        if (this._deserializerModifier != null) {
            setupContext.addBeanDeserializerModifier(this._deserializerModifier);
        }
        if (this._serializerModifier != null) {
            setupContext.addBeanSerializerModifier(this._serializerModifier);
        }
        if (this._subtypes != null && this._subtypes.size() > 0) {
            setupContext.registerSubtypes(this._subtypes.toArray(new NamedType[this._subtypes.size()]));
        }
        if (this._namingStrategy != null) {
            setupContext.setNamingStrategy(this._namingStrategy);
        }
        if (this._mixins != null) {
            for (Map.Entry<Class<?>, Class<?>> entry : this._mixins.entrySet()) {
                setupContext.setMixInAnnotations(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Version version() {
        return this._version;
    }

    protected void _checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Cannot pass `null` as %s", string));
        }
    }
}

