/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.module;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class SimpleSerializers
extends Serializers.Base
implements Serializable {
    protected HashMap<ClassKey, JsonSerializer<?>> _classMappings = null;
    protected HashMap<ClassKey, JsonSerializer<?>> _interfaceMappings = null;
    protected boolean _hasEnumSerializer = false;

    public SimpleSerializers() {
    }

    public SimpleSerializers(List<JsonSerializer<?>> list) {
        this.addSerializers(list);
    }

    public void addSerializer(JsonSerializer<?> jsonSerializer) {
        Class<?> clazz = jsonSerializer.handledType();
        if (clazz == null || clazz == Object.class) {
            throw new IllegalArgumentException("JsonSerializer of type " + jsonSerializer.getClass().getName() + " does not define valid handledType() -- must either register with method that takes type argument  or make serializer extend 'com.fasterxml.jackson.databind.ser.std.StdSerializer'");
        }
        this._addSerializer(clazz, jsonSerializer);
    }

    public <T> void addSerializer(Class<? extends T> clazz, JsonSerializer<T> jsonSerializer) {
        this._addSerializer(clazz, jsonSerializer);
    }

    public void addSerializers(List<JsonSerializer<?>> object) {
        object = object.iterator();
        while (object.hasNext()) {
            JsonSerializer jsonSerializer = (JsonSerializer)object.next();
            this.addSerializer(jsonSerializer);
        }
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig serializable, JavaType serializable2, BeanDescription object) {
        JsonSerializer<?> jsonSerializer;
        serializable = ((ResolvedType)((Object)serializable2)).getRawClass();
        object = new ClassKey((Class<?>)serializable);
        if (((Class)serializable).isInterface()) {
            if (this._interfaceMappings != null && (jsonSerializer = this._interfaceMappings.get(object)) != null) {
                return jsonSerializer;
            }
        } else if (this._classMappings != null) {
            jsonSerializer = this._classMappings.get(object);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            if (this._hasEnumSerializer && ((ResolvedType)((Object)serializable2)).isEnumType()) {
                ((ClassKey)object).reset(Enum.class);
                jsonSerializer = this._classMappings.get(object);
                if (jsonSerializer != null) {
                    return jsonSerializer;
                }
            }
            for (serializable2 = serializable; serializable2 != null; serializable2 = ((Class)serializable2).getSuperclass()) {
                ((ClassKey)object).reset((Class<?>)serializable2);
                jsonSerializer = this._classMappings.get(object);
                if (jsonSerializer == null) continue;
                return jsonSerializer;
            }
        }
        if (this._interfaceMappings != null) {
            jsonSerializer = this._findInterfaceMapping((Class<?>)serializable, (ClassKey)object);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            if (!((Class)serializable).isInterface()) {
                while ((serializable = ((Class)serializable).getSuperclass()) != null) {
                    jsonSerializer = this._findInterfaceMapping((Class<?>)serializable, (ClassKey)object);
                    if (jsonSerializer == null) continue;
                    return jsonSerializer;
                }
            }
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findArraySerializer(SerializationConfig serializationConfig, ArrayType arrayType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return ((Serializers.Base)this).findSerializer(serializationConfig, arrayType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return ((Serializers.Base)this).findSerializer(serializationConfig, collectionType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findCollectionLikeSerializer(SerializationConfig serializationConfig, CollectionLikeType collectionLikeType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        return ((Serializers.Base)this).findSerializer(serializationConfig, collectionLikeType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findMapSerializer(SerializationConfig serializationConfig, MapType mapType, BeanDescription beanDescription, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) {
        return ((Serializers.Base)this).findSerializer(serializationConfig, mapType, beanDescription);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig serializationConfig, MapLikeType mapLikeType, BeanDescription beanDescription, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) {
        return ((Serializers.Base)this).findSerializer(serializationConfig, mapLikeType, beanDescription);
    }

    protected JsonSerializer<?> _findInterfaceMapping(Class<?> classArray, ClassKey classKey) {
        for (Class<?> clazz : classArray.getInterfaces()) {
            classKey.reset(clazz);
            JsonSerializer<?> jsonSerializer = this._interfaceMappings.get(classKey);
            if (jsonSerializer != null) {
                return jsonSerializer;
            }
            jsonSerializer = this._findInterfaceMapping(clazz, classKey);
            if (jsonSerializer == null) continue;
            return jsonSerializer;
        }
        return null;
    }

    protected void _addSerializer(Class<?> clazz, JsonSerializer<?> jsonSerializer) {
        ClassKey classKey = new ClassKey(clazz);
        if (clazz.isInterface()) {
            if (this._interfaceMappings == null) {
                this._interfaceMappings = new HashMap();
            }
            this._interfaceMappings.put(classKey, jsonSerializer);
            return;
        }
        if (this._classMappings == null) {
            this._classMappings = new HashMap();
        }
        this._classMappings.put(classKey, jsonSerializer);
        if (clazz == Enum.class) {
            this._hasEnumSerializer = true;
        }
    }
}

