/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.NumericNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalNode
extends NumericNode {
    public static final DecimalNode ZERO = new DecimalNode(BigDecimal.ZERO);
    private static final BigDecimal a = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal b = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal c = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal d = BigDecimal.valueOf(Long.MAX_VALUE);
    protected final BigDecimal _value;

    public DecimalNode(BigDecimal bigDecimal) {
        this._value = bigDecimal;
    }

    public static DecimalNode valueOf(BigDecimal bigDecimal) {
        return new DecimalNode(bigDecimal);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.BIG_DECIMAL;
    }

    @Override
    public boolean isFloatingPointNumber() {
        return true;
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public boolean canConvertToInt() {
        return this._value.compareTo(a) >= 0 && this._value.compareTo(b) <= 0;
    }

    @Override
    public boolean canConvertToLong() {
        return this._value.compareTo(c) >= 0 && this._value.compareTo(d) <= 0;
    }

    @Override
    public boolean canConvertToExactIntegral() {
        return this._value.signum() == 0 || this._value.scale() <= 0 || this._value.stripTrailingZeros().scale() <= 0;
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        return this._value.shortValue();
    }

    @Override
    public int intValue() {
        return this._value.intValue();
    }

    @Override
    public long longValue() {
        return this._value.longValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        DecimalNode decimalNode = this;
        return decimalNode._bigIntFromBigDec(decimalNode._value);
    }

    @Override
    public float floatValue() {
        return this._value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this._value.doubleValue();
    }

    @Override
    public BigDecimal decimalValue() {
        return this._value;
    }

    @Override
    public String asText() {
        return this._value.toString();
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof DecimalNode) {
            object = (DecimalNode)object;
            if (((DecimalNode)object)._value == null) {
                return this._value == null;
            }
            if (this._value == null) {
                return false;
            }
            return ((DecimalNode)object)._value.compareTo(this._value) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this._value == null) {
            return 0;
        }
        return Double.hashCode(((JsonNode)this).doubleValue());
    }
}

