/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BasicSerializerFactory;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.PropertyBuilder;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.FilteredBeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.ser.impl.UnsupportedTypeSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.ser.std.ToEmptyObjectSerializer;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.NativeImageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BeanSerializerFactory
extends BasicSerializerFactory
implements Serializable {
    public static final BeanSerializerFactory instance = new BeanSerializerFactory(null);

    protected BeanSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        super(serializerFactoryConfig);
    }

    @Override
    public SerializerFactory withConfig(SerializerFactoryConfig serializerFactoryConfig) {
        if (this._factoryConfig == serializerFactoryConfig) {
            return this;
        }
        if (this.getClass() != BeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': cannot instantiate subtype with additional serializer definitions");
        }
        return new BeanSerializerFactory(serializerFactoryConfig);
    }

    @Override
    protected Iterable<Serializers> customSerializers() {
        return this._factoryConfig.serializers();
    }

    @Override
    public JsonSerializer<Object> createSerializer(SerializerProvider serializerProvider, JavaType object) {
        boolean bl2;
        JavaType javaType;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        BeanDescription beanDescription = serializationConfig.introspect((JavaType)object);
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, beanDescription.getClassInfo());
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            javaType = object;
        } else {
            try {
                javaType = annotationIntrospector.refineSerializationType(serializationConfig, beanDescription.getClassInfo(), (JavaType)object);
            }
            catch (JsonMappingException jsonMappingException) {
                return (JsonSerializer)serializerProvider.reportBadTypeDefinition(beanDescription, ((JsonProcessingException)jsonMappingException).getMessage(), new Object[0]);
            }
        }
        if (javaType == object) {
            bl2 = false;
        } else {
            bl2 = true;
            if (!((ResolvedType)javaType).hasRawClass(((ResolvedType)object).getRawClass())) {
                beanDescription = serializationConfig.introspect(javaType);
            }
        }
        object = beanDescription.findSerializationConverter();
        if (object == null) {
            return this._createSerializer2(serializerProvider, javaType, beanDescription, bl2);
        }
        JavaType javaType2 = object.getOutputType(((DatabindContext)serializerProvider).getTypeFactory());
        if (!((ResolvedType)javaType2).hasRawClass(((ResolvedType)javaType).getRawClass())) {
            beanDescription = serializationConfig.introspect(javaType2);
            jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, beanDescription.getClassInfo());
        }
        if (jsonSerializer == null && !javaType2.isJavaLangObject()) {
            jsonSerializer = this._createSerializer2(serializerProvider, javaType2, beanDescription, true);
        }
        return new StdDelegatingSerializer((Converter<Object, ?>)object, javaType2, jsonSerializer);
    }

    protected JsonSerializer<?> _createSerializer2(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl2) {
        JsonSerializer<Object> jsonSerializer = null;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        if (((ResolvedType)javaType).isContainerType()) {
            if (!bl2) {
                bl2 = this.usesStaticTyping(serializationConfig, beanDescription);
            }
            if ((jsonSerializer = this.buildContainerSerializer(serializerProvider, javaType, beanDescription, bl2)) != null) {
                return jsonSerializer;
            }
        } else {
            if (javaType.isReferenceType()) {
                jsonSerializer = this.findReferenceSerializer(serializerProvider, (ReferenceType)javaType, beanDescription, bl2);
            } else {
                Serializers object;
                Iterator<Object> iterator = this.customSerializers().iterator();
                while (iterator.hasNext() && (jsonSerializer = (object = iterator.next()).findSerializer(serializationConfig, javaType, beanDescription)) == null) {
                }
            }
            if (jsonSerializer == null) {
                jsonSerializer = this.findSerializerByAnnotations(serializerProvider, javaType, beanDescription);
            }
        }
        if (jsonSerializer == null && (jsonSerializer = this.findSerializerByLookup(javaType, serializationConfig, beanDescription, bl2)) == null && (jsonSerializer = this.findSerializerByPrimaryType(serializerProvider, javaType, beanDescription, bl2)) == null && (jsonSerializer = this.findBeanOrAddOnSerializer(serializerProvider, javaType, beanDescription, bl2)) == null) {
            jsonSerializer = serializerProvider.getUnknownTypeSerializer(beanDescription.getBeanClass());
        }
        if (jsonSerializer != null && this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                jsonSerializer = beanSerializerModifier.modifySerializer(serializationConfig, beanDescription, jsonSerializer);
            }
        }
        return jsonSerializer;
    }

    @Deprecated
    public JsonSerializer<Object> findBeanSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) {
        return this.findBeanOrAddOnSerializer(serializerProvider, javaType, beanDescription, ((DatabindContext)serializerProvider).isEnabled(MapperFeature.USE_STATIC_TYPING));
    }

    public JsonSerializer<Object> findBeanOrAddOnSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl2) {
        if (!this.isPotentialBeanType(((ResolvedType)javaType).getRawClass()) && !ClassUtil.isEnumType(((ResolvedType)javaType).getRawClass())) {
            return null;
        }
        return this.constructBeanOrAddOnSerializer(serializerProvider, javaType, beanDescription, bl2);
    }

    public TypeSerializer findPropertyTypeSerializer(JavaType object, SerializationConfig serializationConfig, AnnotatedMember object2) {
        Object object3 = serializationConfig.getAnnotationIntrospector();
        if ((object3 = ((AnnotationIntrospector)object3).findPropertyTypeResolver(serializationConfig, (AnnotatedMember)object2, (JavaType)object)) == null) {
            object = ((SerializerFactory)this).createTypeSerializer(serializationConfig, (JavaType)object);
        } else {
            object2 = ((MapperConfig)serializationConfig).getSubtypeResolver().collectAndResolveSubtypesByClass(serializationConfig, (AnnotatedMember)object2, (JavaType)object);
            object = object3.buildTypeSerializer(serializationConfig, (JavaType)object, (Collection<NamedType>)object2);
        }
        return object;
    }

    public TypeSerializer findPropertyContentTypeSerializer(JavaType typeResolverBuilder, SerializationConfig serializationConfig, AnnotatedMember object) {
        JavaType javaType = ((JavaType)((Object)typeResolverBuilder)).getContentType();
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        typeResolverBuilder = annotationIntrospector.findPropertyContentTypeResolver(serializationConfig, (AnnotatedMember)object, (JavaType)((Object)typeResolverBuilder));
        if (typeResolverBuilder == null) {
            typeResolverBuilder = ((SerializerFactory)this).createTypeSerializer(serializationConfig, javaType);
        } else {
            object = ((MapperConfig)serializationConfig).getSubtypeResolver().collectAndResolveSubtypesByClass(serializationConfig, (AnnotatedMember)object, javaType);
            typeResolverBuilder = typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType, (Collection<NamedType>)object);
        }
        return typeResolverBuilder;
    }

    @Deprecated
    protected JsonSerializer<Object> constructBeanSerializer(SerializerProvider serializerProvider, BeanDescription beanDescription) {
        return this.constructBeanOrAddOnSerializer(serializerProvider, beanDescription.getType(), beanDescription, ((DatabindContext)serializerProvider).isEnabled(MapperFeature.USE_STATIC_TYPING));
    }

    /*
     * WARNING - void declaration
     */
    protected JsonSerializer<Object> constructBeanOrAddOnSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl2) {
        void var5_23;
        JsonSerializer<?> jsonSerializer;
        void var5_14;
        void var5_10;
        void var5_9;
        if (beanDescription.getBeanClass() == Object.class) {
            return serializerProvider.getUnknownTypeSerializer(Object.class);
        }
        JsonSerializer<Object> jsonSerializer2 = this._findUnsupportedTypeSerializer(serializerProvider, javaType, beanDescription);
        if (jsonSerializer2 != null) {
            return jsonSerializer2;
        }
        if (this._isUnserializableJacksonType(serializerProvider, javaType)) {
            return new ToEmptyObjectSerializer(javaType);
        }
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        BeanSerializerBuilder beanSerializerBuilder = this.constructBeanSerializerBuilder(beanDescription);
        beanSerializerBuilder.setConfig(serializationConfig);
        List<BeanPropertyWriter> list = this.findBeanProperties(serializerProvider, beanDescription, beanSerializerBuilder);
        if (list == null) {
            ArrayList arrayList = new ArrayList();
        } else {
            List<BeanPropertyWriter> list2 = this.removeOverlappingTypeIds(serializerProvider, beanDescription, beanSerializerBuilder, list);
        }
        ((DatabindContext)serializerProvider).getAnnotationIntrospector().findAndAddVirtualProperties(serializationConfig, beanDescription.getClassInfo(), (List<BeanPropertyWriter>)var5_9);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                List<BeanPropertyWriter> list3 = beanSerializerModifier.changeProperties(serializationConfig, beanDescription, (List<BeanPropertyWriter>)var5_10);
            }
        }
        List<BeanPropertyWriter> list5 = this.filterUnwantedJDKProperties(serializationConfig, beanDescription, (List<BeanPropertyWriter>)var5_10);
        list5 = this.filterBeanProperties(serializationConfig, beanDescription, list5);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                List<BeanPropertyWriter> list6 = beanSerializerModifier.orderProperties(serializationConfig, beanDescription, (List<BeanPropertyWriter>)var5_14);
            }
        }
        beanSerializerBuilder.setObjectIdWriter(this.constructObjectIdHandler(serializerProvider, beanDescription, (List<BeanPropertyWriter>)var5_14));
        beanSerializerBuilder.setProperties((List<BeanPropertyWriter>)var5_14);
        beanSerializerBuilder.setFilterId(this.findFilterId(serializationConfig, beanDescription));
        AnnotatedMember annotatedMember = beanDescription.findAnyGetter();
        if (annotatedMember != null) {
            JavaType javaType2 = annotatedMember.getType();
            JavaType javaType3 = javaType2.getContentType();
            TypeSerializer typeSerializer = ((SerializerFactory)this).createTypeSerializer(serializationConfig, javaType3);
            MapSerializer mapSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMember);
            if (mapSerializer == null) {
                mapSerializer = MapSerializer.construct(null, javaType2, serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING), typeSerializer, null, null, null);
            }
            PropertyName propertyName = PropertyName.construct(annotatedMember.getName());
            BeanProperty.Std std = new BeanProperty.Std(propertyName, javaType3, null, annotatedMember, PropertyMetadata.STD_OPTIONAL);
            beanSerializerBuilder.setAnyGetter(new AnyGetterWriter(std, annotatedMember, mapSerializer));
        }
        this.processViews(serializationConfig, beanSerializerBuilder);
        if (this._factoryConfig.hasSerializerModifiers()) {
            for (BeanSerializerModifier beanSerializerModifier : this._factoryConfig.serializerModifiers()) {
                beanSerializerBuilder = beanSerializerModifier.updateBuilder(serializationConfig, beanDescription, beanSerializerBuilder);
            }
        }
        try {
            jsonSerializer = beanSerializerBuilder.build();
        }
        catch (RuntimeException runtimeException) {
            return (JsonSerializer)serializerProvider.reportBadTypeDefinition(beanDescription, "Failed to construct BeanSerializer for %s: (%s) %s", beanDescription.getType(), runtimeException.getClass().getName(), runtimeException.getMessage());
        }
        if (jsonSerializer == null) {
            if (javaType.isRecordType() && !NativeImageUtil.needsReflectionConfiguration(((ResolvedType)javaType).getRawClass())) {
                return beanSerializerBuilder.createDummy();
            }
            JsonSerializer<?> jsonSerializer3 = this.findSerializerByAddonType(serializationConfig, javaType, beanDescription, bl2);
            if (jsonSerializer3 == null && beanDescription.hasKnownClassAnnotations()) {
                return beanSerializerBuilder.createDummy();
            }
        }
        return var5_23;
    }

    protected ObjectIdWriter constructObjectIdHandler(SerializerProvider object, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
        ObjectIdInfo objectIdInfo = beanDescription.getObjectIdInfo();
        if (objectIdInfo == null) {
            return null;
        }
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
            clazz = objectIdInfo.getPropertyName().getSimpleName();
            int n2 = 0;
            int n3 = list.size();
            while (true) {
                if (n2 == n3) {
                    throw new IllegalArgumentException(String.format("Invalid Object Id definition for %s: cannot find property with name %s", ClassUtil.getTypeDescription(beanDescription.getType()), ClassUtil.name((String)((Object)clazz))));
                }
                BeanPropertyWriter beanPropertyWriter = list.get(n2);
                if (((String)((Object)clazz)).equals(((PropertyWriter)beanPropertyWriter).getName())) {
                    clazz = beanPropertyWriter;
                    if (n2 <= 0) break;
                    list.remove(n2);
                    list.add(0, (BeanPropertyWriter)((Object)clazz));
                    break;
                }
                ++n2;
            }
            JavaType javaType = ((BeanPropertyWriter)((Object)clazz)).getType();
            PropertyBasedObjectIdGenerator propertyBasedObjectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo, (BeanPropertyWriter)((Object)clazz));
            return ObjectIdWriter.construct(javaType, null, propertyBasedObjectIdGenerator, objectIdInfo.getAlwaysAsId());
        }
        clazz = ((DatabindContext)object).constructType(clazz);
        clazz = ((DatabindContext)object).getTypeFactory().findTypeParameters((JavaType)((Object)clazz), ObjectIdGenerator.class)[0];
        object = ((DatabindContext)object).objectIdGeneratorInstance(beanDescription.getClassInfo(), objectIdInfo);
        return ObjectIdWriter.construct((JavaType)((Object)clazz), objectIdInfo.getPropertyName(), object, objectIdInfo.getAlwaysAsId());
    }

    protected BeanPropertyWriter constructFilteredBeanWriter(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
        return FilteredBeanPropertyWriter.constructViewBased(beanPropertyWriter, classArray);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        return new PropertyBuilder(serializationConfig, beanDescription);
    }

    protected BeanSerializerBuilder constructBeanSerializerBuilder(BeanDescription beanDescription) {
        return new BeanSerializerBuilder(beanDescription);
    }

    protected boolean isPotentialBeanType(Class<?> clazz) {
        return ClassUtil.canBeABeanType(clazz) == null && !ClassUtil.isProxyType(clazz);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializerProvider serializerProvider, BeanDescription object, BeanSerializerBuilder beanSerializerBuilder) {
        Object object2 = ((BeanDescription)object).findProperties();
        Serializable serializable = serializerProvider.getConfig();
        this.removeIgnorableTypes((SerializationConfig)serializable, (BeanDescription)object, (List<BeanPropertyDefinition>)object2);
        if (((MapperConfig)serializable).isEnabled(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS)) {
            this.removeSetterlessGetters((SerializationConfig)serializable, (BeanDescription)object, (List<BeanPropertyDefinition>)object2);
        }
        if (object2.isEmpty()) {
            return null;
        }
        boolean bl2 = this.usesStaticTyping((SerializationConfig)serializable, (BeanDescription)object);
        object = this.constructPropertyBuilder((SerializationConfig)serializable, (BeanDescription)object);
        serializable = new ArrayList(object2.size());
        object2 = object2.iterator();
        while (object2.hasNext()) {
            BeanPropertyDefinition beanPropertyDefinition = (BeanPropertyDefinition)object2.next();
            AnnotatedMember annotatedMember = beanPropertyDefinition.getAccessor();
            if (beanPropertyDefinition.isTypeId()) {
                if (annotatedMember == null) continue;
                beanSerializerBuilder.setTypeId(annotatedMember);
                continue;
            }
            AnnotationIntrospector.ReferenceProperty referenceProperty = beanPropertyDefinition.findReferenceType();
            if (referenceProperty != null && referenceProperty.isBackReference()) continue;
            if (annotatedMember instanceof AnnotatedMethod) {
                ((ArrayList)serializable).add(this._constructWriter(serializerProvider, beanPropertyDefinition, (PropertyBuilder)object, bl2, (AnnotatedMethod)annotatedMember));
                continue;
            }
            ((ArrayList)serializable).add(this._constructWriter(serializerProvider, beanPropertyDefinition, (PropertyBuilder)object, bl2, (AnnotatedField)annotatedMember));
        }
        return serializable;
    }

    protected List<BeanPropertyWriter> filterBeanProperties(SerializationConfig object, BeanDescription object2, List<BeanPropertyWriter> list) {
        JsonIgnoreProperties.Value value = ((MapperConfig)object).getDefaultPropertyIgnorals(((BeanDescription)object2).getBeanClass(), ((BeanDescription)object2).getClassInfo());
        Set<String> set = null;
        if (value != null) {
            set = value.findIgnoredForSerialization();
        }
        object = ((MapperConfig)object).getDefaultPropertyInclusions(((BeanDescription)object2).getBeanClass(), ((BeanDescription)object2).getClassInfo());
        object2 = null;
        if (object != null) {
            object2 = ((JsonIncludeProperties.Value)object).getIncluded();
        }
        if (object2 != null || set != null && !set.isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                if (!IgnorePropertiesUtil.shouldIgnore(((PropertyWriter)((BeanPropertyWriter)object.next())).getName(), set, (Collection<String>)object2)) continue;
                object.remove();
            }
        }
        return list;
    }

    protected List<BeanPropertyWriter> filterUnwantedJDKProperties(SerializationConfig serializable, BeanDescription beanDescription, List<BeanPropertyWriter> list) {
        if (beanDescription.getType().isTypeOrSubTypeOf(CharSequence.class) && list.size() == 1) {
            serializable = list.get(0);
            if ((serializable = ((BeanPropertyWriter)serializable).getMember()) instanceof AnnotatedMethod && "isEmpty".equals(((Annotated)((Object)serializable)).getName()) && ((AnnotatedMember)serializable).getDeclaringClass() == CharSequence.class) {
                list.remove(0);
            }
        }
        return list;
    }

    protected void processViews(SerializationConfig serializationConfig, BeanSerializerBuilder beanSerializerBuilder) {
        List<BeanPropertyWriter> list = beanSerializerBuilder.getProperties();
        boolean bl2 = serializationConfig.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        int n2 = list.size();
        int n3 = 0;
        BeanPropertyWriter[] beanPropertyWriterArray = new BeanPropertyWriter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanPropertyWriter beanPropertyWriter = list.get(i2);
            Class<?>[] classArray = beanPropertyWriter.getViews();
            if (classArray == null || classArray.length == 0) {
                if (!bl2) continue;
                beanPropertyWriterArray[i2] = beanPropertyWriter;
                continue;
            }
            ++n3;
            beanPropertyWriterArray[i2] = this.constructFilteredBeanWriter(beanPropertyWriter, classArray);
        }
        if (bl2 && n3 == 0) {
            return;
        }
        beanSerializerBuilder.setFilteredProperties(beanPropertyWriterArray);
    }

    protected void removeIgnorableTypes(SerializationConfig serializationConfig, BeanDescription object, List<BeanPropertyDefinition> object2) {
        object = serializationConfig.getAnnotationIntrospector();
        HashMap<Object, Serializable> hashMap = new HashMap<Object, Serializable>();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = (BeanPropertyDefinition)object2.next();
            Object object4 = ((BeanPropertyDefinition)object3).getAccessor();
            if (object4 == null) {
                object2.remove();
                continue;
            }
            object4 = (Boolean)hashMap.get(object3 = ((BeanPropertyDefinition)object3).getRawPrimaryType());
            if (object4 == null) {
                object4 = ((MapperConfig)serializationConfig).getConfigOverride((Class<?>)object3).getIsIgnoredType();
                if (object4 == null) {
                    object4 = serializationConfig.introspectClassAnnotations((Class<?>)object3);
                    object4 = ((BeanDescription)object4).getClassInfo();
                    if ((object4 = ((AnnotationIntrospector)object).isIgnorableType((AnnotatedClass)object4)) == null) {
                        object4 = Boolean.FALSE;
                    }
                }
                hashMap.put(object3, (Serializable)object4);
            }
            if (!((Boolean)object4).booleanValue()) continue;
            object2.remove();
        }
    }

    protected void removeSetterlessGetters(SerializationConfig serializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list) {
        list.removeIf(beanPropertyDefinition -> !beanPropertyDefinition.couldDeserialize() && !beanPropertyDefinition.isExplicitlyIncluded());
    }

    protected List<BeanPropertyWriter> removeOverlappingTypeIds(SerializerProvider serializerProvider, BeanDescription beanDescription, BeanSerializerBuilder object, List<BeanPropertyWriter> list) {
        int n2 = list.size();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            object = list.get(i2);
            Object object2 = ((BeanPropertyWriter)object).getTypeSerializer();
            if (object2 == null || ((TypeSerializer)object2).getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
            object2 = ((TypeSerializer)object2).getPropertyName();
            object2 = PropertyName.construct((String)object2);
            for (BeanPropertyWriter beanPropertyWriter : list) {
                if (beanPropertyWriter == object || !beanPropertyWriter.wouldConflictWithName((PropertyName)object2)) continue;
                ((BeanPropertyWriter)object).assignTypeSerializer(null);
                continue block0;
            }
        }
        return list;
    }

    protected BeanPropertyWriter _constructWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, PropertyBuilder propertyBuilder, boolean bl2, AnnotatedMember annotatedMember) {
        Object object = beanPropertyDefinition.getFullName();
        JavaType javaType = annotatedMember.getType();
        object = new BeanProperty.Std((PropertyName)object, javaType, beanPropertyDefinition.getWrapperName(), annotatedMember, beanPropertyDefinition.getMetadata());
        JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMember);
        if (jsonSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
        }
        jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, (BeanProperty)object);
        object = null;
        if (((ResolvedType)javaType).isContainerType() || javaType.isReferenceType()) {
            object = this.findPropertyContentTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        }
        TypeSerializer typeSerializer = this.findPropertyTypeSerializer(javaType, serializerProvider.getConfig(), annotatedMember);
        return propertyBuilder.buildWriter(serializerProvider, beanPropertyDefinition, javaType, jsonSerializer, typeSerializer, (TypeSerializer)object, annotatedMember, bl2);
    }

    protected JsonSerializer<?> _findUnsupportedTypeSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription object) {
        object = BeanUtil.checkUnsupportedType(javaType);
        if (object != null && serializerProvider.getConfig().findMixInClassFor(((ResolvedType)javaType).getRawClass()) == null) {
            return new UnsupportedTypeSerializer(javaType, (String)object);
        }
        return null;
    }

    protected boolean _isUnserializableJacksonType(SerializerProvider clazz, JavaType javaType) {
        clazz = ((ResolvedType)javaType).getRawClass();
        return ObjectMapper.class.isAssignableFrom(clazz) || ObjectReader.class.isAssignableFrom(clazz) || ObjectWriter.class.isAssignableFrom(clazz) || DatabindContext.class.isAssignableFrom(clazz) || TokenStreamFactory.class.isAssignableFrom(clazz) || JsonParser.class.isAssignableFrom(clazz) || JsonGenerator.class.isAssignableFrom(clazz);
    }
}

