/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.LookupCache;
import com.fasterxml.jackson.databind.util.TypeKey;
import java.util.concurrent.atomic.AtomicReference;

public final class SerializerCache {
    public static final int DEFAULT_MAX_CACHE_SIZE = 4000;
    @Deprecated
    public static final int DEFAULT_MAX_CACHED = 4000;
    private final LookupCache<TypeKey, JsonSerializer<Object>> a;
    private final AtomicReference<ReadOnlyClassToSerializerMap> b = new AtomicReference();

    public SerializerCache() {
        this(4000);
    }

    public SerializerCache(int n2) {
        int n3 = Math.min(64, n2 >> 2);
        this.a = new LRUMap<TypeKey, JsonSerializer<Object>>(n3, n2);
    }

    public SerializerCache(LookupCache<TypeKey, JsonSerializer<Object>> lookupCache) {
        this.a = lookupCache;
    }

    public final ReadOnlyClassToSerializerMap getReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap readOnlyClassToSerializerMap = this.b.get();
        if (readOnlyClassToSerializerMap != null) {
            return readOnlyClassToSerializerMap;
        }
        return this.a();
    }

    private final synchronized ReadOnlyClassToSerializerMap a() {
        ReadOnlyClassToSerializerMap readOnlyClassToSerializerMap = this.b.get();
        if (readOnlyClassToSerializerMap == null) {
            readOnlyClassToSerializerMap = ReadOnlyClassToSerializerMap.from(this.a);
            this.b.set(readOnlyClassToSerializerMap);
        }
        return readOnlyClassToSerializerMap;
    }

    public final synchronized int size() {
        return this.a.size();
    }

    public final JsonSerializer<Object> untypedValueSerializer(Class<?> clazz) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this.a.get(new TypeKey(clazz, false));
        }
    }

    public final JsonSerializer<Object> untypedValueSerializer(JavaType javaType) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this.a.get(new TypeKey(javaType, false));
        }
    }

    public final JsonSerializer<Object> typedValueSerializer(JavaType javaType) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this.a.get(new TypeKey(javaType, true));
        }
    }

    public final JsonSerializer<Object> typedValueSerializer(Class<?> clazz) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this.a.get(new TypeKey(clazz, true));
        }
    }

    public final void addTypedSerializer(JavaType javaType, JsonSerializer<Object> jsonSerializer) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this.a.put(new TypeKey(javaType, true), jsonSerializer) == null) {
                this.b.set(null);
            }
            return;
        }
    }

    public final void addTypedSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this.a.put(new TypeKey(clazz, true), jsonSerializer) == null) {
                this.b.set(null);
            }
            return;
        }
    }

    public final void addAndResolveNonTypedSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this.a.put(new TypeKey(clazz, false), jsonSerializer) == null) {
                this.b.set(null);
            }
            if (jsonSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
            }
            return;
        }
    }

    public final void addAndResolveNonTypedSerializer(JavaType javaType, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this.a.put(new TypeKey(javaType, false), jsonSerializer) == null) {
                this.b.set(null);
            }
            if (jsonSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
            }
            return;
        }
    }

    public final void addAndResolveNonTypedSerializer(Class<?> object, JavaType object2, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            object = this.a.put(new TypeKey((Class<?>)object, false), jsonSerializer);
            object2 = this.a.put(new TypeKey((JavaType)object2, false), jsonSerializer);
            if (object == null || object2 == null) {
                this.b.set(null);
            }
            if (jsonSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
            }
            return;
        }
    }

    public final synchronized void flush() {
        this.a.clear();
        this.b.set(null);
    }
}

