/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SimpleBeanPropertyFilter
implements BeanPropertyFilter,
PropertyFilter {
    protected SimpleBeanPropertyFilter() {
    }

    public static SimpleBeanPropertyFilter serializeAll() {
        return SerializeExceptFilter.a;
    }

    public static SimpleBeanPropertyFilter filterOutAll() {
        return FilterExceptFilter.a;
    }

    @Deprecated
    public static SimpleBeanPropertyFilter serializeAll(Set<String> set) {
        return new FilterExceptFilter(set);
    }

    public static SimpleBeanPropertyFilter filterOutAllExcept(Set<String> set) {
        return new FilterExceptFilter(set);
    }

    public static SimpleBeanPropertyFilter filterOutAllExcept(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        return new FilterExceptFilter(hashSet);
    }

    public static SimpleBeanPropertyFilter serializeAllExcept(Set<String> set) {
        return new SerializeExceptFilter(set);
    }

    public static SimpleBeanPropertyFilter serializeAllExcept(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        return new SerializeExceptFilter(hashSet);
    }

    public static PropertyFilter from(BeanPropertyFilter beanPropertyFilter) {
        return new PropertyFilter(beanPropertyFilter){
            private /* synthetic */ BeanPropertyFilter a;
            {
                this.a = beanPropertyFilter;
            }

            @Override
            public final void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyWriter propertyWriter) {
                this.a.serializeAsField(object, jsonGenerator, serializerProvider, (BeanPropertyWriter)propertyWriter);
            }

            @Override
            public final void depositSchemaProperty(PropertyWriter propertyWriter, ObjectNode objectNode, SerializerProvider serializerProvider) {
                this.a.depositSchemaProperty((BeanPropertyWriter)propertyWriter, objectNode, serializerProvider);
            }

            @Override
            public final void depositSchemaProperty(PropertyWriter propertyWriter, JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
                this.a.depositSchemaProperty((BeanPropertyWriter)propertyWriter, jsonObjectFormatVisitor, serializerProvider);
            }

            @Override
            public final void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyWriter propertyWriter) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected boolean include(BeanPropertyWriter beanPropertyWriter) {
        return true;
    }

    protected boolean include(PropertyWriter propertyWriter) {
        return true;
    }

    protected boolean includeElement(Object object) {
        return true;
    }

    @Override
    @Deprecated
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, BeanPropertyWriter beanPropertyWriter) {
        if (this.include(beanPropertyWriter)) {
            ((PropertyWriter)beanPropertyWriter).serializeAsField(object, jsonGenerator, serializerProvider);
            return;
        }
        if (!jsonGenerator.canOmitFields()) {
            ((PropertyWriter)beanPropertyWriter).serializeAsOmittedField(object, jsonGenerator, serializerProvider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(BeanPropertyWriter beanPropertyWriter, ObjectNode objectNode, SerializerProvider serializerProvider) {
        if (this.include(beanPropertyWriter)) {
            ((PropertyWriter)beanPropertyWriter).depositSchemaProperty(objectNode, serializerProvider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(BeanPropertyWriter beanPropertyWriter, JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
        if (this.include(beanPropertyWriter)) {
            ((PropertyWriter)beanPropertyWriter).depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
        }
    }

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyWriter propertyWriter) {
        if (this.include(propertyWriter)) {
            propertyWriter.serializeAsField(object, jsonGenerator, serializerProvider);
            return;
        }
        if (!jsonGenerator.canOmitFields()) {
            propertyWriter.serializeAsOmittedField(object, jsonGenerator, serializerProvider);
        }
    }

    @Override
    public void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, PropertyWriter propertyWriter) {
        if (this.includeElement(object)) {
            propertyWriter.serializeAsElement(object, jsonGenerator, serializerProvider);
        }
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(PropertyWriter propertyWriter, ObjectNode objectNode, SerializerProvider serializerProvider) {
        if (this.include(propertyWriter)) {
            propertyWriter.depositSchemaProperty(objectNode, serializerProvider);
        }
    }

    @Override
    public void depositSchemaProperty(PropertyWriter propertyWriter, JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
        if (this.include(propertyWriter)) {
            propertyWriter.depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
        }
    }

    public static class SerializeExceptFilter
    extends SimpleBeanPropertyFilter
    implements Serializable {
        static final SerializeExceptFilter a = new SerializeExceptFilter(Collections.emptySet());
        protected final Set<String> _propertiesToExclude;

        public SerializeExceptFilter(Set<String> set) {
            this._propertiesToExclude = set;
        }

        @Override
        protected boolean include(BeanPropertyWriter beanPropertyWriter) {
            return !this._propertiesToExclude.contains(((PropertyWriter)beanPropertyWriter).getName());
        }

        @Override
        protected boolean include(PropertyWriter propertyWriter) {
            return !this._propertiesToExclude.contains(propertyWriter.getName());
        }
    }

    public static class FilterExceptFilter
    extends SimpleBeanPropertyFilter
    implements Serializable {
        static final FilterExceptFilter a = new FilterExceptFilter(Collections.emptySet());
        protected final Set<String> _propertiesToInclude;

        public FilterExceptFilter(Set<String> set) {
            this._propertiesToInclude = set;
        }

        @Override
        protected boolean include(BeanPropertyWriter beanPropertyWriter) {
            return this._propertiesToInclude.contains(((PropertyWriter)beanPropertyWriter).getName());
        }

        @Override
        protected boolean include(PropertyWriter propertyWriter) {
            return this._propertiesToInclude.contains(propertyWriter.getName());
        }
    }
}

