/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.UnwrappingBeanSerializer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.util.Map;

public class UnwrappingBeanPropertyWriter
extends BeanPropertyWriter
implements Serializable {
    protected final NameTransformer _nameTransformer;

    public UnwrappingBeanPropertyWriter(BeanPropertyWriter beanPropertyWriter, NameTransformer nameTransformer) {
        super(beanPropertyWriter);
        this._nameTransformer = nameTransformer;
    }

    protected UnwrappingBeanPropertyWriter(UnwrappingBeanPropertyWriter unwrappingBeanPropertyWriter, NameTransformer nameTransformer, SerializedString serializedString) {
        super((BeanPropertyWriter)unwrappingBeanPropertyWriter, serializedString);
        this._nameTransformer = nameTransformer;
    }

    @Override
    public UnwrappingBeanPropertyWriter rename(NameTransformer nameTransformer) {
        String string = this._name.getValue();
        string = nameTransformer.transform(string);
        nameTransformer = NameTransformer.chainedTransformer(nameTransformer, this._nameTransformer);
        return this._new(nameTransformer, new SerializedString(string));
    }

    protected UnwrappingBeanPropertyWriter _new(NameTransformer nameTransformer, SerializedString serializedString) {
        return new UnwrappingBeanPropertyWriter(this, nameTransformer, serializedString);
    }

    @Override
    public boolean isUnwrapping() {
        return true;
    }

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        Object object2 = this.get(object);
        if (object2 == null) {
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? jsonSerializer.isEmpty(serializerProvider, object2) : this._suppressableValue.equals(object2))) {
            return;
        }
        if (object2 == object && this._handleSelfReference(object, jsonGenerator, serializerProvider, jsonSerializer)) {
            return;
        }
        if (!jsonSerializer.isUnwrappingSerializer()) {
            jsonGenerator.writeFieldName(this._name);
        }
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
    }

    @Override
    public void assignSerializer(JsonSerializer<Object> jsonSerializer) {
        if (jsonSerializer != null) {
            NameTransformer nameTransformer = this._nameTransformer;
            if (jsonSerializer.isUnwrappingSerializer() && jsonSerializer instanceof UnwrappingBeanSerializer) {
                nameTransformer = NameTransformer.chainedTransformer(nameTransformer, ((UnwrappingBeanSerializer)jsonSerializer)._nameTransformer);
            }
            jsonSerializer = jsonSerializer.unwrappingSerializer(nameTransformer);
        }
        super.assignSerializer(jsonSerializer);
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findValueSerializer(this.getType(), (BeanProperty)this).unwrappingSerializer(this._nameTransformer);
        if (jsonSerializer.isUnwrappingSerializer()) {
            jsonSerializer.acceptJsonFormatVisitor(new JsonFormatVisitorWrapper.Base(this, serializerProvider, jsonObjectFormatVisitor){
                private /* synthetic */ JsonObjectFormatVisitor a;
                private /* synthetic */ UnwrappingBeanPropertyWriter b;
                {
                    this.b = unwrappingBeanPropertyWriter;
                    this.a = jsonObjectFormatVisitor;
                    super(serializerProvider);
                }

                @Override
                public final JsonObjectFormatVisitor expectObjectFormat(JavaType javaType) {
                    return this.a;
                }
            }, this.getType());
            return;
        }
        super.depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
    }

    @Override
    protected void _depositSchemaProperty(ObjectNode objectNode, JsonNode object) {
        if ((object = ((JsonNode)object).get("properties")) != null) {
            object = ((JsonNode)object).fields();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                String string = (String)entry.getKey();
                if (this._nameTransformer != null) {
                    string = this._nameTransformer.transform(string);
                }
                objectNode.set(string, (JsonNode)entry.getValue());
            }
        }
    }

    @Override
    protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap jsonSerializer, Class<?> clazz, SerializerProvider serializerProvider) {
        Object object;
        if (this._nonTrivialBaseType != null) {
            object = ((DatabindContext)serializerProvider).constructSpecializedType(this._nonTrivialBaseType, clazz);
            jsonSerializer = serializerProvider.findValueSerializer((JavaType)object, (BeanProperty)this);
        } else {
            jsonSerializer = serializerProvider.findValueSerializer(clazz, (BeanProperty)this);
        }
        object = this._nameTransformer;
        if (jsonSerializer.isUnwrappingSerializer() && jsonSerializer instanceof UnwrappingBeanSerializer) {
            object = NameTransformer.chainedTransformer((NameTransformer)object, ((UnwrappingBeanSerializer)jsonSerializer)._nameTransformer);
        }
        jsonSerializer = jsonSerializer.unwrappingSerializer((NameTransformer)object);
        this._dynamicSerializers = this._dynamicSerializers.newWith(clazz, jsonSerializer);
        return jsonSerializer;
    }
}

