/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.lang.reflect.Type;

@JacksonStdImpl
public final class BooleanSerializer
extends StdScalarSerializer<Object>
implements ContextualSerializer {
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean bl2) {
        super(bl2 ? Boolean.TYPE : Boolean.class, false);
        this._forPrimitive = bl2;
    }

    @Override
    public final JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
        if ((object = this.findFormatOverrides((SerializerProvider)object, beanProperty, ((JsonSerializer)this).handledType())) != null) {
            if (((JsonFormat.Shape)((Object)(object = ((JsonFormat.Value)object).getShape()))).isNumeric()) {
                return new a(this._forPrimitive);
            }
            if (object == JsonFormat.Shape.STRING) {
                return new ToStringSerializer((Class<?>)this._handledType);
            }
        }
        return this;
    }

    @Override
    public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeBoolean(Boolean.TRUE.equals(object));
    }

    @Override
    public final void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        jsonGenerator.writeBoolean(Boolean.TRUE.equals(object));
    }

    @Override
    @Deprecated
    public final JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public final void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        jsonFormatVisitorWrapper.expectBooleanFormat(javaType);
    }

    static final class a
    extends StdScalarSerializer<Object>
    implements ContextualSerializer {
        private boolean a;

        public a(boolean bl2) {
            super(bl2 ? Boolean.TYPE : Boolean.class, false);
            this.a = bl2;
        }

        @Override
        public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber(Boolean.FALSE.equals(object) ? 0 : 1);
        }

        @Override
        public final void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
            jsonGenerator.writeBoolean(Boolean.TRUE.equals(object));
        }

        @Override
        public final void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            this.visitIntFormat(jsonFormatVisitorWrapper, javaType, JsonParser.NumberType.INT);
        }

        @Override
        public final JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
            if ((object = this.findFormatOverrides((SerializerProvider)object, beanProperty, Boolean.class)) != null && !((JsonFormat.Shape)((Object)(object = ((JsonFormat.Value)object).getShape()))).isNumeric()) {
                return new BooleanSerializer(this.a);
            }
            return this;
        }
    }
}

