/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer object, JsonGenerator jsonGenerator, SerializerProvider object2) {
        if (((ByteBuffer)object).hasArray()) {
            int n2 = ((Buffer)object).position();
            jsonGenerator.writeBinary(((ByteBuffer)object).array(), ((ByteBuffer)object).arrayOffset() + n2, ((Buffer)object).limit() - n2);
            return;
        }
        object2 = ((ByteBuffer)object).asReadOnlyBuffer();
        object = new ByteBufferBackedInputStream((ByteBuffer)object2);
        jsonGenerator.writeBinary((InputStream)object, ((Buffer)object2).remaining());
        ((InputStream)object).close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWithSerializerProvider, JavaType javaType) {
        if ((jsonFormatVisitorWithSerializerProvider = jsonFormatVisitorWithSerializerProvider.expectArrayFormat(javaType)) != null) {
            jsonFormatVisitorWithSerializerProvider.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

