/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.net.InetAddress;

public class InetAddressSerializer
extends StdScalarSerializer<InetAddress>
implements ContextualSerializer {
    protected final boolean _asNumeric;

    public InetAddressSerializer() {
        this(false);
    }

    public InetAddressSerializer(boolean bl2) {
        super(InetAddress.class);
        this._asNumeric = bl2;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
        object = this.findFormatOverrides((SerializerProvider)object, beanProperty, ((JsonSerializer)this).handledType());
        boolean bl2 = false;
        if (object != null && (((JsonFormat.Shape)((Object)(object = ((JsonFormat.Value)object).getShape()))).isNumeric() || object == JsonFormat.Shape.ARRAY)) {
            bl2 = true;
        }
        if (bl2 != this._asNumeric) {
            return new InetAddressSerializer(bl2);
        }
        return this;
    }

    @Override
    public void serialize(InetAddress object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._asNumeric) {
            object = ((InetAddress)object).getHostAddress();
        } else {
            int n2 = ((String)(object = ((InetAddress)object).toString().trim())).indexOf(47);
            if (n2 >= 0) {
                object = n2 == 0 ? ((String)object).substring(1) : ((String)object).substring(0, n2);
            }
        }
        jsonGenerator.writeString((String)object);
    }

    @Override
    public void serializeWithType(InetAddress inetAddress, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId((Object)inetAddress, InetAddress.class, JsonToken.VALUE_STRING));
        this.serialize(inetAddress, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }
}

