/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializerBase;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberSerializer
extends StdScalarSerializer<Number>
implements ContextualSerializer {
    public static final NumberSerializer instance = new NumberSerializer((Class<? extends Number>)Number.class);
    protected static final int MAX_BIG_DECIMAL_SCALE = 9999;
    protected final boolean _isInt;

    public NumberSerializer(Class<? extends Number> clazz) {
        super(clazz, false);
        this._isInt = clazz == BigInteger.class;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
        if ((object = this.findFormatOverrides((SerializerProvider)object, beanProperty, ((JsonSerializer)this).handledType())) != null) {
            switch (((JsonFormat.Value)object).getShape()) {
                case STRING: {
                    if (((JsonSerializer)this).handledType() == BigDecimal.class) {
                        return NumberSerializer.bigDecimalAsStringSerializer();
                    }
                    return ToStringSerializer.instance;
                }
            }
        }
        return this;
    }

    @Override
    public void serialize(Number number, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (number instanceof BigDecimal) {
            jsonGenerator.writeNumber((BigDecimal)number);
            return;
        }
        if (number instanceof BigInteger) {
            jsonGenerator.writeNumber((BigInteger)number);
            return;
        }
        if (number instanceof Long) {
            jsonGenerator.writeNumber(number.longValue());
            return;
        }
        if (number instanceof Double) {
            jsonGenerator.writeNumber(number.doubleValue());
            return;
        }
        if (number instanceof Float) {
            jsonGenerator.writeNumber(number.floatValue());
            return;
        }
        if (number instanceof Integer || number instanceof Byte || number instanceof Short) {
            jsonGenerator.writeNumber(number.intValue());
            return;
        }
        jsonGenerator.writeNumber(number.toString());
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        NumberSerializer numberSerializer = this;
        return numberSerializer.createSchemaNode(numberSerializer._isInt ? "integer" : "number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        if (this._isInt) {
            this.visitIntFormat(jsonFormatVisitorWrapper, javaType, JsonParser.NumberType.BIG_INTEGER);
            return;
        }
        if (((JsonSerializer)this).handledType() == BigDecimal.class) {
            this.visitFloatFormat(jsonFormatVisitorWrapper, javaType, JsonParser.NumberType.BIG_DECIMAL);
            return;
        }
        jsonFormatVisitorWrapper.expectNumberFormat(javaType);
    }

    public static JsonSerializer<?> bigDecimalAsStringSerializer() {
        return a.a;
    }

    static final class a
    extends ToStringSerializerBase {
        static final a a = new a();

        public a() {
            super(BigDecimal.class);
        }

        @Override
        public final boolean isEmpty(SerializerProvider serializerProvider, Object object) {
            return false;
        }

        @Override
        public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            if (jsonGenerator.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN)) {
                object = (BigDecimal)object;
                BigDecimal bigDecimal = object;
                int n2 = ((BigDecimal)object).scale();
                if (!(n2 >= -9999 && n2 <= 9999)) {
                    String string = String.format("Attempt to write plain `java.math.BigDecimal` (see JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) with illegal scale (%d): needs to be between [-%d, %d]", ((BigDecimal)object).scale(), 9999, 9999);
                    serializerProvider.reportMappingProblem(string, new Object[0]);
                }
                object = ((BigDecimal)object).toPlainString();
            } else {
                object = object.toString();
            }
            jsonGenerator.writeString((String)object);
        }

        @Override
        public final String valueToString(Object object) {
            throw new IllegalStateException();
        }
    }
}

