/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.NumberOutput;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;

public class NumberSerializers {
    protected NumberSerializers() {
    }

    public static void addAll(Map<String, JsonSerializer<?>> map) {
        map.put(Integer.class.getName(), new IntegerSerializer(Integer.class));
        map.put(Integer.TYPE.getName(), new IntegerSerializer((Class<?>)Integer.TYPE));
        map.put(Long.class.getName(), new LongSerializer(Long.class));
        map.put(Long.TYPE.getName(), new LongSerializer((Class<?>)Long.TYPE));
        map.put(Byte.class.getName(), IntLikeSerializer.a);
        map.put(Byte.TYPE.getName(), IntLikeSerializer.a);
        map.put(Short.class.getName(), ShortSerializer.a);
        map.put(Short.TYPE.getName(), ShortSerializer.a);
        map.put(Double.class.getName(), new DoubleSerializer(Double.class));
        map.put(Double.TYPE.getName(), new DoubleSerializer((Class<?>)Double.TYPE));
        map.put(Float.class.getName(), FloatSerializer.a);
        map.put(Float.TYPE.getName(), FloatSerializer.a);
    }

    @JacksonStdImpl
    public static class DoubleSerializer
    extends Base<Object> {
        public DoubleSerializer(Class<?> clazz) {
            super(clazz, JsonParser.NumberType.DOUBLE, "number");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber((Double)object);
        }

        @Override
        public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider object2, TypeSerializer typeSerializer) {
            object2 = (Double)object;
            if (NumberOutput.notFinite((Double)object2)) {
                object = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(object, JsonToken.VALUE_NUMBER_FLOAT));
                jsonGenerator.writeNumber((Double)object2);
                typeSerializer.writeTypeSuffix(jsonGenerator, (WritableTypeId)object);
                return;
            }
            jsonGenerator.writeNumber((Double)object2);
        }

        @Deprecated
        public static boolean notFinite(double d2) {
            return NumberOutput.notFinite(d2);
        }
    }

    @JacksonStdImpl
    public static class FloatSerializer
    extends Base<Object> {
        static final FloatSerializer a = new FloatSerializer();

        public FloatSerializer() {
            super(Float.class, JsonParser.NumberType.FLOAT, "number");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber(((Float)object).floatValue());
        }
    }

    @JacksonStdImpl
    public static class LongSerializer
    extends Base<Object> {
        public LongSerializer(Class<?> clazz) {
            super(clazz, JsonParser.NumberType.LONG, "integer");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber((Long)object);
        }
    }

    @JacksonStdImpl
    public static class IntLikeSerializer
    extends Base<Object> {
        static final IntLikeSerializer a = new IntLikeSerializer();

        public IntLikeSerializer() {
            super(Number.class, JsonParser.NumberType.INT, "integer");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber(((Number)object).intValue());
        }
    }

    @JacksonStdImpl
    public static class IntegerSerializer
    extends Base<Object> {
        public IntegerSerializer(Class<?> clazz) {
            super(clazz, JsonParser.NumberType.INT, "integer");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber((Integer)object);
        }

        @Override
        public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
            ((JsonSerializer)this).serialize(object, jsonGenerator, serializerProvider);
        }
    }

    @JacksonStdImpl
    public static class ShortSerializer
    extends Base<Object> {
        static final ShortSerializer a = new ShortSerializer();

        public ShortSerializer() {
            super(Short.class, JsonParser.NumberType.INT, "integer");
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeNumber((Short)object);
        }
    }

    public static abstract class Base<T>
    extends StdScalarSerializer<T>
    implements ContextualSerializer {
        protected final JsonParser.NumberType _numberType;
        protected final String _schemaType;
        protected final boolean _isInt;

        protected Base(Class<?> clazz, JsonParser.NumberType numberType, String string) {
            super(clazz, false);
            this._numberType = numberType;
            this._schemaType = string;
            this._isInt = numberType == JsonParser.NumberType.INT || numberType == JsonParser.NumberType.LONG || numberType == JsonParser.NumberType.BIG_INTEGER;
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            Base base = this;
            return base.createSchemaNode(base._schemaType, true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            if (this._isInt) {
                this.visitIntFormat(jsonFormatVisitorWrapper, javaType, this._numberType);
                return;
            }
            this.visitFloatFormat(jsonFormatVisitorWrapper, javaType, this._numberType);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
            if ((object = this.findFormatOverrides((SerializerProvider)object, beanProperty, ((JsonSerializer)this).handledType())) != null) {
                switch (((JsonFormat.Value)object).getShape()) {
                    case STRING: {
                        if (((JsonSerializer)this).handledType() == BigDecimal.class) {
                            return NumberSerializer.bigDecimalAsStringSerializer();
                        }
                        return ToStringSerializer.instance;
                    }
                }
            }
            return this;
        }
    }
}

