/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import java.io.Serializable;
import java.util.Objects;

@JacksonStdImpl
public class ObjectArraySerializer
extends ArraySerializerBase<Object[]>
implements ContextualSerializer {
    protected final boolean _staticTyping;
    protected final JavaType _elementType;
    protected final TypeSerializer _valueTypeSerializer;
    protected JsonSerializer<Object> _elementSerializer;
    protected PropertySerializerMap _dynamicSerializers;

    public ObjectArraySerializer(JavaType javaType, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        super(Object[].class);
        this._elementType = javaType;
        this._staticTyping = bl2;
        this._valueTypeSerializer = typeSerializer;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._elementSerializer = jsonSerializer;
    }

    public ObjectArraySerializer(ObjectArraySerializer objectArraySerializer, TypeSerializer typeSerializer) {
        super(objectArraySerializer);
        this._elementType = objectArraySerializer._elementType;
        this._valueTypeSerializer = typeSerializer;
        this._staticTyping = objectArraySerializer._staticTyping;
        this._dynamicSerializers = objectArraySerializer._dynamicSerializers;
        this._elementSerializer = objectArraySerializer._elementSerializer;
    }

    public ObjectArraySerializer(ObjectArraySerializer objectArraySerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl2) {
        super(objectArraySerializer, beanProperty, bl2);
        this._elementType = objectArraySerializer._elementType;
        this._valueTypeSerializer = typeSerializer;
        this._staticTyping = objectArraySerializer._staticTyping;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._elementSerializer = jsonSerializer;
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
        return new ObjectArraySerializer(this, beanProperty, this._valueTypeSerializer, this._elementSerializer, bl2);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new ObjectArraySerializer(this._elementType, this._staticTyping, typeSerializer, this._elementSerializer);
    }

    public ObjectArraySerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl2) {
        if (this._property == beanProperty && jsonSerializer == this._elementSerializer && this._valueTypeSerializer == typeSerializer && Objects.equals(this._unwrapSingle, bl2)) {
            return this;
        }
        return new ObjectArraySerializer(this, beanProperty, typeSerializer, jsonSerializer, bl2);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        Serializable serializable;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        JsonSerializer<Object> jsonSerializer = null;
        Boolean bl2 = null;
        if (beanProperty != null) {
            serializable = beanProperty.getMember();
            Object object = ((DatabindContext)serializerProvider).getAnnotationIntrospector();
            if (serializable != null && (object = ((AnnotationIntrospector)object).findContentSerializer((Annotated)((Object)serializable))) != null) {
                jsonSerializer = serializerProvider.serializerInstance((Annotated)((Object)serializable), object);
            }
        }
        if ((serializable = this.findFormatOverrides(serializerProvider, beanProperty, ((JsonSerializer)this).handledType())) != null) {
            bl2 = ((JsonFormat.Value)serializable).getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._elementSerializer;
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null && this._elementType != null && this._staticTyping && !this._elementType.isJavaLangObject()) {
            jsonSerializer = serializerProvider.findContentValueSerializer(this._elementType, beanProperty);
        }
        return this.withResolved(beanProperty, typeSerializer, jsonSerializer, bl2);
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Object[] objectArray) {
        return objectArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(Object[] objectArray) {
        return objectArray.length == 1;
    }

    @Override
    public final void serialize(Object[] objectArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = objectArray.length;
        if (n2 == 1 && (this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(objectArray, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(objectArray, n2);
        this.serializeContents(objectArray, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(Object[] objectArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2;
        int n3 = objectArray.length;
        if (n3 == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(objectArray, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        if (this._valueTypeSerializer != null) {
            this.serializeTypedContents(objectArray, jsonGenerator, serializerProvider);
            return;
        }
        Object object = null;
        try {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                if (object == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> clazz = object.getClass();
                JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
                if (jsonSerializer == null) {
                    jsonSerializer = ((ResolvedType)this._elementType).hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, ((DatabindContext)serializerProvider).constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                }
                jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
            }
            return;
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, n2);
            return;
        }
    }

    public void serializeContentsUsing(Object[] objectArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) {
        int n2;
        int n3 = objectArray.length;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        Object object = null;
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                if (object == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                if (typeSerializer == null) {
                    jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
            }
            return;
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, n2);
            return;
        }
    }

    public void serializeTypedContents(Object[] objectArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2;
        int n3 = objectArray.length;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        Object object = null;
        try {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                if (object == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> clazz = object.getClass();
                JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
                if (jsonSerializer == null) {
                    jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                }
                jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
            }
            return;
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, n2);
            return;
        }
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType object) {
        if ((object = jsonFormatVisitorWrapper.expectArrayFormat((JavaType)object)) != null) {
            JavaType javaType = this._elementType;
            JsonSerializer<Object> jsonSerializer = this._elementSerializer;
            if (jsonSerializer == null) {
                jsonSerializer = jsonFormatVisitorWrapper.getProvider().findContentValueSerializer(javaType, this._property);
            }
            object.itemsFormat(jsonSerializer, javaType);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> object, SerializerProvider serializerProvider) {
        object = propertySerializerMap.findAndAddSecondarySerializer((Class<?>)object, serializerProvider, this._property);
        if (propertySerializerMap != ((PropertySerializerMap.SerializerAndMapResult)object).map) {
            this._dynamicSerializers = ((PropertySerializerMap.SerializerAndMapResult)object).map;
        }
        return ((PropertySerializerMap.SerializerAndMapResult)object).serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType object, SerializerProvider serializerProvider) {
        object = propertySerializerMap.findAndAddSecondarySerializer((JavaType)object, serializerProvider, this._property);
        if (propertySerializerMap != ((PropertySerializerMap.SerializerAndMapResult)object).map) {
            this._dynamicSerializers = ((PropertySerializerMap.SerializerAndMapResult)object).map;
        }
        return ((PropertySerializerMap.SerializerAndMapResult)object).serializer;
    }
}

