/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;

public abstract class ReferenceTypeSerializer<T>
extends StdSerializer<T>
implements ContextualSerializer {
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final JavaType _referredType;
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final NameTransformer _unwrapper;
    protected transient PropertySerializerMap _dynamicSerializers;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;

    public ReferenceTypeSerializer(ReferenceType referenceType, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        super(referenceType);
        this._referredType = ((JavaType)referenceType).getReferencedType();
        this._property = null;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._unwrapper = null;
        this._suppressableValue = null;
        this._suppressNulls = false;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected ReferenceTypeSerializer(ReferenceTypeSerializer<?> referenceTypeSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, NameTransformer nameTransformer, Object object, boolean bl2) {
        super(referenceTypeSerializer);
        this._referredType = referenceTypeSerializer._referredType;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._property = beanProperty;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._unwrapper = nameTransformer;
        this._suppressableValue = object;
        this._suppressNulls = bl2;
    }

    @Override
    public JsonSerializer<T> unwrappingSerializer(NameTransformer nameTransformer) {
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer != null && (jsonSerializer = jsonSerializer.unwrappingSerializer(nameTransformer)) == this._valueSerializer) {
            return this;
        }
        NameTransformer nameTransformer2 = nameTransformer = this._unwrapper == null ? nameTransformer : NameTransformer.chainedTransformer(nameTransformer, this._unwrapper);
        if (this._valueSerializer == jsonSerializer && this._unwrapper == nameTransformer) {
            return this;
        }
        ReferenceTypeSerializer referenceTypeSerializer = this;
        return referenceTypeSerializer.withResolved(referenceTypeSerializer._property, this._valueTypeSerializer, jsonSerializer, nameTransformer);
    }

    protected abstract ReferenceTypeSerializer<T> withResolved(BeanProperty var1, TypeSerializer var2, JsonSerializer<?> var3, NameTransformer var4);

    public abstract ReferenceTypeSerializer<T> withContentInclusion(Object var1, boolean var2);

    protected abstract boolean _isValuePresent(T var1);

    protected abstract Object _getReferenced(T var1);

    protected abstract Object _getReferencedIfPresent(T var1);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty object) {
        Object object2;
        Object object3 = this._valueTypeSerializer;
        if (object3 != null) {
            object3 = ((TypeSerializer)object3).forProperty((BeanProperty)object);
        }
        if ((object2 = this.findAnnotatedContentSerializer(serializerProvider, (BeanProperty)object)) == null) {
            object2 = this._valueSerializer;
            if (object2 == null) {
                if (this._useStatic(serializerProvider, (BeanProperty)object, this._referredType)) {
                    BeanProperty beanProperty = object;
                    JavaType javaType = this._referredType;
                    object2 = serializerProvider;
                    object2 = ((SerializerProvider)object2).findPrimaryPropertySerializer(javaType, beanProperty);
                }
            } else {
                object2 = serializerProvider.handlePrimaryContextualization((JsonSerializer<?>)object2, (BeanProperty)object);
            }
        }
        object2 = this.findContextualConvertingSerializer(serializerProvider, (BeanProperty)object, (JsonSerializer<?>)object2);
        object3 = this._property == object && this._valueTypeSerializer == object3 && this._valueSerializer == object2 ? this : this.withResolved((BeanProperty)object, (TypeSerializer)object3, (JsonSerializer<?>)object2, this._unwrapper);
        if (object != null && (object = object.findPropertyInclusion(serializerProvider.getConfig(), ((JsonSerializer)this).handledType())) != null && (object2 = ((JsonInclude.Value)object).getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            boolean bl2;
            switch (1.a[((Enum)object2).ordinal()]) {
                case 1: {
                    object = BeanUtil.getDefaultValue(this._referredType);
                    bl2 = true;
                    if (object == null || !object.getClass().isArray()) break;
                    object = ArrayBuilders.getArrayComparator(object);
                    break;
                }
                case 2: {
                    bl2 = true;
                    object = this._referredType.isReferenceType() ? MARKER_FOR_EMPTY : null;
                    break;
                }
                case 3: {
                    bl2 = true;
                    object = MARKER_FOR_EMPTY;
                    break;
                }
                case 4: {
                    object = serializerProvider.includeFilterInstance(null, ((JsonInclude.Value)object).getContentFilter());
                    if (object == null) {
                        bl2 = true;
                        break;
                    }
                    bl2 = serializerProvider.includeFilterSuppressNulls(object);
                    break;
                }
                case 5: {
                    object = null;
                    bl2 = true;
                    break;
                }
                default: {
                    object = null;
                    bl2 = false;
                }
            }
            if (this._suppressableValue != object || this._suppressNulls != bl2) {
                object3 = ((ReferenceTypeSerializer)object3).withContentInclusion(object, bl2);
            }
        }
        return object3;
    }

    protected boolean _useStatic(SerializerProvider serializerProvider, BeanProperty object, JavaType serializable) {
        AnnotatedMember annotatedMember;
        if (((JavaType)serializable).isJavaLangObject()) {
            return false;
        }
        if (((ResolvedType)((Object)serializable)).isFinal()) {
            return true;
        }
        if (((JavaType)serializable).useStaticType()) {
            return true;
        }
        serializable = ((DatabindContext)serializerProvider).getAnnotationIntrospector();
        if (serializable != null && object != null && (annotatedMember = object.getMember()) != null) {
            if ((object = ((AnnotationIntrospector)serializable).findSerializationTyping(object.getMember())) == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (object == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return ((DatabindContext)serializerProvider).isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, T object) {
        if (!this._isValuePresent(object)) {
            return true;
        }
        if ((object = this._getReferenced(object)) == null) {
            return this._suppressNulls;
        }
        if (this._suppressableValue == null) {
            return false;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            try {
                jsonSerializer = this.a(serializerProvider, object.getClass());
            }
            catch (JsonMappingException jsonMappingException) {
                throw new RuntimeJsonMappingException(jsonMappingException);
            }
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            return jsonSerializer.isEmpty(serializerProvider, object);
        }
        return this._suppressableValue.equals(object);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    public JavaType getReferredType() {
        return this._referredType;
    }

    @Override
    public void serialize(T object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if ((object = this._getReferencedIfPresent(object)) == null) {
            if (this._unwrapper == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this.a(serializerProvider, object.getClass());
        }
        if (this._valueTypeSerializer != null) {
            jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, this._valueTypeSerializer);
            return;
        }
        jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
    }

    @Override
    public void serializeWithType(T object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        if ((object = this._getReferencedIfPresent(object)) == null) {
            if (this._unwrapper == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this.a(serializerProvider, object.getClass());
        }
        jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType jsonSerializer) {
        jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            BeanProperty beanProperty = this._property;
            JavaType javaType = this._referredType;
            jsonSerializer = jsonFormatVisitorWrapper.getProvider();
            jsonSerializer = ((SerializerProvider)((Object)jsonSerializer)).findPrimaryPropertySerializer(javaType, beanProperty);
            if (this._unwrapper != null) {
                jsonSerializer = jsonSerializer.unwrappingSerializer(this._unwrapper);
            }
        }
        jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, this._referredType);
    }

    private final JsonSerializer<Object> a(SerializerProvider serializerProvider, Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor(clazz);
        if (jsonSerializer == null) {
            if (((ResolvedType)this._referredType).hasGenericTypes()) {
                jsonSerializer = ((DatabindContext)serializerProvider).constructSpecializedType(this._referredType, clazz);
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer((JavaType)((Object)jsonSerializer), this._property);
            } else {
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(clazz, this._property);
            }
            if (this._unwrapper != null) {
                jsonSerializer = jsonSerializer.unwrappingSerializer(this._unwrapper);
            }
            this._dynamicSerializers = this._dynamicSerializers.newWith(clazz, jsonSerializer);
        }
        return jsonSerializer;
    }
}

