/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.CollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;

public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T>
implements ContextualSerializer {
    protected final Boolean _unwrapSingle;

    protected StaticListSerializerBase(Class<?> clazz) {
        super(clazz, false);
        this._unwrapSingle = null;
    }

    protected StaticListSerializerBase(StaticListSerializerBase<?> staticListSerializerBase, Boolean bl2) {
        super(staticListSerializerBase);
        this._unwrapSingle = bl2;
    }

    public abstract JsonSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        Object object;
        JsonSerializer<Object> jsonSerializer = null;
        Boolean bl2 = null;
        if (beanProperty != null) {
            object = ((DatabindContext)serializerProvider).getAnnotationIntrospector();
            AnnotatedMember annotatedMember = beanProperty.getMember();
            if (annotatedMember != null && (object = ((AnnotationIntrospector)object).findContentSerializer(annotatedMember)) != null) {
                jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
            }
        }
        if ((object = this.findFormatOverrides(serializerProvider, beanProperty, ((JsonSerializer)this).handledType())) != null) {
            bl2 = ((JsonFormat.Value)object).getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null) {
            jsonSerializer = serializerProvider.findContentValueSerializer(String.class, beanProperty);
        }
        if (this.isDefaultSerializer(jsonSerializer)) {
            if (Objects.equals(bl2, this._unwrapSingle)) {
                return this;
            }
            return this._withResolved(beanProperty, bl2);
        }
        return new CollectionSerializer(serializerProvider.constructType((Type)((Object)String.class)), true, null, jsonSerializer);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, T t2) {
        return t2 == null || t2.isEmpty();
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("array", true).set("items", this.contentSchema());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWithSerializerProvider, JavaType javaType) {
        if ((jsonFormatVisitorWithSerializerProvider = jsonFormatVisitorWithSerializerProvider.expectArrayFormat(javaType)) != null) {
            this.acceptContentVisitor((JsonArrayFormatVisitor)jsonFormatVisitorWithSerializerProvider);
        }
    }

    protected abstract JsonNode contentSchema();

    protected abstract void acceptContentVisitor(JsonArrayFormatVisitor var1);

    @Override
    public abstract void serializeWithType(T var1, JsonGenerator var2, SerializerProvider var3, TypeSerializer var4);
}

