/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumValues;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public abstract class StdKeySerializers {
    protected static final JsonSerializer<Object> DEFAULT_KEY_SERIALIZER = new StdKeySerializer();
    protected static final JsonSerializer<Object> DEFAULT_STRING_SERIALIZER = new StringKeySerializer();

    public static JsonSerializer<Object> getStdKeySerializer(SerializationConfig serializationConfig, Class<?> clazz, boolean bl2) {
        if (clazz == null || clazz == Object.class) {
            return new Dynamic();
        }
        if (clazz == String.class) {
            return DEFAULT_STRING_SERIALIZER;
        }
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        if (clazz == Integer.class) {
            return new Default(5, clazz);
        }
        if (clazz == Long.class) {
            return new Default(6, clazz);
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz)) {
            return new Default(8, clazz);
        }
        if (clazz == Class.class) {
            return new Default(3, clazz);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new Default(1, clazz);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return new Default(2, clazz);
        }
        if (clazz == UUID.class) {
            return new Default(8, clazz);
        }
        if (clazz == byte[].class) {
            return new Default(7, clazz);
        }
        if (bl2) {
            return new Default(8, clazz);
        }
        return null;
    }

    public static JsonSerializer<Object> getFallbackKeySerializer(SerializationConfig serializationConfig, Class<?> clazz, AnnotatedClass annotatedClass) {
        if (clazz != null) {
            if (clazz == Enum.class) {
                return new Dynamic();
            }
            if (ClassUtil.isEnumType(clazz)) {
                return EnumKeySerializer.construct(clazz, EnumValues.constructFromName(serializationConfig, annotatedClass), EnumSerializer.constructEnumNamingStrategyValues(serializationConfig, clazz, annotatedClass));
            }
        }
        return new Default(8, clazz);
    }

    @Deprecated
    public static JsonSerializer<Object> getDefault() {
        return DEFAULT_KEY_SERIALIZER;
    }

    public static class EnumKeySerializer
    extends StdSerializer<Object> {
        protected final EnumValues _values;
        protected final EnumValues _valuesByEnumNaming;

        protected EnumKeySerializer(Class<?> clazz, EnumValues enumValues) {
            super(clazz, false);
            this._values = enumValues;
            this._valuesByEnumNaming = null;
        }

        protected EnumKeySerializer(Class<?> clazz, EnumValues enumValues, EnumValues enumValues2) {
            super(clazz, false);
            this._values = enumValues;
            this._valuesByEnumNaming = enumValues2;
        }

        public static EnumKeySerializer construct(Class<?> clazz, EnumValues enumValues) {
            return new EnumKeySerializer(clazz, enumValues);
        }

        public static EnumKeySerializer construct(Class<?> clazz, EnumValues enumValues, EnumValues enumValues2) {
            return new EnumKeySerializer(clazz, enumValues, enumValues2);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                jsonGenerator.writeFieldName(object.toString());
                return;
            }
            object = (Enum)object;
            if (this._valuesByEnumNaming != null) {
                jsonGenerator.writeFieldName(this._valuesByEnumNaming.serializedValueFor((Enum<?>)object));
                return;
            }
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUM_KEYS_USING_INDEX)) {
                jsonGenerator.writeFieldName(String.valueOf(((Enum)object).ordinal()));
                return;
            }
            jsonGenerator.writeFieldName(this._values.serializedValueFor((Enum<?>)object));
        }
    }

    public static class StringKeySerializer
    extends StdSerializer<Object> {
        public StringKeySerializer() {
            super(String.class, false);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            jsonGenerator.writeFieldName((String)object);
        }
    }

    public static class Dynamic
    extends StdSerializer<Object> {
        protected transient PropertySerializerMap _dynamicSerializers = PropertySerializerMap.emptyForProperties();

        public Dynamic() {
            super(String.class, false);
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            Class<?> clazz = object.getClass();
            JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
            if (jsonSerializer == null) {
                jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
            }
            jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
            this.visitStringFormat(jsonFormatVisitorWrapper, javaType);
        }

        protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz, SerializerProvider object) {
            if (clazz == Object.class) {
                object = new Default(8, clazz);
                this._dynamicSerializers = propertySerializerMap.newWith(clazz, (JsonSerializer<Object>)object);
                return object;
            }
            object = propertySerializerMap.findAndAddKeySerializer(clazz, (SerializerProvider)object, null);
            if (propertySerializerMap != ((PropertySerializerMap.SerializerAndMapResult)object).map) {
                this._dynamicSerializers = ((PropertySerializerMap.SerializerAndMapResult)object).map;
            }
            return ((PropertySerializerMap.SerializerAndMapResult)object).serializer;
        }
    }

    public static class Default
    extends StdSerializer<Object> {
        protected final int _typeId;

        public Default(int n2, Class<?> clazz) {
            super(clazz, false);
            this._typeId = n2;
        }

        @Override
        public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
            switch (this._typeId) {
                case 1: {
                    serializerProvider.defaultSerializeDateKey((Date)object, jsonGenerator);
                    return;
                }
                case 2: {
                    serializerProvider.defaultSerializeDateKey(((Calendar)object).getTimeInMillis(), jsonGenerator);
                    return;
                }
                case 3: {
                    jsonGenerator.writeFieldName(((Class)object).getName());
                    return;
                }
                case 4: {
                    if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                        object = object.toString();
                    } else {
                        object = (Enum)object;
                        object = serializerProvider.isEnabled(SerializationFeature.WRITE_ENUM_KEYS_USING_INDEX) ? String.valueOf(((Enum)object).ordinal()) : ((Enum)object).name();
                    }
                    jsonGenerator.writeFieldName((String)object);
                    return;
                }
                case 5: 
                case 6: {
                    jsonGenerator.writeFieldId(((Number)object).longValue());
                    return;
                }
                case 7: {
                    object = serializerProvider.getConfig().getBase64Variant().encode((byte[])object);
                    jsonGenerator.writeFieldName((String)object);
                    return;
                }
            }
            jsonGenerator.writeFieldName(object.toString());
        }
    }
}

