/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.IdentityHashMap;

public abstract class StdSerializer<T>
extends JsonSerializer<T>
implements JsonFormatVisitable,
SchemaAware,
Serializable {
    private static final Object a = new Object();
    protected final Class<T> _handledType;

    protected StdSerializer(Class<T> clazz) {
        this._handledType = clazz;
    }

    protected StdSerializer(JavaType javaType) {
        this._handledType = ((ResolvedType)javaType).getRawClass();
    }

    protected StdSerializer(Class<?> clazz, boolean bl2) {
        this._handledType = clazz;
    }

    protected StdSerializer(StdSerializer<?> stdSerializer) {
        this._handledType = stdSerializer._handledType;
    }

    @Override
    public Class<T> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3);

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        jsonFormatVisitorWrapper.expectAnyFormat(javaType);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("string");
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider object, Type type, boolean bl2) {
        object = (ObjectNode)this.getSchema((SerializerProvider)object, type);
        if (!bl2) {
            ((ObjectNode)object).put("required", true);
        }
        return object;
    }

    protected ObjectNode createSchemaNode(String string) {
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        objectNode.put("type", string);
        return objectNode;
    }

    protected ObjectNode createSchemaNode(String object, boolean bl2) {
        object = this.createSchemaNode((String)object);
        if (!bl2) {
            ((ObjectNode)object).put("required", true);
        }
        return object;
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        jsonFormatVisitorWrapper.expectStringFormat(javaType);
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper object, JavaType javaType, JsonValueFormat jsonValueFormat) {
        if ((object = object.expectStringFormat(javaType)) != null) {
            object.format(jsonValueFormat);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper object, JavaType javaType, JsonParser.NumberType numberType) {
        if (StdSerializer._neitherNull(object = object.expectIntegerFormat(javaType), (Object)numberType)) {
            object.numberType(numberType);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper object, JavaType javaType, JsonParser.NumberType numberType, JsonValueFormat jsonValueFormat) {
        if ((object = object.expectIntegerFormat(javaType)) != null) {
            if (numberType != null) {
                object.numberType(numberType);
            }
            if (jsonValueFormat != null) {
                object.format(jsonValueFormat);
            }
        }
    }

    protected void visitFloatFormat(JsonFormatVisitorWrapper object, JavaType javaType, JsonParser.NumberType numberType) {
        if ((object = object.expectNumberFormat(javaType)) != null) {
            object.numberType(numberType);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper jsonFormatVisitorWithSerializerProvider, JavaType javaType, JsonSerializer<?> jsonSerializer, JavaType javaType2) {
        if (StdSerializer._neitherNull(jsonFormatVisitorWithSerializerProvider = jsonFormatVisitorWithSerializerProvider.expectArrayFormat(javaType), jsonSerializer)) {
            jsonFormatVisitorWithSerializerProvider.itemsFormat(jsonSerializer, javaType2);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper jsonFormatVisitorWithSerializerProvider, JavaType javaType, JsonFormatTypes jsonFormatTypes) {
        if ((jsonFormatVisitorWithSerializerProvider = jsonFormatVisitorWithSerializerProvider.expectArrayFormat(javaType)) != null) {
            jsonFormatVisitorWithSerializerProvider.itemsFormat(jsonFormatTypes);
        }
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, String string) {
        boolean bl2;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        boolean bl3 = bl2 = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl2 || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl2) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, int n2) {
        boolean bl2;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        boolean bl3 = bl2 = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl2 || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl2) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw JsonMappingException.wrapWithPath(throwable, object, n2);
    }

    protected JsonSerializer<?> findContextualConvertingSerializer(SerializerProvider object, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) {
        Object object2;
        IdentityHashMap<BeanProperty, Boolean> identityHashMap = (IdentityHashMap<BeanProperty, Boolean>)((DatabindContext)object).getAttribute(a);
        if (identityHashMap != null) {
            object2 = identityHashMap.get(beanProperty);
            if (object2 != null) {
                return jsonSerializer;
            }
        } else {
            identityHashMap = new IdentityHashMap<BeanProperty, Boolean>();
            ((SerializerProvider)object).setAttribute(a, identityHashMap);
        }
        identityHashMap.put(beanProperty, Boolean.TRUE);
        try {
            object2 = this.findConvertingContentSerializer((SerializerProvider)object, beanProperty, jsonSerializer);
            if (object2 != null) {
                object = ((SerializerProvider)object).handleSecondaryContextualization((JsonSerializer<?>)object2, beanProperty);
                return object;
            }
        }
        finally {
            identityHashMap.remove(beanProperty);
        }
        return jsonSerializer;
    }

    @Deprecated
    protected JsonSerializer<?> findConvertingContentSerializer(SerializerProvider serializerProvider, BeanProperty object, JsonSerializer<?> jsonSerializer) {
        AnnotatedMember annotatedMember;
        Object object2 = ((DatabindContext)serializerProvider).getAnnotationIntrospector();
        if (StdSerializer._neitherNull(object2, object) && (annotatedMember = object.getMember()) != null && (object2 = ((AnnotationIntrospector)object2).findSerializationContentConverter(annotatedMember)) != null) {
            object = serializerProvider.converterInstance(object.getMember(), object2);
            object2 = object.getOutputType(((DatabindContext)serializerProvider).getTypeFactory());
            if (jsonSerializer == null && !((JavaType)object2).isJavaLangObject()) {
                jsonSerializer = serializerProvider.findValueSerializer((JavaType)object2);
            }
            return new StdDelegatingSerializer((Converter<Object, ?>)object, (JavaType)object2, jsonSerializer);
        }
        return jsonSerializer;
    }

    protected PropertyFilter findPropertyFilter(SerializerProvider serializerProvider, Object object, Object object2) {
        FilterProvider filterProvider = serializerProvider.getFilterProvider();
        if (filterProvider == null) {
            return (PropertyFilter)serializerProvider.reportBadDefinition(((JsonSerializer)this).handledType(), "Cannot resolve PropertyFilter with id '" + object + "'; no FilterProvider configured");
        }
        return filterProvider.findPropertyFilter(object, object2);
    }

    protected JsonFormat.Value findFormatOverrides(SerializerProvider serializerProvider, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyFormat(serializerProvider.getConfig(), clazz);
        }
        return ((DatabindContext)serializerProvider).getDefaultPropertyFormat(clazz);
    }

    protected Boolean findFormatFeature(SerializerProvider object, BeanProperty beanProperty, Class<?> clazz, JsonFormat.Feature feature) {
        if ((object = this.findFormatOverrides((SerializerProvider)object, beanProperty, clazz)) != null) {
            return ((JsonFormat.Value)object).getFeature(feature);
        }
        return null;
    }

    protected JsonInclude.Value findIncludeOverrides(SerializerProvider serializerProvider, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyInclusion(serializerProvider.getConfig(), clazz);
        }
        return serializerProvider.getDefaultPropertyInclusion(clazz);
    }

    protected JsonSerializer<?> findAnnotatedContentSerializer(SerializerProvider serializerProvider, BeanProperty object) {
        if (object != null) {
            object = object.getMember();
            Object object2 = ((DatabindContext)serializerProvider).getAnnotationIntrospector();
            if (object != null && (object2 = ((AnnotationIntrospector)object2).findContentSerializer((Annotated)object)) != null) {
                return serializerProvider.serializerInstance((Annotated)object, object2);
            }
        }
        return null;
    }

    protected boolean isDefaultSerializer(JsonSerializer<?> jsonSerializer) {
        return ClassUtil.isJacksonStdImpl(jsonSerializer);
    }

    protected static final boolean _neitherNull(Object object, Object object2) {
        return object != null && object2 != null;
    }

    protected static final boolean _nonEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }
}

