/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToEmptyObjectSerializer
extends StdSerializer<Object> {
    protected ToEmptyObjectSerializer(Class<?> clazz) {
        super(clazz, false);
    }

    public ToEmptyObjectSerializer(JavaType javaType) {
        super(javaType);
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeStartObject(object, 0);
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        object = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(object, JsonToken.START_OBJECT));
        typeSerializer.writeTypeSuffix(jsonGenerator, (WritableTypeId)object);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Object object) {
        return true;
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        jsonFormatVisitorWrapper.expectObjectFormat(javaType);
    }
}

