/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.util.Objects;
import java.util.UUID;

public class UUIDSerializer
extends StdScalarSerializer<UUID>
implements ContextualSerializer {
    private static char[] a = "0123456789abcdef".toCharArray();
    protected final Boolean _asBinary;

    public UUIDSerializer() {
        this((Boolean)null);
    }

    protected UUIDSerializer(Boolean bl2) {
        super(UUID.class);
        this._asBinary = bl2;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, UUID uUID) {
        return uUID.getLeastSignificantBits() == 0L && uUID.getMostSignificantBits() == 0L;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty object2) {
        object = this.findFormatOverrides((SerializerProvider)object, (BeanProperty)object2, ((JsonSerializer)this).handledType());
        object2 = null;
        if (object != null) {
            if ((object = ((JsonFormat.Value)object).getShape()) == JsonFormat.Shape.BINARY) {
                object2 = Boolean.TRUE;
            } else if (object == JsonFormat.Shape.STRING) {
                object2 = Boolean.FALSE;
            }
        }
        if (!Objects.equals(object2, this._asBinary)) {
            return new UUIDSerializer((Boolean)object2);
        }
        return this;
    }

    @Override
    public void serialize(UUID uUID, JsonGenerator object, SerializerProvider object2) {
        if (this._writeAsBinary((JsonGenerator)object)) {
            JsonGenerator jsonGenerator = object;
            object = new byte[16];
            long l2 = uUID.getMostSignificantBits();
            long l3 = uUID.getLeastSignificantBits();
            UUIDSerializer.a((int)(l2 >> 32), (byte[])object, 0);
            UUIDSerializer.a((int)l2, (byte[])object, 4);
            UUIDSerializer.a((int)(l3 >> 32), (byte[])object, 8);
            UUIDSerializer.a((int)l3, (byte[])object, 12);
            jsonGenerator.writeBinary((byte[])object);
            return;
        }
        object2 = new char[36];
        long l4 = uUID.getMostSignificantBits();
        UUIDSerializer.a((int)(l4 >> 32), (char[])object2, 0);
        object2[8] = 45;
        int n2 = (int)l4;
        UUIDSerializer.b(n2 >>> 16, (char[])object2, 9);
        object2[13] = 45;
        UUIDSerializer.b(n2, (char[])object2, 14);
        object2[18] = 45;
        long l5 = uUID.getLeastSignificantBits();
        UUIDSerializer.b((int)(l5 >>> 48), (char[])object2, 19);
        object2[23] = 45;
        UUIDSerializer.b((int)(l5 >>> 32), (char[])object2, 24);
        UUIDSerializer.a((int)l5, (char[])object2, 28);
        ((JsonGenerator)object).writeString((char[])object2, 0, 36);
    }

    protected boolean _writeAsBinary(JsonGenerator jsonGenerator) {
        if (this._asBinary != null) {
            return this._asBinary;
        }
        return !(jsonGenerator instanceof TokenBuffer) && jsonGenerator.canWriteBinaryNatively();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        this.visitStringFormat(jsonFormatVisitorWrapper, javaType, JsonValueFormat.UUID);
    }

    private static void a(int n2, char[] cArray, int n3) {
        UUIDSerializer.b(n2 >> 16, cArray, n3);
        UUIDSerializer.b(n2, cArray, n3 + 4);
    }

    private static void b(int n2, char[] cArray, int n3) {
        cArray[n3] = a[n2 >> 12 & 0xF];
        cArray[++n3] = a[n2 >> 8 & 0xF];
        cArray[++n3] = a[n2 >> 4 & 0xF];
        cArray[++n3] = a[n2 & 0xF];
    }

    private static final void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >> 24);
        byArray[++n3] = (byte)(n2 >> 16);
        byArray[++n3] = (byte)(n2 >> 8);
        byArray[++n3] = (byte)n2;
    }
}

