/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ResolvedRecursiveType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.TypeVariable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TypeBindings
implements Serializable {
    private static final String[] a = new String[0];
    private static final JavaType[] b = new JavaType[0];
    private static final TypeBindings c = new TypeBindings(a, b, null);
    private final String[] d;
    private final JavaType[] e;
    private final String[] f;
    private final int g;

    private TypeBindings(String[] stringArray, JavaType[] javaTypeArray, String[] stringArray2) {
        this.d = stringArray == null ? a : stringArray;
        JavaType[] javaTypeArray2 = this.e = javaTypeArray == null ? b : javaTypeArray;
        if (this.d.length != this.e.length) {
            throw new IllegalArgumentException("Mismatching names (" + this.d.length + "), types (" + this.e.length + ")");
        }
        this.f = stringArray2;
        this.g = Arrays.hashCode(this.e);
    }

    public static TypeBindings emptyBindings() {
        return c;
    }

    protected Object readResolve() {
        if (this.d == null || this.d.length == 0) {
            return c;
        }
        return this;
    }

    public static TypeBindings create(Class<?> clazz, List<JavaType> javaTypeArray) {
        javaTypeArray = javaTypeArray == null || javaTypeArray.isEmpty() ? b : javaTypeArray.toArray(b);
        return TypeBindings.create(clazz, javaTypeArray);
    }

    public static TypeBindings create(Class<?> clazz, JavaType[] javaTypeArray) {
        String[] stringArray;
        if (javaTypeArray == null) {
            javaTypeArray = b;
        } else {
            switch (javaTypeArray.length) {
                case 1: {
                    return TypeBindings.create(clazz, javaTypeArray[0]);
                }
                case 2: {
                    return TypeBindings.create(clazz, javaTypeArray[0], javaTypeArray[1]);
                }
            }
        }
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        if (typeVariableArray == null || typeVariableArray.length == 0) {
            stringArray = a;
        } else {
            int n2 = typeVariableArray.length;
            stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = typeVariableArray[i2].getName();
            }
        }
        if (stringArray.length != javaTypeArray.length) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with " + javaTypeArray.length + " type parameter" + (javaTypeArray.length == 1 ? "" : "s") + ": class expects " + stringArray.length);
        }
        return new TypeBindings(stringArray, javaTypeArray, null);
    }

    public static TypeBindings create(Class<?> clazz, JavaType javaType) {
        TypeVariable<?>[] typeVariableArray = com.fasterxml.jackson.databind.type.TypeBindings$b.a(clazz);
        int n2 = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n2 != 1) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with 1 type parameter: class expects " + n2);
        }
        return new TypeBindings(new String[]{typeVariableArray[0].getName()}, new JavaType[]{javaType}, null);
    }

    public static TypeBindings create(Class<?> clazz, JavaType javaType, JavaType javaType2) {
        TypeVariable<?>[] typeVariableArray = com.fasterxml.jackson.databind.type.TypeBindings$b.b(clazz);
        int n2 = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n2 != 2) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with 2 type parameters: class expects " + n2);
        }
        return new TypeBindings(new String[]{typeVariableArray[0].getName(), typeVariableArray[1].getName()}, new JavaType[]{javaType, javaType2}, null);
    }

    public static TypeBindings create(List<String> list, List<JavaType> list2) {
        if (list == null || list.isEmpty() || list2 == null || list2.isEmpty()) {
            return c;
        }
        return new TypeBindings(list.toArray(a), list2.toArray(b), null);
    }

    public static TypeBindings createIfNeeded(Class<?> clazz, JavaType javaType) {
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        int n2 = typeVariableArray == null ? 0 : typeVariableArray.length;
        if (n2 == 0) {
            return c;
        }
        if (n2 != 1) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with 1 type parameter: class expects " + n2);
        }
        return new TypeBindings(new String[]{typeVariableArray[0].getName()}, new JavaType[]{javaType}, null);
    }

    public static TypeBindings createIfNeeded(Class<?> clazz, JavaType[] javaTypeArray) {
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        if (typeVariableArray == null || typeVariableArray.length == 0) {
            return c;
        }
        if (javaTypeArray == null) {
            javaTypeArray = b;
        }
        int n2 = typeVariableArray.length;
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = typeVariableArray[i2].getName();
        }
        if (stringArray.length != javaTypeArray.length) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + clazz.getName() + " with " + javaTypeArray.length + " type parameter" + (javaTypeArray.length == 1 ? "" : "s") + ": class expects " + stringArray.length);
        }
        return new TypeBindings(stringArray, javaTypeArray, null);
    }

    public TypeBindings withUnboundVariable(String string) {
        int n2 = this.f == null ? 0 : this.f.length;
        String[] stringArray = n2 == 0 ? new String[1] : Arrays.copyOf(this.f, n2 + 1);
        String[] stringArray2 = stringArray;
        stringArray[n2] = string;
        return new TypeBindings(this.d, this.e, stringArray2);
    }

    public TypeBindings withoutVariable(String string) {
        int n2 = Arrays.asList(this.d).indexOf(string);
        if (n2 == -1) {
            return this;
        }
        JavaType[] javaTypeArray = (JavaType[])this.e.clone();
        JavaType[] javaTypeArray2 = javaTypeArray;
        javaTypeArray[n2] = null;
        return new TypeBindings(this.d, javaTypeArray2, this.f);
    }

    public JavaType findBoundType(String object) {
        int n2 = this.d.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((String)object).equals(this.d[i2])) continue;
            object = this.e[i2];
            if (object instanceof ResolvedRecursiveType) {
                JavaType javaType = (ResolvedRecursiveType)object;
                if ((javaType = javaType.getSelfReferencedType()) != null) {
                    object = javaType;
                }
            }
            return object;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.e.length == 0;
    }

    public int size() {
        return this.e.length;
    }

    public String getBoundName(int n2) {
        if (n2 < 0 || n2 >= this.d.length) {
            return null;
        }
        return this.d[n2];
    }

    public JavaType getBoundType(int n2) {
        if (n2 < 0 || n2 >= this.e.length) {
            return null;
        }
        JavaType javaType = this.e[n2];
        if (javaType == null) {
            javaType = TypeFactory.unknownType();
        }
        return javaType;
    }

    public JavaType getBoundTypeOrNull(int n2) {
        if (n2 < 0 || n2 >= this.e.length) {
            return null;
        }
        return this.e[n2];
    }

    public List<JavaType> getTypeParameters() {
        if (this.e.length == 0) {
            return Collections.emptyList();
        }
        List<JavaType> list = Arrays.asList(this.e);
        if (list.contains(null)) {
            list = new ArrayList<JavaType>(list);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2) != null) continue;
                list.set(i2, TypeFactory.unknownType());
            }
        }
        return list;
    }

    public boolean hasUnbound(String string) {
        if (this.f != null) {
            int n2 = this.f.length;
            while (--n2 >= 0) {
                if (!string.equals(this.f[n2])) continue;
                return true;
            }
        }
        return false;
    }

    public Object asKey(Class<?> clazz) {
        boolean bl2;
        block2: {
            JavaType[] javaTypeArray = this;
            javaTypeArray = this.e;
            int n2 = this.e.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                JavaType javaType = javaTypeArray[i2];
                if (!(javaType instanceof com.fasterxml.jackson.databind.type.a)) continue;
                bl2 = true;
                break block2;
            }
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        return new a(clazz, this.e, this.g);
    }

    public String toString() {
        if (this.e.length == 0) {
            return "<>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        int n2 = this.e.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaType javaType;
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            if ((javaType = this.e[i2]) == null) {
                stringBuilder.append("?");
                continue;
            }
            stringBuilder.append(javaType.getGenericSignature());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.g;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        object = (TypeBindings)object;
        return this.g == ((TypeBindings)object).g && Arrays.equals(this.e, ((TypeBindings)object).e);
    }

    protected JavaType[] typeParameterArray() {
        return this.e;
    }

    static final class a {
        private final Class<?> a;
        private final JavaType[] b;
        private final int c;

        public a(Class<?> clazz, JavaType[] javaTypeArray, int n2) {
            this.a = clazz;
            this.b = javaTypeArray;
            this.c = 31 * clazz.hashCode() + n2;
        }

        public final int hashCode() {
            return this.c;
        }

        public final boolean equals(Object javaTypeArray) {
            int n2;
            if (javaTypeArray == this) {
                return true;
            }
            if (javaTypeArray == null) {
                return false;
            }
            if (javaTypeArray.getClass() != this.getClass()) {
                return false;
            }
            javaTypeArray = (a)javaTypeArray;
            if (this.c == javaTypeArray.c && this.a == javaTypeArray.a && (n2 = this.b.length) == (javaTypeArray = javaTypeArray.b).length) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (Objects.equals(this.b[i2], javaTypeArray[i2])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public final String toString() {
            return this.a.getName() + "<>";
        }
    }

    static final class b {
        private static final TypeVariable<?>[] a = AbstractList.class.getTypeParameters();
        private static final TypeVariable<?>[] b = Collection.class.getTypeParameters();
        private static final TypeVariable<?>[] c = Iterable.class.getTypeParameters();
        private static final TypeVariable<?>[] d = List.class.getTypeParameters();
        private static final TypeVariable<?>[] e = ArrayList.class.getTypeParameters();
        private static final TypeVariable<?>[] f = Map.class.getTypeParameters();
        private static final TypeVariable<?>[] g = HashMap.class.getTypeParameters();
        private static final TypeVariable<?>[] h = LinkedHashMap.class.getTypeParameters();

        public static TypeVariable<?>[] a(Class<?> clazz) {
            if (clazz == Collection.class) {
                return b;
            }
            if (clazz == List.class) {
                return d;
            }
            if (clazz == ArrayList.class) {
                return e;
            }
            if (clazz == AbstractList.class) {
                return a;
            }
            if (clazz == Iterable.class) {
                return c;
            }
            return clazz.getTypeParameters();
        }

        public static TypeVariable<?>[] b(Class<?> clazz) {
            if (clazz == Map.class) {
                return f;
            }
            if (clazz == HashMap.class) {
                return g;
            }
            if (clazz == LinkedHashMap.class) {
                return h;
            }
            return clazz.getTypeParameters();
        }
    }
}

