/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.ClassStack;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.IterationType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.PlaceholderForType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.ResolvedRecursiveType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.databind.type.TypeParser;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.LookupCache;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class TypeFactory
implements Serializable {
    public static final int DEFAULT_MAX_CACHE_SIZE = 200;
    private static final JavaType[] a = new JavaType[0];
    protected static final TypeFactory instance = new TypeFactory();
    protected static final TypeBindings EMPTY_BINDINGS = TypeBindings.emptyBindings();
    private static final Class<?> b = String.class;
    private static final Class<?> c = Object.class;
    private static final Class<?> d = Comparable.class;
    private static final Class<?> e = Enum.class;
    private static final Class<?> f = JsonNode.class;
    private static final Class<?> g = Boolean.TYPE;
    private static final Class<?> h = Double.TYPE;
    private static final Class<?> i = Integer.TYPE;
    private static final Class<?> j = Long.TYPE;
    protected static final SimpleType CORE_TYPE_BOOL = new SimpleType(g);
    protected static final SimpleType CORE_TYPE_DOUBLE = new SimpleType(h);
    protected static final SimpleType CORE_TYPE_INT = new SimpleType(i);
    protected static final SimpleType CORE_TYPE_LONG = new SimpleType(j);
    protected static final SimpleType CORE_TYPE_STRING = new SimpleType(b);
    protected static final SimpleType CORE_TYPE_OBJECT = new SimpleType(c);
    protected static final SimpleType CORE_TYPE_COMPARABLE = new SimpleType(d);
    protected static final SimpleType CORE_TYPE_ENUM = new SimpleType(e);
    protected static final SimpleType CORE_TYPE_JSON_NODE = new SimpleType(f);
    protected final LookupCache<Object, JavaType> _typeCache;
    protected final TypeModifier[] _modifiers;
    protected final TypeParser _parser;
    protected final ClassLoader _classLoader;

    private TypeFactory() {
        this(new LRUMap<Object, JavaType>(16, 200));
    }

    protected TypeFactory(LookupCache<Object, JavaType> lookupCache) {
        this._typeCache = Objects.requireNonNull(lookupCache);
        this._parser = new TypeParser(this);
        this._modifiers = null;
        this._classLoader = null;
    }

    protected TypeFactory(LookupCache<Object, JavaType> lookupCache, TypeParser typeParser, TypeModifier[] typeModifierArray, ClassLoader classLoader) {
        if (lookupCache == null) {
            lookupCache = new LRUMap<Object, JavaType>(16, 200);
        }
        this._typeCache = lookupCache;
        this._parser = typeParser.withFactory(this);
        this._modifiers = typeModifierArray;
        this._classLoader = classLoader;
    }

    public TypeFactory withModifier(TypeModifier typeModifierArray) {
        LookupCache<Object, JavaType> lookupCache = this._typeCache;
        if (typeModifierArray == null) {
            typeModifierArray = null;
            lookupCache = null;
        } else if (this._modifiers == null) {
            typeModifierArray = new TypeModifier[]{typeModifierArray};
            lookupCache = null;
        } else {
            typeModifierArray = ArrayBuilders.insertInListNoDup(this._modifiers, typeModifierArray);
        }
        return new TypeFactory(lookupCache, this._parser, typeModifierArray, this._classLoader);
    }

    public TypeFactory withClassLoader(ClassLoader classLoader) {
        return new TypeFactory(this._typeCache, this._parser, this._modifiers, classLoader);
    }

    @Deprecated
    public TypeFactory withCache(LRUMap<Object, JavaType> lRUMap) {
        return new TypeFactory(lRUMap, this._parser, this._modifiers, this._classLoader);
    }

    public TypeFactory withCache(LookupCache<Object, JavaType> lookupCache) {
        return new TypeFactory(lookupCache, this._parser, this._modifiers, this._classLoader);
    }

    public static TypeFactory defaultInstance() {
        return instance;
    }

    public void clearCache() {
        this._typeCache.clear();
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public static JavaType unknownType() {
        return TypeFactory.defaultInstance()._unknownType();
    }

    public static Class<?> rawClass(Type type) {
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof JavaType) {
                return ((ResolvedType)((JavaType)type)).getRawClass();
            }
            if (type instanceof GenericArrayType) {
                return Array.newInstance(TypeFactory.rawClass(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
            }
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
                continue;
            }
            if (type instanceof TypeVariable) {
                type = ((TypeVariable)type).getBounds()[0];
                continue;
            }
            if (!(type instanceof WildcardType)) break;
            type = ((WildcardType)type).getUpperBounds()[0];
        }
        return ((ResolvedType)TypeFactory.defaultInstance().constructType(type)).getRawClass();
    }

    public Class<?> findClass(String string) {
        Serializable serializable;
        if (string.indexOf(46) < 0 && (serializable = this._findPrimitive(string)) != null) {
            return serializable;
        }
        serializable = null;
        Object object = this.getClassLoader();
        if (object == null) {
            object = Thread.currentThread().getContextClassLoader();
        }
        if (object != null) {
            try {
                return this.classForName(string, true, (ClassLoader)object);
            }
            catch (Exception exception) {
                object = exception;
                serializable = ClassUtil.getRootCause(exception);
            }
        }
        try {
            return this.classForName(string);
        }
        catch (Exception exception) {
            if (serializable == null) {
                serializable = ClassUtil.getRootCause(exception);
            }
            ClassUtil.throwIfRTE(serializable);
            throw new ClassNotFoundException(((Throwable)serializable).getMessage(), (Throwable)serializable);
        }
    }

    protected Class<?> classForName(String string, boolean bl2, ClassLoader classLoader) {
        return Class.forName(string, true, classLoader);
    }

    protected Class<?> classForName(String string) {
        return Class.forName(string);
    }

    protected Class<?> _findPrimitive(String string) {
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("long".equals(string)) {
            return Long.TYPE;
        }
        if ("float".equals(string)) {
            return Float.TYPE;
        }
        if ("double".equals(string)) {
            return Double.TYPE;
        }
        if ("boolean".equals(string)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        if ("char".equals(string)) {
            return Character.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("void".equals(string)) {
            return Void.TYPE;
        }
        return null;
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        return this.constructSpecializedType(javaType, clazz, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JavaType constructSpecializedType(JavaType javaType, Class<?> type, boolean bl2) {
        String string;
        String string2;
        JavaType[] javaTypeArray;
        JavaType javaType2;
        int n2;
        Type type2;
        boolean bl3;
        block18: {
            Class<?> clazz = ((ResolvedType)javaType).getRawClass();
            if (clazz == type) {
                return javaType;
            }
            if (clazz == Object.class) {
                type = this._fromClass(null, (Class<?>)type, EMPTY_BINDINGS);
                return ((JavaType)type).withHandlersFrom(javaType);
            }
            if (!clazz.isAssignableFrom((Class<?>)type)) {
                throw new IllegalArgumentException(String.format("Class %s not subtype of %s", ClassUtil.nameOf(type), ClassUtil.getTypeDescription(javaType)));
            }
            if (((ResolvedType)javaType).isContainerType()) {
                if (((ResolvedType)javaType).isMapLikeType()) {
                    if (type == HashMap.class || type == LinkedHashMap.class || type == EnumMap.class || type == TreeMap.class) {
                        Type type3 = type;
                        type = this._fromClass(null, (Class<?>)type3, TypeBindings.create(type3, javaType.getKeyType(), javaType.getContentType()));
                        return ((JavaType)type).withHandlersFrom(javaType);
                    }
                } else if (((ResolvedType)javaType).isCollectionLikeType()) {
                    if (type == ArrayList.class || type == LinkedList.class || type == HashSet.class || type == TreeSet.class) {
                        Type type4 = type;
                        type = this._fromClass(null, (Class<?>)type4, TypeBindings.create(type4, javaType.getContentType()));
                        return ((JavaType)type).withHandlersFrom(javaType);
                    }
                    if (clazz == EnumSet.class) {
                        return javaType;
                    }
                }
            }
            if (javaType.getBindings().isEmpty()) {
                type = this._fromClass(null, (Class<?>)type, EMPTY_BINDINGS);
                return ((JavaType)type).withHandlersFrom(javaType);
            }
            int n3 = ((Class)type).getTypeParameters().length;
            if (n3 == 0) {
                type = this._fromClass(null, (Class<?>)type, EMPTY_BINDINGS);
                return ((JavaType)type).withHandlersFrom(javaType);
            }
            bl3 = bl2;
            type2 = type;
            n2 = n3;
            javaType2 = javaType;
            TypeFactory typeFactory = this;
            javaTypeArray = new PlaceholderForType[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                javaTypeArray[i2] = new PlaceholderForType(i2);
            }
            Serializable serializable = TypeBindings.create(type2, javaTypeArray);
            serializable = typeFactory._fromClass(null, (Class<?>)type2, (TypeBindings)serializable);
            if ((serializable = ((JavaType)serializable).findSuperType(((ResolvedType)javaType2).getRawClass())) == null) {
                throw new IllegalArgumentException(String.format("Internal error: unable to locate supertype (%s) from resolved subtype %s", ((ResolvedType)javaType2).getRawClass().getName(), ((Class)type2).getName()));
            }
            Object object = serializable;
            serializable = javaType2;
            TypeFactory typeFactory2 = typeFactory;
            List<JavaType> list = ((JavaType)serializable).getBindings().getTypeParameters();
            object = ((JavaType)object).getBindings().getTypeParameters();
            int n4 = object.size();
            int n5 = list.size();
            for (int i3 = 0; i3 < n5; ++i3) {
                JavaType javaType3;
                JavaType javaType4 = list.get(i3);
                JavaType javaType5 = javaType3 = i3 < n4 ? (JavaType)object.get(i3) : TypeFactory.unknownType();
                if (typeFactory2.a(javaType4, javaType3) || ((ResolvedType)javaType4).hasRawClass(Object.class) || i3 == 0 && ((ResolvedType)((Object)serializable)).isMapLikeType() && ((ResolvedType)javaType3).hasRawClass(Object.class) || ((ResolvedType)javaType4).isInterface() && javaType4.isTypeOrSuperTypeOf(((ResolvedType)javaType3).getRawClass())) continue;
                string2 = String.format("Type parameter #%d/%d differs; can not specialize %s with %s", i3 + 1, n5, javaType4.toCanonical(), javaType3.toCanonical());
                break block18;
            }
            string2 = string = null;
        }
        if (string2 != null && !bl3) {
            throw new IllegalArgumentException("Failed to specialize base type " + javaType2.toCanonical() + " as " + ((Class)type2).getName() + ", problem: " + string);
        }
        JavaType[] javaTypeArray2 = new JavaType[n2];
        for (int i4 = 0; i4 < n2; ++i4) {
            JavaType javaType6 = ((PlaceholderForType)javaTypeArray[i4]).actualType();
            if (javaType6 == null) {
                javaType6 = TypeFactory.unknownType();
            }
            javaTypeArray2[i4] = javaType6;
        }
        TypeBindings typeBindings = TypeBindings.create(type2, javaTypeArray2);
        type = this._fromClass(null, (Class<?>)type, typeBindings);
        return ((JavaType)type).withHandlersFrom(javaType);
    }

    private boolean a(JavaType object, JavaType object2) {
        if (object2 instanceof PlaceholderForType) {
            ((PlaceholderForType)object2).actualType((JavaType)object);
            return true;
        }
        if (((ResolvedType)object).getRawClass() != ((ResolvedType)object2).getRawClass()) {
            return false;
        }
        object = ((JavaType)object).getBindings().getTypeParameters();
        object2 = ((JavaType)object2).getBindings().getTypeParameters();
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaType javaType;
            JavaType javaType2 = (JavaType)object.get(i2);
            if (this.a(javaType2, javaType = (JavaType)object2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public JavaType constructGeneralizedType(JavaType javaType, Class<?> clazz) {
        Class<?> clazz2 = ((ResolvedType)javaType).getRawClass();
        if (clazz2 == clazz) {
            return javaType;
        }
        JavaType javaType2 = javaType.findSuperType(clazz);
        if (javaType2 == null) {
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException(String.format("Class %s not a super-type of %s", clazz.getName(), javaType));
            }
            throw new IllegalArgumentException(String.format("Internal error: class %s not included as super-type for %s", clazz.getName(), javaType));
        }
        return javaType2;
    }

    public JavaType constructFromCanonical(String string) {
        return this._parser.parse(string);
    }

    public JavaType[] findTypeParameters(JavaType javaType, Class<?> clazz) {
        if ((javaType = javaType.findSuperType(clazz)) == null) {
            return a;
        }
        return javaType.getBindings().typeParameterArray();
    }

    public JavaType findFirstTypeParameter(JavaType javaType, Class<?> clazz) {
        if ((javaType = javaType.findSuperType(clazz)) != null && (javaType = javaType.getBindings().getBoundTypeOrNull(0)) != null) {
            return javaType;
        }
        return this._unknownType();
    }

    @Deprecated
    public JavaType[] findTypeParameters(Class<?> clazz, Class<?> clazz2, TypeBindings typeBindings) {
        TypeFactory typeFactory = this;
        return typeFactory.findTypeParameters(typeFactory.constructType(clazz, typeBindings), clazz2);
    }

    @Deprecated
    public JavaType[] findTypeParameters(Class<?> clazz, Class<?> clazz2) {
        TypeFactory typeFactory = this;
        return typeFactory.findTypeParameters(typeFactory.constructType(clazz), clazz2);
    }

    public JavaType moreSpecificType(JavaType javaType, JavaType javaType2) {
        Class<?> clazz;
        if (javaType == null) {
            return javaType2;
        }
        if (javaType2 == null) {
            return javaType;
        }
        Class<?> clazz2 = ((ResolvedType)javaType).getRawClass();
        if (clazz2 == (clazz = ((ResolvedType)javaType2).getRawClass())) {
            return javaType;
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return javaType2;
        }
        return javaType;
    }

    public JavaType constructType(Type type) {
        return this._fromAny(null, type, EMPTY_BINDINGS);
    }

    public JavaType constructType(TypeReference<?> typeReference) {
        return this._fromAny(null, typeReference.getType(), EMPTY_BINDINGS);
    }

    public JavaType resolveMemberType(Type type, TypeBindings typeBindings) {
        return this._fromAny(null, type, typeBindings);
    }

    @Deprecated
    public JavaType constructType(Type type, TypeBindings serializable) {
        if (type instanceof Class) {
            serializable = this._fromClass(null, (Class)type, (TypeBindings)serializable);
            return this._applyModifiers(type, (JavaType)serializable);
        }
        return this._fromAny(null, type, (TypeBindings)serializable);
    }

    @Deprecated
    public JavaType constructType(Type type, Class<?> clazz) {
        clazz = clazz == null ? null : this.constructType(clazz);
        return this.constructType(type, (JavaType)((Object)clazz));
    }

    @Deprecated
    public JavaType constructType(Type type, JavaType javaType) {
        TypeBindings typeBindings;
        if (javaType == null) {
            typeBindings = EMPTY_BINDINGS;
        } else {
            typeBindings = javaType.getBindings();
            if (type.getClass() != Class.class) {
                while (typeBindings.isEmpty() && (javaType = javaType.getSuperClass()) != null) {
                    typeBindings = javaType.getBindings();
                }
            }
        }
        return this._fromAny(null, type, typeBindings);
    }

    public ArrayType constructArrayType(Class<?> clazz) {
        return ArrayType.construct(this._fromAny(null, clazz, null), null);
    }

    public ArrayType constructArrayType(JavaType javaType) {
        return ArrayType.construct(javaType, null);
    }

    public CollectionType constructCollectionType(Class<? extends Collection> clazz, Class<?> clazz2) {
        return this.constructCollectionType(clazz, this._fromClass(null, clazz2, EMPTY_BINDINGS));
    }

    public CollectionType constructCollectionType(Class<? extends Collection> clazz, JavaType javaType) {
        Serializable serializable = TypeBindings.createIfNeeded(clazz, javaType);
        CollectionType collectionType = (CollectionType)this._fromClass(null, clazz, (TypeBindings)serializable);
        if (serializable.isEmpty() && javaType != null) {
            serializable = ((JavaType)collectionType).findSuperType(Collection.class);
            if (!((JavaType)(serializable = ((JavaType)serializable).getContentType())).equals(javaType)) {
                throw new IllegalArgumentException(String.format("Non-generic Collection class %s did not resolve to something with element type %s but %s ", ClassUtil.nameOf(clazz), javaType, serializable));
            }
        }
        return collectionType;
    }

    public CollectionLikeType constructCollectionLikeType(Class<?> clazz, Class<?> clazz2) {
        return this.constructCollectionLikeType(clazz, this._fromClass(null, clazz2, EMPTY_BINDINGS));
    }

    public CollectionLikeType constructCollectionLikeType(Class<?> type, JavaType javaType) {
        Class<?> clazz = type;
        type = this._fromClass(null, clazz, TypeBindings.createIfNeeded(clazz, javaType));
        if (type instanceof CollectionLikeType) {
            return (CollectionLikeType)type;
        }
        return CollectionLikeType.upgradeFrom(type, javaType);
    }

    public MapType constructMapType(Class<? extends Map> clazz, Class<?> type, Class<?> type2) {
        if (clazz == Properties.class) {
            type2 = CORE_TYPE_STRING;
            type = type2;
        } else {
            type = this._fromClass(null, (Class<?>)type, EMPTY_BINDINGS);
            type2 = this._fromClass(null, (Class<?>)type2, EMPTY_BINDINGS);
        }
        return this.constructMapType(clazz, (JavaType)type, (JavaType)type2);
    }

    public MapType constructMapType(Class<? extends Map> clazz, JavaType javaType, JavaType javaType2) {
        Serializable serializable = TypeBindings.createIfNeeded(clazz, new JavaType[]{javaType, javaType2});
        MapType mapType = (MapType)this._fromClass(null, clazz, (TypeBindings)serializable);
        if (((TypeBindings)serializable).isEmpty()) {
            serializable = ((JavaType)mapType).findSuperType(Map.class);
            JavaType javaType3 = ((JavaType)serializable).getKeyType();
            if (!javaType3.equals(javaType)) {
                throw new IllegalArgumentException(String.format("Non-generic Map class %s did not resolve to something with key type %s but %s ", ClassUtil.nameOf(clazz), javaType, javaType3));
            }
            javaType = ((JavaType)serializable).getContentType();
            if (!javaType.equals(javaType2)) {
                throw new IllegalArgumentException(String.format("Non-generic Map class %s did not resolve to something with value type %s but %s ", ClassUtil.nameOf(clazz), javaType2, javaType));
            }
        }
        return mapType;
    }

    public MapLikeType constructMapLikeType(Class<?> clazz, Class<?> clazz2, Class<?> clazz3) {
        return this.constructMapLikeType(clazz, this._fromClass(null, clazz2, EMPTY_BINDINGS), this._fromClass(null, clazz3, EMPTY_BINDINGS));
    }

    public MapLikeType constructMapLikeType(Class<?> type, JavaType javaType, JavaType javaType2) {
        Class<?> clazz = type;
        type = this._fromClass(null, clazz, TypeBindings.createIfNeeded(clazz, new JavaType[]{javaType, javaType2}));
        if (type instanceof MapLikeType) {
            return (MapLikeType)type;
        }
        return MapLikeType.upgradeFrom(type, javaType, javaType2);
    }

    public JavaType constructSimpleType(Class<?> clazz, JavaType[] javaTypeArray) {
        Class<?> clazz2 = clazz;
        return this._fromClass(null, clazz2, TypeBindings.create(clazz2, javaTypeArray));
    }

    @Deprecated
    public JavaType constructSimpleType(Class<?> clazz, Class<?> clazz2, JavaType[] javaTypeArray) {
        return this.constructSimpleType(clazz, javaTypeArray);
    }

    public JavaType constructReferenceType(Class<?> clazz, JavaType javaType) {
        Class<?> clazz2 = clazz;
        return ReferenceType.construct(clazz2, TypeBindings.create(clazz2, javaType), null, null, javaType);
    }

    @Deprecated
    public JavaType uncheckedSimpleType(Class<?> clazz) {
        return this._constructSimple(clazz, EMPTY_BINDINGS, null, null);
    }

    public JavaType constructParametricType(Class<?> clazz, Class<?> ... classArray) {
        int n2 = classArray.length;
        JavaType[] javaTypeArray = new JavaType[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            javaTypeArray[i2] = this._fromClass(null, classArray[i2], EMPTY_BINDINGS);
        }
        return this.constructParametricType(clazz, javaTypeArray);
    }

    public JavaType constructParametricType(Class<?> clazz, JavaType ... javaTypeArray) {
        Class<?> clazz2 = clazz;
        return this.constructParametricType(clazz2, TypeBindings.create(clazz2, javaTypeArray));
    }

    public JavaType constructParametricType(Class<?> clazz, TypeBindings serializable) {
        serializable = this._fromClass(null, clazz, (TypeBindings)serializable);
        return this._applyModifiers(clazz, (JavaType)serializable);
    }

    @Deprecated
    public JavaType constructParametrizedType(Class<?> clazz, Class<?> clazz2, JavaType ... javaTypeArray) {
        return this.constructParametricType(clazz, javaTypeArray);
    }

    @Deprecated
    public JavaType constructParametrizedType(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        return this.constructParametricType(clazz, classArray);
    }

    public CollectionType constructRawCollectionType(Class<? extends Collection> clazz) {
        return this.constructCollectionType(clazz, TypeFactory.unknownType());
    }

    public CollectionLikeType constructRawCollectionLikeType(Class<?> clazz) {
        return this.constructCollectionLikeType(clazz, TypeFactory.unknownType());
    }

    public MapType constructRawMapType(Class<? extends Map> clazz) {
        return this.constructMapType(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    public MapLikeType constructRawMapLikeType(Class<?> clazz) {
        return this.constructMapLikeType(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    private static JavaType a(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray, JavaType javaType2) {
        return IterationType.construct(clazz, typeBindings, javaType, javaTypeArray, javaType2);
    }

    protected JavaType _constructSimple(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        JavaType javaType2;
        if (typeBindings.isEmpty() && (javaType2 = this._findWellKnownSimple(clazz)) != null) {
            return javaType2;
        }
        return this._newSimpleType(clazz, typeBindings, javaType, javaTypeArray);
    }

    protected JavaType _newSimpleType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        return new SimpleType(clazz, typeBindings, javaType, javaTypeArray);
    }

    protected JavaType _unknownType() {
        return CORE_TYPE_OBJECT;
    }

    protected JavaType _findWellKnownSimple(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == g) {
                return CORE_TYPE_BOOL;
            }
            if (clazz == i) {
                return CORE_TYPE_INT;
            }
            if (clazz == j) {
                return CORE_TYPE_LONG;
            }
            if (clazz == h) {
                return CORE_TYPE_DOUBLE;
            }
        } else {
            if (clazz == b) {
                return CORE_TYPE_STRING;
            }
            if (clazz == c) {
                return CORE_TYPE_OBJECT;
            }
            if (clazz == f) {
                return CORE_TYPE_JSON_NODE;
            }
        }
        return null;
    }

    protected JavaType _fromAny(ClassStack object, Type type, TypeBindings typeBindings) {
        if (type instanceof Class) {
            object = this._fromClass((ClassStack)object, (Class)type, EMPTY_BINDINGS);
        } else if (type instanceof ParameterizedType) {
            object = this._fromParamType((ClassStack)object, (ParameterizedType)type, typeBindings);
        } else {
            if (type instanceof JavaType) {
                return (JavaType)type;
            }
            if (type instanceof GenericArrayType) {
                object = this._fromArrayType((ClassStack)object, (GenericArrayType)type, typeBindings);
            } else if (type instanceof TypeVariable) {
                object = this._fromVariable((ClassStack)object, (TypeVariable)type, typeBindings);
            } else if (type instanceof WildcardType) {
                object = this._fromWildcard((ClassStack)object, (WildcardType)type, typeBindings);
            } else {
                throw new IllegalArgumentException("Unrecognized Type: " + (type == null ? "[null]" : type.toString()));
            }
        }
        return this._applyModifiers(type, (JavaType)object);
    }

    protected JavaType _applyModifiers(Type type, JavaType javaType) {
        if (this._modifiers == null) {
            return javaType;
        }
        TypeBindings typeBindings = javaType.getBindings();
        if (typeBindings == null) {
            typeBindings = EMPTY_BINDINGS;
        }
        TypeModifier[] typeModifierArray = this._modifiers;
        int n2 = this._modifiers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeModifier typeModifier = typeModifierArray[i2];
            JavaType javaType2 = typeModifier.modifyType(javaType, type, typeBindings, this);
            if (javaType2 == null) {
                throw new IllegalStateException(String.format("TypeModifier %s (of type %s) return null for type %s", typeModifier, typeModifier.getClass().getName(), javaType));
            }
            javaType = javaType2;
        }
        return javaType;
    }

    protected JavaType _fromClass(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings) {
        Object object;
        JavaType javaType = this._findWellKnownSimple(clazz);
        if (javaType != null) {
            return javaType;
        }
        Object object2 = typeBindings == null || typeBindings.isEmpty() ? clazz : typeBindings.asKey(clazz);
        javaType = object2 == null ? null : this._typeCache.get(object2);
        if (javaType != null) {
            return javaType;
        }
        if (classStack == null) {
            classStack = new ClassStack(clazz);
        } else {
            object = classStack.find(clazz);
            if (object != null) {
                ResolvedRecursiveType resolvedRecursiveType = new ResolvedRecursiveType(clazz, EMPTY_BINDINGS);
                ((ClassStack)object).addSelfReference(resolvedRecursiveType);
                return resolvedRecursiveType;
            }
            classStack = classStack.child(clazz);
        }
        if (clazz.isArray()) {
            javaType = ArrayType.construct(this._fromAny(classStack, clazz.getComponentType(), typeBindings), typeBindings);
        } else {
            JavaType[] javaTypeArray;
            if (clazz.isInterface()) {
                object = null;
                javaTypeArray = this._resolveSuperInterfaces(classStack, clazz, typeBindings);
            } else {
                object = this._resolveSuperClass(classStack, clazz, typeBindings);
                javaTypeArray = this._resolveSuperInterfaces(classStack, clazz, typeBindings);
            }
            if (clazz == Properties.class) {
                SimpleType simpleType = CORE_TYPE_STRING;
                javaType = MapType.construct(clazz, typeBindings, (JavaType)object, javaTypeArray, simpleType, simpleType);
            } else if (object != null) {
                javaType = ((JavaType)object).refine(clazz, typeBindings, (JavaType)object, javaTypeArray);
            }
            if (javaType == null && (javaType = this._fromWellKnownClass(classStack, clazz, typeBindings, (JavaType)object, javaTypeArray)) == null && (javaType = this._fromWellKnownInterface(classStack, clazz, typeBindings, (JavaType)object, javaTypeArray)) == null) {
                javaType = this._newSimpleType(clazz, typeBindings, (JavaType)object, javaTypeArray);
            }
        }
        classStack.resolveSelfReferences(javaType);
        if (object2 != null && !javaType.hasHandlers()) {
            this._typeCache.putIfAbsent(object2, javaType);
        }
        return javaType;
    }

    protected JavaType _resolveSuperClass(ClassStack classStack, Class<?> type, TypeBindings typeBindings) {
        if ((type = ClassUtil.getGenericSuperclass(type)) == null) {
            return null;
        }
        return this._fromAny(classStack, type, typeBindings);
    }

    protected JavaType[] _resolveSuperInterfaces(ClassStack classStack, Class<?> typeArray, TypeBindings typeBindings) {
        if ((typeArray = ClassUtil.getGenericInterfaces(typeArray)) == null || typeArray.length == 0) {
            return a;
        }
        int n2 = typeArray.length;
        JavaType[] javaTypeArray = new JavaType[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type = typeArray[i2];
            javaTypeArray[i2] = this._fromAny(classStack, type, typeBindings);
        }
        return javaTypeArray;
    }

    protected JavaType _fromWellKnownClass(ClassStack object, Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        if (typeBindings == null) {
            typeBindings = EMPTY_BINDINGS;
        }
        if (clazz == Map.class) {
            JavaType javaType2;
            object = this;
            if (clazz == Properties.class) {
                object = CORE_TYPE_STRING;
                javaType2 = object;
            } else {
                List<JavaType> list = typeBindings.getTypeParameters();
                int n2 = list.size();
                switch (n2) {
                    case 0: {
                        object = ((TypeFactory)object)._unknownType();
                        javaType2 = object;
                        break;
                    }
                    case 2: {
                        javaType2 = list.get(0);
                        object = list.get(1);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Strange Map type %s with %d type parameter%s (%s), can not resolve", ClassUtil.nameOf(clazz), n2, n2 == 1 ? "" : "s", typeBindings));
                    }
                }
            }
            return MapType.construct(clazz, typeBindings, javaType, javaTypeArray, javaType2, (JavaType)object);
        }
        if (clazz == Collection.class) {
            object = this;
            List<JavaType> list = typeBindings.getTypeParameters();
            if (list.isEmpty()) {
                object = ((TypeFactory)object)._unknownType();
            } else if (list.size() == 1) {
                object = list.get(0);
            } else {
                throw new IllegalArgumentException("Strange Collection type " + clazz.getName() + ": cannot determine type parameters");
            }
            return CollectionType.construct(clazz, typeBindings, javaType, javaTypeArray, (JavaType)object);
        }
        if (clazz == AtomicReference.class) {
            object = this;
            List<JavaType> list = typeBindings.getTypeParameters();
            if (list.isEmpty()) {
                object = ((TypeFactory)object)._unknownType();
            } else if (list.size() == 1) {
                object = list.get(0);
            } else {
                throw new IllegalArgumentException("Strange Reference type " + clazz.getName() + ": cannot determine type parameters");
            }
            return ReferenceType.construct(clazz, typeBindings, javaType, javaTypeArray, (JavaType)object);
        }
        if (clazz == Iterator.class || clazz == Stream.class) {
            object = this;
            List<JavaType> list = typeBindings.getTypeParameters();
            if (list.isEmpty()) {
                object = ((TypeFactory)object)._unknownType();
            } else if (list.size() == 1) {
                object = list.get(0);
            } else {
                throw new IllegalArgumentException("Strange Iteration type " + clazz.getName() + ": cannot determine type parameters");
            }
            return TypeFactory.a(clazz, (TypeBindings)typeBindings, (JavaType)javaType, (JavaType[])javaTypeArray, (JavaType)object);
        }
        if (BaseStream.class.isAssignableFrom(clazz)) {
            if (DoubleStream.class.isAssignableFrom(clazz)) {
                return TypeFactory.a(clazz, (TypeBindings)typeBindings, (JavaType)javaType, (JavaType[])javaTypeArray, (JavaType)CORE_TYPE_DOUBLE);
            }
            if (IntStream.class.isAssignableFrom(clazz)) {
                return TypeFactory.a(clazz, (TypeBindings)typeBindings, (JavaType)javaType, (JavaType[])javaTypeArray, (JavaType)CORE_TYPE_INT);
            }
            if (LongStream.class.isAssignableFrom(clazz)) {
                return TypeFactory.a(clazz, (TypeBindings)typeBindings, (JavaType)javaType, (JavaType[])javaTypeArray, (JavaType)CORE_TYPE_LONG);
            }
        }
        return null;
    }

    protected JavaType _fromWellKnownInterface(ClassStack classStack, Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        int n2 = javaTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaType javaType2 = javaTypeArray[i2].refine(clazz, typeBindings, javaType, javaTypeArray);
            if (javaType2 == null) continue;
            return javaType2;
        }
        return null;
    }

    protected JavaType _fromParamType(ClassStack classStack, ParameterizedType object, TypeBindings typeBindings) {
        Class clazz = (Class)object.getRawType();
        if (clazz == e) {
            return CORE_TYPE_ENUM;
        }
        if (clazz == d) {
            return CORE_TYPE_COMPARABLE;
        }
        int n2 = (object = object.getActualTypeArguments()) == null ? 0 : ((Type[])object).length;
        if (n2 == 0) {
            object = EMPTY_BINDINGS;
        } else {
            JavaType[] javaTypeArray = new JavaType[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                javaTypeArray[i2] = this._fromAny(classStack, object[i2], typeBindings);
            }
            object = TypeBindings.create(clazz, javaTypeArray);
        }
        return this._fromClass(classStack, clazz, (TypeBindings)object);
    }

    protected JavaType _fromArrayType(ClassStack object, GenericArrayType genericArrayType, TypeBindings typeBindings) {
        object = this._fromAny((ClassStack)object, genericArrayType.getGenericComponentType(), typeBindings);
        return ArrayType.construct((JavaType)object, typeBindings);
    }

    protected JavaType _fromVariable(ClassStack classStack, TypeVariable<?> typeArray, TypeBindings typeBindings) {
        Object object = typeArray.getName();
        if (typeBindings == null) {
            throw new IllegalArgumentException("Null `bindings` passed (type variable \"" + (String)object + "\")");
        }
        JavaType javaType = typeBindings.findBoundType((String)object);
        if (javaType != null) {
            return javaType;
        }
        if (typeBindings.hasUnbound((String)object)) {
            return CORE_TYPE_OBJECT;
        }
        typeBindings = typeBindings.withUnboundVariable((String)object);
        object = typeArray;
        synchronized (typeArray) {
            typeArray = typeArray.getBounds();
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return this._fromAny(classStack, typeArray[0], typeBindings);
        }
    }

    protected JavaType _fromWildcard(ClassStack classStack, WildcardType wildcardType, TypeBindings typeBindings) {
        return this._fromAny(classStack, wildcardType.getUpperBounds()[0], typeBindings);
    }
}

