/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TypeParser
implements Serializable {
    protected static final int MAX_TYPE_LENGTH = 64000;
    protected static final int MAX_TYPE_NESTING = 1000;
    protected final TypeFactory _factory;

    public TypeParser(TypeFactory typeFactory) {
        this._factory = typeFactory;
    }

    public TypeParser withFactory(TypeFactory typeFactory) {
        if (typeFactory == this._factory) {
            return this;
        }
        return new TypeParser(typeFactory);
    }

    public JavaType parse(String object) {
        if (((String)object).length() > 64000) {
            throw new IllegalArgumentException(String.format("Failed to parse type %s: too long (%d characters), maximum length allowed: %d", TypeParser.a((String)object), ((String)object).length(), 64000));
        }
        object = new a(((String)object).trim());
        JavaType javaType = this.parseType((a)object, 1000);
        if (((a)object).hasMoreTokens()) {
            throw this._problem((a)object, "Unexpected tokens after complete type");
        }
        return javaType;
    }

    protected JavaType parseType(a object, int n2) {
        if (!((a)object).hasMoreTokens()) {
            throw this._problem((a)object, "Unexpected end-of-string");
        }
        Class<?> clazz = this.findClass(((a)object).nextToken(), (a)object);
        if (((a)object).hasMoreTokens()) {
            String string = ((a)object).nextToken();
            if ("<".equals(string)) {
                object = this.parseTypes((a)object, n2 - 1);
                object = TypeBindings.create(clazz, (List<JavaType>)object);
                return this._factory._fromClass(null, clazz, (TypeBindings)object);
            }
            ((a)object).a(string);
        }
        return this._factory._fromClass(null, clazz, TypeBindings.emptyBindings());
    }

    protected List<JavaType> parseTypes(a a2, int n2) {
        if (n2 < 0) {
            throw this._problem(a2, "too deeply nested; exceeds maximum of 1000 nesting levels");
        }
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        while (a2.hasMoreTokens()) {
            arrayList.add(this.parseType(a2, n2));
            if (!a2.hasMoreTokens()) break;
            String string = a2.nextToken();
            if (">".equals(string)) {
                return arrayList;
            }
            if (",".equals(string)) continue;
            throw this._problem(a2, "Unexpected token '" + string + "', expected ',' or '>')");
        }
        throw this._problem(a2, "Unexpected end-of-string");
    }

    protected Class<?> findClass(String string, a a2) {
        try {
            return this._factory.findClass(string);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ClassUtil.throwIfRTE(exception);
            throw this._problem(a2, "Cannot locate class '" + string + "', problem: " + exception2.getMessage());
        }
    }

    protected IllegalArgumentException _problem(a a2, String string) {
        return new IllegalArgumentException(String.format("Failed to parse type %s (remaining: %s): %s", TypeParser.a(a2.a()), TypeParser.a(a2.b()), string));
    }

    private static String a(String string) {
        if (string.length() <= 1000) {
            return "'" + string + "'";
        }
        return String.format("'%s...'[truncated %d charaters]", string.substring(0, 1000), string.length() - 1000);
    }

    static final class a
    extends StringTokenizer {
        private String a;
        private int b;
        private String c;

        public a(String string) {
            super(string, "<,>", true);
            this.a = string;
        }

        @Override
        public final boolean hasMoreTokens() {
            return this.c != null || super.hasMoreTokens();
        }

        @Override
        public final String nextToken() {
            String string;
            if (this.c != null) {
                string = this.c;
                this.c = null;
            } else {
                string = super.nextToken();
                this.b += string.length();
                string = string.trim();
            }
            return string;
        }

        public final void a(String string) {
            this.c = string;
        }

        public final String a() {
            return this.a;
        }

        public final String b() {
            return this.a.substring(this.b);
        }
    }
}

