/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;
import java.lang.reflect.Array;
import java.util.HashSet;

public final class ArrayBuilders {
    private BooleanBuilder a = null;
    private ByteBuilder b = null;
    private ShortBuilder c = null;
    private IntBuilder d = null;
    private LongBuilder e = null;
    private FloatBuilder f = null;
    private DoubleBuilder g = null;

    public final BooleanBuilder getBooleanBuilder() {
        if (this.a == null) {
            this.a = new BooleanBuilder();
        }
        return this.a;
    }

    public final ByteBuilder getByteBuilder() {
        if (this.b == null) {
            this.b = new ByteBuilder();
        }
        return this.b;
    }

    public final ShortBuilder getShortBuilder() {
        if (this.c == null) {
            this.c = new ShortBuilder();
        }
        return this.c;
    }

    public final IntBuilder getIntBuilder() {
        if (this.d == null) {
            this.d = new IntBuilder();
        }
        return this.d;
    }

    public final LongBuilder getLongBuilder() {
        if (this.e == null) {
            this.e = new LongBuilder();
        }
        return this.e;
    }

    public final FloatBuilder getFloatBuilder() {
        if (this.f == null) {
            this.f = new FloatBuilder();
        }
        return this.f;
    }

    public final DoubleBuilder getDoubleBuilder() {
        if (this.g == null) {
            this.g = new DoubleBuilder();
        }
        return this.g;
    }

    public static Object getArrayComparator(Object object) {
        int n2 = Array.getLength(object);
        Class<?> clazz = object.getClass();
        return new Object(clazz, n2, object){
            private /* synthetic */ Class a;
            private /* synthetic */ int b;
            private /* synthetic */ Object c;
            {
                this.a = clazz;
                this.b = n2;
                this.c = object;
            }

            public final boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!ClassUtil.hasClass(object, this.a)) {
                    return false;
                }
                if (Array.getLength(object) != this.b) {
                    return false;
                }
                for (int i2 = 0; i2 < this.b; ++i2) {
                    Object object2;
                    Object object3 = Array.get(this.c, i2);
                    if (object3 == (object2 = Array.get(object, i2)) || object3 == null || object3.equals(object2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> HashSet<T> arrayToSet(T[] TArray) {
        if (TArray != null) {
            int n2 = TArray.length;
            HashSet<T> hashSet = new HashSet<T>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                hashSet.add(TArray[i2]);
            }
            return hashSet;
        }
        return new HashSet();
    }

    public static <T> T[] insertInListNoDup(T[] TArray, T t2) {
        int n2 = TArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (TArray[i2] != t2) continue;
            if (i2 == 0) {
                return TArray;
            }
            Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2);
            System.arraycopy(TArray, 0, objectArray, 1, i2);
            objectArray[0] = t2;
            int n3 = n2 - ++i2;
            if (n3 > 0) {
                System.arraycopy(TArray, i2, objectArray, i2, n3);
            }
            return objectArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2 + 1);
        if (n2 > 0) {
            System.arraycopy(TArray, 0, objectArray, 1, n2);
        }
        objectArray[0] = t2;
        return objectArray;
    }

    public static final class DoubleBuilder
    extends PrimitiveArrayBuilder<double[]> {
        @Override
        public final double[] _constructArray(int n2) {
            return new double[n2];
        }
    }

    public static final class FloatBuilder
    extends PrimitiveArrayBuilder<float[]> {
        @Override
        public final float[] _constructArray(int n2) {
            return new float[n2];
        }
    }

    public static final class LongBuilder
    extends PrimitiveArrayBuilder<long[]> {
        @Override
        public final long[] _constructArray(int n2) {
            return new long[n2];
        }
    }

    public static final class IntBuilder
    extends PrimitiveArrayBuilder<int[]> {
        @Override
        public final int[] _constructArray(int n2) {
            return new int[n2];
        }
    }

    public static final class ShortBuilder
    extends PrimitiveArrayBuilder<short[]> {
        @Override
        public final short[] _constructArray(int n2) {
            return new short[n2];
        }
    }

    public static final class ByteBuilder
    extends PrimitiveArrayBuilder<byte[]> {
        @Override
        public final byte[] _constructArray(int n2) {
            return new byte[n2];
        }
    }

    public static final class BooleanBuilder
    extends PrimitiveArrayBuilder<boolean[]> {
        @Override
        public final boolean[] _constructArray(int n2) {
            return new boolean[n2];
        }
    }
}

