/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BeanUtil {
    @Deprecated
    public static String okNameForGetter(AnnotatedMethod annotatedMethod, boolean bl2) {
        String string = ((Annotated)annotatedMethod).getName();
        String string2 = BeanUtil.okNameForIsGetter(annotatedMethod, string, bl2);
        if (string2 == null) {
            string2 = BeanUtil.okNameForRegularGetter(annotatedMethod, string, bl2);
        }
        return string2;
    }

    @Deprecated
    public static String okNameForRegularGetter(AnnotatedMethod annotatedMethod, String string, boolean bl2) {
        if (string.startsWith("get")) {
            if ("getCallbacks".equals(string) ? BeanUtil.isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && BeanUtil.isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            if (bl2) {
                return BeanUtil.stdManglePropertyName(string, 3);
            }
            return BeanUtil.legacyManglePropertyName(string, 3);
        }
        return null;
    }

    @Deprecated
    public static String okNameForIsGetter(AnnotatedMethod serializable, String string, boolean bl2) {
        if (string.startsWith("is") && ((serializable = ((Annotated)((Object)serializable)).getRawType()) == Boolean.class || serializable == Boolean.TYPE)) {
            if (bl2) {
                return BeanUtil.stdManglePropertyName(string, 2);
            }
            return BeanUtil.legacyManglePropertyName(string, 2);
        }
        return null;
    }

    @Deprecated
    public static String okNameForSetter(AnnotatedMethod annotatedMethod, boolean bl2) {
        return BeanUtil.okNameForMutator(annotatedMethod, "set", bl2);
    }

    @Deprecated
    public static String okNameForMutator(AnnotatedMethod object, String string, boolean bl2) {
        if (((String)(object = ((Annotated)object).getName())).startsWith(string)) {
            if (bl2) {
                return BeanUtil.stdManglePropertyName((String)object, string.length());
            }
            return BeanUtil.legacyManglePropertyName((String)object, string.length());
        }
        return null;
    }

    public static Object getDefaultValue(JavaType serializable) {
        Class<?> clazz = ((ResolvedType)((Object)serializable)).getRawClass();
        Class<?> clazz2 = ClassUtil.primitiveType(clazz);
        if (clazz2 != null) {
            return ClassUtil.defaultValue(clazz2);
        }
        if (((ResolvedType)((Object)serializable)).isContainerType() || serializable.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (clazz == String.class) {
            return "";
        }
        if (serializable.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (serializable.isTypeOrSubTypeOf(Calendar.class)) {
            serializable = new GregorianCalendar();
            ((Calendar)serializable).setTimeInMillis(0L);
            return serializable;
        }
        return null;
    }

    protected static boolean isCglibGetCallbacks(AnnotatedMethod object) {
        if (((Class)(object = ((Annotated)object).getRawType())).isArray()) {
            object = ((Class)object).getComponentType();
            if (((String)(object = ((Class)object).getName())).contains(".cglib")) {
                return ((String)object).startsWith("net.sf.cglib") || ((String)object).startsWith("org.hibernate.repackage.cglib") || ((String)object).startsWith("org.springframework.cglib");
            }
        }
        return false;
    }

    protected static boolean isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        return ((Annotated)annotatedMethod).getRawType().getName().startsWith("groovy.lang");
    }

    protected static String legacyManglePropertyName(String string, int n2) {
        char c2;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c3 = string.charAt(n2);
        if (c3 == (c2 = Character.toLowerCase(c3))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c2);
        ++n2;
        while (n2 < n3) {
            c3 = string.charAt(n2);
            if (c3 == (c2 = Character.toLowerCase(c3))) {
                stringBuilder.append(string, n2, n3);
                break;
            }
            stringBuilder.append(c2);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String stdManglePropertyName(String string, int n2) {
        char c2;
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c3 = string.charAt(n2);
        if (c3 == (c2 = Character.toLowerCase(c3))) {
            return string.substring(n2);
        }
        if (n2 + 1 < n3 && Character.isUpperCase(string.charAt(n2 + 1))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c2);
        stringBuilder.append(string, n2 + 1, n3);
        return stringBuilder.toString();
    }

    public static String checkUnsupportedType(JavaType javaType) {
        String string;
        String string2 = string = ((ResolvedType)javaType).getRawClass().getName();
        if (string.startsWith("java.time.")) {
            if (string.indexOf(46, 10) >= 0) {
                return null;
            }
            if (javaType.isTypeOrSubTypeOf(Throwable.class)) {
                return null;
            }
            string = "Java 8 date/time";
            string2 = "com.fasterxml.jackson.datatype:jackson-datatype-jsr310";
        } else {
            string2 = string;
            if (string2.startsWith("org.joda.time.")) {
                string = "Joda date/time";
                string2 = "com.fasterxml.jackson.datatype:jackson-datatype-joda";
            } else {
                string2 = string;
                if (string2.startsWith("java.util.Optional")) {
                    string = "Java 8 optional";
                    string2 = "com.fasterxml.jackson.datatype:jackson-datatype-jdk8";
                } else {
                    return null;
                }
            }
        }
        return String.format("%s type %s not supported by default: add Module \"%s\" to enable handling", string, ClassUtil.getTypeDescription(javaType), string2);
    }

    public static boolean isJava8TimeClass(Class<?> object) {
        object = ((Class)object).getName();
        return ((String)object).startsWith("java.time.");
    }

    public static boolean isJava8OptionalClass(Class<?> object) {
        object = ((Class)object).getName();
        return ((String)object).startsWith("java.util.Optional");
    }

    public static boolean isJodaTimeClass(Class<?> object) {
        object = ((Class)object).getName();
        return ((String)object).startsWith("org.joda.time.");
    }
}

