/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CompactStringObjectMap
implements Serializable {
    private static final CompactStringObjectMap a = new CompactStringObjectMap(1, 0, new Object[4]);
    private final int b;
    private final int c;
    private final Object[] d;

    private CompactStringObjectMap(int n2, int n3, Object[] objectArray) {
        this.b = n2;
        this.c = n3;
        this.d = objectArray;
    }

    public static <T> CompactStringObjectMap construct(Map<String, T> object) {
        int n2;
        int n3;
        if (object.isEmpty()) {
            return a;
        }
        int n4 = object.size();
        if (n4 <= 5) {
            n3 = 8;
        } else if (n4 <= 12) {
            n3 = 16;
        } else {
            int n5 = n4;
            n4 = n5 + (n5 >> 2);
            n2 = 32;
            while (n2 < n4) {
                int n6 = n2;
                n2 = n6 + n6;
            }
            n3 = n2;
        }
        n4 = n3;
        n2 = n3 - 1;
        int n7 = n4;
        int n8 = n7 + (n7 >> 1) << 1;
        Object[] objectArray = new Object[n8];
        int n9 = 0;
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            if (string == null) continue;
            int n10 = string.hashCode() & n2;
            int n11 = n10 + n10;
            if (objectArray[n11] != null && objectArray[n11 = n4 + (n10 >> 1) << 1] != null) {
                int n12 = n4;
                n11 = (n12 + (n12 >> 1) << 1) + n9;
                n9 += 2;
                if (n11 >= objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, objectArray.length + 4);
                }
            }
            objectArray[n11] = string;
            objectArray[n11 + 1] = entry.getValue();
        }
        return new CompactStringObjectMap(n2, n9, objectArray);
    }

    public final Object find(String object) {
        int n2 = ((String)object).hashCode() & this.b;
        int n3 = n2 << 1;
        Object object2 = this.d[n3];
        if (object2 == object || ((String)object).equals(object2)) {
            return this.d[n3 + 1];
        }
        n3 = n2;
        String string = object;
        object = this;
        if (object2 != null) {
            int n4 = ((CompactStringObjectMap)object).b + 1;
            object2 = ((CompactStringObjectMap)object).d[n3 = n4 + (n3 >> 1) << 1];
            if (string.equals(object2)) {
                return ((CompactStringObjectMap)object).d[n3 + 1];
            }
            if (object2 != null) {
                int n5 = n4;
                n4 = n3 + ((CompactStringObjectMap)object).c;
                for (n3 = (v1249974) + ((v1249974) >> 1) << 1; n3 < n4; n3 += 2) {
                    object2 = ((CompactStringObjectMap)object).d[n3];
                    if (object2 != string && !string.equals(object2)) continue;
                    return ((CompactStringObjectMap)object).d[n3 + 1];
                }
            }
        }
        return null;
    }

    public final Object findCaseInsensitive(String string) {
        int n2 = this.d.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object = this.d[i2];
            if (object == null || !((String)(object = (String)object)).equalsIgnoreCase(string)) continue;
            return this.d[i2 + 1];
        }
        return null;
    }

    public final List<String> keys() {
        int n2 = this.d.length;
        ArrayList<String> arrayList = new ArrayList<String>(n2 >> 2);
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object = this.d[i2];
            if (object == null) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }
}

