/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;

public final class EnumValues
implements Serializable {
    private final Class<Enum<?>> a;
    private final Enum<?>[] b;
    private final SerializableString[] c;
    private transient EnumMap<?, SerializableString> d;

    private EnumValues(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        this.a = clazz;
        this.b = clazz.getEnumConstants();
        this.c = serializableStringArray;
    }

    public static EnumValues construct(SerializationConfig serializationConfig, AnnotatedClass annotatedClass) {
        if (serializationConfig.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            return EnumValues.constructFromToString(serializationConfig, annotatedClass);
        }
        return EnumValues.constructFromName(serializationConfig, annotatedClass);
    }

    @Deprecated
    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        String[] stringArray = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = stringArray.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        stringArray = mapperConfig.getAnnotationIntrospector().findEnumValues((Class<?>)stringArray, enumArray, new String[enumArray.length]);
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enum_.name();
            }
            if (mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE)) {
                string = string.toLowerCase();
            }
            serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, AnnotatedClass stringArray) {
        SerializableString[] serializableStringArray = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Enum<?>[] enumArray = stringArray.getRawType();
        Class<Enum<?>> clazz = EnumValues._enumClass(enumArray);
        enumArray = EnumValues._enumConstants(enumArray);
        stringArray = serializableStringArray.findEnumValues(mapperConfig, (AnnotatedClass)stringArray, enumArray, new String[enumArray.length]);
        serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enum_.name();
            }
            if (bl2) {
                string = string.toLowerCase();
            }
            serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues constructFromToString(MapperConfig<?> mapperConfig, AnnotatedClass serializableStringArray) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Enum<?>[] enumArray = serializableStringArray.getRawType();
        Class<Enum<?>> clazz = EnumValues._enumClass(enumArray);
        enumArray = EnumValues._enumConstants(enumArray);
        String[] stringArray = new String[enumArray.length];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(mapperConfig, (AnnotatedClass)serializableStringArray, enumArray, stringArray);
        }
        serializableStringArray = new SerializableString[enumArray.length];
        for (int i2 = 0; i2 < enumArray.length; ++i2) {
            Object object = stringArray[i2];
            if (object == null) {
                object = enumArray[i2];
                if ((object = ((Enum)object).toString()) == null) {
                    object = "";
                }
            }
            if (bl2) {
                object = ((String)object).toLowerCase();
            }
            serializableStringArray[i2] = mapperConfig.compileString((String)object);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    @Deprecated
    public static EnumValues constructFromToString(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        Enum<?>[] enumArray = ClassUtil.findEnumType(clazz);
        if ((enumArray = enumArray.getEnumConstants()) == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum<?> enum_ : enumArray) {
            arrayList.add(enum_.toString());
        }
        return EnumValues.construct(mapperConfig, clazz, arrayList);
    }

    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> mapperConfig, AnnotatedClass serializableStringArray, EnumNamingStrategy enumNamingStrategy) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Enum<?>[] enumArray = serializableStringArray.getRawType();
        Class<Enum<?>> clazz = EnumValues._enumClass(enumArray);
        enumArray = EnumValues._enumConstants(enumArray);
        String[] stringArray = new String[enumArray.length];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(mapperConfig, (AnnotatedClass)serializableStringArray, enumArray, stringArray);
        }
        serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enumNamingStrategy.convertEnumToExternalName(enum_.name());
            }
            if (bl2) {
                string = string.toLowerCase();
            }
            serializableStringArray[i2] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    @Deprecated
    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz, EnumNamingStrategy enumNamingStrategy) {
        Enum<?>[] enumArray = ClassUtil.findEnumType(clazz);
        if ((enumArray = enumArray.getEnumConstants()) == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum<?> enum_ : enumArray) {
            arrayList.add(enumNamingStrategy.convertEnumToExternalName(enum_.name()));
        }
        return EnumValues.construct(mapperConfig, clazz, arrayList);
    }

    public static EnumValues construct(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz, List<String> list) {
        int n2 = list.size();
        SerializableString[] serializableStringArray = new SerializableString[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            serializableStringArray[i2] = mapperConfig.compileString(list.get(i2));
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues construct(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        return new EnumValues(clazz, serializableStringArray);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> clazz) {
        return clazz;
    }

    protected static Enum<?>[] _enumConstants(Class<?> clazz) {
        Enum<?>[] enumArray = ClassUtil.findEnumType(clazz).getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        return enumArray;
    }

    public final SerializableString serializedValueFor(Enum<?> enum_) {
        return this.c[enum_.ordinal()];
    }

    public final Collection<SerializableString> values() {
        return Arrays.asList(this.c);
    }

    public final List<Enum<?>> enums() {
        return Arrays.asList(this.b);
    }

    public final EnumMap<?, SerializableString> internalMap() {
        AbstractMap abstractMap = this.d;
        if (abstractMap == null) {
            abstractMap = new LinkedHashMap();
            Enum<?>[] enumArray = this.b;
            int n2 = this.b.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Enum<?> enum_ = enumArray[i2];
                abstractMap.put(enum_, (SerializableString)this.c[enum_.ordinal()]);
            }
            abstractMap = new EnumMap(abstractMap);
            this.d = abstractMap;
        }
        return abstractMap;
    }

    public final Class<Enum<?>> getEnumClass() {
        return this.a;
    }
}

