/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.io.Serializable;

public abstract class NameTransformer {
    public static final NameTransformer NOP = new NopTransformer();

    protected NameTransformer() {
    }

    public static NameTransformer simpleTransformer(String string, String string2) {
        boolean bl2;
        boolean bl3 = string != null && !string.isEmpty();
        boolean bl4 = bl2 = string2 != null && !string2.isEmpty();
        if (bl3) {
            if (bl2) {
                return new NameTransformer(string, string2){
                    private /* synthetic */ String a;
                    private /* synthetic */ String b;
                    {
                        this.a = string;
                        this.b = string2;
                    }

                    @Override
                    public final String transform(String string) {
                        return this.a + string + this.b;
                    }

                    @Override
                    public final String reverse(String string) {
                        if (string.startsWith(this.a) && (string = string.substring(this.a.length())).endsWith(this.b)) {
                            return string.substring(0, string.length() - this.b.length());
                        }
                        return null;
                    }

                    public final String toString() {
                        return "[PreAndSuffixTransformer('" + this.a + "','" + this.b + "')]";
                    }
                };
            }
            return new NameTransformer(string){
                private /* synthetic */ String a;
                {
                    this.a = string;
                }

                @Override
                public final String transform(String string) {
                    return this.a + string;
                }

                @Override
                public final String reverse(String string) {
                    if (string.startsWith(this.a)) {
                        return string.substring(this.a.length());
                    }
                    return null;
                }

                public final String toString() {
                    return "[PrefixTransformer('" + this.a + "')]";
                }
            };
        }
        if (bl2) {
            return new NameTransformer(string2){
                private /* synthetic */ String a;
                {
                    this.a = string;
                }

                @Override
                public final String transform(String string) {
                    return string + this.a;
                }

                @Override
                public final String reverse(String string) {
                    if (string.endsWith(this.a)) {
                        return string.substring(0, string.length() - this.a.length());
                    }
                    return null;
                }

                public final String toString() {
                    return "[SuffixTransformer('" + this.a + "')]";
                }
            };
        }
        return NOP;
    }

    public static NameTransformer chainedTransformer(NameTransformer nameTransformer, NameTransformer nameTransformer2) {
        return new Chained(nameTransformer, nameTransformer2);
    }

    public abstract String transform(String var1);

    public abstract String reverse(String var1);

    public static class Chained
    extends NameTransformer
    implements Serializable {
        protected final NameTransformer _t1;
        protected final NameTransformer _t2;

        public Chained(NameTransformer nameTransformer, NameTransformer nameTransformer2) {
            this._t1 = nameTransformer;
            this._t2 = nameTransformer2;
        }

        @Override
        public String transform(String string) {
            return this._t1.transform(this._t2.transform(string));
        }

        @Override
        public String reverse(String string) {
            if ((string = this._t1.reverse(string)) != null) {
                string = this._t2.reverse(string);
            }
            return string;
        }

        public String toString() {
            return "[ChainedTransformer(" + this._t1 + ", " + this._t2 + ")]";
        }
    }

    protected static final class NopTransformer
    extends NameTransformer
    implements Serializable {
        protected NopTransformer() {
        }

        @Override
        public final String transform(String string) {
            return string;
        }

        @Override
        public final String reverse(String string) {
            return string;
        }
    }
}

