/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.InvocationTargetException;

public class NativeImageUtil {
    private static final boolean a = System.getProperty("org.graalvm.nativeimage.imagecode") != null;

    private NativeImageUtil() {
    }

    public static boolean isInNativeImageAndIsAtRuntime() {
        return a && "runtime".equals(System.getProperty("org.graalvm.nativeimage.imagecode"));
    }

    public static boolean isInNativeImage() {
        return a;
    }

    public static boolean isUnsupportedFeatureError(Throwable throwable) {
        if (!NativeImageUtil.isInNativeImageAndIsAtRuntime()) {
            return false;
        }
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        return throwable.getClass().getName().equals("com.oracle.svm.core.jdk.UnsupportedFeatureError");
    }

    public static boolean needsReflectionConfiguration(Class<?> clazz) {
        if (!NativeImageUtil.isInNativeImageAndIsAtRuntime()) {
            return false;
        }
        return (clazz.getDeclaredFields().length == 0 || ClassUtil.isRecordType(clazz)) && clazz.getDeclaredMethods().length == 0 && clazz.getDeclaredConstructors().length == 0;
    }
}

