/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.LinkedNode;
import java.lang.reflect.Array;
import java.util.List;

public final class ObjectBuffer {
    private LinkedNode<Object[]> a;
    private LinkedNode<Object[]> b;
    private int c;
    private Object[] d;

    public final Object[] resetAndStart() {
        this._reset();
        if (this.d == null) {
            this.d = new Object[12];
            return this.d;
        }
        return this.d;
    }

    public final Object[] resetAndStart(Object[] objectArray, int n2) {
        this._reset();
        if (this.d == null || this.d.length < n2) {
            this.d = new Object[Math.max(12, n2)];
        }
        System.arraycopy(objectArray, 0, this.d, 0, n2);
        return this.d;
    }

    public final Object[] appendCompletedChunk(Object[] objectArray) {
        LinkedNode<Object[]> linkedNode = new LinkedNode<Object[]>(objectArray, null);
        if (this.a == null) {
            this.b = linkedNode;
            this.a = this.b;
        } else {
            this.b.linkNext(linkedNode);
            this.b = linkedNode;
        }
        int n2 = objectArray.length;
        this.c += n2;
        if (n2 < 16384) {
            int n3 = n2;
            n2 = n3 + n3;
        } else if (n2 < 262144) {
            int n4 = n2;
            n2 = n4 + (n4 >> 2);
        }
        return new Object[n2];
    }

    public final Object[] completeAndClearBuffer(Object[] objectArray, int n2) {
        int n3 = n2 + this.c;
        Object[] objectArray2 = new Object[n3];
        this._copyTo(objectArray2, n3, objectArray, n2);
        this._reset();
        return objectArray2;
    }

    public final <T> T[] completeAndClearBuffer(Object[] objectArray, int n2, Class<T> objectArray2) {
        int n3 = n2 + this.c;
        objectArray2 = (Object[])Array.newInstance(objectArray2, n3);
        this._copyTo(objectArray2, n3, objectArray, n2);
        this._reset();
        return objectArray2;
    }

    public final void completeAndClearBuffer(Object[] objectArray, int n2, List<Object> list) {
        for (LinkedNode<Object[]> linkedNode = this.a; linkedNode != null; linkedNode = linkedNode.next()) {
            Object[] objectArray2 = linkedNode.value();
            int n3 = objectArray2.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                list.add(objectArray2[i2]);
            }
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            list.add(objectArray[i3]);
        }
        this._reset();
    }

    public final int initialCapacity() {
        if (this.d == null) {
            return 0;
        }
        return this.d.length;
    }

    public final int bufferedSize() {
        return this.c;
    }

    protected final void _reset() {
        if (this.b != null) {
            this.d = this.b.value();
        }
        ObjectBuffer objectBuffer = this;
        objectBuffer.b = null;
        objectBuffer.a = null;
        this.c = 0;
    }

    protected final void _copyTo(Object object, int n2, Object[] objectArray, int n3) {
        int n4 = 0;
        for (LinkedNode<Object[]> linkedNode = this.a; linkedNode != null; linkedNode = linkedNode.next()) {
            Object[] objectArray2 = linkedNode.value();
            int n5 = objectArray2.length;
            System.arraycopy(objectArray2, 0, object, n4, n5);
            n4 += n5;
        }
        System.arraycopy(objectArray, 0, object, n4, n3);
        if ((n4 += n3) != n2) {
            throw new IllegalStateException("Should have gotten " + n2 + " entries, got " + n4);
        }
    }
}

