/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(((ResolvedType)javaType).getRawClass(), mapperConfig);
    }

    public PropertyName findRootName(Class<?> clazz, MapperConfig<?> serializable) {
        ClassKey classKey = new ClassKey(clazz);
        Object object = this._rootNames.get(classKey);
        if (object != null) {
            return object;
        }
        object = ((MapperConfig)serializable).introspectClassAnnotations(clazz);
        serializable = ((MapperConfig)serializable).getAnnotationIntrospector();
        object = ((BeanDescription)object).getClassInfo();
        if ((object = ((AnnotationIntrospector)serializable).findRootName((AnnotatedClass)object)) == null || !((PropertyName)object).hasSimpleName()) {
            object = PropertyName.construct(clazz.getSimpleName());
        }
        this._rootNames.put(classKey, (PropertyName)object);
        return object;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

