/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.RawValue;
import com.fasterxml.jackson.databind.util.TokenBufferReadContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.TreeMap;

public class TokenBuffer
extends JsonGenerator {
    protected static final int DEFAULT_GENERATOR_FEATURES = JsonGenerator.Feature.collectDefaults();
    protected ObjectCodec _objectCodec;
    protected JsonStreamContext _parentContext;
    protected int _generatorFeatures;
    protected StreamReadConstraints _streamReadConstraints = StreamReadConstraints.defaults();
    protected boolean _closed;
    protected boolean _hasNativeTypeIds;
    protected boolean _hasNativeObjectIds;
    protected boolean _mayHaveNativeIds;
    protected boolean _forceBigDecimal;
    protected Segment _first;
    protected Segment _last;
    protected int _appendAt;
    protected Object _typeId;
    protected Object _objectId;
    protected boolean _hasNativeId = false;
    protected JsonWriteContext _writeContext;

    public TokenBuffer(ObjectCodec objectCodec, boolean bl2) {
        this._objectCodec = objectCodec;
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext(null);
        TokenBuffer tokenBuffer = this;
        tokenBuffer._first = tokenBuffer._last = new Segment();
        this._appendAt = 0;
        this._hasNativeTypeIds = bl2;
        this._hasNativeObjectIds = bl2;
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
    }

    public TokenBuffer(JsonParser jsonParser) {
        this(jsonParser, null);
    }

    public TokenBuffer(JsonParser jsonParser, DeserializationContext deserializationContext) {
        this._objectCodec = jsonParser.getCodec();
        this._streamReadConstraints = jsonParser.streamReadConstraints();
        this._parentContext = jsonParser.getParsingContext();
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext(null);
        TokenBuffer tokenBuffer = this;
        tokenBuffer._first = tokenBuffer._last = new Segment();
        this._appendAt = 0;
        this._hasNativeTypeIds = jsonParser.canReadTypeId();
        this._hasNativeObjectIds = jsonParser.canReadObjectId();
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
        this._forceBigDecimal = deserializationContext == null ? false : deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    }

    @Deprecated
    public static TokenBuffer asCopyOfValue(JsonParser jsonParser) {
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser);
        ((JsonGenerator)tokenBuffer).copyCurrentStructure(jsonParser);
        return tokenBuffer;
    }

    public TokenBuffer overrideParentContext(JsonStreamContext jsonStreamContext) {
        this._parentContext = jsonStreamContext;
        return this;
    }

    public TokenBuffer forceUseOfBigDecimal(boolean bl2) {
        this._forceBigDecimal = bl2;
        return this;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public JsonParser asParser() {
        TokenBuffer tokenBuffer = this;
        return tokenBuffer.asParser(tokenBuffer._objectCodec);
    }

    public JsonParser asParserOnFirstToken() {
        TokenBuffer tokenBuffer = this;
        JsonParser jsonParser = tokenBuffer.asParser(tokenBuffer._objectCodec);
        jsonParser.nextToken();
        return jsonParser;
    }

    public JsonParser asParser(ObjectCodec objectCodec) {
        return new Parser(this._first, objectCodec, this._hasNativeTypeIds, this._hasNativeObjectIds, this._parentContext, this._streamReadConstraints);
    }

    public JsonParser asParser(StreamReadConstraints streamReadConstraints) {
        return new Parser(this._first, this._objectCodec, this._hasNativeTypeIds, this._hasNativeObjectIds, this._parentContext, streamReadConstraints);
    }

    public JsonParser asParser(JsonParser jsonParser) {
        Parser parser = new Parser(this._first, jsonParser.getCodec(), this._hasNativeTypeIds, this._hasNativeObjectIds, this._parentContext, jsonParser.streamReadConstraints());
        parser.setLocation(jsonParser.currentTokenLocation());
        return parser;
    }

    public JsonToken firstToken() {
        return this._first.type(0);
    }

    public boolean isEmpty() {
        return this._appendAt == 0 && this._first == this._last;
    }

    public TokenBuffer append(TokenBuffer closeable) {
        if (!this._hasNativeTypeIds) {
            this._hasNativeTypeIds = ((JsonGenerator)closeable).canWriteTypeId();
        }
        if (!this._hasNativeObjectIds) {
            this._hasNativeObjectIds = ((JsonGenerator)closeable).canWriteObjectId();
        }
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
        closeable = ((TokenBuffer)closeable).asParser();
        while (((JsonParser)closeable).nextToken() != null) {
            ((JsonGenerator)this).copyCurrentStructure((JsonParser)closeable);
        }
        return this;
    }

    public void serialize(JsonGenerator jsonGenerator) {
        block32: {
            boolean bl2;
            Segment segment = this._first;
            int n2 = -1;
            boolean bl3 = this._mayHaveNativeIds;
            boolean bl4 = bl2 = bl3 && segment.hasIds();
            block14: while (true) {
                Object object;
                JsonToken jsonToken;
                if (++n2 >= 16) {
                    n2 = 0;
                    if ((segment = segment.next()) == null) break block32;
                    boolean bl5 = bl2 = bl3 && segment.hasIds();
                }
                if ((jsonToken = segment.type(n2)) == null) break block32;
                if (bl2) {
                    object = segment.a(n2);
                    if (object != null) {
                        jsonGenerator.writeObjectId(object);
                    }
                    if ((object = segment.b(n2)) != null) {
                        jsonGenerator.writeTypeId(object);
                    }
                }
                switch (jsonToken) {
                    case START_OBJECT: {
                        jsonGenerator.writeStartObject();
                        continue block14;
                    }
                    case END_OBJECT: {
                        jsonGenerator.writeEndObject();
                        continue block14;
                    }
                    case START_ARRAY: {
                        jsonGenerator.writeStartArray();
                        continue block14;
                    }
                    case END_ARRAY: {
                        jsonGenerator.writeEndArray();
                        continue block14;
                    }
                    case FIELD_NAME: {
                        object = segment.get(n2);
                        if (object instanceof SerializableString) {
                            jsonGenerator.writeFieldName((SerializableString)object);
                            continue block14;
                        }
                        jsonGenerator.writeFieldName((String)object);
                        continue block14;
                    }
                    case VALUE_STRING: {
                        object = segment.get(n2);
                        if (object instanceof SerializableString) {
                            jsonGenerator.writeString((SerializableString)object);
                            continue block14;
                        }
                        jsonGenerator.writeString((String)object);
                        continue block14;
                    }
                    case VALUE_NUMBER_INT: {
                        object = segment.get(n2);
                        if (object instanceof Integer) {
                            jsonGenerator.writeNumber((Integer)object);
                            continue block14;
                        }
                        if (object instanceof BigInteger) {
                            jsonGenerator.writeNumber((BigInteger)object);
                            continue block14;
                        }
                        if (object instanceof Long) {
                            jsonGenerator.writeNumber((Long)object);
                            continue block14;
                        }
                        if (object instanceof Short) {
                            jsonGenerator.writeNumber((Short)object);
                            continue block14;
                        }
                        jsonGenerator.writeNumber(((Number)object).intValue());
                        continue block14;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        object = segment.get(n2);
                        if (object instanceof Double) {
                            jsonGenerator.writeNumber((Double)object);
                            continue block14;
                        }
                        if (object instanceof BigDecimal) {
                            jsonGenerator.writeNumber((BigDecimal)object);
                            continue block14;
                        }
                        if (object instanceof Float) {
                            jsonGenerator.writeNumber(((Float)object).floatValue());
                            continue block14;
                        }
                        if (object == null) {
                            jsonGenerator.writeNull();
                            continue block14;
                        }
                        if (object instanceof String) {
                            jsonGenerator.writeNumber((String)object);
                            continue block14;
                        }
                        this._reportError(String.format("Unrecognized value type for VALUE_NUMBER_FLOAT: %s, cannot serialize", object.getClass().getName()));
                        continue block14;
                    }
                    case VALUE_TRUE: {
                        jsonGenerator.writeBoolean(true);
                        continue block14;
                    }
                    case VALUE_FALSE: {
                        jsonGenerator.writeBoolean(false);
                        continue block14;
                    }
                    case VALUE_NULL: {
                        jsonGenerator.writeNull();
                        continue block14;
                    }
                    case VALUE_EMBEDDED_OBJECT: {
                        object = segment.get(n2);
                        if (object instanceof RawValue) {
                            ((RawValue)object).serialize(jsonGenerator);
                            continue block14;
                        }
                        if (object instanceof JsonSerializable) {
                            jsonGenerator.writeObject(object);
                            continue block14;
                        }
                        jsonGenerator.writeEmbeddedObject(object);
                        continue block14;
                    }
                }
                break;
            }
            throw new RuntimeException("Internal error: should never end up through this code path");
        }
    }

    public TokenBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken;
        if (!jsonParser.hasToken(JsonToken.FIELD_NAME)) {
            ((JsonGenerator)this).copyCurrentStructure(jsonParser);
            return this;
        }
        ((JsonGenerator)this).writeStartObject();
        do {
            ((JsonGenerator)this).copyCurrentStructure(jsonParser);
        } while ((jsonToken = jsonParser.nextToken()) == JsonToken.FIELD_NAME);
        if (jsonToken != JsonToken.END_OBJECT) {
            deserializationContext.reportWrongTokenException(TokenBuffer.class, JsonToken.END_OBJECT, "Expected END_OBJECT after copying contents of a JsonParser into TokenBuffer, got " + (Object)((Object)jsonToken), new Object[0]);
        }
        ((JsonGenerator)this).writeEndObject();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[TokenBuffer: ");
        JsonParser jsonParser = this.asParser();
        int n2 = 0;
        boolean bl2 = this._hasNativeTypeIds || this._hasNativeObjectIds;
        while (true) {
            try {
                JsonToken jsonToken = jsonParser.nextToken();
                if (jsonToken == null) break;
                if (bl2) {
                    StringBuilder stringBuilder2 = stringBuilder;
                    Object object = this;
                    Object object2 = ((TokenBuffer)object)._last.a(((TokenBuffer)object)._appendAt - 1);
                    if (object2 != null) {
                        stringBuilder2.append("[objectId=").append(String.valueOf(object2)).append(']');
                    }
                    if ((object = ((TokenBuffer)object)._last.b(((TokenBuffer)object)._appendAt - 1)) != null) {
                        stringBuilder2.append("[typeId=").append(String.valueOf(object)).append(']');
                    }
                }
                if (n2 < 100) {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(jsonToken.toString());
                    if (jsonToken == JsonToken.FIELD_NAME) {
                        stringBuilder.append('(');
                        stringBuilder.append(jsonParser.currentName());
                        stringBuilder.append(')');
                    }
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            ++n2;
        }
        if (n2 >= 100) {
            stringBuilder.append(" ... (truncated ").append(n2 - 100).append(" entries)");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        this._generatorFeatures |= feature.getMask();
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        this._generatorFeatures &= ~feature.getMask();
        return this;
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    @Override
    public int getFeatureMask() {
        return this._generatorFeatures;
    }

    @Override
    @Deprecated
    public JsonGenerator setFeatureMask(int n2) {
        this._generatorFeatures = n2;
        return this;
    }

    @Override
    public JsonGenerator overrideStdFeatures(int n2, int n3) {
        int n4 = ((JsonGenerator)this).getFeatureMask();
        this._generatorFeatures = n4 & ~n3 | n2 & n3;
        return this;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public final JsonWriteContext getOutputContext() {
        return this._writeContext;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_WRITE_CAPABILITIES;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public final void writeStartArray() {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    @Override
    public void writeStartArray(Object object) {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext(object);
    }

    @Override
    public void writeStartArray(Object object, int n2) {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext(object);
    }

    @Override
    public final void writeEndArray() {
        this._appendEndMarker(JsonToken.END_ARRAY);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeStartObject() {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_OBJECT);
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    @Override
    public void writeStartObject(Object object) {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_OBJECT);
        this._writeContext = this._writeContext.createChildObjectContext(object);
    }

    @Override
    public void writeStartObject(Object object, int n2) {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_OBJECT);
        this._writeContext = this._writeContext.createChildObjectContext(object);
    }

    @Override
    public final void writeEndObject() {
        this._appendEndMarker(JsonToken.END_OBJECT);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeFieldName(String string) {
        this._writeContext.writeFieldName(string);
        this._appendFieldName(string);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        this._writeContext.writeFieldName(serializableString.getValue());
        this._appendFieldName(serializableString);
    }

    @Override
    public void writeString(String string) {
        if (string == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._appendValue(JsonToken.VALUE_STRING, string);
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        ((JsonGenerator)this).writeString(new String(cArray, n2, n3));
    }

    @Override
    public void writeString(SerializableString serializableString) {
        if (serializableString == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._appendValue(JsonToken.VALUE_STRING, serializableString);
    }

    @Override
    public void writeString(Reader reader, int n2) {
        int n3;
        int n4;
        if (reader == null) {
            this._reportError("null reader");
        }
        char[] cArray = new char[1000];
        StringBuilder stringBuilder = new StringBuilder(1000);
        for (n3 = n2 >= 0 ? n2 : Integer.MAX_VALUE; n3 > 0; n3 -= n4) {
            n4 = Math.min(n3, cArray.length);
            if ((n4 = reader.read(cArray, 0, n4)) <= 0) break;
            stringBuilder.append(cArray, 0, n4);
        }
        if (n3 > 0 && n2 >= 0) {
            this._reportError("Was not able to read enough from reader");
        }
        this._appendValue(JsonToken.VALUE_STRING, stringBuilder.toString());
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(SerializableString serializableString) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c2) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new RawValue(string));
    }

    @Override
    public void writeRawValue(String string, int n2, int n3) {
        if (n2 > 0 || n3 != string.length()) {
            int n4 = n2;
            string = string.substring(n4, n4 + n3);
        }
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new RawValue(string));
    }

    @Override
    public void writeRawValue(char[] cArray, int n2, int n3) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new String(cArray, n2, n3));
    }

    @Override
    public void writeNumber(short s2) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, s2);
    }

    @Override
    public void writeNumber(int n2) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, n2);
    }

    @Override
    public void writeNumber(long l2) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, l2);
    }

    @Override
    public void writeNumber(double d2) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, d2);
    }

    @Override
    public void writeNumber(float f2) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, Float.valueOf(f2));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, bigDecimal);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        if (bigInteger == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._appendValue(JsonToken.VALUE_NUMBER_INT, bigInteger);
    }

    @Override
    public void writeNumber(String string) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, string);
    }

    private void a(Object object) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, object);
    }

    private void b(Object object) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, object);
    }

    @Override
    public void writeBoolean(boolean bl2) {
        this._appendValue(bl2 ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE);
    }

    @Override
    public void writeNull() {
        this._appendValue(JsonToken.VALUE_NULL);
    }

    @Override
    public void writeObject(Object object) {
        if (object == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class || object instanceof RawValue) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
            return;
        }
        if (this._objectCodec == null) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
            return;
        }
        this._objectCodec.writeValue(this, object);
    }

    @Override
    public void writeTree(TreeNode treeNode) {
        if (treeNode == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        if (this._objectCodec == null) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, treeNode);
            return;
        }
        ((TreeCodec)this._objectCodec).writeTree(this, treeNode);
    }

    @Override
    public void writeBinary(Base64Variant object, byte[] byArray, int n2, int n3) {
        object = new byte[n3];
        System.arraycopy(byArray, n2, object, 0, n3);
        ((JsonGenerator)this).writeObject(object);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWriteTypeId() {
        return this._hasNativeTypeIds;
    }

    @Override
    public boolean canWriteObjectId() {
        return this._hasNativeObjectIds;
    }

    @Override
    public void writeTypeId(Object object) {
        this._typeId = object;
        this._hasNativeId = true;
    }

    @Override
    public void writeObjectId(Object object) {
        this._objectId = object;
        this._hasNativeId = true;
    }

    @Override
    public void writeEmbeddedObject(Object object) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
    }

    @Override
    public void copyCurrentEvent(JsonParser jsonParser) {
        if (this._mayHaveNativeIds) {
            this.a(jsonParser);
        }
        switch (jsonParser.currentToken()) {
            case START_OBJECT: {
                ((JsonGenerator)this).writeStartObject();
                return;
            }
            case END_OBJECT: {
                ((JsonGenerator)this).writeEndObject();
                return;
            }
            case START_ARRAY: {
                ((JsonGenerator)this).writeStartArray();
                return;
            }
            case END_ARRAY: {
                ((JsonGenerator)this).writeEndArray();
                return;
            }
            case FIELD_NAME: {
                ((JsonGenerator)this).writeFieldName(jsonParser.currentName());
                return;
            }
            case VALUE_STRING: {
                if (jsonParser.hasTextCharacters()) {
                    ((JsonGenerator)this).writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    return;
                }
                ((JsonGenerator)this).writeString(jsonParser.getText());
                return;
            }
            case VALUE_NUMBER_INT: {
                switch (jsonParser.getNumberType()) {
                    case INT: {
                        ((JsonGenerator)this).writeNumber(jsonParser.getIntValue());
                        return;
                    }
                    case BIG_INTEGER: {
                        this.a(jsonParser.getNumberValueDeferred());
                        return;
                    }
                }
                ((JsonGenerator)this).writeNumber(jsonParser.getLongValue());
                return;
            }
            case VALUE_NUMBER_FLOAT: {
                this.b(jsonParser.getNumberValueDeferred());
                return;
            }
            case VALUE_TRUE: {
                ((JsonGenerator)this).writeBoolean(true);
                return;
            }
            case VALUE_FALSE: {
                ((JsonGenerator)this).writeBoolean(false);
                return;
            }
            case VALUE_NULL: {
                ((JsonGenerator)this).writeNull();
                return;
            }
            case VALUE_EMBEDDED_OBJECT: {
                ((JsonGenerator)this).writeObject(jsonParser.getEmbeddedObject());
                return;
            }
        }
        throw new RuntimeException("Internal error: unexpected token: " + (Object)((Object)jsonParser.currentToken()));
    }

    @Override
    public void copyCurrentStructure(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            if (this._mayHaveNativeIds) {
                this.a(jsonParser);
            }
            ((JsonGenerator)this).writeFieldName(jsonParser.currentName());
            jsonToken = jsonParser.nextToken();
        } else if (jsonToken == null) {
            throw new JsonEOFException(jsonParser, null, "Unexpected end-of-input");
        }
        switch (jsonToken) {
            case START_ARRAY: {
                if (this._mayHaveNativeIds) {
                    this.a(jsonParser);
                }
                ((JsonGenerator)this).writeStartArray();
                this._copyBufferContents(jsonParser);
                return;
            }
            case START_OBJECT: {
                if (this._mayHaveNativeIds) {
                    this.a(jsonParser);
                }
                ((JsonGenerator)this).writeStartObject();
                this._copyBufferContents(jsonParser);
                return;
            }
            case END_ARRAY: {
                ((JsonGenerator)this).writeEndArray();
                return;
            }
            case END_OBJECT: {
                ((JsonGenerator)this).writeEndObject();
                return;
            }
        }
        this.a(jsonParser, jsonToken);
    }

    protected void _copyBufferContents(JsonParser jsonParser) {
        JsonToken jsonToken;
        int n2 = 1;
        block7: while ((jsonToken = jsonParser.nextToken()) != null) {
            switch (jsonToken) {
                case FIELD_NAME: {
                    if (this._mayHaveNativeIds) {
                        this.a(jsonParser);
                    }
                    ((JsonGenerator)this).writeFieldName(jsonParser.currentName());
                    continue block7;
                }
                case START_ARRAY: {
                    if (this._mayHaveNativeIds) {
                        this.a(jsonParser);
                    }
                    ((JsonGenerator)this).writeStartArray();
                    ++n2;
                    continue block7;
                }
                case START_OBJECT: {
                    if (this._mayHaveNativeIds) {
                        this.a(jsonParser);
                    }
                    ((JsonGenerator)this).writeStartObject();
                    ++n2;
                    continue block7;
                }
                case END_ARRAY: {
                    ((JsonGenerator)this).writeEndArray();
                    if (--n2 != 0) continue block7;
                    return;
                }
                case END_OBJECT: {
                    ((JsonGenerator)this).writeEndObject();
                    if (--n2 != 0) continue block7;
                    return;
                }
            }
            this.a(jsonParser, jsonToken);
        }
    }

    private void a(JsonParser jsonParser, JsonToken jsonToken) {
        if (this._mayHaveNativeIds) {
            this.a(jsonParser);
        }
        switch (jsonToken) {
            case VALUE_STRING: {
                if (jsonParser.hasTextCharacters()) {
                    ((JsonGenerator)this).writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    return;
                }
                ((JsonGenerator)this).writeString(jsonParser.getText());
                return;
            }
            case VALUE_NUMBER_INT: {
                switch (jsonParser.getNumberType()) {
                    case INT: {
                        ((JsonGenerator)this).writeNumber(jsonParser.getIntValue());
                        return;
                    }
                    case BIG_INTEGER: {
                        this.a(jsonParser.getNumberValueDeferred());
                        return;
                    }
                }
                ((JsonGenerator)this).writeNumber(jsonParser.getLongValue());
                return;
            }
            case VALUE_NUMBER_FLOAT: {
                this.b(jsonParser.getNumberValueDeferred());
                return;
            }
            case VALUE_TRUE: {
                ((JsonGenerator)this).writeBoolean(true);
                return;
            }
            case VALUE_FALSE: {
                ((JsonGenerator)this).writeBoolean(false);
                return;
            }
            case VALUE_NULL: {
                ((JsonGenerator)this).writeNull();
                return;
            }
            case VALUE_EMBEDDED_OBJECT: {
                ((JsonGenerator)this).writeObject(jsonParser.getEmbeddedObject());
                return;
            }
        }
        throw new RuntimeException("Internal error: unexpected token: " + (Object)((Object)jsonToken));
    }

    private final void a(JsonParser jsonParser) {
        this._typeId = jsonParser.getTypeId();
        if (this._typeId != null) {
            this._hasNativeId = true;
        }
        if ((this._objectId = jsonParser.getObjectId()) != null) {
            this._hasNativeId = true;
        }
    }

    protected final void _appendValue(JsonToken object) {
        this._writeContext.writeValue();
        object = this._hasNativeId ? this._last.append(this._appendAt, (JsonToken)((Object)object), this._objectId, this._typeId) : this._last.append(this._appendAt, (JsonToken)((Object)object));
        if (object == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    protected final void _appendValue(JsonToken object, Object object2) {
        this._writeContext.writeValue();
        object = this._hasNativeId ? this._last.append(this._appendAt, (JsonToken)((Object)object), object2, this._objectId, this._typeId) : this._last.append(this._appendAt, (JsonToken)((Object)object), object2);
        if (object == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    protected final void _appendFieldName(Object object) {
        object = this._hasNativeId ? this._last.append(this._appendAt, JsonToken.FIELD_NAME, object, this._objectId, this._typeId) : this._last.append(this._appendAt, JsonToken.FIELD_NAME, object);
        if (object == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    protected final void _appendStartMarker(JsonToken object) {
        object = this._hasNativeId ? this._last.append(this._appendAt, (JsonToken)((Object)object), this._objectId, this._typeId) : this._last.append(this._appendAt, (JsonToken)((Object)object));
        if (object == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    protected final void _appendEndMarker(JsonToken object) {
        if ((object = this._last.append(this._appendAt, (JsonToken)((Object)object))) == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    @Override
    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Called operation not supported for TokenBuffer");
    }

    protected static final class Segment {
        public static final int TOKENS_PER_SEGMENT = 16;
        private static final JsonToken[] a = new JsonToken[16];
        protected Segment _next;
        protected long _tokenTypes;
        protected final Object[] _tokens = new Object[16];
        protected TreeMap<Integer, Object> _nativeIds;

        public final JsonToken type(int n2) {
            long l2 = this._tokenTypes;
            if (n2 > 0) {
                l2 >>= n2 << 2;
            }
            n2 = (int)l2 & 0xF;
            return a[n2];
        }

        public final int rawType(int n2) {
            long l2 = this._tokenTypes;
            if (n2 > 0) {
                l2 >>= n2 << 2;
            }
            return (int)l2 & 0xF;
        }

        public final Object get(int n2) {
            return this._tokens[n2];
        }

        public final Segment next() {
            return this._next;
        }

        public final boolean hasIds() {
            return this._nativeIds != null;
        }

        public final Segment append(int n2, JsonToken jsonToken) {
            if (n2 < 16) {
                this.a(n2, jsonToken);
                return null;
            }
            this._next = new Segment();
            this._next.a(0, jsonToken);
            return this._next;
        }

        public final Segment append(int n2, JsonToken jsonToken, Object object, Object object2) {
            if (n2 < 16) {
                this.a(n2, jsonToken, object, object2);
                return null;
            }
            this._next = new Segment();
            this._next.a(0, jsonToken, object, object2);
            return this._next;
        }

        public final Segment append(int n2, JsonToken jsonToken, Object object) {
            if (n2 < 16) {
                this.a(n2, jsonToken, object);
                return null;
            }
            this._next = new Segment();
            this._next.a(0, jsonToken, object);
            return this._next;
        }

        public final Segment append(int n2, JsonToken jsonToken, Object object, Object object2, Object object3) {
            if (n2 < 16) {
                this.a(n2, jsonToken, object, object2, object3);
                return null;
            }
            this._next = new Segment();
            this._next.a(0, jsonToken, object, object2, object3);
            return this._next;
        }

        private void a(int n2, JsonToken jsonToken) {
            long l2 = jsonToken.ordinal();
            if (n2 > 0) {
                l2 <<= n2 << 2;
            }
            this._tokenTypes |= l2;
        }

        private void a(int n2, JsonToken jsonToken, Object object, Object object2) {
            long l2 = jsonToken.ordinal();
            if (n2 > 0) {
                l2 <<= n2 << 2;
            }
            this._tokenTypes |= l2;
            this.a(n2, object, object2);
        }

        private void a(int n2, JsonToken jsonToken, Object object) {
            this._tokens[n2] = object;
            long l2 = jsonToken.ordinal();
            if (n2 > 0) {
                l2 <<= n2 << 2;
            }
            this._tokenTypes |= l2;
        }

        private void a(int n2, JsonToken jsonToken, Object object, Object object2, Object object3) {
            this._tokens[n2] = object;
            long l2 = jsonToken.ordinal();
            if (n2 > 0) {
                l2 <<= n2 << 2;
            }
            this._tokenTypes |= l2;
            this.a(n2, object2, object3);
        }

        private final void a(int n2, Object object, Object object2) {
            int n3;
            if (this._nativeIds == null) {
                this._nativeIds = new TreeMap();
            }
            if (object != null) {
                n3 = n2;
                this._nativeIds.put(n3 + n3 + 1, object);
            }
            if (object2 != null) {
                n3 = n2;
                this._nativeIds.put(n3 + n3, object2);
            }
        }

        final Object a(int n2) {
            if (this._nativeIds == null) {
                return null;
            }
            return this._nativeIds.get(n2 + n2 + 1);
        }

        final Object b(int n2) {
            if (this._nativeIds == null) {
                return null;
            }
            return this._nativeIds.get(n2 + n2);
        }

        static {
            JsonToken[] jsonTokenArray = JsonToken.values();
            System.arraycopy(jsonTokenArray, 1, a, 1, Math.min(15, jsonTokenArray.length - 1));
        }
    }

    protected static final class Parser
    extends ParserMinimalBase {
        protected ObjectCodec _codec;
        protected StreamReadConstraints _streamReadConstraints;
        protected final boolean _hasNativeTypeIds;
        protected final boolean _hasNativeObjectIds;
        protected final boolean _hasNativeIds;
        protected Segment _segment;
        protected int _segmentPtr;
        protected TokenBufferReadContext _parsingContext;
        protected boolean _closed;
        protected transient ByteArrayBuilder _byteBuilder;
        protected JsonLocation _location = null;

        @Deprecated
        public Parser(Segment segment, ObjectCodec objectCodec, boolean bl2, boolean bl3) {
            this(segment, objectCodec, bl2, bl3, null);
        }

        @Deprecated
        public Parser(Segment segment, ObjectCodec objectCodec, boolean bl2, boolean bl3, JsonStreamContext jsonStreamContext) {
            this(segment, objectCodec, bl2, bl3, jsonStreamContext, StreamReadConstraints.defaults());
        }

        public Parser(Segment segment, ObjectCodec objectCodec, boolean bl2, boolean bl3, JsonStreamContext jsonStreamContext, StreamReadConstraints streamReadConstraints) {
            this._segment = segment;
            this._segmentPtr = -1;
            this._codec = objectCodec;
            this._streamReadConstraints = streamReadConstraints;
            this._parsingContext = TokenBufferReadContext.createRootContext(jsonStreamContext);
            this._hasNativeTypeIds = bl2;
            this._hasNativeObjectIds = bl3;
            this._hasNativeIds = bl2 || bl3;
        }

        public final void setLocation(JsonLocation jsonLocation) {
            this._location = jsonLocation;
        }

        @Override
        public final ObjectCodec getCodec() {
            return this._codec;
        }

        @Override
        public final void setCodec(ObjectCodec objectCodec) {
            this._codec = objectCodec;
        }

        @Override
        public final Version version() {
            return PackageVersion.VERSION;
        }

        @Override
        public final JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
            return DEFAULT_READ_CAPABILITIES;
        }

        @Override
        public final StreamReadConstraints streamReadConstraints() {
            return this._streamReadConstraints;
        }

        public final JsonToken peekNextToken() {
            if (this._closed) {
                return null;
            }
            Segment segment = this._segment;
            int n2 = this._segmentPtr + 1;
            if (n2 >= 16) {
                n2 = 0;
                Segment segment2 = segment = segment == null ? null : segment.next();
            }
            if (segment == null) {
                return null;
            }
            return segment.type(n2);
        }

        @Override
        public final void close() {
            if (!this._closed) {
                this._closed = true;
            }
        }

        @Override
        public final JsonToken nextToken() {
            if (this._closed || this._segment == null) {
                return null;
            }
            if (++this._segmentPtr >= 16) {
                this._segmentPtr = 0;
                this._segment = this._segment.next();
                if (this._segment == null) {
                    return null;
                }
            }
            this._currToken = this._segment.type(this._segmentPtr);
            if (this._currToken == JsonToken.FIELD_NAME) {
                Object object = this._currentObject();
                object = object instanceof String ? (String)object : object.toString();
                this._parsingContext.setCurrentName((String)object);
            } else if (this._currToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext();
            } else if (this._currToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext();
            } else if (this._currToken == JsonToken.END_OBJECT || this._currToken == JsonToken.END_ARRAY) {
                this._parsingContext = this._parsingContext.parentOrCopy();
            } else {
                this._parsingContext.updateForValue();
            }
            return this._currToken;
        }

        @Override
        public final String nextFieldName() {
            if (this._closed || this._segment == null) {
                return null;
            }
            int n2 = this._segmentPtr + 1;
            if (n2 < 16 && this._segment.type(n2) == JsonToken.FIELD_NAME) {
                this._segmentPtr = n2;
                this._currToken = JsonToken.FIELD_NAME;
                Object object = this._segment.get(n2);
                object = object instanceof String ? (String)object : object.toString();
                this._parsingContext.setCurrentName((String)object);
                return object;
            }
            if (((JsonParser)this).nextToken() == JsonToken.FIELD_NAME) {
                return ((JsonParser)this).currentName();
            }
            return null;
        }

        @Override
        public final boolean isClosed() {
            return this._closed;
        }

        @Override
        public final JsonStreamContext getParsingContext() {
            return this._parsingContext;
        }

        @Override
        public final JsonLocation currentLocation() {
            if (this._location == null) {
                return JsonLocation.NA;
            }
            return this._location;
        }

        @Override
        public final JsonLocation currentTokenLocation() {
            return ((JsonParser)this).currentLocation();
        }

        @Override
        @Deprecated
        public final JsonLocation getTokenLocation() {
            return ((JsonParser)this).currentTokenLocation();
        }

        @Override
        @Deprecated
        public final JsonLocation getCurrentLocation() {
            return ((JsonParser)this).currentLocation();
        }

        @Override
        public final String currentName() {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                JsonStreamContext jsonStreamContext = ((JsonStreamContext)this._parsingContext).getParent();
                return jsonStreamContext.getCurrentName();
            }
            return ((JsonStreamContext)this._parsingContext).getCurrentName();
        }

        @Override
        public final void overrideCurrentName(String string) {
            JsonStreamContext jsonStreamContext = this._parsingContext;
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                jsonStreamContext = jsonStreamContext.getParent();
            }
            if (jsonStreamContext instanceof TokenBufferReadContext) {
                try {
                    ((TokenBufferReadContext)jsonStreamContext).setCurrentName(string);
                    return;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }

        @Override
        @Deprecated
        public final String getCurrentName() {
            return ((JsonParser)this).currentName();
        }

        @Override
        public final String getText() {
            if (this._currToken == JsonToken.VALUE_STRING || this._currToken == JsonToken.FIELD_NAME) {
                Object object = this._currentObject();
                if (object instanceof String) {
                    return (String)object;
                }
                return ClassUtil.nullOrToString(object);
            }
            if (this._currToken == null) {
                return null;
            }
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return ClassUtil.nullOrToString(this._currentObject());
                }
            }
            return this._currToken.asString();
        }

        @Override
        public final char[] getTextCharacters() {
            String string = ((JsonParser)this).getText();
            if (string == null) {
                return null;
            }
            return string.toCharArray();
        }

        @Override
        public final int getTextLength() {
            String string = ((JsonParser)this).getText();
            if (string == null) {
                return 0;
            }
            return string.length();
        }

        @Override
        public final int getTextOffset() {
            return 0;
        }

        @Override
        public final boolean hasTextCharacters() {
            return false;
        }

        @Override
        public final boolean isNaN() {
            if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                Object object = this._currentObject();
                if (object instanceof Double) {
                    double d2 = (Double)object;
                    return !Double.isFinite(d2);
                }
                if (object instanceof Float) {
                    float f2 = ((Float)object).floatValue();
                    return !Double.isFinite(f2);
                }
            }
            return false;
        }

        @Override
        public final BigInteger getBigIntegerValue() {
            Number number = this.a(true);
            if (number instanceof BigInteger) {
                return (BigInteger)number;
            }
            if (number instanceof BigDecimal) {
                number = (BigDecimal)number;
                ((JsonParser)this).streamReadConstraints().validateBigIntegerScale(((BigDecimal)number).scale());
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }

        @Override
        public final BigDecimal getDecimalValue() {
            Number number = this.a(true);
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            if (number instanceof Integer) {
                return BigDecimal.valueOf(number.intValue());
            }
            if (number instanceof Long) {
                return BigDecimal.valueOf(number.longValue());
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return BigDecimal.valueOf(number.doubleValue());
        }

        @Override
        public final double getDoubleValue() {
            return ((JsonParser)this).getNumberValue().doubleValue();
        }

        @Override
        public final float getFloatValue() {
            return ((JsonParser)this).getNumberValue().floatValue();
        }

        @Override
        public final int getIntValue() {
            Number number;
            Number number2 = this._currToken == JsonToken.VALUE_NUMBER_INT ? (Number)((Number)this._currentObject()) : (Number)((JsonParser)this).getNumberValue();
            if (number2 instanceof Integer || (number = number2) instanceof Short || number instanceof Byte) {
                return number2.intValue();
            }
            return this._convertNumberToInt(number2);
        }

        @Override
        public final long getLongValue() {
            Number number;
            Number number2 = this._currToken == JsonToken.VALUE_NUMBER_INT ? (Number)((Number)this._currentObject()) : (Number)((JsonParser)this).getNumberValue();
            if (number2 instanceof Long || (number = number2) instanceof Integer || number instanceof Short || number instanceof Byte) {
                return number2.longValue();
            }
            return this._convertNumberToLong(number2);
        }

        @Override
        public final JsonParser.NumberType getNumberType() {
            Object object = ((JsonParser)this).getNumberValueDeferred();
            if (object instanceof Integer) {
                return JsonParser.NumberType.INT;
            }
            if (object instanceof Long) {
                return JsonParser.NumberType.LONG;
            }
            if (object instanceof Double) {
                return JsonParser.NumberType.DOUBLE;
            }
            if (object instanceof BigDecimal) {
                return JsonParser.NumberType.BIG_DECIMAL;
            }
            if (object instanceof BigInteger) {
                return JsonParser.NumberType.BIG_INTEGER;
            }
            if (object instanceof Float) {
                return JsonParser.NumberType.FLOAT;
            }
            if (object instanceof Short) {
                return JsonParser.NumberType.INT;
            }
            if (object instanceof String) {
                if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                    return JsonParser.NumberType.BIG_DECIMAL;
                }
                return JsonParser.NumberType.BIG_INTEGER;
            }
            return null;
        }

        @Override
        public final JsonParser.NumberTypeFP getNumberTypeFP() {
            if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                Object object = this._currentObject();
                if (object instanceof Double) {
                    return JsonParser.NumberTypeFP.DOUBLE64;
                }
                if (object instanceof BigDecimal) {
                    return JsonParser.NumberTypeFP.BIG_DECIMAL;
                }
                if (object instanceof Float) {
                    return JsonParser.NumberTypeFP.FLOAT32;
                }
            }
            return JsonParser.NumberTypeFP.UNKNOWN;
        }

        @Override
        public final Number getNumberValue() {
            return this.a(false);
        }

        @Override
        public final Object getNumberValueDeferred() {
            this._checkIsNumber();
            return this._currentObject();
        }

        private Number a(boolean bl2) {
            this._checkIsNumber();
            Object object = this._currentObject();
            if (object instanceof Number) {
                return (Number)object;
            }
            if (object instanceof String) {
                object = (String)object;
                int n2 = ((String)object).length();
                if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
                    if (bl2 || n2 >= 19) {
                        return NumberInput.parseBigInteger((String)object, this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                    }
                    if (n2 >= 10) {
                        return NumberInput.parseLong((String)object);
                    }
                    return NumberInput.parseInt((String)object);
                }
                if (bl2) {
                    BigDecimal bigDecimal = NumberInput.parseBigDecimal((String)object, this.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                    if (bigDecimal == null) {
                        throw new IllegalStateException("Internal error: failed to parse number '" + (String)object + "'");
                    }
                    return bigDecimal;
                }
                return NumberInput.parseDouble((String)object, this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            }
            throw new IllegalStateException("Internal error: entry should be a Number, but is of type " + ClassUtil.classNameOf(object));
        }

        protected final int _convertNumberToInt(Number number) {
            if (number instanceof Long) {
                long l2 = number.longValue();
                int n2 = (int)l2;
                if ((long)n2 != l2) {
                    this.reportOverflowInt();
                }
                return n2;
            }
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                if (BI_MIN_INT.compareTo(bigInteger) > 0 || BI_MAX_INT.compareTo(bigInteger) < 0) {
                    this.reportOverflowInt();
                }
            } else {
                if (number instanceof Double || number instanceof Float) {
                    double d2 = number.doubleValue();
                    if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                        this.reportOverflowInt();
                    }
                    return (int)d2;
                }
                if (number instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)number;
                    if (BD_MIN_INT.compareTo(bigDecimal) > 0 || BD_MAX_INT.compareTo(bigDecimal) < 0) {
                        this.reportOverflowInt();
                    }
                } else {
                    this._throwInternal();
                }
            }
            return number.intValue();
        }

        protected final long _convertNumberToLong(Number number) {
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                if (BI_MIN_LONG.compareTo(bigInteger) > 0 || BI_MAX_LONG.compareTo(bigInteger) < 0) {
                    this.reportOverflowLong();
                }
            } else {
                if (number instanceof Double || number instanceof Float) {
                    double d2 = number.doubleValue();
                    if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                        this.reportOverflowLong();
                    }
                    return (long)d2;
                }
                if (number instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)number;
                    if (BD_MIN_LONG.compareTo(bigDecimal) > 0 || BD_MAX_LONG.compareTo(bigDecimal) < 0) {
                        this.reportOverflowLong();
                    }
                } else {
                    this._throwInternal();
                }
            }
            return number.longValue();
        }

        @Override
        public final Object getEmbeddedObject() {
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return this._currentObject();
            }
            return null;
        }

        @Override
        public final byte[] getBinaryValue(Base64Variant base64Variant) {
            Object object;
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && (object = this._currentObject()) instanceof byte[]) {
                return (byte[])object;
            }
            if (this._currToken != JsonToken.VALUE_STRING) {
                throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING (or VALUE_EMBEDDED_OBJECT with byte[]), cannot access as binary");
            }
            object = ((JsonParser)this).getText();
            if (object == null) {
                return null;
            }
            ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
            if (byteArrayBuilder == null) {
                this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(100);
            } else {
                this._byteBuilder.reset();
            }
            this._decodeBase64((String)object, byteArrayBuilder, base64Variant);
            return byteArrayBuilder.toByteArray();
        }

        @Override
        public final int readBinaryValue(Base64Variant object, OutputStream outputStream) {
            byte[] byArray = ((JsonParser)this).getBinaryValue((Base64Variant)object);
            object = byArray;
            if (byArray != null) {
                outputStream.write((byte[])object, 0, ((Object)object).length);
                return ((Object)object).length;
            }
            return 0;
        }

        @Override
        public final boolean canReadObjectId() {
            return this._hasNativeObjectIds;
        }

        @Override
        public final boolean canReadTypeId() {
            return this._hasNativeTypeIds;
        }

        @Override
        public final Object getTypeId() {
            return this._segment.b(this._segmentPtr);
        }

        @Override
        public final Object getObjectId() {
            return this._segment.a(this._segmentPtr);
        }

        protected final Object _currentObject() {
            return this._segment.get(this._segmentPtr);
        }

        protected final void _checkIsNumber() {
            if (this._currToken == null || !this._currToken.isNumeric()) {
                throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, cannot use numeric value accessors");
            }
        }

        @Override
        protected final void _handleEOF() {
            this._throwInternal();
        }
    }
}

