/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.internal.text.StringEscapeUtils;
import com.github.jknack.handlebars.internal.text.translate.LookupTranslator;
import java.util.HashMap;
import java.util.Map;

public interface EscapingStrategy {
    public static final EscapingStrategy HTML_ENTITY = new Hbs(new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"'", "&#x27;"}, {"`", "&#x60;"}, {"&", "&amp;"}, {"=", "&#x3D;"}});
    public static final EscapingStrategy HBS3 = new Hbs(new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {"\"", "&quot;"}, {"'", "&#x27;"}, {"`", "&#x60;"}, {"&", "&amp;"}});
    public static final EscapingStrategy HBS4 = HTML_ENTITY;
    public static final EscapingStrategy CSV = charSequence -> {
        if (charSequence == null) {
            return null;
        }
        return StringEscapeUtils.escapeCsv(charSequence.toString());
    };
    public static final EscapingStrategy XML = charSequence -> {
        if (charSequence == null) {
            return null;
        }
        return StringEscapeUtils.escapeXml11(charSequence.toString());
    };
    public static final EscapingStrategy JS = charSequence -> {
        if (charSequence == null) {
            return null;
        }
        return StringEscapeUtils.escapeEcmaScript(charSequence.toString());
    };
    public static final EscapingStrategy NOOP = charSequence -> charSequence;
    public static final EscapingStrategy DEF = HBS4;

    public CharSequence escape(CharSequence var1);

    public static class Hbs
    implements EscapingStrategy {
        private final LookupTranslator a;

        public Hbs(String[][] stringArray) {
            this(Hbs.a(stringArray));
        }

        public Hbs(Map<CharSequence, CharSequence> map) {
            this.a = new LookupTranslator(map);
        }

        @Override
        public CharSequence escape(CharSequence charSequence) {
            if (charSequence instanceof Handlebars.SafeString) {
                return ((Handlebars.SafeString)charSequence).content;
            }
            if (charSequence == null || charSequence.length() == 0) {
                return "";
            }
            return this.a.translate(charSequence);
        }

        private static Map<CharSequence, CharSequence> a(String[][] stringArray) {
            HashMap<CharSequence, CharSequence> hashMap = new HashMap<CharSequence, CharSequence>();
            for (String[] stringArray2 : stringArray) {
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
            return hashMap;
        }
    }
}

