/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Decorator;
import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Formatter;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HelperRegistry;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.ParserFactory;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.NullTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.helper.DefaultHelperRegistry;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.internal.Files;
import com.github.jknack.handlebars.internal.FormatterChain;
import com.github.jknack.handlebars.internal.HbsParserFactory;
import com.github.jknack.handlebars.internal.Throwing;
import com.github.jknack.handlebars.internal.lang3.Validate;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.CompositeTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handlebars
implements HelperRegistry {
    public static final String DELIM_START = "{{";
    public static final String DELIM_END = "}}";
    private static final Logger a = LoggerFactory.getLogger(Handlebars.class);
    private TemplateLoader b;
    private TemplateCache c = NullTemplateCache.INSTANCE;
    private boolean d;
    private boolean e;
    private HelperRegistry f = new DefaultHelperRegistry();
    private boolean g;
    private boolean h;
    private EscapingStrategy i = EscapingStrategy.HTML_ENTITY;
    private ParserFactory j = new HbsParserFactory();
    private String k = "{{";
    private String l = "}}";
    private String m = "/handlebars-v4.7.7.js";
    private List<Formatter> n = new ArrayList<Formatter>();
    private Formatter.Chain o = Formatter.NOOP;
    private boolean p = true;
    private boolean q = true;
    private Charset r = StandardCharsets.UTF_8;
    private ScriptEngine s;

    public Handlebars(TemplateLoader templateLoader) {
        this.with(templateLoader);
    }

    public Handlebars() {
        this(new ClassPathTemplateLoader());
    }

    public String precompile(String string) {
        return Throwing.get(() -> {
            Handlebars handlebars = this;
            return handlebars.precompileInline(handlebars.b.sourceAt(string).content(this.r));
        });
    }

    public String precompileInline(String string) {
        return Throwing.get(() -> {
            ScriptEngine scriptEngine = this.a();
            Object object = scriptEngine.getContext().getAttribute("Handlebars");
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("Handlebars", object);
            bindings.put("template", (Object)string);
            return (String)scriptEngine.eval("Handlebars.precompile(template);", bindings);
        });
    }

    public Template compile(String string) {
        return this.compile(string, this.k, this.l);
    }

    public Template compile(String string, String string2, String string3) {
        Handlebars handlebars = this;
        return handlebars.compile(handlebars.b.sourceAt(string), string2, string3);
    }

    public Template compileInline(String string) {
        return this.compileInline(string, this.k, this.l);
    }

    public Template compileInline(String string, String string2, String string3) {
        Validate.notNull(string, "The input is required.", new Object[0]);
        String string4 = "inline@" + Integer.toHexString(Math.abs(string.hashCode()));
        return this.compile(new StringTemplateSource(string4, string), string2, string3);
    }

    public Template compile(TemplateSource templateSource) {
        return this.compile(templateSource, this.k, this.l);
    }

    public Template compile(TemplateSource object, String object2, String string) {
        Validate.notNull(object, "The template source is required.", new Object[0]);
        Validate.notEmpty(object2, "The start delimiter is required.", new Object[0]);
        Validate.notEmpty(string, "The end delimiter is required.", new Object[0]);
        object2 = this.j.create(this, (String)object2, string);
        object = this.c.get((TemplateSource)object, (Parser)object2);
        return object;
    }

    @Override
    public <C> Helper<C> helper(String string) {
        return this.f.helper(string);
    }

    @Override
    public <H> Handlebars registerHelper(String string, Helper<H> helper) {
        this.f.registerHelper(string, helper);
        return this;
    }

    @Override
    public <H> Handlebars registerHelperMissing(Helper<H> helper) {
        return this.registerHelper("helperMissing", (Helper)helper);
    }

    @Override
    public Handlebars registerHelpers(Object object) {
        this.f.registerHelpers(object);
        return this;
    }

    @Override
    public Handlebars registerHelpers(Class<?> clazz) {
        this.f.registerHelpers(clazz);
        return this;
    }

    @Override
    public Handlebars registerHelpers(URI uRI) {
        this.f.registerHelpers(uRI);
        return this;
    }

    @Override
    public Handlebars registerHelpers(File file) {
        this.f.registerHelpers(file);
        return this;
    }

    @Override
    public Handlebars registerHelpers(String string, Reader reader) {
        this.f.registerHelpers(string, reader);
        return this;
    }

    @Override
    public Handlebars registerHelpers(String string, InputStream inputStream) {
        this.f.registerHelpers(string, inputStream);
        return this;
    }

    @Override
    public Handlebars registerHelpers(String string, String string2) {
        this.f.registerHelpers(string, string2);
        return this;
    }

    @Override
    public Set<Map.Entry<String, Helper<?>>> helpers() {
        return this.f.helpers();
    }

    public TemplateLoader getLoader() {
        return this.b;
    }

    public TemplateCache getCache() {
        return this.c;
    }

    public EscapingStrategy getEscapingStrategy() {
        return this.i;
    }

    public boolean stringParams() {
        return this.d;
    }

    public boolean prettyPrint() {
        return this.e;
    }

    public void setPrettyPrint(boolean bl2) {
        this.e = bl2;
    }

    public Handlebars prettyPrint(boolean bl2) {
        this.setPrettyPrint(bl2);
        return this;
    }

    public void setStringParams(boolean bl2) {
        this.d = bl2;
    }

    public Handlebars stringParams(boolean bl2) {
        this.setStringParams(bl2);
        return this;
    }

    public boolean infiniteLoops() {
        return this.g;
    }

    public void setInfiniteLoops(boolean bl2) {
        this.g = bl2;
    }

    public Handlebars infiniteLoops(boolean bl2) {
        this.setInfiniteLoops(bl2);
        return this;
    }

    public boolean deletePartialAfterMerge() {
        return this.h;
    }

    public Handlebars deletePartialAfterMerge(boolean bl2) {
        this.setDeletePartialAfterMerge(bl2);
        return this;
    }

    public void setDeletePartialAfterMerge(boolean bl2) {
        this.h = bl2;
    }

    public void setEndDelimiter(String string) {
        this.l = Validate.notEmpty(string, "The endDelimiter is required.", new Object[0]);
    }

    public Handlebars endDelimiter(String string) {
        this.setEndDelimiter(string);
        return this;
    }

    public String getEndDelimiter() {
        return this.l;
    }

    public void setStartDelimiter(String string) {
        this.k = Validate.notEmpty(string, "The startDelimiter is required.", new Object[0]);
    }

    public Handlebars startDelimiter(String string) {
        this.setStartDelimiter(string);
        return this;
    }

    public String getStartDelimiter() {
        return this.k;
    }

    public Handlebars with(TemplateLoader ... templateLoaderArray) {
        Validate.isTrue(templateLoaderArray.length > 0, "The template loader is required.", new Object[0]);
        this.b = templateLoaderArray.length == 1 ? templateLoaderArray[0] : new CompositeTemplateLoader(templateLoaderArray);
        return this;
    }

    public Handlebars with(ParserFactory parserFactory) {
        this.j = Validate.notNull(parserFactory, "A parserFactory is required.", new Object[0]);
        return this;
    }

    public Handlebars with(TemplateCache templateCache) {
        this.c = Validate.notNull(templateCache, "The template cache is required.", new Object[0]);
        return this;
    }

    public Handlebars with(HelperRegistry helperRegistry) {
        this.f = Validate.notNull(helperRegistry, "The registry is required.", new Object[0]);
        return this;
    }

    public Handlebars with(EscapingStrategy escapingStrategy) {
        this.i = Validate.notNull(escapingStrategy, "The escaping strategy is required.", new Object[0]);
        return this;
    }

    public Handlebars with(EscapingStrategy ... escapingStrategyArray) {
        return this.with((CharSequence charSequence) -> {
            for (EscapingStrategy escapingStrategy : escapingStrategyArray) {
                charSequence = escapingStrategy.escape(charSequence);
            }
            return charSequence;
        });
    }

    public Formatter.Chain getFormatter() {
        return this.o;
    }

    public Handlebars with(Formatter formatter) {
        Validate.notNull(formatter, "A formatter is required.", new Object[0]);
        this.n.add(formatter);
        this.o = new FormatterChain(this.n);
        return this;
    }

    public Handlebars handlebarsJsFile(String object) {
        this.m = Validate.notEmpty(object, "A handlebars.js location is required.", new Object[0]);
        if (!this.m.startsWith("/")) {
            this.m = "/" + this.m;
        }
        if ((object = this.getClass().getResource(this.m)) == null) {
            throw new IllegalArgumentException("File not found: " + this.m);
        }
        return this;
    }

    public String handlebarsJsFile() {
        return this.m;
    }

    public boolean parentScopeResolution() {
        return this.p;
    }

    public void setParentScopeResolution(boolean bl2) {
        this.p = bl2;
    }

    public Handlebars parentScopeResolution(boolean bl2) {
        this.setParentScopeResolution(bl2);
        return this;
    }

    public boolean preEvaluatePartialBlocks() {
        return this.q;
    }

    public void setPreEvaluatePartialBlocks(boolean bl2) {
        this.q = bl2;
    }

    public Handlebars preEvaluatePartialBlocks(boolean bl2) {
        this.setPreEvaluatePartialBlocks(bl2);
        return this;
    }

    public ParserFactory getParserFactory() {
        return this.j;
    }

    public static void log(String string, Object ... objectArray) {
        a.info(String.format(string, objectArray));
    }

    public static void log(String string) {
        a.info(string);
    }

    public static void warn(String string, Object ... objectArray) {
        if (a.isWarnEnabled()) {
            a.warn(String.format(string, objectArray));
        }
    }

    public static void warn(String string) {
        a.warn(string);
    }

    public static void debug(String string, Object ... objectArray) {
        if (a.isDebugEnabled()) {
            a.debug(String.format(string, objectArray));
        }
    }

    public static void debug(String string) {
        a.debug(string);
    }

    public static void error(String string, Object ... objectArray) {
        a.error(String.format(string, objectArray));
    }

    public static void error(String string) {
        a.error(string);
    }

    @Override
    public Decorator decorator(String string) {
        return this.f.decorator(string);
    }

    @Override
    public Handlebars registerDecorator(String string, Decorator decorator) {
        this.f.registerDecorator(string, decorator);
        return this;
    }

    @Override
    public Handlebars setCharset(Charset charset) {
        this.r = Validate.notNull(charset, "Charset required.", new Object[0]);
        this.f.setCharset(charset);
        this.b.setCharset(charset);
        I18nHelper.i18n.setCharset(charset);
        I18nHelper.i18nJs.setCharset(charset);
        return this;
    }

    public Charset getCharset() {
        return this.r;
    }

    private ScriptEngine a() {
        Handlebars handlebars = this;
        synchronized (handlebars) {
            if (this.s == null) {
                this.s = new ScriptEngineManager().getEngineByName("nashorn");
                Throwing.run(() -> this.s.eval(Files.read(this.m, this.r)));
            }
            return this.s;
        }
    }

    public static class Utils {
        public static final int javaVersion = Utils.a();
        public static final boolean javaVersion14 = Utils.a() >= 14;

        public static boolean isEmpty(Object object) {
            if (object == null) {
                return true;
            }
            if (object instanceof CharSequence) {
                return ((CharSequence)object).length() == 0;
            }
            if (object instanceof Collection) {
                return ((Collection)object).size() == 0;
            }
            if (object instanceof Iterable) {
                return !((Iterable)object).iterator().hasNext();
            }
            if (object instanceof Boolean) {
                return (Boolean)object == false;
            }
            if (object.getClass().isArray()) {
                return Array.getLength(object) == 0;
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue() == 0.0;
            }
            return false;
        }

        public static CharSequence escapeExpression(CharSequence charSequence) {
            return EscapingStrategy.DEF.escape(charSequence);
        }

        private static int a() {
            String string = System.getProperty("java.specification.version").trim();
            return Integer.parseInt(string.replace("1.", ""));
        }

        public static RuntimeException propagate(Throwable throwable) {
            if (throwable == null) {
                throw new NullPointerException("x");
            }
            throw throwable;
        }
    }

    public static class SafeString
    implements CharSequence {
        public final CharSequence content;

        public SafeString(CharSequence charSequence) {
            this.content = charSequence;
        }

        @Override
        public int length() {
            return this.content.length();
        }

        @Override
        public char charAt(int n2) {
            return this.content.charAt(n2);
        }

        @Override
        public CharSequence subSequence(int n2, int n3) {
            return this.content.subSequence(n2, n3);
        }

        @Override
        public String toString() {
            return this.content.toString();
        }

        public int hashCode() {
            int n2 = 31 + (this.content == null ? 0 : this.content.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (object instanceof SafeString) {
                object = (SafeString)object;
                return this.content.equals(((SafeString)object).content);
            }
            return false;
        }
    }
}

