/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.internal.lang3.Validate;
import java.util.Objects;

public enum ConditionalHelpers implements Helper<Object>
{
    eq{

        @Override
        public final Object apply(Object object, Options options) {
            Object var3_4 = options.param(0, null);
            boolean bl2 = this.eq(object, var3_4);
            if (options.tagType == TagType.SECTION) {
                if (bl2) {
                    return options.fn();
                }
                return options.inverse();
            }
            if (bl2) {
                return options.hash("yes", Boolean.TRUE);
            }
            return options.hash("no", Boolean.FALSE);
        }
    }
    ,
    neq{

        @Override
        public final Object apply(Object object, Options options) {
            boolean bl2;
            Object var3_4 = options.param(0, null);
            boolean bl3 = bl2 = !this.eq(object, var3_4);
            if (options.tagType == TagType.SECTION) {
                if (bl2) {
                    return options.fn();
                }
                return options.inverse();
            }
            if (bl2) {
                return options.hash("yes", Boolean.TRUE);
            }
            return options.hash("no", Boolean.FALSE);
        }
    }
    ,
    gt{

        @Override
        public final Object apply(Object object, Options options) {
            boolean bl2;
            boolean bl3 = bl2 = this.cmp(object, options.param(0, null)) > 0;
            if (options.tagType == TagType.SECTION) {
                if (bl2) {
                    return options.fn();
                }
                return options.inverse();
            }
            if (bl2) {
                return options.hash("yes", Boolean.TRUE);
            }
            return options.hash("no", Boolean.FALSE);
        }
    }
    ,
    gte{

        @Override
        public final Object apply(Object object, Options options) {
            boolean bl2;
            boolean bl3 = bl2 = this.cmp(object, options.param(0, null)) >= 0;
            if (options.tagType == TagType.SECTION) {
                if (bl2) {
                    return options.fn();
                }
                return options.inverse();
            }
            if (bl2) {
                return options.hash("yes", Boolean.TRUE);
            }
            return options.hash("no", Boolean.FALSE);
        }
    }
    ,
    lt{

        @Override
        public final Object apply(Object object, Options options) {
            boolean bl2;
            boolean bl3 = bl2 = this.cmp(object, options.param(0, null)) < 0;
            if (options.tagType == TagType.SECTION) {
                if (bl2) {
                    return options.fn();
                }
                return options.inverse();
            }
            if (bl2) {
                return options.hash("yes", Boolean.TRUE);
            }
            return options.hash("no", Boolean.FALSE);
        }
    }
    ,
    lte{

        @Override
        public final Object apply(Object object, Options options) {
            boolean bl2;
            boolean bl3 = bl2 = this.cmp(object, options.param(0, null)) <= 0;
            if (options.tagType == TagType.SECTION) {
                if (bl2) {
                    return options.fn();
                }
                return options.inverse();
            }
            if (bl2) {
                return options.hash("yes", Boolean.TRUE);
            }
            return options.hash("no", Boolean.FALSE);
        }
    }
    ,
    and{

        @Override
        public final Object apply(Object object, Options options) {
            boolean bl2 = !Handlebars.Utils.isEmpty(object);
            if (bl2) {
                for (int i2 = 0; i2 < options.params.length && bl2; ++i2) {
                    bl2 = !Handlebars.Utils.isEmpty(options.params[i2]);
                }
            }
            if (options.tagType == TagType.SECTION) {
                if (bl2) {
                    return options.fn();
                }
                return options.inverse();
            }
            if (bl2) {
                return options.hash("yes", Boolean.TRUE);
            }
            return options.hash("no", Boolean.FALSE);
        }
    }
    ,
    or{

        @Override
        public final Object apply(Object object, Options options) {
            boolean bl2 = !Handlebars.Utils.isEmpty(object);
            if (!bl2) {
                int n2 = 0;
                while (!bl2 && n2 < options.params.length) {
                    bl2 = !Handlebars.Utils.isEmpty(options.params[n2++]);
                }
            }
            if (options.tagType == TagType.SECTION) {
                if (bl2) {
                    return options.fn();
                }
                return options.inverse();
            }
            if (bl2) {
                return options.hash("yes", Boolean.TRUE);
            }
            return options.hash("no", Boolean.FALSE);
        }
    }
    ,
    not{

        @Override
        public final Object apply(Object object, Options options) {
            boolean bl2 = Handlebars.Utils.isEmpty(object);
            if (options.tagType == TagType.SECTION) {
                if (bl2) {
                    return options.fn();
                }
                return options.inverse();
            }
            if (bl2) {
                return options.hash("yes", Boolean.TRUE);
            }
            return options.hash("no", Boolean.FALSE);
        }
    };


    private ConditionalHelpers() {
    }

    protected int cmp(Object object, Object object2) {
        try {
            Validate.isTrue(object instanceof Comparable, "Not a comparable: " + object, new Object[0]);
            Validate.isTrue(object2 instanceof Comparable, "Not a comparable: " + object2, new Object[0]);
            return ((Comparable)object).compareTo(object2);
        }
        catch (ClassCastException classCastException) {
            return Double.compare(ConditionalHelpers.a(object, classCastException), ConditionalHelpers.a(object2, classCastException));
        }
    }

    protected boolean eq(Object object, Object object2) {
        boolean bl2 = Objects.equals(object, object2);
        if (!bl2 && object instanceof Number && object2 instanceof Number) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        return bl2;
    }

    private static double a(Object object, RuntimeException runtimeException) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw runtimeException;
    }

    /* synthetic */ ConditionalHelpers(String string, int n2, byte by) {
        this();
    }
}

