/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Decorator;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HelperRegistry;
import com.github.jknack.handlebars.helper.BlockHelper;
import com.github.jknack.handlebars.helper.EachHelper;
import com.github.jknack.handlebars.helper.EmbeddedHelper;
import com.github.jknack.handlebars.helper.HelperFunction;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.helper.IfHelper;
import com.github.jknack.handlebars.helper.InlineDecorator;
import com.github.jknack.handlebars.helper.LogHelper;
import com.github.jknack.handlebars.helper.LookupHelper;
import com.github.jknack.handlebars.helper.MethodHelper;
import com.github.jknack.handlebars.helper.PartialHelper;
import com.github.jknack.handlebars.helper.PrecompileHelper;
import com.github.jknack.handlebars.helper.UnlessHelper;
import com.github.jknack.handlebars.helper.WithHelper;
import com.github.jknack.handlebars.internal.Files;
import com.github.jknack.handlebars.internal.Throwing;
import com.github.jknack.handlebars.internal.lang3.Validate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHelperRegistry
implements HelperRegistry {
    private final Logger a = LoggerFactory.getLogger(HelperRegistry.class);
    private static final String b;
    private final Map<String, Helper<?>> c = new HashMap();
    private final Map<String, Decorator> d = new HashMap<String, Decorator>();
    private Charset e = StandardCharsets.UTF_8;
    private ScriptEngine f;
    private Pattern g = Pattern.compile("(?:^|[\\s(;])(let|const)\\s+");

    public DefaultHelperRegistry() {
        DefaultHelperRegistry defaultHelperRegistry = this;
        defaultHelperRegistry.registerHelper("with", WithHelper.INSTANCE);
        defaultHelperRegistry.registerHelper("if", IfHelper.INSTANCE);
        defaultHelperRegistry.registerHelper("unless", UnlessHelper.INSTANCE);
        defaultHelperRegistry.registerHelper("each", EachHelper.INSTANCE);
        defaultHelperRegistry.registerHelper("embedded", EmbeddedHelper.INSTANCE);
        defaultHelperRegistry.registerHelper("block", BlockHelper.INSTANCE);
        defaultHelperRegistry.registerHelper("partial", PartialHelper.INSTANCE);
        defaultHelperRegistry.registerHelper("precompile", PrecompileHelper.INSTANCE);
        defaultHelperRegistry.registerHelper("i18n", I18nHelper.i18n);
        defaultHelperRegistry.registerHelper("i18nJs", I18nHelper.i18nJs);
        defaultHelperRegistry.registerHelper("lookup", LookupHelper.INSTANCE);
        defaultHelperRegistry.registerHelper("log", LogHelper.INSTANCE);
        defaultHelperRegistry.registerDecorator("inline", InlineDecorator.INSTANCE);
    }

    @Override
    public <C> Helper<C> helper(String string) {
        Validate.notEmpty(string, "A helper's name is required.", new Object[0]);
        return this.c.get(string);
    }

    @Override
    public <H> HelperRegistry registerHelper(String string, Helper<H> helper) {
        Validate.notEmpty(string, "A helper's name is required.", new Object[0]);
        Validate.notNull(helper, "A helper is required.", new Object[0]);
        Helper<H> helper2 = this.c.put(string, helper);
        if (helper2 != null) {
            this.a.debug("Helper '{}' has been replaced by '{}'", (Object)string, (Object)helper);
        }
        return this;
    }

    @Override
    public <H> HelperRegistry registerHelperMissing(Helper<H> helper) {
        return this.registerHelper("helperMissing", helper);
    }

    @Override
    public HelperRegistry registerHelpers(Object object) {
        Validate.notNull(object, "The helper source is required.", new Object[0]);
        Validate.isTrue(!(object instanceof String), "java.lang.String isn't a helper source.", new Object[0]);
        try {
            if (object instanceof File) {
                return this.registerHelpers((File)object);
            }
            if (object instanceof URI) {
                return this.registerHelpers((URI)object);
            }
            if (object instanceof Class) {
                return this.registerHelpers((Class)object);
            }
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't register helpers", exception);
        }
        Object object2 = object;
        this.a(object2, object2.getClass());
        return this;
    }

    @Override
    public HelperRegistry registerHelpers(Class<?> enumArray) {
        Validate.notNull(enumArray, "The helper source is required.", new Object[0]);
        if (Enum.class.isAssignableFrom((Class<?>)enumArray)) {
            Enum[] enumArray2 = (Enum[])enumArray.getEnumConstants();
            enumArray = enumArray2;
            enumArray = enumArray2;
            int n2 = enumArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Enum enum_ = enumArray[i2];
                Validate.isTrue(enum_ instanceof Helper, "'%s' isn't a helper.", enum_.name());
                this.registerHelper(enum_.name(), (Helper)((Object)enum_));
            }
        } else {
            this.a((Object)null, (Class<?>)enumArray);
        }
        return this;
    }

    @Override
    public HelperRegistry registerHelpers(URI uRI) {
        return this.registerHelpers(uRI.getPath(), Files.read(uRI.toString(), this.e));
    }

    @Override
    public HelperRegistry registerHelpers(File file) {
        return this.registerHelpers(file.getAbsolutePath(), Files.read(file, this.e));
    }

    @Override
    public HelperRegistry registerHelpers(String string, Reader reader) {
        return this.registerHelpers(string, Files.read(reader));
    }

    @Override
    public HelperRegistry registerHelpers(String string, InputStream inputStream) {
        return this.registerHelpers(string, Files.read(inputStream, this.e));
    }

    @Override
    public HelperRegistry registerHelpers(String object, String string) {
        Validate.notNull(object, "The filename is required.", new Object[0]);
        Validate.notEmpty(string, "The source is required.", new Object[0]);
        object = this.a();
        Throwing.run(() -> this.a((ScriptEngine)object, string));
        return this;
    }

    @Override
    public Set<Map.Entry<String, Helper<?>>> helpers() {
        return this.c.entrySet();
    }

    private void a(Object object, Class<?> methodArray) {
        if (methodArray != Object.class) {
            HashSet<Object> hashSet = new HashSet<Object>();
            Method[] methodArray2 = methodArray.getDeclaredMethods();
            methodArray = methodArray2;
            methodArray = methodArray2;
            int n2 = methodArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Method method = methodArray[i2];
                boolean bl2 = Modifier.isPublic(method.getModifiers());
                if (!bl2) continue;
                bl2 = Modifier.isStatic(method.getModifiers());
                if (object == null && !bl2) continue;
                Object object2 = method.getAnnotation(HelperFunction.class);
                object2 = object2 != null ? object2.value() : method.getName();
                Validate.isTrue(hashSet.add(object2), "name conflict found: " + (String)object2, new Object[0]);
                this.registerHelper((String)object2, new MethodHelper(method, object));
            }
        }
    }

    @Override
    public Decorator decorator(String string) {
        Validate.notEmpty(string, "A decorator's name is required.", new Object[0]);
        return this.d.get(string);
    }

    @Override
    public HelperRegistry registerDecorator(String string, Decorator decorator) {
        Validate.notEmpty(string, "A decorator's name is required.", new Object[0]);
        Validate.notNull(decorator, "A decorator is required.", new Object[0]);
        Decorator decorator2 = this.d.put(string, decorator);
        if (decorator2 != null) {
            this.a.warn("Decorator '{}' has been replaced by '{}'", (Object)string, (Object)decorator);
        }
        return this;
    }

    @Override
    public DefaultHelperRegistry setCharset(Charset charset) {
        this.e = Validate.notNull(charset, "Charset required.", new Object[0]);
        return this;
    }

    private ScriptEngine a() {
        DefaultHelperRegistry defaultHelperRegistry = this;
        synchronized (defaultHelperRegistry) {
            if (this.f == null) {
                this.f = new ScriptEngineManager().getEngineByName("nashorn");
                this.f.put("Handlebars_java", this);
                Throwing.run(() -> this.f.eval(b));
            }
            return this.f;
        }
    }

    private /* synthetic */ void a(ScriptEngine object, String charSequence) {
        ScriptEngine scriptEngine = object;
        object = this;
        object = ((DefaultHelperRegistry)object).g.matcher(charSequence);
        charSequence = new StringBuffer();
        while (((Matcher)object).find()) {
            StringBuffer stringBuffer = new StringBuffer(((Matcher)object).group());
            stringBuffer.replace(((Matcher)object).start(1) - ((Matcher)object).start(), ((Matcher)object).end(1) - ((Matcher)object).start(), "var");
            ((Matcher)object).appendReplacement((StringBuffer)charSequence, stringBuffer.toString());
        }
        scriptEngine.eval(((Matcher)object).appendTail((StringBuffer)charSequence).toString());
    }

    static {
        String string = "/helpers.nashorn.js";
        try {
            b = Files.read(string, StandardCharsets.UTF_8);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("File not found: " + string, iOException);
        }
    }
}

