/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.helper.a;
import com.github.jknack.handlebars.internal.lang3.LocaleUtils;
import com.github.jknack.handlebars.internal.lang3.StringUtils;
import com.github.jknack.handlebars.internal.lang3.Validate;
import com.github.jknack.handlebars.internal.text.WordUtils;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum StringHelpers implements Helper<Object>
{
    capitalizeFirst{

        @Override
        protected final CharSequence safeApply(Object object, Options options) {
            return StringUtils.capitalize(object.toString());
        }
    }
    ,
    center{

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            Integer n2 = (Integer)((Options)object2).hash("size");
            Validate.notNull(n2, "found 'null', expected 'size'", new Object[0]);
            object2 = (String)((Options)object2).hash("pad", " ");
            return StringUtils.center(object.toString(), (int)n2, (String)object2);
        }
    }
    ,
    cut{

        @Override
        public final Object apply(Object object, Options options) {
            return this.safeApply(object, options);
        }

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            if (((Options)object2).isFalsy(object)) {
                return "";
            }
            object2 = ((Options)object2).param(0, " ");
            return object.toString().replace((CharSequence)object2, "");
        }
    }
    ,
    defaultIfEmpty{

        @Override
        public final Object apply(Object object, Options options) {
            if (Handlebars.Utils.isEmpty(object)) {
                return options.param(0, "");
            }
            return String.valueOf(object);
        }

        @Override
        protected final CharSequence safeApply(Object object, Options options) {
            return null;
        }
    }
    ,
    join{

        @Override
        public final Object apply(Object object, Options options) {
            if (options.isFalsy(object)) {
                return "";
            }
            return this.safeApply(object, options);
        }

        @Override
        protected final CharSequence safeApply(Object object, Options options) {
            int n2 = options.params.length - 1;
            Object t2 = options.param(n2, null);
            Validate.notNull(t2, "found 'null', expected 'separator' at param[%s]", n2);
            Validate.isTrue(t2 instanceof String, "found '%s', expected 'separator' at param[%s]", t2, n2);
            String string = (String)options.hash("prefix", "");
            String string2 = (String)options.hash("suffix", "");
            if (object instanceof Iterable) {
                return string + StringUtils.join((Iterable)object, (String)t2) + string2;
            }
            if (object instanceof Iterator) {
                return string + StringUtils.join((Iterator)object, (String)t2) + string2;
            }
            if (object.getClass().isArray()) {
                return string + StringUtils.join((Object[])object, (String)t2) + string2;
            }
            Object[] objectArray = new Object[options.params.length];
            System.arraycopy(options.params, 0, objectArray, 1, n2);
            objectArray[0] = object;
            return string + StringUtils.join(objectArray, (String)t2) + string2;
        }
    }
    ,
    ljust{

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            Integer n2 = (Integer)((Options)object2).hash("size");
            Validate.notNull(n2, "found 'null', expected 'size'", new Object[0]);
            object2 = (String)((Options)object2).hash("pad", " ");
            return StringUtils.rightPad(object.toString(), (int)n2, (String)object2);
        }
    }
    ,
    rjust{

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            Integer n2 = (Integer)((Options)object2).hash("size");
            Validate.notNull(n2, "found 'null', expected 'size'", new Object[0]);
            object2 = (String)((Options)object2).hash("pad", " ");
            return StringUtils.leftPad(object.toString(), (int)n2, (String)object2);
        }
    }
    ,
    substring{

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            Validate.validIndex(((Options)object2).params, 0, "Required start offset: ", new Object[0]);
            object = object.toString();
            Integer n2 = (Integer)((Options)object2).param(0);
            object2 = ((Options)object2).param(1, ((String)object).length());
            return ((String)object).subSequence(n2, (Integer)object2);
        }
    }
    ,
    lower{

        @Override
        protected final CharSequence safeApply(Object object, Options options) {
            return object.toString().toLowerCase();
        }
    }
    ,
    upper{

        @Override
        protected final CharSequence safeApply(Object object, Options options) {
            return object.toString().toUpperCase();
        }
    }
    ,
    slugify{

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            object = StringUtils.strip(object.toString());
            object2 = new StringBuilder(((String)object).length());
            for (int i2 = 0; i2 < ((String)object).length(); ++i2) {
                char c2 = ((String)object).charAt(i2);
                if (Character.isLetter(c2)) {
                    ((StringBuilder)object2).append(Character.toLowerCase(c2));
                }
                if (!Character.isWhitespace(c2)) continue;
                ((StringBuilder)object2).append('-');
            }
            return ((StringBuilder)object2).toString();
        }
    }
    ,
    stringFormat{

        @Override
        protected final CharSequence safeApply(Object object, Options options) {
            return String.format(object.toString(), options.params);
        }
    }
    ,
    stripTags{
        private final Pattern a = Pattern.compile("\\<[^>]*>", 32);

        @Override
        protected final CharSequence safeApply(Object object, Options options) {
            object = this.a.matcher(object.toString());
            return ((Matcher)object).replaceAll("");
        }
    }
    ,
    capitalize{

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            if (((Boolean)(object2 = (Boolean)((Options)object2).hash("fully", Boolean.FALSE))).booleanValue()) {
                return WordUtils.capitalizeFully(object.toString());
            }
            return WordUtils.capitalize(object.toString());
        }
    }
    ,
    abbreviate{

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            object2 = ((Options)object2).param(0, null);
            Validate.notNull(object2, "found 'null', expected 'width'", new Object[0]);
            return StringUtils.abbreviate(object.toString(), (Integer)object2);
        }
    }
    ,
    wordWrap{

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            object2 = ((Options)object2).param(0, null);
            Validate.notNull(object2, "found 'null', expected 'length'", new Object[0]);
            return WordUtils.wrap(object.toString(), (Integer)object2);
        }
    }
    ,
    replace{

        @Override
        public final CharSequence safeApply(Object object, Options object2) {
            String string = ((Options)object2).param(0, null);
            object2 = ((Options)object2).param(1, null);
            return object.toString().replace(string, (CharSequence)object2);
        }
    }
    ,
    yesno{

        @Override
        public final Object apply(Object object, Options options) {
            if (object == null) {
                return options.hash("maybe", "maybe");
            }
            Validate.isTrue(object instanceof Boolean, "found '%s', expected 'boolean'", object);
            if (Boolean.TRUE.equals(object)) {
                return options.hash("yes", "yes");
            }
            return options.hash("no", "no");
        }

        @Override
        protected final CharSequence safeApply(Object object, Options options) {
            return null;
        }
    }
    ,
    dateFormat{
        private final Map<String, FormatStyle> a = new HashMap<String, FormatStyle>(this, 4){
            private /* synthetic */ 11 a;
            {
                this.a = var1_1;
                super(4);
                this.put("full", FormatStyle.FULL);
                this.put("long", FormatStyle.LONG);
                this.put("medium", FormatStyle.MEDIUM);
                this.put("short", FormatStyle.SHORT);
            }
        };

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            TemporalAccessor temporalAccessor;
            if (object instanceof TemporalAccessor) {
                temporalAccessor = (TemporalAccessor)object;
            } else if (object instanceof Date) {
                temporalAccessor = ((Date)object).toInstant();
            } else {
                object2 = null;
                if (object != null) {
                    object2 = object.getClass().getSimpleName();
                }
                throw new IllegalArgumentException(String.format("found instance of %s with value '%s', but expected instance of TemporalAccessor", object2, object));
            }
            object = temporalAccessor;
            Object object3 = (String)((Options)object2).param(0, ((Options)object2).hash("format", "medium"));
            Object object4 = this.a.get(object3);
            FormatStyle formatStyle = this.a.get(((Options)object2).hash("time"));
            object3 = object4 == null ? DateTimeFormatter.ofPattern((String)object3) : (formatStyle != null ? DateTimeFormatter.ofLocalizedDateTime((FormatStyle)((Object)object4), formatStyle) : DateTimeFormatter.ofLocalizedDate((FormatStyle)((Object)object4)));
            object4 = (String)((Options)object2).param(1, ((Options)object2).hash("locale"));
            object4 = object4 != null && ((String)object4).length() > 0 ? LocaleUtils.toLocale((String)object4) : Locale.getDefault();
            object3 = ((DateTimeFormatter)object3).withLocale((Locale)object4);
            object2 = ((Options)object2).hash("tz");
            if (object2 != null) {
                object2 = object2 instanceof ZoneId ? (ZoneId)object2 : (object2 instanceof TimeZone ? ((TimeZone)object2).toZoneId() : TimeZone.getTimeZone(object2.toString()).toZoneId());
                object3 = ((DateTimeFormatter)object3).withZone((ZoneId)object2);
            } else {
                object3 = ((DateTimeFormatter)object3).withZone(ZoneId.systemDefault());
            }
            return ((DateTimeFormatter)object3).format((TemporalAccessor)object);
        }
    }
    ,
    numberFormat{

        @Override
        public final Object apply(Object object, Options options) {
            if (object instanceof Number) {
                return this.safeApply(object, options);
            }
            object = options.param(0, null);
            if (object == null) {
                return null;
            }
            return object.toString();
        }

        @Override
        protected final CharSequence safeApply(Object object, Options object2) {
            Validate.isTrue(object instanceof Number, "found '%s', expected 'number'", object);
            object = (Number)object;
            NumberFormat numberFormat = 13.a((Options)object2);
            Comparable<Boolean> comparable = (Boolean)((Options)object2).hash("groupingUsed");
            if (comparable != null) {
                numberFormat.setGroupingUsed((Boolean)comparable);
            }
            if ((comparable = (Integer)((Options)object2).hash("maximumFractionDigits")) != null) {
                numberFormat.setMaximumFractionDigits((Integer)comparable);
            }
            if ((comparable = (Integer)((Options)object2).hash("maximumIntegerDigits")) != null) {
                numberFormat.setMaximumIntegerDigits((Integer)comparable);
            }
            if ((comparable = (Integer)((Options)object2).hash("minimumFractionDigits")) != null) {
                numberFormat.setMinimumFractionDigits((Integer)comparable);
            }
            if ((comparable = (Integer)((Options)object2).hash("minimumIntegerDigits")) != null) {
                numberFormat.setMinimumIntegerDigits((Integer)comparable);
            }
            if ((comparable = (Boolean)((Options)object2).hash("parseIntegerOnly")) != null) {
                numberFormat.setParseIntegerOnly((Boolean)comparable);
            }
            if ((object2 = (String)((Options)object2).hash("roundingMode")) != null) {
                numberFormat.setRoundingMode(RoundingMode.valueOf(((String)object2).toUpperCase().trim()));
            }
            return numberFormat.format(object);
        }

        private static NumberFormat a(Options object) {
            if (((Options)object).params.length == 0) {
                return ((a)com.github.jknack.handlebars.helper.a.a).a(Locale.getDefault());
            }
            Validate.isTrue(((Options)object).params[0] instanceof String, "found '%s', expected 'string'", ((Options)object).params[0]);
            String string = (String)((Options)object).param(0);
            object = ((Options)object).param(1, Locale.getDefault().toString());
            object = LocaleUtils.toLocale((String)object);
            try {
                a a2 = com.github.jknack.handlebars.helper.a.valueOf(string.toUpperCase().trim());
                return a2.a((Locale)object);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return ((a)com.github.jknack.handlebars.helper.a.a).a((Locale)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new DecimalFormat(string, new DecimalFormatSymbols((Locale)object));
            }
        }
    }
    ,
    now{

        @Override
        protected final CharSequence safeApply(Object object, Options options) {
            return dateFormat.safeApply(new Date(), options);
        }
    };


    private StringHelpers() {
    }

    @Override
    public Object apply(Object object, Options options) {
        if (options.isFalsy(object)) {
            object = options.param(0, null);
            if (object == null) {
                return null;
            }
            return object.toString();
        }
        return this.safeApply(object, options);
    }

    protected abstract CharSequence safeApply(Object var1, Options var2);

    public void registerHelper(Handlebars handlebars) {
        Validate.notNull(handlebars, "The handlebars is required.", new Object[0]);
        handlebars.registerHelper(this.name(), (Helper)this);
    }

    public static void register(Handlebars handlebars) {
        Validate.notNull(handlebars, "A handlebars object is required.", new Object[0]);
        StringHelpers[] stringHelpersArray = StringHelpers.values();
        StringHelpers[] stringHelpersArray2 = stringHelpersArray;
        stringHelpersArray2 = stringHelpersArray;
        int n2 = stringHelpersArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StringHelpers stringHelpers = stringHelpersArray2[i2];
            stringHelpers.registerHelper(handlebars);
        }
    }

    /* synthetic */ StringHelpers(String string, int n2, byte by) {
        this();
    }
}

