/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr;

import com.github.jknack.handlebars.internal.antlr.CharStream;
import com.github.jknack.handlebars.internal.antlr.misc.Interval;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;

public class ANTLRInputStream
implements CharStream {
    public static final int READ_BUFFER_SIZE = 1024;
    public static final int INITIAL_BUFFER_SIZE = 1024;
    protected char[] data;
    protected int n;
    protected int p = 0;
    public String name;

    public ANTLRInputStream() {
    }

    public ANTLRInputStream(String string) {
        this.data = string.toCharArray();
        this.n = string.length();
    }

    public ANTLRInputStream(char[] cArray, int n2) {
        this.data = cArray;
        this.n = n2;
    }

    public ANTLRInputStream(Reader reader) {
        this(reader, 1024, 1024);
    }

    public ANTLRInputStream(Reader reader, int n2) {
        this(reader, n2, 1024);
    }

    public ANTLRInputStream(Reader reader, int n2, int n3) {
        this.load(reader, n2, n3);
    }

    public ANTLRInputStream(InputStream inputStream) {
        this(new InputStreamReader(inputStream), 1024);
    }

    public ANTLRInputStream(InputStream inputStream, int n2) {
        this(new InputStreamReader(inputStream), n2);
    }

    public ANTLRInputStream(InputStream inputStream, int n2, int n3) {
        this(new InputStreamReader(inputStream), n2, n3);
    }

    public void load(Reader reader, int n2, int n3) {
        if (reader == null) {
            return;
        }
        if (n2 <= 0) {
            n2 = 1024;
        }
        if (n3 <= 0) {
            n3 = 1024;
        }
        try {
            this.data = new char[n2];
            int n4 = 0;
            do {
                if (n4 + n3 > this.data.length) {
                    this.data = Arrays.copyOf(this.data, this.data.length << 1);
                }
                n2 = reader.read(this.data, n4, n3);
                n4 += n2;
            } while (n2 != -1);
            this.n = n4 + 1;
            return;
        }
        finally {
            reader.close();
        }
    }

    public void reset() {
        this.p = 0;
    }

    @Override
    public void consume() {
        if (this.p >= this.n) {
            assert (this.LA(1) == -1);
            throw new IllegalStateException("cannot consume EOF");
        }
        if (this.p < this.n) {
            ++this.p;
        }
    }

    @Override
    public int LA(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0 && this.p + ++n2 - 1 < 0) {
            return -1;
        }
        if (this.p + n2 - 1 >= this.n) {
            return -1;
        }
        return this.data[this.p + n2 - 1];
    }

    public int LT(int n2) {
        return this.LA(n2);
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public int mark() {
        return -1;
    }

    @Override
    public void release(int n2) {
    }

    @Override
    public void seek(int n2) {
        if (n2 <= this.p) {
            this.p = n2;
            return;
        }
        n2 = Math.min(n2, this.n);
        while (this.p < n2) {
            this.consume();
        }
    }

    @Override
    public String getText(Interval interval) {
        int n2 = interval.a;
        int n3 = interval.b;
        if (n3 >= this.n) {
            n3 = this.n - 1;
        }
        n3 = n3 - n2 + 1;
        if (n2 >= this.n) {
            return "";
        }
        return new String(this.data, n2, n3);
    }

    @Override
    public String getSourceName() {
        if (this.name == null || this.name.isEmpty()) {
            return "<unknown>";
        }
        return this.name;
    }

    public String toString() {
        return new String(this.data);
    }
}

