/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr;

import com.github.jknack.handlebars.internal.antlr.CharStream;
import com.github.jknack.handlebars.internal.antlr.CodePointBuffer;
import com.github.jknack.handlebars.internal.antlr.CodePointCharStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class CharStreams {
    private CharStreams() {
    }

    public static CharStream fromPath(Path path) {
        return CharStreams.fromPath(path, StandardCharsets.UTF_8);
    }

    public static CharStream fromPath(Path object, Charset charset) {
        block9: {
            long l2 = Files.size((Path)object);
            SeekableByteChannel seekableByteChannel = Files.newByteChannel((Path)object, new OpenOption[0]);
            Throwable throwable = null;
            try {
                object = CharStreams.fromChannel(seekableByteChannel, charset, 4096, CodingErrorAction.REPLACE, object.toString(), l2);
                if (seekableByteChannel == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (seekableByteChannel != null) {
                        if (throwable != null) {
                            try {
                                seekableByteChannel.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            seekableByteChannel.close();
                        }
                    }
                    throw throwable3;
                }
            }
            seekableByteChannel.close();
        }
        return object;
    }

    public static CharStream fromFileName(String string) {
        return CharStreams.fromPath(Paths.get(string, new String[0]), StandardCharsets.UTF_8);
    }

    public static CharStream fromFileName(String string, Charset charset) {
        return CharStreams.fromPath(Paths.get(string, new String[0]), charset);
    }

    public static CharStream fromStream(InputStream inputStream) {
        return CharStreams.fromStream(inputStream, StandardCharsets.UTF_8);
    }

    public static CharStream fromStream(InputStream inputStream, Charset charset) {
        return CharStreams.fromStream(inputStream, charset, -1L);
    }

    public static CharStream fromStream(InputStream closeable, Charset object, long l2) {
        block9: {
            closeable = Channels.newChannel((InputStream)closeable);
            Throwable throwable = null;
            try {
                object = CharStreams.fromChannel((ReadableByteChannel)closeable, (Charset)object, 4096, CodingErrorAction.REPLACE, "<unknown>", l2);
                if (closeable == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (closeable != null) {
                        if (throwable != null) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            closeable.close();
                        }
                    }
                    throw throwable3;
                }
            }
            closeable.close();
        }
        return object;
    }

    public static CharStream fromChannel(ReadableByteChannel readableByteChannel) {
        return CharStreams.fromChannel(readableByteChannel, StandardCharsets.UTF_8);
    }

    public static CharStream fromChannel(ReadableByteChannel readableByteChannel, Charset charset) {
        return CharStreams.fromChannel(readableByteChannel, 4096, CodingErrorAction.REPLACE, "<unknown>");
    }

    public static CodePointCharStream fromReader(Reader reader) {
        return CharStreams.fromReader(reader, "<unknown>");
    }

    public static CodePointCharStream fromReader(Reader reader, String object) {
        try {
            CodePointBuffer.Builder builder = CodePointBuffer.builder(4096);
            CharBuffer charBuffer = CharBuffer.allocate(4096);
            while (reader.read(charBuffer) != -1) {
                charBuffer.flip();
                builder.append(charBuffer);
                charBuffer.compact();
            }
            object = CodePointCharStream.fromBuffer(builder.build(), (String)object);
            return object;
        }
        finally {
            reader.close();
        }
    }

    public static CodePointCharStream fromString(String string) {
        return CharStreams.fromString(string, "<unknown>");
    }

    public static CodePointCharStream fromString(String string, String string2) {
        CodePointBuffer.Builder builder = CodePointBuffer.builder(string.length());
        CharBuffer charBuffer = CharBuffer.allocate(string.length());
        charBuffer.put(string);
        charBuffer.flip();
        builder.append(charBuffer);
        return CodePointCharStream.fromBuffer(builder.build(), string2);
    }

    public static CodePointCharStream fromChannel(ReadableByteChannel readableByteChannel, int n2, CodingErrorAction codingErrorAction, String string) {
        return CharStreams.fromChannel(readableByteChannel, StandardCharsets.UTF_8, n2, codingErrorAction, string, -1L);
    }

    public static CodePointCharStream fromChannel(ReadableByteChannel readableByteChannel, Charset object, int n2, CodingErrorAction codingErrorAction, String string, long l2) {
        try {
            Object object2;
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            CharBuffer charBuffer = CharBuffer.allocate(n2);
            if (l2 == -1L) {
                l2 = n2;
            } else if (l2 > Integer.MAX_VALUE) {
                throw new IOException(String.format("inputSize %d larger than max %d", l2, Integer.MAX_VALUE));
            }
            CodePointBuffer.Builder builder = CodePointBuffer.builder((int)l2);
            object = ((Charset)object).newDecoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction);
            int n3 = 0;
            while (!n3) {
                n3 = readableByteChannel.read(byteBuffer);
                n3 = n3 == -1 ? 1 : 0;
                byteBuffer.flip();
                object2 = ((CharsetDecoder)object).decode(byteBuffer, charBuffer, n3 != 0);
                if (((CoderResult)object2).isError() && codingErrorAction.equals(CodingErrorAction.REPORT)) {
                    ((CoderResult)object2).throwException();
                }
                charBuffer.flip();
                builder.append(charBuffer);
                byteBuffer.compact();
                charBuffer.compact();
            }
            CoderResult coderResult = ((CharsetDecoder)object).flush(charBuffer);
            if (coderResult.isError() && codingErrorAction.equals(CodingErrorAction.REPORT)) {
                coderResult.throwException();
            }
            charBuffer.flip();
            builder.append(charBuffer);
            object2 = builder.build();
            object = CodePointCharStream.fromBuffer((CodePointBuffer)object2, string);
            return object;
        }
        finally {
            readableByteChannel.close();
        }
    }
}

