/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr;

import com.github.jknack.handlebars.internal.antlr.CharStream;
import com.github.jknack.handlebars.internal.antlr.Recognizer;
import com.github.jknack.handlebars.internal.antlr.Token;
import com.github.jknack.handlebars.internal.antlr.TokenSource;
import com.github.jknack.handlebars.internal.antlr.WritableToken;
import com.github.jknack.handlebars.internal.antlr.misc.Interval;
import com.github.jknack.handlebars.internal.antlr.misc.Pair;
import java.io.Serializable;

public class CommonToken
implements WritableToken,
Serializable {
    protected static final Pair<TokenSource, CharStream> EMPTY_SOURCE = new Pair<Object, Object>(null, null);
    protected int type;
    protected int line;
    protected int charPositionInLine = -1;
    protected int channel = 0;
    protected Pair<TokenSource, CharStream> source;
    protected String text;
    protected int index = -1;
    protected int start;
    protected int stop;

    public CommonToken(int n2) {
        this.type = n2;
        this.source = EMPTY_SOURCE;
    }

    public CommonToken(Pair<TokenSource, CharStream> pair, int n2, int n3, int n4, int n5) {
        this.source = pair;
        this.type = n2;
        this.channel = n3;
        this.start = n4;
        this.stop = n5;
        if (pair.a != null) {
            this.line = ((TokenSource)pair.a).getLine();
            this.charPositionInLine = ((TokenSource)pair.a).getCharPositionInLine();
        }
    }

    public CommonToken(int n2, String string) {
        this.type = n2;
        this.channel = 0;
        this.text = string;
        this.source = EMPTY_SOURCE;
    }

    public CommonToken(Token token) {
        this.type = token.getType();
        this.line = token.getLine();
        this.index = token.getTokenIndex();
        this.charPositionInLine = token.getCharPositionInLine();
        this.channel = token.getChannel();
        this.start = token.getStartIndex();
        this.stop = token.getStopIndex();
        if (token instanceof CommonToken) {
            this.text = ((CommonToken)token).text;
            this.source = ((CommonToken)token).source;
            return;
        }
        this.text = token.getText();
        this.source = new Pair<TokenSource, CharStream>(token.getTokenSource(), token.getInputStream());
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setLine(int n2) {
        this.line = n2;
    }

    @Override
    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        CharStream charStream = this.getInputStream();
        if (charStream == null) {
            return null;
        }
        int n2 = charStream.size();
        if (this.start < n2 && this.stop < n2) {
            return charStream.getText(Interval.of(this.start, this.stop));
        }
        return "<EOF>";
    }

    @Override
    public void setText(String string) {
        this.text = string;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    @Override
    public void setCharPositionInLine(int n2) {
        this.charPositionInLine = n2;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(int n2) {
        this.channel = n2;
    }

    @Override
    public void setType(int n2) {
        this.type = n2;
    }

    @Override
    public int getStartIndex() {
        return this.start;
    }

    public void setStartIndex(int n2) {
        this.start = n2;
    }

    @Override
    public int getStopIndex() {
        return this.stop;
    }

    public void setStopIndex(int n2) {
        this.stop = n2;
    }

    @Override
    public int getTokenIndex() {
        return this.index;
    }

    @Override
    public void setTokenIndex(int n2) {
        this.index = n2;
    }

    @Override
    public TokenSource getTokenSource() {
        return (TokenSource)this.source.a;
    }

    @Override
    public CharStream getInputStream() {
        return (CharStream)this.source.b;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Recognizer recognizer) {
        String string;
        String string2 = "";
        if (this.channel > 0) {
            string2 = ",channel=" + this.channel;
        }
        if ((string = this.getText()) != null) {
            string = string.replace("\n", "\\n");
            string = string.replace("\r", "\\r");
            string = string.replace("\t", "\\t");
        } else {
            string = "<no text>";
        }
        String string3 = String.valueOf(this.type);
        if (recognizer != null) {
            string3 = recognizer.getVocabulary().getDisplayName(this.type);
        }
        return "[@" + this.getTokenIndex() + "," + this.start + ":" + this.stop + "='" + string + "',<" + string3 + ">" + string2 + "," + this.line + ":" + this.getCharPositionInLine() + "]";
    }
}

