/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.antlr;

import com.github.jknack.handlebars.internal.antlr.ANTLRErrorStrategy;
import com.github.jknack.handlebars.internal.antlr.CharStream;
import com.github.jknack.handlebars.internal.antlr.FailedPredicateException;
import com.github.jknack.handlebars.internal.antlr.InputMismatchException;
import com.github.jknack.handlebars.internal.antlr.NoViableAltException;
import com.github.jknack.handlebars.internal.antlr.Parser;
import com.github.jknack.handlebars.internal.antlr.ParserRuleContext;
import com.github.jknack.handlebars.internal.antlr.RecognitionException;
import com.github.jknack.handlebars.internal.antlr.Recognizer;
import com.github.jknack.handlebars.internal.antlr.RuleContext;
import com.github.jknack.handlebars.internal.antlr.Token;
import com.github.jknack.handlebars.internal.antlr.TokenSource;
import com.github.jknack.handlebars.internal.antlr.TokenStream;
import com.github.jknack.handlebars.internal.antlr.atn.ATN;
import com.github.jknack.handlebars.internal.antlr.atn.ATNState;
import com.github.jknack.handlebars.internal.antlr.atn.ParserATNSimulator;
import com.github.jknack.handlebars.internal.antlr.atn.RuleTransition;
import com.github.jknack.handlebars.internal.antlr.misc.IntSet;
import com.github.jknack.handlebars.internal.antlr.misc.IntervalSet;
import com.github.jknack.handlebars.internal.antlr.misc.Pair;

public class DefaultErrorStrategy
implements ANTLRErrorStrategy {
    protected boolean errorRecoveryMode = false;
    protected int lastErrorIndex = -1;
    protected IntervalSet lastErrorStates;
    protected ParserRuleContext nextTokensContext;
    protected int nextTokensState;

    @Override
    public void reset(Parser parser) {
        this.endErrorCondition(parser);
    }

    protected void beginErrorCondition(Parser parser) {
        this.errorRecoveryMode = true;
    }

    @Override
    public boolean inErrorRecoveryMode(Parser parser) {
        return this.errorRecoveryMode;
    }

    protected void endErrorCondition(Parser parser) {
        this.errorRecoveryMode = false;
        this.lastErrorStates = null;
        this.lastErrorIndex = -1;
    }

    @Override
    public void reportMatch(Parser parser) {
        this.endErrorCondition(parser);
    }

    @Override
    public void reportError(Parser parser, RecognitionException recognitionException) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        if (recognitionException instanceof NoViableAltException) {
            this.reportNoViableAlternative(parser, (NoViableAltException)recognitionException);
            return;
        }
        if (recognitionException instanceof InputMismatchException) {
            this.reportInputMismatch(parser, (InputMismatchException)recognitionException);
            return;
        }
        if (recognitionException instanceof FailedPredicateException) {
            this.reportFailedPredicate(parser, (FailedPredicateException)recognitionException);
            return;
        }
        System.err.println("unknown recognition error type: " + recognitionException.getClass().getName());
        parser.notifyErrorListeners(recognitionException.getOffendingToken(), recognitionException.getMessage(), recognitionException);
    }

    @Override
    public void recover(Parser parser, RecognitionException object) {
        if (this.lastErrorIndex == parser.getInputStream().index() && this.lastErrorStates != null && this.lastErrorStates.contains(parser.getState())) {
            parser.consume();
        }
        this.lastErrorIndex = parser.getInputStream().index();
        if (this.lastErrorStates == null) {
            this.lastErrorStates = new IntervalSet(new int[0]);
        }
        this.lastErrorStates.add(parser.getState());
        object = this.getErrorRecoverySet(parser);
        this.consumeUntil(parser, (IntervalSet)object);
    }

    @Override
    public void sync(Parser parser) {
        Object object = ((ParserATNSimulator)parser.getInterpreter()).atn.states.get(parser.getState());
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        TokenStream tokenStream = parser.getInputStream();
        int n2 = tokenStream.LA(1);
        IntervalSet intervalSet = parser.getATN().nextTokens((ATNState)object);
        if (intervalSet.contains(n2)) {
            this.nextTokensContext = null;
            this.nextTokensState = -1;
            return;
        }
        if (intervalSet.contains(-2)) {
            if (this.nextTokensContext == null) {
                this.nextTokensContext = parser.getContext();
                this.nextTokensState = parser.getState();
            }
            return;
        }
        switch (((ATNState)object).getStateType()) {
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                if (this.singleTokenDeletion(parser) != null) {
                    return;
                }
                throw new InputMismatchException(parser);
            }
            case 9: 
            case 11: {
                this.reportUnwantedToken(parser);
                object = parser.getExpectedTokens();
                object = ((IntervalSet)object).or(this.getErrorRecoverySet(parser));
                this.consumeUntil(parser, (IntervalSet)object);
            }
        }
    }

    protected void reportNoViableAlternative(Parser parser, NoViableAltException noViableAltException) {
        Object object = parser.getInputStream();
        object = object != null ? (noViableAltException.getStartToken().getType() == -1 ? "<EOF>" : object.getText(noViableAltException.getStartToken(), noViableAltException.getOffendingToken())) : "<unknown input>";
        object = "no viable alternative at input " + this.escapeWSAndQuote((String)object);
        parser.notifyErrorListeners(noViableAltException.getOffendingToken(), (String)object, noViableAltException);
    }

    protected void reportInputMismatch(Parser parser, InputMismatchException inputMismatchException) {
        String string = "mismatched input " + this.getTokenErrorDisplay(inputMismatchException.getOffendingToken()) + " expecting " + inputMismatchException.getExpectedTokens().toString(parser.getVocabulary());
        parser.notifyErrorListeners(inputMismatchException.getOffendingToken(), string, inputMismatchException);
    }

    protected void reportFailedPredicate(Parser parser, FailedPredicateException failedPredicateException) {
        String string = parser.getRuleNames()[parser._ctx.getRuleIndex()];
        string = "rule " + string + " " + failedPredicateException.getMessage();
        parser.notifyErrorListeners(failedPredicateException.getOffendingToken(), string, failedPredicateException);
    }

    protected void reportUnwantedToken(Parser parser) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        Token token = parser.getCurrentToken();
        String string = this.getTokenErrorDisplay(token);
        IntervalSet intervalSet = this.getExpectedTokens(parser);
        string = "extraneous input " + string + " expecting " + intervalSet.toString(parser.getVocabulary());
        parser.notifyErrorListeners(token, string, null);
    }

    protected void reportMissingToken(Parser parser) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        Token token = parser.getCurrentToken();
        Object object = this.getExpectedTokens(parser);
        object = "missing " + ((IntervalSet)object).toString(parser.getVocabulary()) + " at " + this.getTokenErrorDisplay(token);
        parser.notifyErrorListeners(token, (String)object, null);
    }

    @Override
    public Token recoverInline(Parser object) {
        Token token = this.singleTokenDeletion((Parser)object);
        if (token != null) {
            ((Parser)object).consume();
            return token;
        }
        if (this.singleTokenInsertion((Parser)object)) {
            return this.getMissingSymbol((Parser)object);
        }
        object = this.nextTokensContext == null ? new InputMismatchException((Parser)object) : new InputMismatchException((Parser)object, this.nextTokensState, this.nextTokensContext);
        throw object;
    }

    protected boolean singleTokenInsertion(Parser parser) {
        int n2 = parser.getInputStream().LA(1);
        Object object = ((ParserATNSimulator)parser.getInterpreter()).atn.states.get(parser.getState());
        object = ((ATNState)object).transition((int)0).target;
        ATN aTN = ((ParserATNSimulator)parser.getInterpreter()).atn;
        if (((IntervalSet)(object = aTN.nextTokens((ATNState)object, parser._ctx))).contains(n2)) {
            this.reportMissingToken(parser);
            return true;
        }
        return false;
    }

    protected Token singleTokenDeletion(Parser parser) {
        int n2 = parser.getInputStream().LA(2);
        IntervalSet intervalSet = this.getExpectedTokens(parser);
        if (intervalSet.contains(n2)) {
            this.reportUnwantedToken(parser);
            parser.consume();
            Token token = parser.getCurrentToken();
            this.reportMatch(parser);
            return token;
        }
        return null;
    }

    protected Token getMissingSymbol(Parser parser) {
        Token token = parser.getCurrentToken();
        Object object = this.getExpectedTokens(parser);
        int n2 = 0;
        if (!((IntervalSet)object).isNil()) {
            n2 = ((IntervalSet)object).getMinElement();
        }
        object = n2 == -1 ? "<missing EOF>" : "<missing " + parser.getVocabulary().getDisplayName(n2) + ">";
        Token token2 = parser.getInputStream().LT(-1);
        if (token.getType() == -1 && token2 != null) {
            token = token2;
        }
        return ((Recognizer)parser).getTokenFactory().create(new Pair<TokenSource, CharStream>(token.getTokenSource(), token.getTokenSource().getInputStream()), n2, (String)object, 0, -1, -1, token.getLine(), token.getCharPositionInLine());
    }

    protected IntervalSet getExpectedTokens(Parser parser) {
        return parser.getExpectedTokens();
    }

    protected String getTokenErrorDisplay(Token token) {
        if (token == null) {
            return "<no token>";
        }
        String string = this.getSymbolText(token);
        if (string == null) {
            string = this.getSymbolType(token) == -1 ? "<EOF>" : "<" + this.getSymbolType(token) + ">";
        }
        return this.escapeWSAndQuote(string);
    }

    protected String getSymbolText(Token token) {
        return token.getText();
    }

    protected int getSymbolType(Token token) {
        return token.getType();
    }

    protected String escapeWSAndQuote(String string) {
        string = string.replace("\n", "\\n");
        string = string.replace("\r", "\\r");
        string = string.replace("\t", "\\t");
        return "'" + string + "'";
    }

    protected IntervalSet getErrorRecoverySet(Parser object) {
        ATN aTN = ((ParserATNSimulator)((Recognizer)object).getInterpreter()).atn;
        object = ((Parser)object)._ctx;
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        while (object != null && ((RuleContext)object).invokingState >= 0) {
            Object object2 = aTN.states.get(((RuleContext)object).invokingState);
            object2 = (RuleTransition)((ATNState)object2).transition(0);
            object2 = aTN.nextTokens(((RuleTransition)object2).followState);
            intervalSet.addAll((IntSet)object2);
            object = ((RuleContext)object).parent;
        }
        intervalSet.remove(-2);
        return intervalSet;
    }

    protected void consumeUntil(Parser parser, IntervalSet intervalSet) {
        int n2 = parser.getInputStream().LA(1);
        while (n2 != -1 && !intervalSet.contains(n2)) {
            parser.consume();
            n2 = parser.getInputStream().LA(1);
        }
    }
}

